/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.versionmeta.minecraft;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.utilities.common.Utilities;
import de.griefed.serverpackcreator.versionmeta.ManifestParser;
import de.griefed.serverpackcreator.versionmeta.Type;
import de.griefed.serverpackcreator.versionmeta.forge.ForgeMeta;
import de.griefed.serverpackcreator.versionmeta.minecraft.MinecraftClient;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class MinecraftClientMeta
extends ManifestParser {
    private static final Logger LOG = LogManager.getLogger(MinecraftClientMeta.class);
    private final ObjectMapper OBJECTMAPPER;
    private final Utilities UTILITIES;
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final ForgeMeta FORGE_META;
    private final File MINECRAFT_MANIFEST;
    private final List<MinecraftClient> RELEASES = new ArrayList<MinecraftClient>(100);
    private final List<MinecraftClient> SNAPSHOTS = new ArrayList<MinecraftClient>(200);
    private final List<MinecraftClient> ALL = new ArrayList<MinecraftClient>(300);
    private MinecraftClient latestRelease;
    private MinecraftClient latestSnapshot;
    private HashMap<String, MinecraftClient> meta = new HashMap(300);

    MinecraftClientMeta(File minecraftManifest, ForgeMeta injectedForgeMeta, ObjectMapper objectMapper, Utilities utilities, ApplicationProperties applicationProperties) {
        this.APPLICATIONPROPERTIES = applicationProperties;
        this.UTILITIES = utilities;
        this.MINECRAFT_MANIFEST = minecraftManifest;
        this.FORGE_META = injectedForgeMeta;
        this.OBJECTMAPPER = objectMapper;
    }

    void update() throws IOException {
        this.RELEASES.clear();
        this.SNAPSHOTS.clear();
        this.meta = new HashMap(100);
        JsonNode minecraftManifest = this.getJson(this.MINECRAFT_MANIFEST, this.OBJECTMAPPER);
        minecraftManifest.get("versions").forEach(minecraftVersion -> {
            MinecraftClient client = null;
            if (minecraftVersion.get("type").asText().equalsIgnoreCase("release")) {
                try {
                    client = new MinecraftClient(minecraftVersion.get("id").asText(), Type.RELEASE, new URL(minecraftVersion.get("url").asText()), this.FORGE_META, this.OBJECTMAPPER, this.UTILITIES, this.APPLICATIONPROPERTIES);
                    this.RELEASES.add(client);
                }
                catch (IOException ex) {
                    LOG.debug("No server available for MinecraftClient version " + minecraftVersion.get("id").asText(), (Throwable)ex);
                }
            } else if (minecraftVersion.get("type").asText().equalsIgnoreCase("snapshot")) {
                try {
                    client = new MinecraftClient(minecraftVersion.get("id").asText(), Type.SNAPSHOT, new URL(minecraftVersion.get("url").asText()), this.FORGE_META, this.OBJECTMAPPER, this.UTILITIES, this.APPLICATIONPROPERTIES);
                    this.SNAPSHOTS.add(client);
                }
                catch (IOException ex) {
                    LOG.debug("No server available for MinecraftClient version " + minecraftVersion.get("id").asText(), (Throwable)ex);
                }
            }
            if (client != null) {
                this.meta.put(client.version(), client);
                this.ALL.add(client);
            }
        });
        this.latestRelease = new MinecraftClient(minecraftManifest.get("latest").get("release").asText(), Type.RELEASE, this.meta.get(minecraftManifest.get("latest").get("release").asText()).url(), this.meta.get(minecraftManifest.get("latest").get("release").asText()).server(), this.FORGE_META, this.UTILITIES, this.APPLICATIONPROPERTIES);
        this.latestSnapshot = new MinecraftClient(minecraftManifest.get("latest").get("snapshot").asText(), Type.SNAPSHOT, this.meta.get(minecraftManifest.get("latest").get("snapshot").asText()).url(), this.meta.get(minecraftManifest.get("latest").get("snapshot").asText()).server(), this.FORGE_META, this.UTILITIES, this.APPLICATIONPROPERTIES);
    }

    List<MinecraftClient> all() {
        return this.ALL;
    }

    List<MinecraftClient> releases() {
        return this.RELEASES;
    }

    List<MinecraftClient> snapshots() {
        return this.SNAPSHOTS;
    }

    MinecraftClient latestRelease() {
        return this.latestRelease;
    }

    MinecraftClient latestSnapshot() {
        return this.latestSnapshot;
    }

    HashMap<String, MinecraftClient> meta() {
        return this.meta;
    }
}

