/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.versionmeta.legacyfabric;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import de.griefed.serverpackcreator.versionmeta.ManifestParser;
import de.griefed.serverpackcreator.versionmeta.Meta;
import de.griefed.serverpackcreator.versionmeta.legacyfabric.LegacyFabricGame;
import de.griefed.serverpackcreator.versionmeta.legacyfabric.LegacyFabricInstaller;
import de.griefed.serverpackcreator.versionmeta.legacyfabric.LegacyFabricLoader;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public final class LegacyFabricMeta
extends ManifestParser
implements Meta {
    private final LegacyFabricGame GAME_VERSIONS;
    private final LegacyFabricLoader LOADER_VERSIONS;
    private final LegacyFabricInstaller INSTALLER_VERSIONS;

    public LegacyFabricMeta(File gameVersionsManifest, File loaderVersionsManifest, File installerVersionsManifest, ObjectMapper mapper) {
        this.GAME_VERSIONS = new LegacyFabricGame(gameVersionsManifest, mapper);
        this.LOADER_VERSIONS = new LegacyFabricLoader(loaderVersionsManifest, mapper);
        this.INSTALLER_VERSIONS = new LegacyFabricInstaller(installerVersionsManifest);
    }

    @Override
    public void update() throws IOException, ParserConfigurationException, SAXException {
        this.GAME_VERSIONS.update();
        this.LOADER_VERSIONS.update();
        this.INSTALLER_VERSIONS.update();
    }

    @Override
    public String latestLoader() {
        return this.LOADER_VERSIONS.all().get(0);
    }

    @Override
    public String releaseLoader() {
        return this.LOADER_VERSIONS.releases().get(0);
    }

    @Override
    public String latestInstaller() {
        return this.INSTALLER_VERSIONS.latest();
    }

    @Override
    public String releaseInstaller() {
        return this.INSTALLER_VERSIONS.release();
    }

    @Override
    public List<String> loaderVersionsListAscending() {
        return this.LOADER_VERSIONS.all();
    }

    @Override
    public List<String> loaderVersionsListDescending() {
        return Lists.reverse(this.LOADER_VERSIONS.all());
    }

    @Override
    public String[] loaderVersionsArrayAscending() {
        return this.loaderVersionsListAscending().toArray(new String[0]);
    }

    @Override
    public String[] loaderVersionsArrayDescending() {
        return this.loaderVersionsListDescending().toArray(new String[0]);
    }

    @Override
    public List<String> installerVersionsListAscending() {
        return this.INSTALLER_VERSIONS.all();
    }

    @Override
    public List<String> installerVersionsListDescending() {
        return Lists.reverse(this.INSTALLER_VERSIONS.all());
    }

    @Override
    public String[] installerVersionsArrayAscending() {
        return this.installerVersionsListAscending().toArray(new String[0]);
    }

    @Override
    public String[] installerVersionsArrayDescending() {
        return this.installerVersionsListDescending().toArray(new String[0]);
    }

    @Override
    public URL latestInstallerUrl() throws MalformedURLException {
        return this.INSTALLER_VERSIONS.latestURL();
    }

    @Override
    public URL releaseInstallerUrl() throws MalformedURLException {
        return this.INSTALLER_VERSIONS.releaseURL();
    }

    @Override
    public boolean isInstallerUrlAvailable(String version) {
        try {
            return this.INSTALLER_VERSIONS.specificURL(version).isPresent();
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    @Override
    public Optional<URL> getInstallerUrl(String version) throws MalformedURLException {
        return this.INSTALLER_VERSIONS.specificURL(version);
    }

    @Override
    public boolean isVersionValid(String version) {
        return this.LOADER_VERSIONS.all().contains(version);
    }

    @Override
    public boolean isMinecraftSupported(String minecraftVersion) {
        return this.GAME_VERSIONS.all().contains(minecraftVersion);
    }

    public List<String> supportedMinecraftVersions() {
        return this.GAME_VERSIONS.all();
    }
}

