/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.versionmeta.forge;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import de.griefed.serverpackcreator.versionmeta.ManifestParser;
import de.griefed.serverpackcreator.versionmeta.Type;
import de.griefed.serverpackcreator.versionmeta.forge.ForgeInstance;
import de.griefed.serverpackcreator.versionmeta.forge.ForgeLoader;
import de.griefed.serverpackcreator.versionmeta.minecraft.MinecraftMeta;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public final class ForgeMeta
extends ManifestParser {
    private final File FORGE_MANIFEST;
    private final ObjectMapper OBJECTMAPPER;
    private ForgeLoader forgeLoader;

    public ForgeMeta(File forgeManifest, ObjectMapper objectMapper) {
        this.FORGE_MANIFEST = forgeManifest;
        this.OBJECTMAPPER = objectMapper;
    }

    public void initialize(MinecraftMeta injectedMinecraftMeta) throws IOException {
        if (this.forgeLoader == null) {
            this.forgeLoader = new ForgeLoader(this.FORGE_MANIFEST, this.OBJECTMAPPER, injectedMinecraftMeta);
        }
    }

    public void update() throws IOException {
        this.forgeLoader.update();
    }

    private List<String> supportedMinecraftVersionsList(Type order) {
        if (order == Type.DESCENDING) {
            return Lists.reverse(this.forgeLoader.minecraftVersions());
        }
        return this.forgeLoader.minecraftVersions();
    }

    private List<String> supportedForgeVersionsList(Type order) {
        if (order == Type.DESCENDING) {
            return Lists.reverse(this.forgeLoader.forgeVersions());
        }
        return this.forgeLoader.forgeVersions();
    }

    private Optional<String[]> getForgeVersionsArray(String minecraftVersion, Type order) {
        if (!this.checkMinecraftVersion(minecraftVersion)) {
            return Optional.empty();
        }
        if (order == Type.DESCENDING) {
            return Optional.of(Lists.reverse(this.forgeLoader.versionMeta().get(minecraftVersion)).toArray(new String[0]));
        }
        return Optional.of(this.forgeLoader.versionMeta().get(minecraftVersion).toArray(new String[0]));
    }

    private Optional<List<String>> getForgeVersions(String minecraftVersion, Type order) {
        if (!this.checkMinecraftVersion(minecraftVersion)) {
            return Optional.empty();
        }
        if (order == Type.DESCENDING) {
            return Optional.ofNullable(Lists.reverse(this.forgeLoader.versionMeta().get(minecraftVersion)));
        }
        return Optional.ofNullable(this.forgeLoader.versionMeta().get(minecraftVersion));
    }

    public boolean checkForgeVersion(String forgeVersion) {
        return Optional.ofNullable(this.forgeLoader.forgeToMinecraftMeta().get(forgeVersion)).isPresent();
    }

    public boolean checkMinecraftVersion(String minecraftVersion) {
        return Optional.ofNullable(this.forgeLoader.versionMeta().get(minecraftVersion)).isPresent();
    }

    public boolean checkForgeAndMinecraftVersion(String minecraftVersion, String forgeVersion) {
        return this.checkMinecraftVersion(minecraftVersion) && this.checkForgeVersion(forgeVersion);
    }

    public boolean isForgeInstanceAvailable(String minecraftVersion, String forgeVersion) {
        return this.getForgeInstance(minecraftVersion, forgeVersion).isPresent();
    }

    public boolean isForgeInstanceAvailable(String forgeVersion) {
        return this.getForgeInstance(forgeVersion).isPresent();
    }

    public Optional<String> supportedMinecraftVersion(String forgeVersion) {
        return Optional.ofNullable(this.forgeLoader.forgeToMinecraftMeta().get(forgeVersion));
    }

    public Optional<ForgeInstance> getForgeInstance(String minecraftVersion, String forgeVersion) {
        return Optional.ofNullable(this.forgeLoader.instanceMeta().get(minecraftVersion + "-" + forgeVersion));
    }

    public Optional<ForgeInstance> getForgeInstance(String forgeVersion) {
        if (!this.checkForgeVersion(forgeVersion)) {
            return Optional.empty();
        }
        if (this.supportedMinecraftVersion(forgeVersion).isPresent()) {
            return this.getForgeInstance(this.supportedMinecraftVersion(forgeVersion).get(), forgeVersion);
        }
        return Optional.empty();
    }

    public Optional<List<ForgeInstance>> getForgeInstances(String minecraftVersion) {
        ArrayList list = new ArrayList(100);
        if (Optional.ofNullable(this.forgeLoader.versionMeta().get(minecraftVersion)).isPresent()) {
            this.forgeLoader.versionMeta().get(minecraftVersion).forEach(forgeVersion -> {
                if (this.forgeLoader.instanceMeta().get(minecraftVersion + "-" + forgeVersion) != null) {
                    list.add(this.forgeLoader.instanceMeta().get(minecraftVersion + "-" + forgeVersion));
                }
            });
            return Optional.of(list);
        }
        return Optional.empty();
    }

    public Optional<String> latestForgeVersion(String minecraftVersion) {
        if (!this.checkMinecraftVersion(minecraftVersion)) {
            return Optional.empty();
        }
        if (this.getForgeVersions(minecraftVersion, Type.ASCENDING).isPresent()) {
            return Optional.of(this.getForgeVersions(minecraftVersion, Type.ASCENDING).get().get(this.getForgeVersions(minecraftVersion, Type.ASCENDING).get().size() - 1));
        }
        return Optional.empty();
    }

    public Optional<String> oldestForgeVersion(String minecraftVersion) {
        if (!this.checkMinecraftVersion(minecraftVersion)) {
            return Optional.empty();
        }
        if (this.getForgeVersions(minecraftVersion, Type.ASCENDING).isPresent()) {
            return Optional.ofNullable(this.getForgeVersions(minecraftVersion, Type.ASCENDING).get().get(0));
        }
        return Optional.empty();
    }

    public List<String> minecraftVersionsAscending() {
        return this.supportedMinecraftVersionsList(Type.ASCENDING);
    }

    public List<String> minecraftVersionsDescending() {
        return this.supportedMinecraftVersionsList(Type.DESCENDING);
    }

    public String[] minecraftVersionsArrayAscending() {
        return this.supportedMinecraftVersionsList(Type.ASCENDING).toArray(new String[0]);
    }

    public String[] minecraftVersionsArrayDescending() {
        return this.supportedMinecraftVersionsList(Type.DESCENDING).toArray(new String[0]);
    }

    public List<String> forgeVersions() {
        return this.supportedForgeVersionsList(Type.ASCENDING);
    }

    public List<String> forgeVersionsDescending() {
        return this.supportedForgeVersionsList(Type.DESCENDING);
    }

    public String[] forgeVersionsArray() {
        return this.supportedForgeVersionsList(Type.ASCENDING).toArray(new String[0]);
    }

    public String[] forgeVersionsArrayDescending() {
        return this.supportedForgeVersionsList(Type.DESCENDING).toArray(new String[0]);
    }

    public Optional<List<String>> availableForgeVersionsAscending(String minecraftVersion) {
        return this.getForgeVersions(minecraftVersion, Type.ASCENDING);
    }

    public Optional<List<String>> availableForgeVersionsDescending(String minecraftVersion) {
        return this.getForgeVersions(minecraftVersion, Type.DESCENDING);
    }

    public Optional<String[]> availableForgeVersionsArrayAscending(String minecraftVersion) {
        return this.getForgeVersionsArray(minecraftVersion, Type.ASCENDING);
    }

    public Optional<String[]> availableForgeVersionsArrayDescending(String minecraftVersion) {
        return this.getForgeVersionsArray(minecraftVersion, Type.DESCENDING);
    }

    public Optional<URL> installerUrl(String forgeVersion) {
        if (!this.checkForgeVersion(forgeVersion)) {
            return Optional.empty();
        }
        if (this.getForgeInstance(forgeVersion).isPresent()) {
            return Optional.ofNullable(this.getForgeInstance(forgeVersion).get().installerUrl());
        }
        return Optional.empty();
    }
}

