/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.swing.utilities;

import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentListener;

public class IconTextArea
extends JTextArea {
    private static final int ICON_SPACING = 4;
    private Border mBorder;
    private Icon mIcon;

    public IconTextArea(String s2) {
        super(s2);
    }

    public IconTextArea() {
    }

    @Override
    public void setBorder(Border border) {
        this.mBorder = border;
        if (this.mIcon == null) {
            super.setBorder(border);
        } else {
            Border margin = BorderFactory.createEmptyBorder(0, this.mIcon.getIconWidth() + 4, 0, 0);
            CompoundBorder compoud = BorderFactory.createCompoundBorder(border, margin);
            super.setBorder(compoud);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.mIcon != null) {
            Insets iconInsets = this.mBorder.getBorderInsets(this);
            this.mIcon.paintIcon(this, graphics, iconInsets.left, this.getHeight() - this.mIcon.getIconHeight());
        }
    }

    public void setIcon(Icon icon) {
        this.mIcon = icon;
        this.resetBorder();
    }

    private void resetBorder() {
        this.setBorder(this.mBorder);
    }

    public void addDocumentListener(DocumentListener listener) {
        this.getDocument().addDocumentListener(listener);
    }
}

