/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.swing;

import de.griefed.serverpackcreator.ApplicationAddons;
import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.ConfigurationHandler;
import de.griefed.serverpackcreator.ServerPackHandler;
import de.griefed.serverpackcreator.i18n.I18n;
import de.griefed.serverpackcreator.swing.MainMenuBar;
import de.griefed.serverpackcreator.swing.ServerPackCreatorSplash;
import de.griefed.serverpackcreator.swing.TabAddonsHandlerLog;
import de.griefed.serverpackcreator.swing.TabCreateServerPack;
import de.griefed.serverpackcreator.swing.TabServerPackCreatorLog;
import de.griefed.serverpackcreator.swing.themes.DarkTheme;
import de.griefed.serverpackcreator.swing.themes.LightTheme;
import de.griefed.serverpackcreator.swing.utilities.BackgroundPanel;
import de.griefed.serverpackcreator.utilities.ConfigUtilities;
import de.griefed.serverpackcreator.utilities.UpdateChecker;
import de.griefed.serverpackcreator.utilities.common.Utilities;
import de.griefed.serverpackcreator.versionmeta.VersionMeta;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import mdlaf.MaterialLookAndFeel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ServerPackCreatorWindow
extends JFrame {
    private static final Logger LOG = LogManager.getLogger(ServerPackCreatorWindow.class);
    private final ImageIcon ICON_SERVERPACKCREATOR_BANNER = new ImageIcon(Objects.requireNonNull(ServerPackCreatorWindow.class.getResource("/de/griefed/resources/gui/banner.png")));
    private final Image ICON_SERVERPACKCREATOR = Toolkit.getDefaultToolkit().getImage(Objects.requireNonNull(ServerPackCreatorWindow.class.getResource("/de/griefed/resources/gui/app.png")));
    private final ImageIcon ISSUE_ICON = new ImageIcon(ImageIO.read(Objects.requireNonNull(TabCreateServerPack.class.getResource("/de/griefed/resources/gui/issue.png"))).getScaledInstance(48, 48, 4));
    private final Dimension DIMENSION_WINDOW = new Dimension(1200, 800);
    private final I18n I18N;
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final ServerPackCreatorSplash SERVERPACKCREATORSPLASH;
    private final LightTheme LIGHTTHEME = new LightTheme();
    private final DarkTheme DARKTHEME = new DarkTheme();
    private final MaterialLookAndFeel LAF_LIGHT = new MaterialLookAndFeel(this.LIGHTTHEME);
    private final MaterialLookAndFeel LAF_DARK = new MaterialLookAndFeel(this.DARKTHEME);
    private final BackgroundPanel BACKGROUNDPANEL;
    private final TabCreateServerPack TAB_CREATESERVERPACK;
    private final JTabbedPane TABBEDPANE;
    private final MainMenuBar MENUBAR;

    public ServerPackCreatorWindow(I18n injectedI18n, ConfigurationHandler injectedConfigurationHandler, ServerPackHandler injectedServerPackHandler, ApplicationProperties injectedApplicationProperties, VersionMeta injectedVersionMeta, Utilities injectedUtilities, UpdateChecker injectedUpdateChecker, ServerPackCreatorSplash injectedServerPackCreatorSplash, ApplicationAddons injectedApplicationAddons, ConfigUtilities injectedConfigUtilities) throws IOException {
        this.SERVERPACKCREATORSPLASH = injectedServerPackCreatorSplash;
        this.SERVERPACKCREATORSPLASH.update(90);
        this.APPLICATIONPROPERTIES = injectedApplicationProperties;
        this.I18N = injectedI18n;
        BufferedImage bufferedImage = ImageIO.read(Objects.requireNonNull(this.getClass().getResource("/de/griefed/resources/gui/tile" + new Random().nextInt(4) + ".jpg")));
        this.setTitle(injectedI18n.getMessage("createserverpack.gui.createandshowgui") + " - " + this.APPLICATIONPROPERTIES.SERVERPACKCREATOR_VERSION());
        this.TAB_CREATESERVERPACK = new TabCreateServerPack(injectedI18n, injectedConfigurationHandler, injectedServerPackHandler, injectedVersionMeta, this.APPLICATIONPROPERTIES, this, injectedUtilities, this.DARKTHEME, this.LIGHTTHEME, injectedApplicationAddons, injectedConfigUtilities);
        TabServerPackCreatorLog TAB_LOG_SERVERPACKCREATOR = new TabServerPackCreatorLog(injectedI18n.getMessage("createserverpack.gui.tabbedpane.serverpackcreatorlog.tooltip"));
        TabAddonsHandlerLog TAB_LOG_ADDONSHANDLER = new TabAddonsHandlerLog(injectedI18n.getMessage("createserverpack.gui.tabbedpane.addonshandlerlog.tip"));
        this.BACKGROUNDPANEL = new BackgroundPanel(bufferedImage, 1, 0.0f, 0.0f);
        this.TABBEDPANE = new JTabbedPane(1);
        this.TABBEDPANE.addTab(injectedI18n.getMessage("createserverpack.gui.tabbedpane.createserverpack.title"), null, this.TAB_CREATESERVERPACK, injectedI18n.getMessage("createserverpack.gui.tabbedpane.createserverpack.tip"));
        this.TABBEDPANE.addTab(injectedI18n.getMessage("createserverpack.gui.tabbedpane.serverpackcreatorlog.title"), null, TAB_LOG_SERVERPACKCREATOR, injectedI18n.getMessage("createserverpack.gui.tabbedpane.serverpackcreatorlog.tip"));
        this.TABBEDPANE.addTab(injectedI18n.getMessage("createserverpack.gui.tabbedpane.addonshandlerlog.title"), null, TAB_LOG_ADDONSHANDLER);
        this.TABBEDPANE.setMnemonicAt(0, 49);
        this.TABBEDPANE.setMnemonicAt(1, 50);
        this.TABBEDPANE.setMnemonicAt(2, 51);
        injectedApplicationAddons.addTabExtensionTabs(this.TABBEDPANE);
        this.TABBEDPANE.setTabLayoutPolicy(1);
        this.MENUBAR = new MainMenuBar(injectedI18n, this.LIGHTTHEME, this.DARKTHEME, this, this.LAF_LIGHT, this.LAF_DARK, this.TAB_CREATESERVERPACK, this.TABBEDPANE, this.APPLICATIONPROPERTIES, injectedUpdateChecker, injectedUtilities);
        this.setJMenuBar(this.MENUBAR.createMenuBar());
    }

    public void mainGUI() {
        SwingUtilities.invokeLater(() -> {
            try {
                if (this.APPLICATIONPROPERTIES.isDarkTheme()) {
                    UIManager.setLookAndFeel(this.LAF_DARK);
                    MaterialLookAndFeel.changeTheme(this.DARKTHEME);
                } else {
                    UIManager.setLookAndFeel(this.LAF_LIGHT);
                    MaterialLookAndFeel.changeTheme(this.LIGHTTHEME);
                }
                UIManager.put("Table.showVerticalLines", true);
                UIManager.put("Table.showHorizontalLines", true);
                UIManager.put("Table.intercellSpacing", new Dimension(1, 1));
            }
            catch (UnsupportedLookAndFeelException ex) {
                LOG.error("Error: There was an error setting the look and feel.", (Throwable)ex);
            }
            this.SERVERPACKCREATORSPLASH.update(95);
            this.createAndShowGUI();
        });
    }

    private void createAndShowGUI() {
        this.SERVERPACKCREATORSPLASH.close();
        JLabel serverPackCreatorBanner = new JLabel(this.ICON_SERVERPACKCREATOR_BANNER);
        serverPackCreatorBanner.setOpaque(false);
        this.setDefaultCloseOperation(3);
        this.setContentPane(this.BACKGROUNDPANEL);
        this.setIconImage(this.ICON_SERVERPACKCREATOR);
        this.add((Component)serverPackCreatorBanner, "First");
        this.add((Component)this.TABBEDPANE, "Center");
        this.setSize(this.DIMENSION_WINDOW);
        this.setPreferredSize(this.DIMENSION_WINDOW);
        this.setLocationRelativeTo(null);
        this.setResizable(true);
        this.pack();
        SwingUtilities.updateComponentTreeUI(this);
        this.TABBEDPANE.setOpaque(true);
        this.setVisible(true);
        this.TAB_CREATESERVERPACK.validateInputFields();
        this.TAB_CREATESERVERPACK.updatePanelTheme();
        this.MENUBAR.displayUpdateDialog();
    }

    boolean checkJava() {
        if (!this.APPLICATIONPROPERTIES.javaAvailable()) {
            switch (JOptionPane.showConfirmDialog(this, this.I18N.getMessage("createserverpack.gui.createserverpack.checkboxserver.confirm.message"), this.I18N.getMessage("createserverpack.gui.createserverpack.checkboxserver.confirm.title"), 0, 2, this.ISSUE_ICON)) {
                case 0: {
                    this.chooseJava();
                    return true;
                }
                case 1: {
                    JOptionPane.showMessageDialog(this, this.I18N.getMessage("createserverpack.gui.createserverpack.checkboxserver.message.message"), this.I18N.getMessage("createserverpack.gui.createserverpack.checkboxserver.message.title"), 0, this.ISSUE_ICON);
                }
            }
            return false;
        }
        return true;
    }

    void chooseJava() {
        JFileChooser javaChooser = new JFileChooser();
        if (new File(String.format("%s/bin/", System.getProperty("java.home").replace("\\", "/"))).isDirectory()) {
            javaChooser.setCurrentDirectory(new File(String.format("%s/bin/", System.getProperty("java.home").replace("\\", "/"))));
        } else {
            javaChooser.setCurrentDirectory(new File("."));
        }
        javaChooser.setDialogTitle(this.I18N.getMessage("createserverpack.gui.buttonjavapath.tile"));
        javaChooser.setFileSelectionMode(0);
        javaChooser.setAcceptAllFileFilterUsed(true);
        javaChooser.setMultiSelectionEnabled(false);
        javaChooser.setPreferredSize(new Dimension(750, 450));
        if (javaChooser.showOpenDialog(this) == 0) {
            try {
                this.APPLICATIONPROPERTIES.setJavaPath(javaChooser.getSelectedFile().getCanonicalPath().replace("\\", "/"));
                LOG.debug("Set path to Java executable to: " + javaChooser.getSelectedFile().getCanonicalPath().replace("\\", "/"));
            }
            catch (IOException ex) {
                LOG.error("Couldn't set java executable path.", (Throwable)ex);
            }
        }
    }
}

