/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.swing;

import de.griefed.serverpackcreator.swing.ServerPackCreatorWindow;
import de.griefed.serverpackcreator.swing.utilities.BackgroundPanel;
import de.griefed.serverpackcreator.utilities.ReticulatingSplines;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Objects;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class ServerPackCreatorSplash {
    private final ReticulatingSplines RETICULATING_SPLINES = new ReticulatingSplines();
    private final JWindow SPLASH_WINDOW;
    private final JLabel PROGRESS_TEXT = new JLabel(this.RETICULATING_SPLINES.reticulate());
    private final JProgressBar PROGRESS_BAR = new JProgressBar();

    public ServerPackCreatorSplash(String version) {
        ImageIcon splashScreenBackgroundImage = new ImageIcon(ServerPackCreatorSplash.class.getResource("/de/griefed/resources/gui/splashscreen" + new Random().nextInt(3) + ".png"));
        BufferedImage bufferedImage = new BufferedImage(splashScreenBackgroundImage.getIconWidth(), splashScreenBackgroundImage.getIconHeight(), 2);
        Graphics2D graphics = bufferedImage.createGraphics();
        splashScreenBackgroundImage.paintIcon(null, graphics, 0, 0);
        graphics.dispose();
        final Color c0FFEE = new Color(192, 255, 238);
        final Color primary = new Color(50, 83, 88);
        this.SPLASH_WINDOW = new JWindow();
        this.SPLASH_WINDOW.setContentPane(new BackgroundPanel(bufferedImage, 2, 0.0f, 0.0f));
        this.SPLASH_WINDOW.getContentPane().setLayout(null);
        this.SPLASH_WINDOW.setSize(splashScreenBackgroundImage.getIconWidth(), splashScreenBackgroundImage.getIconHeight());
        this.SPLASH_WINDOW.setLocationRelativeTo(null);
        this.SPLASH_WINDOW.getContentPane().setBackground(c0FFEE);
        this.PROGRESS_TEXT.setFont(new Font("arial", 1, 20));
        this.PROGRESS_TEXT.setHorizontalAlignment(0);
        this.PROGRESS_TEXT.setBounds(0, Math.floorDiv(splashScreenBackgroundImage.getIconHeight(), 2) + 20, splashScreenBackgroundImage.getIconWidth(), 40);
        this.PROGRESS_TEXT.setForeground(c0FFEE);
        this.SPLASH_WINDOW.add(this.PROGRESS_TEXT);
        float offsetInPercent = 20.0f;
        this.PROGRESS_BAR.setBounds(Math.round((float)splashScreenBackgroundImage.getIconWidth() / 100.0f * offsetInPercent), Math.floorDiv(splashScreenBackgroundImage.getIconHeight(), 2), Math.round((float)splashScreenBackgroundImage.getIconWidth() / 100.0f * (100.0f - offsetInPercent * 2.0f)), 20);
        this.PROGRESS_BAR.setAlignmentY(0.0f);
        this.PROGRESS_BAR.setBorderPainted(true);
        this.PROGRESS_BAR.setStringPainted(true);
        this.PROGRESS_BAR.setBackground(Color.WHITE);
        this.PROGRESS_BAR.setUI(new BasicProgressBarUI(){

            @Override
            protected Color getSelectionBackground() {
                return primary;
            }

            @Override
            protected Color getSelectionForeground() {
                return c0FFEE;
            }
        });
        this.PROGRESS_BAR.setForeground(primary);
        this.PROGRESS_BAR.setValue(0);
        this.SPLASH_WINDOW.add(this.PROGRESS_BAR);
        JLabel versionLabel = new JLabel(version);
        versionLabel.setFont(new Font("arial", 1, 15));
        versionLabel.setBounds(15, splashScreenBackgroundImage.getIconHeight() - 40, splashScreenBackgroundImage.getIconWidth(), 40);
        versionLabel.setForeground(c0FFEE);
        this.SPLASH_WINDOW.add(versionLabel);
        JLabel someLuv = new JLabel("By Griefed");
        someLuv.setFont(new Font("arial", 1, 15));
        someLuv.setBounds(splashScreenBackgroundImage.getIconWidth() - 100, splashScreenBackgroundImage.getIconHeight() - 40, splashScreenBackgroundImage.getIconWidth(), 40);
        someLuv.setForeground(c0FFEE);
        this.SPLASH_WINDOW.add(someLuv);
        JButton EXIT = new JButton();
        int buttonSize = 16;
        try {
            EXIT.setIcon(new ImageIcon(ImageIO.read(Objects.requireNonNull(ServerPackCreatorWindow.class.getResource("/de/griefed/resources/gui/error.png"))).getScaledInstance(buttonSize, buttonSize, 4)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        EXIT.setBounds(splashScreenBackgroundImage.getIconWidth() - buttonSize, 0, buttonSize, buttonSize);
        EXIT.addActionListener(this::exit);
        EXIT.setContentAreaFilled(false);
        EXIT.setOpaque(false);
        EXIT.setBorder(null);
        EXIT.setBorderPainted(false);
        this.SPLASH_WINDOW.add(EXIT);
        this.SPLASH_WINDOW.setIconImage(Toolkit.getDefaultToolkit().getImage(Objects.requireNonNull(ServerPackCreatorWindow.class.getResource("/de/griefed/resources/gui/app.png"))));
        this.SPLASH_WINDOW.setVisible(true);
    }

    public void update(int progress) {
        this.PROGRESS_TEXT.setText(this.RETICULATING_SPLINES.reticulate());
        this.PROGRESS_TEXT.setHorizontalAlignment(0);
        this.PROGRESS_BAR.setValue(progress);
    }

    public void close() {
        this.SPLASH_WINDOW.dispose();
    }

    public void exit(ActionEvent actionEvent) {
        this.close();
        System.exit(0);
    }
}

