/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.swing;

import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.i18n.I18n;
import de.griefed.serverpackcreator.swing.ServerPackCreatorWindow;
import de.griefed.serverpackcreator.swing.TabCreateServerPack;
import de.griefed.serverpackcreator.swing.themes.DarkTheme;
import de.griefed.serverpackcreator.swing.themes.LightTheme;
import de.griefed.serverpackcreator.utilities.UpdateChecker;
import de.griefed.serverpackcreator.utilities.common.InvalidFileTypeException;
import de.griefed.serverpackcreator.utilities.common.Utilities;
import de.griefed.versionchecker.Update;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.Optional;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import mdlaf.MaterialLookAndFeel;
import mdlaf.components.textpane.MaterialTextPaneUI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MainMenuBar
extends Component {
    private static final Logger LOG = LogManager.getLogger(MainMenuBar.class);
    private final Clipboard CLIPBOARD = Toolkit.getDefaultToolkit().getSystemClipboard();
    private final I18n I18N;
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final UpdateChecker UPDATECHECKER;
    private final Utilities UTILITIES;
    private final LightTheme LIGHTTHEME;
    private final DarkTheme DARKTHEME;
    private final ServerPackCreatorWindow SERVERPACKCREATORWINDOW;
    private final TabCreateServerPack TAB_CREATESERVERPACK;
    private final JTabbedPane TABBEDPANE;
    private final WindowEvent CLOSEEVENT;
    private final MaterialLookAndFeel LAF_DARK;
    private final MaterialLookAndFeel LAF_LIGHT;
    private final Dimension CHOOSERDIMENSION = new Dimension(750, 450);
    private final Dimension ABOUTDIMENSION = new Dimension(925, 520);
    private final ImageIcon HELPICON = new ImageIcon(Objects.requireNonNull(MainMenuBar.class.getResource("/de/griefed/resources/gui/help.png")));
    private final ImageIcon ICON_HASTEBIN = new ImageIcon(Objects.requireNonNull(MainMenuBar.class.getResource("/de/griefed/resources/gui/hastebin.png")));
    private final ImageIcon INFO_ICON = new ImageIcon(ImageIO.read(Objects.requireNonNull(MainMenuBar.class.getResource("/de/griefed/resources/gui/info.png"))).getScaledInstance(48, 48, 4));
    private final JMenuBar MENUBAR = new JMenuBar();
    private final String[] HASTEOPTIONS = new String[3];
    private final StyledDocument ABOUT_DOCUMENT = new DefaultStyledDocument();
    private final StyledDocument CONFIG_DOCUMENT = new DefaultStyledDocument();
    private final StyledDocument SPCLOG_DOCUMENT = new DefaultStyledDocument();
    private final SimpleAttributeSet CONFIG_ATTRIBUTESET = new SimpleAttributeSet();
    private final SimpleAttributeSet SPCLOG_ATTRIBUTESET = new SimpleAttributeSet();
    private final JTextPane ABOUT_WINDOW_TEXTPANE = new JTextPane(this.ABOUT_DOCUMENT);
    private final JTextPane CONFIG_WINDOW_TEXTPANE = new JTextPane(this.CONFIG_DOCUMENT);
    private final JTextPane SPCLOG_WINDOW_TEXTPANE = new JTextPane(this.SPCLOG_DOCUMENT);
    private final JTextPane FILETOOLARGE_WINDOW_TEXTPANE = new JTextPane();
    private final MaterialTextPaneUI MATERIALTEXTPANEUI = new MaterialTextPaneUI();
    private JFileChooser configChooser;
    private File lastLoadedConfigurationFile = null;

    public MainMenuBar(I18n injectedI18n, LightTheme injectedLightTheme, DarkTheme injectedDarkTheme, ServerPackCreatorWindow injectedJFrame, MaterialLookAndFeel injectedLAF_Light, MaterialLookAndFeel injectedLAF_Dark, TabCreateServerPack injectedTabCreateServerPack, JTabbedPane injectedTabbedPane, ApplicationProperties injectedApplicationProperties, UpdateChecker injectedUpdateChecker, Utilities injectedUtilities) throws IOException {
        this.APPLICATIONPROPERTIES = injectedApplicationProperties;
        this.I18N = injectedI18n;
        this.UPDATECHECKER = injectedUpdateChecker;
        this.UTILITIES = injectedUtilities;
        this.LIGHTTHEME = injectedLightTheme;
        this.DARKTHEME = injectedDarkTheme;
        this.SERVERPACKCREATORWINDOW = injectedJFrame;
        this.LAF_LIGHT = injectedLAF_Light;
        this.LAF_DARK = injectedLAF_Dark;
        this.TAB_CREATESERVERPACK = injectedTabCreateServerPack;
        this.TABBEDPANE = injectedTabbedPane;
        this.CLOSEEVENT = new WindowEvent(this.SERVERPACKCREATORWINDOW, 201);
        String ABOUTWINDOWTEXT = this.I18N.getMessage("createserverpack.gui.about.text");
        this.ABOUT_WINDOW_TEXTPANE.setEditable(false);
        this.ABOUT_WINDOW_TEXTPANE.setOpaque(false);
        this.ABOUT_WINDOW_TEXTPANE.setMinimumSize(this.ABOUTDIMENSION);
        this.ABOUT_WINDOW_TEXTPANE.setPreferredSize(this.ABOUTDIMENSION);
        this.ABOUT_WINDOW_TEXTPANE.setMaximumSize(this.ABOUTDIMENSION);
        SimpleAttributeSet ABOUTATTRIBUTESET = new SimpleAttributeSet();
        StyleConstants.setBold(ABOUTATTRIBUTESET, true);
        StyleConstants.setFontSize(ABOUTATTRIBUTESET, 14);
        this.ABOUT_WINDOW_TEXTPANE.setCharacterAttributes(ABOUTATTRIBUTESET, true);
        StyleConstants.setAlignment(ABOUTATTRIBUTESET, 1);
        this.ABOUT_DOCUMENT.setParagraphAttributes(0, this.ABOUT_DOCUMENT.getLength(), ABOUTATTRIBUTESET, false);
        try {
            this.ABOUT_DOCUMENT.insertString(0, ABOUTWINDOWTEXT, ABOUTATTRIBUTESET);
        }
        catch (BadLocationException ex) {
            LOG.error("Error inserting text into aboutDocument.", (Throwable)ex);
        }
        this.ABOUT_WINDOW_TEXTPANE.addHierarchyListener(e1 -> {
            Dialog dialog;
            Window window = SwingUtilities.getWindowAncestor(this.ABOUT_WINDOW_TEXTPANE);
            if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                dialog.setResizable(true);
            }
        });
        this.HASTEOPTIONS[0] = this.I18N.getMessage("createserverpack.gui.about.hastebin.dialog.yes");
        this.HASTEOPTIONS[1] = this.I18N.getMessage("createserverpack.gui.about.hastebin.dialog.clipboard");
        this.HASTEOPTIONS[2] = this.I18N.getMessage("createserverpack.gui.about.hastebin.dialog.no");
        this.CONFIG_WINDOW_TEXTPANE.setOpaque(false);
        this.CONFIG_WINDOW_TEXTPANE.setEditable(false);
        StyleConstants.setBold(this.CONFIG_ATTRIBUTESET, true);
        StyleConstants.setFontSize(this.CONFIG_ATTRIBUTESET, 14);
        this.CONFIG_WINDOW_TEXTPANE.setCharacterAttributes(this.CONFIG_ATTRIBUTESET, true);
        StyleConstants.setAlignment(this.CONFIG_ATTRIBUTESET, 0);
        this.CONFIG_DOCUMENT.setParagraphAttributes(0, this.CONFIG_DOCUMENT.getLength(), this.CONFIG_ATTRIBUTESET, false);
        this.CONFIG_WINDOW_TEXTPANE.addHierarchyListener(e1 -> {
            Dialog dialog;
            Window window = SwingUtilities.getWindowAncestor(this.CONFIG_WINDOW_TEXTPANE);
            if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                dialog.setResizable(true);
            }
        });
        this.SPCLOG_WINDOW_TEXTPANE.setOpaque(false);
        this.SPCLOG_WINDOW_TEXTPANE.setEditable(false);
        StyleConstants.setBold(this.SPCLOG_ATTRIBUTESET, true);
        StyleConstants.setFontSize(this.SPCLOG_ATTRIBUTESET, 14);
        this.SPCLOG_WINDOW_TEXTPANE.setCharacterAttributes(this.SPCLOG_ATTRIBUTESET, true);
        StyleConstants.setAlignment(this.SPCLOG_ATTRIBUTESET, 0);
        this.SPCLOG_DOCUMENT.setParagraphAttributes(0, this.SPCLOG_DOCUMENT.getLength(), this.SPCLOG_ATTRIBUTESET, false);
        this.SPCLOG_WINDOW_TEXTPANE.addHierarchyListener(e1 -> {
            Dialog dialog;
            Window window = SwingUtilities.getWindowAncestor(this.SPCLOG_WINDOW_TEXTPANE);
            if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                dialog.setResizable(true);
            }
        });
    }

    public JMenuBar createMenuBar() {
        JMenu fileMenu = new JMenu(this.I18N.getMessage("menubar.gui.menu.file"));
        JMenu editMenu = new JMenu(this.I18N.getMessage("menubar.gui.menu.edit"));
        JMenu viewMenu = new JMenu(this.I18N.getMessage("menubar.gui.menu.view"));
        JMenu aboutMenu = new JMenu(this.I18N.getMessage("menubar.gui.menu.about"));
        JMenuItem file_NewConfigurationMenuItem = new JMenuItem(this.I18N.getMessage("menubar.gui.menuitem.newconfig"));
        JMenuItem file_LoadConfigMenuItem = new JMenuItem(this.I18N.getMessage("menubar.gui.menuitem.loadconfig"));
        JMenuItem file_SaveConfigMenuItem = new JMenuItem(this.I18N.getMessage("menubar.gui.menuitem.saveconfig"));
        JMenuItem file_SaveAsConfigMenuItem = new JMenuItem(this.I18N.getMessage("menubar.gui.menuitem.saveas"));
        JMenuItem file_UploadConfigurationToHasteBin = new JMenuItem(this.I18N.getMessage("menubar.gui.menuitem.uploadconfig"));
        JMenuItem file_UploadServerPackCreatorLogToHasteBin = new JMenuItem(this.I18N.getMessage("menubar.gui.menuitem.uploadlog"));
        JMenuItem file_UpdateFallbackModslist = new JMenuItem(this.I18N.getMessage("menubar.gui.menuitem.updatefallback"));
        JMenuItem file_ExitConfigMenuItem = new JMenuItem(this.I18N.getMessage("menubar.gui.menuitem.exit"));
        JMenuItem edit_SwitchTheme = new JMenuItem(this.I18N.getMessage("menubar.gui.menuitem.theme"));
        JMenuItem edit_OpenInEditorServerProperties = new JMenuItem(this.I18N.getMessage("menubar.gui.menuitem.serverproperties"));
        JMenuItem edit_OpenInEditorServerIcon = new JMenuItem(this.I18N.getMessage("menubar.gui.menuitem.servericon"));
        JMenuItem view_OpenAddonsDirectoryMenuItem = new JMenuItem(this.I18N.getMessage("menubar.gui.menuitem.addonsdir"));
        JMenuItem view_ExampleAddonRepositoryMenuItem = new JMenuItem(this.I18N.getMessage("menubar.gui.menuitem.exampleaddonrepo"));
        JMenuItem view_OpenServerPackCreatorDirectoryMenuItem = new JMenuItem(this.I18N.getMessage("menubar.gui.menuitem.spcdir"));
        JMenuItem view_OpenServerPacksDirectoryMenuItem = new JMenuItem(this.I18N.getMessage("menubar.gui.menuitem.serverpacksdir"));
        JMenuItem view_OpenServerFilesDirectoryMenuItem = new JMenuItem(this.I18N.getMessage("menubar.gui.menuitem.serverfilesdir"));
        JMenuItem view_OpenSPCLog = new JMenuItem(this.I18N.getMessage("menubar.gui.menuitem.spclog"));
        JMenuItem view_OpenModloaderInstallerLog = new JMenuItem(this.I18N.getMessage("menubar.gui.menuitem.modloaderlog"));
        JMenuItem view_OpenAddonLog = new JMenuItem(this.I18N.getMessage("menubar.gui.menuitem.addonlog"));
        new JMenuItem(this.I18N.getMessage("menubar.gui.menuitem.about"));
        JMenuItem about_OpenGitHubPageMenuItem = new JMenuItem(this.I18N.getMessage("menubar.gui.menuitem.repository"));
        JMenuItem about_OpenGitHubIssuesPageMenuItem = new JMenuItem(this.I18N.getMessage("menubar.gui.menuitem.issues"));
        JMenuItem about_OpenReleasesPageMenuItem = new JMenuItem(this.I18N.getMessage("menubar.gui.menuitem.releases"));
        JMenuItem about_OpenDiscordLinkMenuItem = new JMenuItem(this.I18N.getMessage("menubar.gui.menuitem.discord"));
        JMenuItem about_OpenDonationsPageMenuItem = new JMenuItem(this.I18N.getMessage("menubar.gui.menuitem.donate"));
        JMenuItem about_OpenWikiHelpMenuItem = new JMenuItem(this.I18N.getMessage("menubar.gui.menuitem.wiki.help"));
        JMenuItem about_OpenWikiHowToMenuItem = new JMenuItem(this.I18N.getMessage("menubar.gui.menuitem.wiki.howto"));
        JMenuItem about_CheckForUpdates = new JMenuItem(this.I18N.getMessage("menubar.gui.menuitem.updates"));
        file_NewConfigurationMenuItem.addActionListener(this::newConfiguration);
        file_LoadConfigMenuItem.addActionListener(this::loadConfigurationFromFileMenuItem);
        file_SaveConfigMenuItem.addActionListener(this::saveConfigToFileMenuItem);
        file_SaveAsConfigMenuItem.addActionListener(this::saveAsConfigToFileMenuItem);
        file_UploadConfigurationToHasteBin.addActionListener(this::uploadConfigurationToHasteBinMenuItem);
        file_UploadServerPackCreatorLogToHasteBin.addActionListener(this::uploadServerPackCreatorLogToHasteBinMenuItem);
        file_UpdateFallbackModslist.addActionListener(this::updateFallbackModslist);
        file_ExitConfigMenuItem.addActionListener(this::exitMenuItem);
        edit_SwitchTheme.addActionListener(this::switchThemeMenuItem);
        edit_OpenInEditorServerProperties.addActionListener(this::openInEditorServerProperties);
        edit_OpenInEditorServerIcon.addActionListener(this::openServerIcon);
        view_OpenServerPackCreatorDirectoryMenuItem.addActionListener(this::openSPCDirectoryMenuItem);
        view_OpenServerPacksDirectoryMenuItem.addActionListener(this::openServerPacksDirectoryMenuItem);
        view_OpenServerFilesDirectoryMenuItem.addActionListener(this::openServerFilesDirectoryMenuItem);
        view_OpenAddonsDirectoryMenuItem.addActionListener(this::openPluginsDirectoryMenuItem);
        view_ExampleAddonRepositoryMenuItem.addActionListener(this::viewExampleAddonMenuItem);
        view_OpenSPCLog.addActionListener(this::openSPClog);
        view_OpenModloaderInstallerLog.addActionListener(this::openModloaderInstallerLog);
        view_OpenAddonLog.addActionListener(this::openAddonsLog);
        about_OpenGitHubPageMenuItem.addActionListener(this::openGitHubMenuItem);
        about_OpenGitHubIssuesPageMenuItem.addActionListener(this::openIssuesMenuItem);
        about_OpenReleasesPageMenuItem.addActionListener(this::openReleaseMenuItem);
        about_OpenDiscordLinkMenuItem.addActionListener(this::openDiscordLinkMenuItem);
        about_OpenDonationsPageMenuItem.addActionListener(this::openDonateMenuItem);
        about_OpenWikiHelpMenuItem.addActionListener(this::openWikiHelpMenuItem);
        about_OpenWikiHowToMenuItem.addActionListener(this::openWikiHowToMenuItem);
        about_CheckForUpdates.addActionListener(this::checkForUpdates);
        fileMenu.add(file_NewConfigurationMenuItem);
        fileMenu.add(file_LoadConfigMenuItem);
        fileMenu.add(new JSeparator());
        fileMenu.add(file_SaveConfigMenuItem);
        fileMenu.add(file_SaveAsConfigMenuItem);
        fileMenu.add(new JSeparator());
        fileMenu.add(file_UploadConfigurationToHasteBin);
        fileMenu.add(file_UploadServerPackCreatorLogToHasteBin);
        fileMenu.add(new JSeparator());
        fileMenu.add(file_UpdateFallbackModslist);
        fileMenu.add(new JSeparator());
        fileMenu.add(file_ExitConfigMenuItem);
        editMenu.add(edit_OpenInEditorServerProperties);
        editMenu.add(edit_OpenInEditorServerIcon);
        editMenu.add(new JSeparator());
        editMenu.add(edit_SwitchTheme);
        viewMenu.add(view_OpenServerPackCreatorDirectoryMenuItem);
        viewMenu.add(view_OpenServerPacksDirectoryMenuItem);
        viewMenu.add(view_OpenServerFilesDirectoryMenuItem);
        viewMenu.add(view_OpenAddonsDirectoryMenuItem);
        viewMenu.add(new JSeparator());
        viewMenu.add(view_ExampleAddonRepositoryMenuItem);
        viewMenu.add(new JSeparator());
        viewMenu.add(view_OpenSPCLog);
        viewMenu.add(view_OpenModloaderInstallerLog);
        viewMenu.add(view_OpenAddonLog);
        aboutMenu.add(about_CheckForUpdates);
        aboutMenu.add(new JSeparator());
        aboutMenu.add(about_OpenWikiHelpMenuItem);
        aboutMenu.add(about_OpenWikiHowToMenuItem);
        aboutMenu.add(new JSeparator());
        aboutMenu.add(about_OpenGitHubPageMenuItem);
        aboutMenu.add(about_OpenGitHubIssuesPageMenuItem);
        aboutMenu.add(about_OpenReleasesPageMenuItem);
        aboutMenu.add(new JSeparator());
        aboutMenu.add(about_OpenDiscordLinkMenuItem);
        aboutMenu.add(new JSeparator());
        aboutMenu.add(about_OpenDonationsPageMenuItem);
        this.MENUBAR.add(fileMenu);
        this.MENUBAR.add(editMenu);
        this.MENUBAR.add(viewMenu);
        this.MENUBAR.add(aboutMenu);
        return this.MENUBAR;
    }

    private void openAddonsLog(ActionEvent actionEvent) {
        LOG.debug("Clicked open Addons-log.");
        this.UTILITIES.FileUtils().openFile("logs/addons.log");
    }

    private void openModloaderInstallerLog(ActionEvent actionEvent) {
        LOG.debug("Clicked open Modloader-Installer-log.");
        this.UTILITIES.FileUtils().openFile("logs/modloader_installer.log");
    }

    private void openSPClog(ActionEvent actionEvent) {
        LOG.debug("Clicked open ServerPackCreator-log.");
        this.UTILITIES.FileUtils().openFile("logs/serverpackcreator.log");
    }

    private void checkForUpdates(ActionEvent actionEvent) {
        LOG.debug("Clicked Check for Updates");
        if (!this.displayUpdateDialog()) {
            JOptionPane.showMessageDialog(this.SERVERPACKCREATORWINDOW, this.I18N.getMessage("menubar.gui.menuitem.updates.none") + "   ", this.I18N.getMessage("menubar.gui.menuitem.updates.none.title") + "   ", 1, this.INFO_ICON);
        }
    }

    protected boolean displayUpdateDialog() {
        Optional<Update> update = this.UPDATECHECKER.checkForUpdate(this.APPLICATIONPROPERTIES.SERVERPACKCREATOR_VERSION(), this.APPLICATIONPROPERTIES.checkForAvailablePreReleases());
        if (update.isPresent()) {
            String textContent = String.format(this.I18N.getMessage("update.dialog.new"), update.get().url());
            DefaultStyledDocument styledDocument = new DefaultStyledDocument();
            SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
            MaterialTextPaneUI materialTextPaneUI = new MaterialTextPaneUI();
            JTextPane jTextPane = new JTextPane(styledDocument);
            StyleConstants.setBold(simpleAttributeSet, true);
            StyleConstants.setFontSize(simpleAttributeSet, 14);
            jTextPane.setCharacterAttributes(simpleAttributeSet, true);
            StyleConstants.setAlignment(simpleAttributeSet, 0);
            styledDocument.setParagraphAttributes(0, styledDocument.getLength(), simpleAttributeSet, false);
            jTextPane.addHierarchyListener(e1 -> {
                Dialog dialog;
                Window window = SwingUtilities.getWindowAncestor(jTextPane);
                if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                    dialog.setResizable(true);
                }
            });
            jTextPane.setOpaque(false);
            jTextPane.setEditable(false);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Object[] options = new String[]{this.I18N.getMessage("update.dialog.yes"), this.I18N.getMessage("update.dialog.no"), this.I18N.getMessage("update.dialog.clipboard")};
            try {
                styledDocument.insertString(0, textContent, simpleAttributeSet);
            }
            catch (BadLocationException ex) {
                LOG.error("Error inserting text into aboutDocument.", (Throwable)ex);
            }
            materialTextPaneUI.installUI(jTextPane);
            switch (JOptionPane.showOptionDialog(this.SERVERPACKCREATORWINDOW, jTextPane, this.I18N.getMessage("update.dialog.available"), -1, 1, this.INFO_ICON, options, options[0])) {
                case 0: {
                    try {
                        this.UTILITIES.WebUtils().openLinkInBrowser(update.get().url().toURI());
                    }
                    catch (RuntimeException | URISyntaxException ex) {
                        LOG.error("Error opening browser.", (Throwable)ex);
                    }
                    break;
                }
                case 1: {
                    clipboard.setContents(new StringSelection(update.get().url().toString()), null);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    private void updateFallbackModslist(ActionEvent actionEvent) {
        LOG.debug("Running update check for fallback modslist...");
        if (this.APPLICATIONPROPERTIES.updateFallback()) {
            JOptionPane.showMessageDialog(this.SERVERPACKCREATORWINDOW, this.I18N.getMessage("menubar.gui.menuitem.updatefallback.updated"), this.I18N.getMessage("menubar.gui.menuitem.updatefallback.title"), 1, this.INFO_ICON);
        } else {
            JOptionPane.showMessageDialog(this.SERVERPACKCREATORWINDOW, this.I18N.getMessage("menubar.gui.menuitem.updatefallback.nochange"), this.I18N.getMessage("menubar.gui.menuitem.updatefallback.title"), 1, this.INFO_ICON);
        }
    }

    private void openWikiHelpMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked Help.");
        this.UTILITIES.WebUtils().openLinkInBrowser(URI.create("https://wiki.griefed.de/en/Documentation/ServerPackCreator/ServerPackCreator-Help"));
    }

    private void openWikiHowToMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked Getting started.");
        this.UTILITIES.WebUtils().openLinkInBrowser(URI.create("https://wiki.griefed.de/en/Documentation/ServerPackCreator/ServerPackCreator-HowTo"));
    }

    private void newConfiguration(ActionEvent actionEvent) {
        LOG.debug("Clearing GUI...");
        this.TAB_CREATESERVERPACK.clearInterface();
        this.lastLoadedConfigurationFile = null;
    }

    private void openDiscordLinkMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked Join Discord.");
        this.UTILITIES.WebUtils().openLinkInBrowser(URI.create("https://discord.griefed.de"));
    }

    private void openIssuesMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked Open Issues page on GitHub.");
        this.UTILITIES.WebUtils().openLinkInBrowser(URI.create("https://github.com/Griefed/ServerPackCreator/issues"));
    }

    private void uploadServerPackCreatorLogToHasteBinMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked Upload ServerPackCreator Log to HasteBin.");
        if (this.UTILITIES.WebUtils().hasteBinPreChecks(new File("logs/serverpackcreator.log"))) {
            String urltoHasteBin = this.UTILITIES.WebUtils().createHasteBinFromFile(new File("logs/serverpackcreator.log"));
            String textContent = String.format("URL: %s", urltoHasteBin);
            try {
                this.SPCLOG_DOCUMENT.insertString(0, textContent, this.SPCLOG_ATTRIBUTESET);
            }
            catch (BadLocationException ex) {
                LOG.error("Error inserting text into aboutDocument.", (Throwable)ex);
            }
            this.displayUploadUrl(urltoHasteBin, this.SPCLOG_WINDOW_TEXTPANE);
        } else {
            this.fileTooLargeDialog();
        }
    }

    private void uploadConfigurationToHasteBinMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked Upload Configuration to HasteBin.");
        if (this.UTILITIES.WebUtils().hasteBinPreChecks(new File("serverpackcreator.conf"))) {
            String urltoHasteBin = this.UTILITIES.WebUtils().createHasteBinFromFile(new File("serverpackcreator.conf"));
            String textContent = String.format("URL: %s", urltoHasteBin);
            try {
                this.CONFIG_DOCUMENT.insertString(0, textContent, this.CONFIG_ATTRIBUTESET);
            }
            catch (BadLocationException ex) {
                LOG.error("Error inserting text into aboutDocument.", (Throwable)ex);
            }
            this.displayUploadUrl(urltoHasteBin, this.CONFIG_WINDOW_TEXTPANE);
        } else {
            this.fileTooLargeDialog();
        }
    }

    private void displayUploadUrl(String urltoHasteBin, JTextPane displayTextPane) {
        this.MATERIALTEXTPANEUI.installUI(displayTextPane);
        switch (JOptionPane.showOptionDialog(this.SERVERPACKCREATORWINDOW, displayTextPane, this.I18N.getMessage("createserverpack.gui.about.hastebin.dialog"), -1, 1, this.ICON_HASTEBIN, this.HASTEOPTIONS, this.HASTEOPTIONS[0])) {
            case 0: {
                this.UTILITIES.WebUtils().openLinkInBrowser(URI.create(urltoHasteBin));
                break;
            }
            case 1: {
                this.CLIPBOARD.setContents(new StringSelection(urltoHasteBin), null);
                break;
            }
        }
    }

    private void fileTooLargeDialog() {
        this.MATERIALTEXTPANEUI.installUI(this.FILETOOLARGE_WINDOW_TEXTPANE);
        JOptionPane.showConfirmDialog(this.SERVERPACKCREATORWINDOW, this.I18N.getMessage("menubar.gui.filetoolarge"), this.I18N.getMessage("menubar.gui.filetoolargetitle"), -1, 2, this.ICON_HASTEBIN);
    }

    private void openInEditorServerProperties(ActionEvent actionEvent) {
        LOG.debug("Clicked Open server.properties in Editor.");
        if (new File(this.TAB_CREATESERVERPACK.getServerPropertiesPath()).isFile()) {
            this.UTILITIES.FileUtils().openFile(this.TAB_CREATESERVERPACK.getServerPropertiesPath());
        } else {
            this.UTILITIES.FileUtils().openFile("./server_files/server.properties");
        }
    }

    private void openServerIcon(ActionEvent actionEvent) {
        LOG.debug("Clicked Open server-icon.png in Editor.");
        if (new File(this.TAB_CREATESERVERPACK.getServerIconPath()).isFile()) {
            this.UTILITIES.FileUtils().openFile(this.TAB_CREATESERVERPACK.getServerIconPath());
        } else {
            this.UTILITIES.FileUtils().openFile("./server_files/server-icon.png");
        }
    }

    private void exitMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked Exit.");
        this.SERVERPACKCREATORWINDOW.dispatchEvent(this.CLOSEEVENT);
    }

    private void saveAsConfigToFileMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked Save As...");
        this.configChooser = new JFileChooser();
        this.configChooser.setCurrentDirectory(new File("."));
        this.configChooser.setDialogTitle("Store current configuration");
        this.configChooser.setFileSelectionMode(0);
        this.configChooser.setFileFilter(new FileNameExtensionFilter(this.I18N.getMessage("createserverpack.gui.buttonloadconfig.filter"), "conf"));
        this.configChooser.setAcceptAllFileFilterUsed(false);
        this.configChooser.setMultiSelectionEnabled(false);
        this.configChooser.setPreferredSize(this.CHOOSERDIMENSION);
        if (this.configChooser.showOpenDialog(this.SERVERPACKCREATORWINDOW) == 0) {
            try {
                if (this.configChooser.getSelectedFile().getCanonicalPath().endsWith(".conf")) {
                    this.TAB_CREATESERVERPACK.saveConfig(new File(this.configChooser.getSelectedFile().getCanonicalPath()));
                    LOG.debug("Saved configuration to: " + this.configChooser.getSelectedFile().getCanonicalPath());
                } else {
                    this.TAB_CREATESERVERPACK.saveConfig(new File(this.configChooser.getSelectedFile().getCanonicalPath() + ".conf"));
                    LOG.debug("Saved configuration to: " + this.configChooser.getSelectedFile().getCanonicalPath() + ".conf");
                }
            }
            catch (IOException ex) {
                LOG.error("Error loading configuration from selected file.", (Throwable)ex);
            }
        }
    }

    private void saveConfigToFileMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked Save.");
        LOG.debug("Saving serverpackcreator.conf");
        this.TAB_CREATESERVERPACK.saveConfig(new File("./serverpackcreator.conf"));
        if (this.lastLoadedConfigurationFile != null && this.APPLICATIONPROPERTIES.getSaveLoadedConfiguration()) {
            LOG.debug("Saving " + this.lastLoadedConfigurationFile.getName());
            this.TAB_CREATESERVERPACK.saveConfig(this.lastLoadedConfigurationFile);
        }
    }

    private void switchThemeMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked Toggle light/dark-mode.");
        if (!this.APPLICATIONPROPERTIES.isDarkTheme()) {
            try {
                UIManager.setLookAndFeel(this.LAF_DARK);
                MaterialLookAndFeel.changeTheme(this.DARKTHEME);
                this.APPLICATIONPROPERTIES.setTheme(true);
                this.APPLICATIONPROPERTIES.saveToDisk(this.APPLICATIONPROPERTIES.SERVERPACKCREATOR_PROPERTIES());
            }
            catch (UnsupportedLookAndFeelException ex) {
                LOG.error("Couldn't change theme.", (Throwable)ex);
            }
        } else {
            try {
                UIManager.setLookAndFeel(this.LAF_LIGHT);
                MaterialLookAndFeel.changeTheme(this.LIGHTTHEME);
                this.APPLICATIONPROPERTIES.setTheme(false);
                this.APPLICATIONPROPERTIES.saveToDisk(this.APPLICATIONPROPERTIES.SERVERPACKCREATOR_PROPERTIES());
            }
            catch (UnsupportedLookAndFeelException ex) {
                LOG.error("Couldn't change theme.", (Throwable)ex);
            }
        }
        SwingUtilities.updateComponentTreeUI(this.SERVERPACKCREATORWINDOW);
        this.TABBEDPANE.setOpaque(true);
        this.TAB_CREATESERVERPACK.validateInputFields();
        this.TAB_CREATESERVERPACK.updatePanelTheme();
    }

    private void loadConfigurationFromFileMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked load configuration from file.");
        this.configChooser = new JFileChooser();
        this.configChooser.setCurrentDirectory(new File("."));
        this.configChooser.setDialogTitle(this.I18N.getMessage("createserverpack.gui.buttonloadconfig.title"));
        this.configChooser.setFileSelectionMode(0);
        this.configChooser.setFileFilter(new FileNameExtensionFilter(this.I18N.getMessage("createserverpack.gui.buttonloadconfig.filter"), "conf"));
        this.configChooser.setAcceptAllFileFilterUsed(false);
        this.configChooser.setMultiSelectionEnabled(false);
        this.configChooser.setPreferredSize(this.CHOOSERDIMENSION);
        if (this.configChooser.showOpenDialog(this.SERVERPACKCREATORWINDOW) == 0) {
            try {
                File specifiedConfigFile;
                LOG.info("Loading from configuration file: " + this.configChooser.getSelectedFile().getCanonicalPath());
                try {
                    specifiedConfigFile = new File(this.UTILITIES.FileUtils().resolveLink(this.configChooser.getSelectedFile()));
                }
                catch (InvalidFileTypeException ex) {
                    LOG.error("Could not resolve link/symlink. Using entry from user input for checks.", (Throwable)ex);
                    specifiedConfigFile = new File(this.configChooser.getSelectedFile().getCanonicalPath().replace("\\", "/"));
                }
                this.TAB_CREATESERVERPACK.loadConfig(specifiedConfigFile);
                this.lastLoadedConfigurationFile = specifiedConfigFile;
            }
            catch (IOException ex) {
                LOG.error("Error loading configuration from selected file.", (Throwable)ex);
            }
            LOG.debug("Configuration successfully loaded.");
        }
    }

    private void openPluginsDirectoryMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked open plugins directory.");
        this.UTILITIES.FileUtils().openFolder(this.APPLICATIONPROPERTIES.DIRECTORY_PLUGINS());
    }

    private void viewExampleAddonMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked view example addon");
        this.UTILITIES.WebUtils().openLinkInBrowser(URI.create("https://github.com/Griefed/ServerPackCreatorExampleAddon"));
    }

    private void openSPCDirectoryMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked open installation directory.");
        this.UTILITIES.FileUtils().openFolder(".");
    }

    private void openServerPacksDirectoryMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked open server packs directory.");
        this.UTILITIES.FileUtils().openFolder(this.APPLICATIONPROPERTIES.getDirectoryServerPacks());
    }

    private void openServerFilesDirectoryMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked open server files directory.");
        this.UTILITIES.FileUtils().openFolder(this.APPLICATIONPROPERTIES.DIRECTORY_SERVER_FILES());
    }

    private void openAboutSPCMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked open about window.");
        JScrollPane ABOUTWINDOWSCROLLPANE = new JScrollPane(this.ABOUT_WINDOW_TEXTPANE, 22, 31);
        ABOUTWINDOWSCROLLPANE.setMinimumSize(this.ABOUTDIMENSION);
        ABOUTWINDOWSCROLLPANE.setPreferredSize(this.ABOUTDIMENSION);
        ABOUTWINDOWSCROLLPANE.setMaximumSize(this.ABOUTDIMENSION);
        JOptionPane.showMessageDialog(this.SERVERPACKCREATORWINDOW, ABOUTWINDOWSCROLLPANE, this.I18N.getMessage("createserverpack.gui.createserverpack.about.title"), 1, this.HELPICON);
    }

    private void openGitHubMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked open GitHub repository link.");
        this.UTILITIES.WebUtils().openLinkInBrowser(URI.create("https://github.com/Griefed/ServerPackCreator"));
    }

    private void openDonateMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked open donations link.");
        this.UTILITIES.WebUtils().openLinkInBrowser(URI.create("https://github.com/sponsors/Griefed"));
    }

    private void openReleaseMenuItem(ActionEvent actionEvent) {
        LOG.debug("Clicked open releases link");
        this.UTILITIES.WebUtils().openLinkInBrowser(URI.create("https://github.com/Griefed/ServerPackCreator/releases"));
    }
}

