/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.i18n;

import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.i18n.IncorrectLanguageException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public final class I18n {
    private static final Logger LOG = LogManager.getLogger(I18n.class);
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final ResourceBundle FALLBACKRESOURCES = ResourceBundle.getBundle("de/griefed/resources/lang/lang_en_us", new Locale("en", "us"), new UTF8Control());
    private final Map<String, String> CURRENT_LANGUAGE = new HashMap<String, String>(2);
    private final File PROPERTIESFILE = new File("serverpackcreator.properties");
    private final String MAP_PATH_LANGUAGE = "language";
    private final String MAP_PATH_COUNTRY = "country";
    private final List<String> SUPPORTED_LANGUAGES = new ArrayList<String>(Arrays.asList("en_us", "uk_ua", "de_de"));
    private ResourceBundle filesystemResources = null;
    private ResourceBundle jarResources = null;

    @Autowired
    public I18n(ApplicationProperties injectedApplicationProperties) {
        this(injectedApplicationProperties, injectedApplicationProperties.getLanguage());
    }

    public I18n(ApplicationProperties injectedApplicationProperties, String locale) {
        this.APPLICATIONPROPERTIES = injectedApplicationProperties;
        try {
            this.initialize(locale);
            this.writeLocaleToFile(locale);
        }
        catch (IncorrectLanguageException ex) {
            LOG.error("The specified language is not supported: " + locale, (Throwable)ex);
            this.initialize();
        }
    }

    public void initialize() {
        try {
            this.initialize("en_us");
        }
        catch (IncorrectLanguageException e) {
            LOG.error("Error during default localization initialization.");
        }
    }

    public void initialize(String locale) throws IncorrectLanguageException {
        if (!this.SUPPORTED_LANGUAGES.contains(locale)) {
            LOG.warn("The specified language is not officially supported. You may provide your own definitions and translations.");
            LOG.warn("Beware: When doing this, you are on your own and will receive no support. Errors and problems may occur when loading and working with custom language definitions and translations which are not officially supported yet.");
            LOG.warn("When you are satisfied with your translations, feel free to open an issue on GitHub and submit them so they can get officially added and supported to and by ServerPackCreator!");
            LOG.warn("GitHub issues available at: https://github.com/Griefed/ServerPackCreator/issues");
        }
        if (!locale.contains("_")) {
            LOG.error("Locales must be formatted like this: \"en_us\",\"uk_ua\",\"de_de\"");
            throw new IncorrectLanguageException(locale);
        }
        String[] langCode = locale.split("_");
        this.CURRENT_LANGUAGE.put("language", langCode[0]);
        this.CURRENT_LANGUAGE.put("country", langCode[1]);
        try (FileInputStream fileInputStream = new FileInputStream(String.format("lang/lang_%s.properties", locale));){
            this.filesystemResources = new PropertyResourceBundle(new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8));
            LOG.debug("Using language-definitions from file on filesystem.");
        }
        catch (IOException ex) {
            LOG.error("Local language-definitions corrupted, not present or otherwise unreadable. Using definitions from JAR-file. " + ex.getMessage());
            try {
                this.filesystemResources = ResourceBundle.getBundle(String.format("de/griefed/resources/lang/lang_%s", locale), new Locale(this.CURRENT_LANGUAGE.get("language").toLowerCase(), this.CURRENT_LANGUAGE.get("country").toUpperCase()), new UTF8Control());
            }
            catch (Exception ex2) {
                LOG.error("Locale resource for " + locale + " not found in JAR-file. Falling back to en_us. " + ex2.getMessage());
                this.filesystemResources = ResourceBundle.getBundle("de/griefed/resources/lang/lang_en_us", new Locale("en", "US"), new UTF8Control());
                locale = "en_us";
            }
        }
        try {
            this.jarResources = ResourceBundle.getBundle(String.format("de/griefed/resources/lang/lang_%s", locale), new Locale(this.CURRENT_LANGUAGE.get("language").toLowerCase(), this.CURRENT_LANGUAGE.get("country").toUpperCase()), new UTF8Control());
        }
        catch (Exception ex) {
            LOG.error("Locale resource for " + locale + " not found in JAR-file. Falling back to en_us. " + ex.getMessage());
            this.jarResources = this.FALLBACKRESOURCES;
        }
        if (this.APPLICATIONPROPERTIES.SERVERPACKCREATOR_VERSION().equals("dev")) {
            LOG.info(this.getMessage("encoding.check"));
            System.out.println(this.getMessage("encoding.check"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage(String languageKey) {
        String text = null;
        String value = null;
        try {
            value = this.filesystemResources.getString(languageKey);
        }
        catch (MissingResourceException ex) {
            if (this.jarResources != null) {
                try {
                    value = this.jarResources.getString(languageKey);
                    LOG.debug(String.format("Language key \"%s\" not found in local file resource \"%s_%s\". Using fallback from JAR-resources.", languageKey, this.CURRENT_LANGUAGE.get("language"), this.CURRENT_LANGUAGE.get("country")));
                }
                catch (MissingResourceException ex2) {
                    value = this.FALLBACKRESOURCES.getString(languageKey);
                    LOG.debug(String.format("Language key \"%s\" not found in JAR-locale-resource \"%s_%s\". Using fallback from \"en_US\".", ex2.getKey(), this.CURRENT_LANGUAGE.get("language"), this.CURRENT_LANGUAGE.get("country")));
                }
            } else {
                value = this.FALLBACKRESOURCES.getString(languageKey);
                LOG.debug(String.format("Language key \"%s\" not found for locale \"%s_%s\". Using JAR-resources fallback from \"en_US\".", ex.getKey(), this.CURRENT_LANGUAGE.get("language"), this.CURRENT_LANGUAGE.get("country")));
            }
        }
        finally {
            text = value != null ? value : "i18n: No value found for key " + languageKey + " , Locale: " + this.CURRENT_LANGUAGE.get("language") + "_" + this.CURRENT_LANGUAGE.get("country");
        }
        return text;
    }

    void writeLocaleToFile(String locale) {
        if (!this.APPLICATIONPROPERTIES.getLanguage().equals(locale)) {
            try (OutputStream outputStream = Files.newOutputStream(this.PROPERTIESFILE.toPath(), new OpenOption[0]);){
                this.APPLICATIONPROPERTIES.setProperty("de.griefed.serverpackcreator.language", locale);
                this.APPLICATIONPROPERTIES.store(outputStream, null);
            }
            catch (IOException ex) {
                LOG.error("Couldn't write properties-file.", (Throwable)ex);
            }
        }
    }

    private class UTF8Control
    extends ResourceBundle.Control {
        private UTF8Control() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IOException {
            String bundleName = this.toBundleName(baseName, locale);
            String resourceName = this.toResourceName(bundleName, "properties");
            PropertyResourceBundle bundle2 = null;
            InputStream stream = null;
            if (reload) {
                URLConnection connection;
                URL url = loader.getResource(resourceName);
                if (url != null && (connection = url.openConnection()) != null) {
                    connection.setUseCaches(false);
                    stream = connection.getInputStream();
                }
            } else {
                stream = loader.getResourceAsStream(resourceName);
            }
            if (stream != null) {
                try {
                    bundle2 = new PropertyResourceBundle(new InputStreamReader(stream, StandardCharsets.UTF_8));
                }
                finally {
                    stream.close();
                }
            }
            return bundle2;
        }
    }
}

