/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator;

import de.griefed.serverpackcreator.utilities.common.FileUtilities;
import de.griefed.serverpackcreator.utilities.common.InvalidFileTypeException;
import de.griefed.serverpackcreator.utilities.common.ListUtilities;
import de.griefed.serverpackcreator.utilities.common.SystemUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
public final class ApplicationProperties
extends Properties {
    private static final Logger LOG = LogManager.getLogger(ApplicationProperties.class);
    private final FileUtilities FILE_UTILITIES;
    private final SystemUtilities SYSTEM_UTILITIES;
    private final ListUtilities LIST_UTILITIES;
    private final String SERVERPACKCREATOR_PROPERTIES = "serverpackcreator.properties";
    private final File SERVERPACKCREATOR_PROPERTIES_FILE = new File("serverpackcreator.properties");
    private final String FALLBACK_MODS_DEFAULT_ASSTRING = "3dskinlayers-,Absolutely-Not-A-Zoom-Mod-,AdvancedChat-,AdvancedChatCore-,AdvancedChatHUD-,AdvancedCompas-,Ambience,AmbientEnvironment-,AmbientSounds_,AreYouBlind-,Armor Status HUD-,ArmorSoundTweak-,BH-Menu-,Batty's Coordinates PLUS Mod,BetterAdvancements-,BetterAnimationsCollection-,BetterDarkMode-,BetterF3-,BetterFoliage-,BetterPingDisplay-,BetterPlacement-,BetterTaskbar-,BetterThirdPerson,BetterTitleScreen-,Blur-,BorderlessWindow-,CTM-,ChunkAnimator-,ClientTweaks_,Controller Support-,Controlling-,CraftPresence-,CustomCursorMod-,CustomMainMenu-,DefaultOptions_,DefaultSettings-,DeleteWorldsToTrash-,DetailArmorBar-,Ding-,DistantHorizons-,DripSounds-,Durability101-,DurabilityNotifier-,DynamicSurroundings-,DynamicSurroundingsHuds-,EffectsLeft-,EiraMoticons_,EnchantmentDescriptions-,EnhancedVisuals_,EquipmentCompare-,FPS-Monitor-,FabricCustomCursorMod-,Fallingleaves-,FancySpawnEggs,FancyVideo-API-,FirstPersonMod,FogTweaker-,ForgeCustomCursorMod-,FpsReducer-,FpsReducer2-,FullscreenWindowed-,GameMenuModOption-,HealthOverlay-,HorseStatsMod-,InventoryEssentials_,InventoryHud_[1.17.1].forge-,InventorySpam-,InventoryTweaks-,ItemBorders-,ItemPhysicLite_,ItemStitchingFix-,JBRA-Client-,JustEnoughCalculation-,JustEnoughEffects-,JustEnoughProfessions-,JustEnoughResources-,LLOverlayReloaded-,LOTRDRP-,LegendaryTooltips,LegendaryTooltips-,LightOverlay-,MoBends,MouseTweaks-,MyServerIsCompatible-,Neat ,Neat-,NekosEnchantedBooks-,NoAutoJump-,NoFog-,Notes-,NotifMod-,OldJavaWarning-,OptiFine,OptiFine_,OptiForge,OptiForge-,PackMenu-,PackModeMenu-,PickUpNotifier-,Ping-,PresenceFootsteps-,RPG-HUD-,ReAuth-,ResourceLoader-,ResourcePackOrganizer,ShoulderSurfing-,ShulkerTooltip-,SimpleDiscordRichPresence-,SimpleWorldTimer-,SoundFilters-,SpawnerFix-,TRansliterationLib-,TipTheScales-,Tips-,Toast Control-,Toast-Control-,ToastControl-,TravelersTitles-,VoidFog-,WindowedFullscreen-,WorldNameRandomizer-,[1.12.2]DamageIndicatorsMod-,[1.12.2]bspkrscore-,antighost-,anviltooltipmod-,appleskin-,armorchroma-,armorpointspp-,auditory-,authme-,auto-reconnect-,autojoin-,autoreconnect-,axolotl-item-fix-,backtools-,bannerunlimited-,beenfo-1.19-,better-recipe-book-,betterbiomeblend-,bhmenu-,blur-,borderless-mining-,catalogue-,charmonium-,chat_heads-,cherishedworlds-,cirback-1.0-,classicbar-,clickadv-,clienttweaks-,combat_music-,configured-,controllable-,cullleaves-,cullparticles-,custom-crosshair-mod-,customdiscordrpc-,darkness-,dashloader-,defaultoptions-,desiredservers-,discordrpc-,drippyloadingscreen-,drippyloadingscreen_,dynamic-fps-,dynamic-music-,dynamiclights-,dynmus-,effective-,eggtab-,eguilib-,eiramoticons-,enchantment-lore-,entity-texture-features-,entityculling-,exhaustedstamina-,extremesoundmuffler-,fabricemotes-,fancymenu_,fancymenu_video_extension,findme-,flickerfix-,fm_audio_extension_,forgemod_VoxelMap-,freelook-,galacticraft-rpc-,gamestagesviewer-,grid-,helium-,hiddenrecipebook_,infinitemusic-,inventoryprofiles,invtweaks-,itemzoom,itlt-,jeed-,jehc-,jeiintegration_,just-enough-harvestcraft-,justenoughbeacons-,justenoughdrags-,justzoom_,keymap-,keywizard-,konkrete_,konkrete_forge_,lazydfu-,light-overlay-,lightfallclient-,loadmyresources_,lock_minecart_view-,lootbeams-,lwl-,magnesium_extras-,maptooltip-,massunbind,mcbindtype-,mcwifipnp-,medievalmusic-,mightyarchitect-,mindful-eating-,minetogether-,mobplusplus-,modcredits-,modernworldcreation_,modmenu-,modnametooltip-,modnametooltip_,moreoverlays-,mousewheelie-,movement-vision-,multihotbar-,music-duration-reducer-,musicdr-,neiRecipeHandlers-,ngrok-lan-expose-mod-,nopotionshift_,notenoughanimations-,oculus-,ornaments-,overloadedarmorbar-,panorama-,paperdoll-,phosphor-,preciseblockplacing-,realm-of-lost-souls-,rebrand-,replanter-,rubidium-,rubidium_extras-,screenshot-to-clipboard-,shutupexperimentalsettings-,shutupmodelloader-,signtools-,simple-rpc-,simpleautorun-,smartcursor-,smoothboot-,smoothfocus-,sounddeviceoptions-,soundreloader-,spoticraft-,tconplanner-,timestamps-,tooltipscroller-,torchoptimizer-,torohealth-,totaldarkness,toughnessbar-,wisla-,xlifeheartcolors-,yisthereautojump-";
    private final TreeSet<String> FALLBACK_CLIENTSIDE_MODS = new TreeSet<String>(Arrays.asList("3dskinlayers-,Absolutely-Not-A-Zoom-Mod-,AdvancedChat-,AdvancedChatCore-,AdvancedChatHUD-,AdvancedCompas-,Ambience,AmbientEnvironment-,AmbientSounds_,AreYouBlind-,Armor Status HUD-,ArmorSoundTweak-,BH-Menu-,Batty's Coordinates PLUS Mod,BetterAdvancements-,BetterAnimationsCollection-,BetterDarkMode-,BetterF3-,BetterFoliage-,BetterPingDisplay-,BetterPlacement-,BetterTaskbar-,BetterThirdPerson,BetterTitleScreen-,Blur-,BorderlessWindow-,CTM-,ChunkAnimator-,ClientTweaks_,Controller Support-,Controlling-,CraftPresence-,CustomCursorMod-,CustomMainMenu-,DefaultOptions_,DefaultSettings-,DeleteWorldsToTrash-,DetailArmorBar-,Ding-,DistantHorizons-,DripSounds-,Durability101-,DurabilityNotifier-,DynamicSurroundings-,DynamicSurroundingsHuds-,EffectsLeft-,EiraMoticons_,EnchantmentDescriptions-,EnhancedVisuals_,EquipmentCompare-,FPS-Monitor-,FabricCustomCursorMod-,Fallingleaves-,FancySpawnEggs,FancyVideo-API-,FirstPersonMod,FogTweaker-,ForgeCustomCursorMod-,FpsReducer-,FpsReducer2-,FullscreenWindowed-,GameMenuModOption-,HealthOverlay-,HorseStatsMod-,InventoryEssentials_,InventoryHud_[1.17.1].forge-,InventorySpam-,InventoryTweaks-,ItemBorders-,ItemPhysicLite_,ItemStitchingFix-,JBRA-Client-,JustEnoughCalculation-,JustEnoughEffects-,JustEnoughProfessions-,JustEnoughResources-,LLOverlayReloaded-,LOTRDRP-,LegendaryTooltips,LegendaryTooltips-,LightOverlay-,MoBends,MouseTweaks-,MyServerIsCompatible-,Neat ,Neat-,NekosEnchantedBooks-,NoAutoJump-,NoFog-,Notes-,NotifMod-,OldJavaWarning-,OptiFine,OptiFine_,OptiForge,OptiForge-,PackMenu-,PackModeMenu-,PickUpNotifier-,Ping-,PresenceFootsteps-,RPG-HUD-,ReAuth-,ResourceLoader-,ResourcePackOrganizer,ShoulderSurfing-,ShulkerTooltip-,SimpleDiscordRichPresence-,SimpleWorldTimer-,SoundFilters-,SpawnerFix-,TRansliterationLib-,TipTheScales-,Tips-,Toast Control-,Toast-Control-,ToastControl-,TravelersTitles-,VoidFog-,WindowedFullscreen-,WorldNameRandomizer-,[1.12.2]DamageIndicatorsMod-,[1.12.2]bspkrscore-,antighost-,anviltooltipmod-,appleskin-,armorchroma-,armorpointspp-,auditory-,authme-,auto-reconnect-,autojoin-,autoreconnect-,axolotl-item-fix-,backtools-,bannerunlimited-,beenfo-1.19-,better-recipe-book-,betterbiomeblend-,bhmenu-,blur-,borderless-mining-,catalogue-,charmonium-,chat_heads-,cherishedworlds-,cirback-1.0-,classicbar-,clickadv-,clienttweaks-,combat_music-,configured-,controllable-,cullleaves-,cullparticles-,custom-crosshair-mod-,customdiscordrpc-,darkness-,dashloader-,defaultoptions-,desiredservers-,discordrpc-,drippyloadingscreen-,drippyloadingscreen_,dynamic-fps-,dynamic-music-,dynamiclights-,dynmus-,effective-,eggtab-,eguilib-,eiramoticons-,enchantment-lore-,entity-texture-features-,entityculling-,exhaustedstamina-,extremesoundmuffler-,fabricemotes-,fancymenu_,fancymenu_video_extension,findme-,flickerfix-,fm_audio_extension_,forgemod_VoxelMap-,freelook-,galacticraft-rpc-,gamestagesviewer-,grid-,helium-,hiddenrecipebook_,infinitemusic-,inventoryprofiles,invtweaks-,itemzoom,itlt-,jeed-,jehc-,jeiintegration_,just-enough-harvestcraft-,justenoughbeacons-,justenoughdrags-,justzoom_,keymap-,keywizard-,konkrete_,konkrete_forge_,lazydfu-,light-overlay-,lightfallclient-,loadmyresources_,lock_minecart_view-,lootbeams-,lwl-,magnesium_extras-,maptooltip-,massunbind,mcbindtype-,mcwifipnp-,medievalmusic-,mightyarchitect-,mindful-eating-,minetogether-,mobplusplus-,modcredits-,modernworldcreation_,modmenu-,modnametooltip-,modnametooltip_,moreoverlays-,mousewheelie-,movement-vision-,multihotbar-,music-duration-reducer-,musicdr-,neiRecipeHandlers-,ngrok-lan-expose-mod-,nopotionshift_,notenoughanimations-,oculus-,ornaments-,overloadedarmorbar-,panorama-,paperdoll-,phosphor-,preciseblockplacing-,realm-of-lost-souls-,rebrand-,replanter-,rubidium-,rubidium_extras-,screenshot-to-clipboard-,shutupexperimentalsettings-,shutupmodelloader-,signtools-,simple-rpc-,simpleautorun-,smartcursor-,smoothboot-,smoothfocus-,sounddeviceoptions-,soundreloader-,spoticraft-,tconplanner-,timestamps-,tooltipscroller-,torchoptimizer-,torohealth-,totaldarkness,toughnessbar-,wisla-,xlifeheartcolors-,yisthereautojump-".split(",")));
    private final TreeSet<String> FALLBACK_MODS = new TreeSet<String>((SortedSet<String>)this.FALLBACK_CLIENTSIDE_MODS);
    private final String FALLBACK_MODS_DEFAULT_REGEX_ASSTRING = "^3dskinlayers-.*$,^Absolutely-Not-A-Zoom-Mod-.*$,^AdvancedChat-.*$,^AdvancedChatCore-.*$,^AdvancedChatHUD-.*$,^AdvancedCompas-.*$,^Ambience.*$,^AmbientEnvironment-.*$,^AmbientSounds_.*$,^AreYouBlind-.*$,^Armor Status HUD-.*$,^ArmorSoundTweak-.*$,^BH-Menu-.*$,^Batty's Coordinates PLUS Mod.*$,^BetterAdvancements-.*$,^BetterAnimationsCollection-.*$,^BetterDarkMode-.*$,^BetterF3-.*$,^BetterFoliage-.*$,^BetterPingDisplay-.*$,^BetterPlacement-.*$,^BetterTaskbar-.*$,^BetterThirdPerson.*$,^BetterTitleScreen-.*$,^Blur-.*$,^BorderlessWindow-.*$,^CTM-.*$,^ChunkAnimator-.*$,^ClientTweaks_.*$,^Controller Support-.*$,^Controlling-.*$,^CraftPresence-.*$,^CustomCursorMod-.*$,^CustomMainMenu-.*$,^DefaultOptions_.*$,^DefaultSettings-.*$,^DeleteWorldsToTrash-.*$,^DetailArmorBar-.*$,^Ding-.*$,^DistantHorizons-.*$,^DripSounds-.*$,^Durability101-.*$,^DurabilityNotifier-.*$,^DynamicSurroundings-.*$,^DynamicSurroundingsHuds-.*$,^EffectsLeft-.*$,^EiraMoticons_.*$,^EnchantmentDescriptions-.*$,^EnhancedVisuals_.*$,^EquipmentCompare-.*$,^FPS-Monitor-.*$,^FabricCustomCursorMod-.*$,^Fallingleaves-.*$,^FancySpawnEggs.*$,^FancyVideo-API-.*$,^FirstPersonMod.*$,^FogTweaker-.*$,^ForgeCustomCursorMod-.*$,^FpsReducer-.*$,^FpsReducer2-.*$,^FullscreenWindowed-.*$,^GameMenuModOption-.*$,^HealthOverlay-.*$,^HorseStatsMod-.*$,^InventoryEssentials_.*$,^InventoryHud_[1.17.1].forge-.*$,^InventorySpam-.*$,^InventoryTweaks-.*$,^ItemBorders-.*$,^ItemPhysicLite_.*$,^ItemStitchingFix-.*$,^JBRA-Client-.*$,^JustEnoughCalculation-.*$,^JustEnoughEffects-.*$,^JustEnoughProfessions-.*$,^JustEnoughResources-.*$,^LLOverlayReloaded-.*$,^LOTRDRP-.*$,^LegendaryTooltips-.*$,^LegendaryTooltips.*$,^LightOverlay-.*$,^MoBends.*$,^MouseTweaks-.*$,^MyServerIsCompatible-.*$,^Neat .*$,^Neat-.*$,^NekosEnchantedBooks-.*$,^NoAutoJump-.*$,^NoFog-.*$,^Notes-.*$,^NotifMod-.*$,^OldJavaWarning-.*$,^OptiFine.*$,^OptiFine_.*$,^OptiForge-.*$,^OptiForge.*$,^PackMenu-.*$,^PackModeMenu-.*$,^PickUpNotifier-.*$,^Ping-.*$,^PresenceFootsteps-.*$,^RPG-HUD-.*$,^ReAuth-.*$,^ResourceLoader-.*$,^ResourcePackOrganizer.*$,^ShoulderSurfing-.*$,^ShulkerTooltip-.*$,^SimpleDiscordRichPresence-.*$,^SimpleWorldTimer-.*$,^SoundFilters-.*$,^SpawnerFix-.*$,^TRansliterationLib-.*$,^TipTheScales-.*$,^Tips-.*$,^Toast Control-.*$,^Toast-Control-.*$,^ToastControl-.*$,^TravelersTitles-.*$,^VoidFog-.*$,^WindowedFullscreen-.*$,^WorldNameRandomizer-.*$,^[1.12.2]DamageIndicatorsMod-.*$,^[1.12.2]bspkrscore-.*$,^antighost-.*$,^anviltooltipmod-.*$,^appleskin-.*$,^armorchroma-.*$,^armorpointspp-.*$,^auditory-.*$,^authme-.*$,^auto-reconnect-.*$,^autojoin-.*$,^autoreconnect-.*$,^axolotl-item-fix-.*$,^backtools-.*$,^bannerunlimited-.*$,^beenfo-1.19-.*$,^better-recipe-book-.*$,^betterbiomeblend-.*$,^bhmenu-.*$,^blur-.*$,^borderless-mining-.*$,^catalogue-.*$,^charmonium-.*$,^chat_heads-.*$,^cherishedworlds-.*$,^cirback-1.0-.*$,^classicbar-.*$,^clickadv-.*$,^clienttweaks-.*$,^combat_music-.*$,^configured-.*$,^controllable-.*$,^cullleaves-.*$,^cullparticles-.*$,^custom-crosshair-mod-.*$,^customdiscordrpc-.*$,^darkness-.*$,^dashloader-.*$,^defaultoptions-.*$,^desiredservers-.*$,^discordrpc-.*$,^drippyloadingscreen-.*$,^drippyloadingscreen_.*$,^dynamic-fps-.*$,^dynamic-music-.*$,^dynamiclights-.*$,^dynmus-.*$,^effective-.*$,^eggtab-.*$,^eguilib-.*$,^eiramoticons-.*$,^enchantment-lore-.*$,^entity-texture-features-.*$,^entityculling-.*$,^exhaustedstamina-.*$,^extremesoundmuffler-.*$,^fabricemotes-.*$,^fancymenu_.*$,^fancymenu_video_extension.*$,^findme-.*$,^flickerfix-.*$,^fm_audio_extension_.*$,^forgemod_VoxelMap-.*$,^freelook-.*$,^galacticraft-rpc-.*$,^gamestagesviewer-.*$,^grid-.*$,^helium-.*$,^hiddenrecipebook_.*$,^infinitemusic-.*$,^inventoryprofiles.*$,^invtweaks-.*$,^itemzoom.*$,^itlt-.*$,^jeed-.*$,^jehc-.*$,^jeiintegration_.*$,^just-enough-harvestcraft-.*$,^justenoughbeacons-.*$,^justenoughdrags-.*$,^justzoom_.*$,^keymap-.*$,^keywizard-.*$,^konkrete_.*$,^konkrete_forge_.*$,^lazydfu-.*$,^light-overlay-.*$,^lightfallclient-.*$,^loadmyresources_.*$,^lock_minecart_view-.*$,^lootbeams-.*$,^lwl-.*$,^magnesium_extras-.*$,^maptooltip-.*$,^massunbind.*$,^mcbindtype-.*$,^mcwifipnp-.*$,^medievalmusic-.*$,^mightyarchitect-.*$,^mindful-eating-.*$,^minetogether-.*$,^mobplusplus-.*$,^modcredits-.*$,^modernworldcreation_.*$,^modmenu-.*$,^modnametooltip-.*$,^modnametooltip_.*$,^moreoverlays-.*$,^mousewheelie-.*$,^movement-vision-.*$,^multihotbar-.*$,^music-duration-reducer-.*$,^musicdr-.*$,^neiRecipeHandlers-.*$,^ngrok-lan-expose-mod-.*$,^nopotionshift_.*$,^notenoughanimations-.*$,^oculus-.*$,^ornaments-.*$,^overloadedarmorbar-.*$,^panorama-.*$,^paperdoll-.*$,^phosphor-.*$,^preciseblockplacing-.*$,^realm-of-lost-souls-.*$,^rebrand-.*$,^replanter-.*$,^rubidium-.*$,^rubidium_extras-.*$,^screenshot-to-clipboard-.*$,^shutupexperimentalsettings-.*$,^shutupmodelloader-.*$,^signtools-.*$,^simple-rpc-.*$,^simpleautorun-.*$,^smartcursor-.*$,^smoothboot-.*$,^smoothfocus-.*$,^sounddeviceoptions-.*$,^soundreloader-.*$,^spoticraft-.*$,^tconplanner-.*$,^timestamps-.*$,^tooltipscroller-.*$,^torchoptimizer-.*$,^torohealth-.*$,^totaldarkness.*$,^toughnessbar-.*$,^wisla-.*$,^xlifeheartcolors-.*$,^yisthereautojump-.*$";
    private final TreeSet<String> FALLBACK_REGEX_CLIENTSIDE_MODS = new TreeSet<String>(Arrays.asList("^3dskinlayers-.*$,^Absolutely-Not-A-Zoom-Mod-.*$,^AdvancedChat-.*$,^AdvancedChatCore-.*$,^AdvancedChatHUD-.*$,^AdvancedCompas-.*$,^Ambience.*$,^AmbientEnvironment-.*$,^AmbientSounds_.*$,^AreYouBlind-.*$,^Armor Status HUD-.*$,^ArmorSoundTweak-.*$,^BH-Menu-.*$,^Batty's Coordinates PLUS Mod.*$,^BetterAdvancements-.*$,^BetterAnimationsCollection-.*$,^BetterDarkMode-.*$,^BetterF3-.*$,^BetterFoliage-.*$,^BetterPingDisplay-.*$,^BetterPlacement-.*$,^BetterTaskbar-.*$,^BetterThirdPerson.*$,^BetterTitleScreen-.*$,^Blur-.*$,^BorderlessWindow-.*$,^CTM-.*$,^ChunkAnimator-.*$,^ClientTweaks_.*$,^Controller Support-.*$,^Controlling-.*$,^CraftPresence-.*$,^CustomCursorMod-.*$,^CustomMainMenu-.*$,^DefaultOptions_.*$,^DefaultSettings-.*$,^DeleteWorldsToTrash-.*$,^DetailArmorBar-.*$,^Ding-.*$,^DistantHorizons-.*$,^DripSounds-.*$,^Durability101-.*$,^DurabilityNotifier-.*$,^DynamicSurroundings-.*$,^DynamicSurroundingsHuds-.*$,^EffectsLeft-.*$,^EiraMoticons_.*$,^EnchantmentDescriptions-.*$,^EnhancedVisuals_.*$,^EquipmentCompare-.*$,^FPS-Monitor-.*$,^FabricCustomCursorMod-.*$,^Fallingleaves-.*$,^FancySpawnEggs.*$,^FancyVideo-API-.*$,^FirstPersonMod.*$,^FogTweaker-.*$,^ForgeCustomCursorMod-.*$,^FpsReducer-.*$,^FpsReducer2-.*$,^FullscreenWindowed-.*$,^GameMenuModOption-.*$,^HealthOverlay-.*$,^HorseStatsMod-.*$,^InventoryEssentials_.*$,^InventoryHud_[1.17.1].forge-.*$,^InventorySpam-.*$,^InventoryTweaks-.*$,^ItemBorders-.*$,^ItemPhysicLite_.*$,^ItemStitchingFix-.*$,^JBRA-Client-.*$,^JustEnoughCalculation-.*$,^JustEnoughEffects-.*$,^JustEnoughProfessions-.*$,^JustEnoughResources-.*$,^LLOverlayReloaded-.*$,^LOTRDRP-.*$,^LegendaryTooltips-.*$,^LegendaryTooltips.*$,^LightOverlay-.*$,^MoBends.*$,^MouseTweaks-.*$,^MyServerIsCompatible-.*$,^Neat .*$,^Neat-.*$,^NekosEnchantedBooks-.*$,^NoAutoJump-.*$,^NoFog-.*$,^Notes-.*$,^NotifMod-.*$,^OldJavaWarning-.*$,^OptiFine.*$,^OptiFine_.*$,^OptiForge-.*$,^OptiForge.*$,^PackMenu-.*$,^PackModeMenu-.*$,^PickUpNotifier-.*$,^Ping-.*$,^PresenceFootsteps-.*$,^RPG-HUD-.*$,^ReAuth-.*$,^ResourceLoader-.*$,^ResourcePackOrganizer.*$,^ShoulderSurfing-.*$,^ShulkerTooltip-.*$,^SimpleDiscordRichPresence-.*$,^SimpleWorldTimer-.*$,^SoundFilters-.*$,^SpawnerFix-.*$,^TRansliterationLib-.*$,^TipTheScales-.*$,^Tips-.*$,^Toast Control-.*$,^Toast-Control-.*$,^ToastControl-.*$,^TravelersTitles-.*$,^VoidFog-.*$,^WindowedFullscreen-.*$,^WorldNameRandomizer-.*$,^[1.12.2]DamageIndicatorsMod-.*$,^[1.12.2]bspkrscore-.*$,^antighost-.*$,^anviltooltipmod-.*$,^appleskin-.*$,^armorchroma-.*$,^armorpointspp-.*$,^auditory-.*$,^authme-.*$,^auto-reconnect-.*$,^autojoin-.*$,^autoreconnect-.*$,^axolotl-item-fix-.*$,^backtools-.*$,^bannerunlimited-.*$,^beenfo-1.19-.*$,^better-recipe-book-.*$,^betterbiomeblend-.*$,^bhmenu-.*$,^blur-.*$,^borderless-mining-.*$,^catalogue-.*$,^charmonium-.*$,^chat_heads-.*$,^cherishedworlds-.*$,^cirback-1.0-.*$,^classicbar-.*$,^clickadv-.*$,^clienttweaks-.*$,^combat_music-.*$,^configured-.*$,^controllable-.*$,^cullleaves-.*$,^cullparticles-.*$,^custom-crosshair-mod-.*$,^customdiscordrpc-.*$,^darkness-.*$,^dashloader-.*$,^defaultoptions-.*$,^desiredservers-.*$,^discordrpc-.*$,^drippyloadingscreen-.*$,^drippyloadingscreen_.*$,^dynamic-fps-.*$,^dynamic-music-.*$,^dynamiclights-.*$,^dynmus-.*$,^effective-.*$,^eggtab-.*$,^eguilib-.*$,^eiramoticons-.*$,^enchantment-lore-.*$,^entity-texture-features-.*$,^entityculling-.*$,^exhaustedstamina-.*$,^extremesoundmuffler-.*$,^fabricemotes-.*$,^fancymenu_.*$,^fancymenu_video_extension.*$,^findme-.*$,^flickerfix-.*$,^fm_audio_extension_.*$,^forgemod_VoxelMap-.*$,^freelook-.*$,^galacticraft-rpc-.*$,^gamestagesviewer-.*$,^grid-.*$,^helium-.*$,^hiddenrecipebook_.*$,^infinitemusic-.*$,^inventoryprofiles.*$,^invtweaks-.*$,^itemzoom.*$,^itlt-.*$,^jeed-.*$,^jehc-.*$,^jeiintegration_.*$,^just-enough-harvestcraft-.*$,^justenoughbeacons-.*$,^justenoughdrags-.*$,^justzoom_.*$,^keymap-.*$,^keywizard-.*$,^konkrete_.*$,^konkrete_forge_.*$,^lazydfu-.*$,^light-overlay-.*$,^lightfallclient-.*$,^loadmyresources_.*$,^lock_minecart_view-.*$,^lootbeams-.*$,^lwl-.*$,^magnesium_extras-.*$,^maptooltip-.*$,^massunbind.*$,^mcbindtype-.*$,^mcwifipnp-.*$,^medievalmusic-.*$,^mightyarchitect-.*$,^mindful-eating-.*$,^minetogether-.*$,^mobplusplus-.*$,^modcredits-.*$,^modernworldcreation_.*$,^modmenu-.*$,^modnametooltip-.*$,^modnametooltip_.*$,^moreoverlays-.*$,^mousewheelie-.*$,^movement-vision-.*$,^multihotbar-.*$,^music-duration-reducer-.*$,^musicdr-.*$,^neiRecipeHandlers-.*$,^ngrok-lan-expose-mod-.*$,^nopotionshift_.*$,^notenoughanimations-.*$,^oculus-.*$,^ornaments-.*$,^overloadedarmorbar-.*$,^panorama-.*$,^paperdoll-.*$,^phosphor-.*$,^preciseblockplacing-.*$,^realm-of-lost-souls-.*$,^rebrand-.*$,^replanter-.*$,^rubidium-.*$,^rubidium_extras-.*$,^screenshot-to-clipboard-.*$,^shutupexperimentalsettings-.*$,^shutupmodelloader-.*$,^signtools-.*$,^simple-rpc-.*$,^simpleautorun-.*$,^smartcursor-.*$,^smoothboot-.*$,^smoothfocus-.*$,^sounddeviceoptions-.*$,^soundreloader-.*$,^spoticraft-.*$,^tconplanner-.*$,^timestamps-.*$,^tooltipscroller-.*$,^torchoptimizer-.*$,^torohealth-.*$,^totaldarkness.*$,^toughnessbar-.*$,^wisla-.*$,^xlifeheartcolors-.*$,^yisthereautojump-.*$".split(",")));
    private final TreeSet<String> FALLBACK_MODS_REGEX = new TreeSet<String>((SortedSet<String>)this.FALLBACK_REGEX_CLIENTSIDE_MODS);
    private final String SERVERPACKCREATOR_VERSION;
    private final String[] SUPPORTED_MODLOADERS = new String[]{"Fabric", "Forge", "Quilt", "LegacyFabric"};
    private final String FALLBACK_DIRECTORIES_INCLUDE_ASSTRING = "mods,config,kubejs,defaultconfigs,scripts";
    private final TreeSet<String> FALLBACK_DIRECTORIES_INCLUDE = new TreeSet<String>(Arrays.asList("mods,config,kubejs,defaultconfigs,scripts".split(",")));
    private final TreeSet<String> DIRECTORIES_TO_INCLUDE = new TreeSet<String>((SortedSet<String>)this.FALLBACK_DIRECTORIES_INCLUDE);
    private final String FALLBACK_DIRECTORIES_EXCLUDE_ASSTRING = "overrides,packmenu,resourcepacks,server_pack,fancymenu,libraries,downloads,logs,profileImage,resourcepacks,screenshots,shaderpacks,tv-cache,asm";
    private final TreeSet<String> FALLBACK_DIRECTORIES_EXCLUDE = new TreeSet<String>(Arrays.asList("overrides,packmenu,resourcepacks,server_pack,fancymenu,libraries,downloads,logs,profileImage,resourcepacks,screenshots,shaderpacks,tv-cache,asm".split(",")));
    private final TreeSet<String> DIRECTORIES_TO_EXCLUDE = new TreeSet<String>((SortedSet<String>)this.FALLBACK_DIRECTORIES_EXCLUDE);
    private final String FALLBACK_FILES_EXCLUDE_ZIP_ASSTRING = "minecraft_server.MINECRAFT_VERSION.jar,server.jar,libraries/net/minecraft/server/MINECRAFT_VERSION/server-MINECRAFT_VERSION.jar";
    private final TreeSet<String> FALLBACK_FILES_EXCLUDE_ZIP = new TreeSet<String>(Arrays.asList("minecraft_server.MINECRAFT_VERSION.jar,server.jar,libraries/net/minecraft/server/MINECRAFT_VERSION/server-MINECRAFT_VERSION.jar".split(",")));
    private final TreeSet<String> FILES_TO_EXCLUDE_FROM_ZIP = new TreeSet<String>((SortedSet<String>)this.FALLBACK_FILES_EXCLUDE_ZIP);
    private final String DEFAULT_SHELL_TEMPLATE = "default_template.sh";
    private final String DEFAULT_POWERSHELL_TEMPLATE = "default_template.ps1";
    private final String FALLBACK_SCRIPT_TEMPLATES_ASSTRING = "default_template.sh,default_template.ps1";
    private final TreeSet<File> FALLBACK_SCRIPT_TEMPLATES = new TreeSet<File>(Arrays.asList(new File("server_files/default_template.sh"), new File("server_files/default_template.ps1")));
    private final TreeSet<File> SCRIPT_TEMPLATES = new TreeSet<File>((SortedSet<File>)this.FALLBACK_SCRIPT_TEMPLATES);
    private final File DEFAULT_CONFIG = new File("serverpackcreator.conf");
    private final File DEFAULT_SERVER_PROPERTIES = new File("server.properties");
    private final File DEFAULT_SERVER_ICON = new File("server-icon.png");
    private final File MINECRAFT_VERSION_MANIFEST = new File("minecraft-manifest.json");
    private final File FORGE_VERSION_MANIFEST = new File("forge-manifest.json");
    private final File FABRIC_VERSION_MANIFEST = new File("fabric-manifest.xml");
    private final File FABRIC_INTERMEDIARIES_MANIFEST = new File("fabric-intermediaries-manifest.json");
    private final String MANIFEST_LOCATION = "./manifests/";
    private final String MINECRAFT_SERVER_MANIFESTS_LOCATION = "./manifests/mcserver/";
    private final File FABRIC_INTERMEDIARIES_MANIFEST_LOCATION = new File("./manifests/" + this.FABRIC_INTERMEDIARIES_MANIFEST.getName());
    private final File FABRIC_INSTALLER_VERSION_MANIFEST = new File("fabric-installer-manifest.xml");
    private final File QUILT_VERSION_MANIFEST = new File("quilt-manifest.xml");
    private final File QUILT_INSTALLER_VERSION_MANIFEST = new File("quilt-installer-manifest.xml");
    private final File SERVERPACKCREATOR_DATABASE = new File("serverpackcreator.db");
    private final File MINECRAFT_VERSION_MANIFEST_LOCATION = new File("./manifests/" + this.MINECRAFT_VERSION_MANIFEST.getName());
    private final File FORGE_VERSION_MANIFEST_LOCATION = new File("./manifests/forge-manifest.json");
    private final File FABRIC_VERSION_MANIFEST_LOCATION = new File("./manifests/fabric-manifest.xml");
    private final File LEGACY_FABRIC_GAME_MANIFEST = new File("legacy-fabric-game-manifest.json");
    private final File LEGACY_FABRIC_LOADER_MANIFEST = new File("legacy-fabric-loader-manifest.json");
    private final File LEGACY_FABRIC_INSTALLER_MANIFEST = new File("legacy-fabric-installer-manifest.xml");
    private final File LEGACY_FABRIC_GAME_MANIFEST_LOCATION = new File("./manifests/" + this.LEGACY_FABRIC_GAME_MANIFEST.getName());
    private final File LEGACY_FABRIC_LOADER_MANIFEST_LOCATION = new File("./manifests/" + this.LEGACY_FABRIC_LOADER_MANIFEST.getName());
    private final File LEGACY_FABRIC_INSTALLER_MANIFEST_LOCATION = new File("./manifests/" + this.LEGACY_FABRIC_INSTALLER_MANIFEST.getName());
    private final File FABRIC_INSTALLER_VERSION_MANIFEST_LOCATION = new File("./manifests/" + this.FABRIC_INSTALLER_VERSION_MANIFEST.getName());
    private final File QUILT_VERSION_MANIFEST_LOCATION = new File("./manifests/" + this.QUILT_VERSION_MANIFEST.getName());
    private final File QUILT_INSTALLER_VERSION_MANIFEST_LOCATION = new File("./manifests/" + this.QUILT_INSTALLER_VERSION_MANIFEST.getName());
    private final String AIKARS_FLAGS = "-Xms4G -Xmx4G -XX:+UseG1GC -XX:+ParallelRefProcEnabled -XX:MaxGCPauseMillis=200 -XX:+UnlockExperimentalVMOptions -XX:+DisableExplicitGC -XX:+AlwaysPreTouch -XX:G1NewSizePercent=30 -XX:G1MaxNewSizePercent=40 -XX:G1HeapRegionSize=8M -XX:G1ReservePercent=20 -XX:G1HeapWastePercent=5 -XX:G1MixedGCCountTarget=4 -XX:InitiatingHeapOccupancyPercent=15 -XX:G1MixedGCLiveThresholdPercent=90 -XX:G1RSetUpdatingPauseTimePercent=5 -XX:SurvivorRatio=32 -XX:+PerfDisableSharedMem -XX:MaxTenuringThreshold=1 -Dusing.aikars.flags=https://mcflags.emc.gs -Daikars.new.flags=true";
    private final HashMap<String, String> JAVA_PATHS = new HashMap(256);
    private final String PROPERTY_VERSIONCHECK_PRERELEASE = "de.griefed.serverpackcreator.versioncheck.prerelease";
    private final String PROPERTY_LANGUAGE = "de.griefed.serverpackcreator.language";
    private final String PROPERTY_CONFIGURATION_FALLBACKMODSLIST = "de.griefed.serverpackcreator.configuration.fallbackmodslist";
    private final String PROPERTY_CONFIGURATION_FALLBACKMODSLIST_REGEX = "de.griefed.serverpackcreator.configuration.fallbackmodslist.regex";
    private final String PROPERTY_CONFIGURATION_HASTEBINSERVER = "de.griefed.serverpackcreator.configuration.hastebinserver";
    private final String PROPERTY_CONFIGURATION_AIKAR = "de.griefed.serverpackcreator.configuration.aikar";
    private final String PROPERTY_SERVERPACK_AUTODISCOVERY_ENABLED = "de.griefed.serverpackcreator.serverpack.autodiscovery.enabled";
    private final String PROPERTY_SERVERPACK_AUTODISCOVERY_ENABLED_LEGACY = "de.griefed.serverpackcreator.serverpack.autodiscoverenabled";
    private final String PROPERTY_GUI_DARKMODE = "de.griefed.serverpackcreator.gui.darkmode";
    private final String PROPERTY_CONFIGURATION_DIRECTORIES_SERVERPACKS = "de.griefed.serverpackcreator.configuration.directories.serverpacks";
    private final String PROPERTY_SERVERPACK_CLEANUP_ENABLED = "de.griefed.serverpackcreator.serverpack.cleanup.enabled";
    private final String PROPERTY_SERVERPACK_OVERWRITE_ENABLED = "de.griefed.serverpackcreator.serverpack.overwrite.enabled";
    private final String PROPERTY_CONFIGURATION_DIRECTORIES_SHOULDEXCLUDE = "de.griefed.serverpackcreator.configuration.directories.shouldexclude";
    private final String PROPERTY_SPRING_SCHEDULES_DATABASE_CLEANUP = "de.griefed.serverpackcreator.spring.schedules.database.cleanup";
    private final String PROPERTY_SPRING_SCHEDULES_FILES_CLEANUP = "de.griefed.serverpackcreator.spring.schedules.files.cleanup";
    private final String PROPERTY_SPRING_SCHEDULES_VERSIONS_REFRESH = "de.griefed.serverpackcreator.spring.schedules.versions.refresh";
    private final String PROPERTY_SPRING_ARTEMIS_QUEUE_MAX_DISK_USAGE = "de.griefed.serverpackcreator.spring.artemis.queue.max_disk_usage";
    private final String PROPERTY_CONFIGURATION_SAVELOADEDCONFIG = "de.griefed.serverpackcreator.configuration.saveloadedconfig";
    private final String PROPERTY_CONFIGURATION_DIRECTORIES_MUSTINCLUDE = "de.griefed.serverpackcreator.configuration.directories.mustinclude";
    private final String PROPERTY_SERVERPACK_ZIP_EXCLUDE = "de.griefed.serverpackcreator.serverpack.zip.exclude";
    private final String PROPERTY_SERVERPACK_ZIP_EXCLUDE_ENABLED = "de.griefed.serverpackcreator.serverpack.zip.exclude.enabled";
    private final String PROPERTY_SERVERPACK_SCRIPT_TEMPLATE = "de.griefed.serverpackcreator.serverpack.script.template";
    private final String PROPERTY_MINECRAFT_SNAPSHOTS = "de.griefed.serverpackcreator.minecraft.snapshots";
    private final String PROPERTY_SERVERPACK_AUTODISCOVERY_FILTER = "de.griefed.serverpackcreator.serverpack.autodiscovery.filter";
    private final String PROPERTY_JAVA = "de.griefed.serverpackcreator.java";
    private final String PROPERTY_SCRIPT_JAVA = "de.griefed.serverpackcreator.script.java";
    private final String PROPERTY_SCRIPT_JAVA_AUTOUPDATE = "de.griefed.serverpackcreator.script.java.autoupdate";
    private String directoryServerPacks = "server-packs";
    private int queueMaxDiskUsage = 90;
    private boolean saveLoadedConfiguration = false;
    private boolean checkForPreReleases = false;
    private String aikarsFlags = "-Xms4G -Xmx4G -XX:+UseG1GC -XX:+ParallelRefProcEnabled -XX:MaxGCPauseMillis=200 -XX:+UnlockExperimentalVMOptions -XX:+DisableExplicitGC -XX:+AlwaysPreTouch -XX:G1NewSizePercent=30 -XX:G1MaxNewSizePercent=40 -XX:G1HeapRegionSize=8M -XX:G1ReservePercent=20 -XX:G1HeapWastePercent=5 -XX:G1MixedGCCountTarget=4 -XX:InitiatingHeapOccupancyPercent=15 -XX:G1MixedGCLiveThresholdPercent=90 -XX:G1RSetUpdatingPauseTimePercent=5 -XX:SurvivorRatio=32 -XX:+PerfDisableSharedMem -XX:MaxTenuringThreshold=1 -Dusing.aikars.flags=https://mcflags.emc.gs -Daikars.new.flags=true";
    private boolean isZipFileExclusionEnabled = true;
    private boolean autoExcludingModsEnabled = true;
    private boolean serverPacksOverwriteEnabled = true;
    private boolean serverPackCleanupEnabled = true;
    private String language = "en_us";
    private String hasteBinServerUrl = "https://haste.zneix.eu/documents";
    private boolean minecraftPreReleases = false;
    private ExclusionFilter exclusionFilter = ExclusionFilter.START;
    private String javaPath = "java";
    private boolean javaScriptAutoupdate = true;

    @Autowired
    public ApplicationProperties(FileUtilities fileUtilities, SystemUtilities systemUtilities, ListUtilities listUtilities) {
        this(new File("serverpackcreator.properties"), fileUtilities, systemUtilities, listUtilities);
    }

    public ApplicationProperties(File propertiesFile, FileUtilities fileUtilities, SystemUtilities systemUtilities, ListUtilities listUtilities) {
        this.FILE_UTILITIES = fileUtilities;
        this.SYSTEM_UTILITIES = systemUtilities;
        this.LIST_UTILITIES = listUtilities;
        String version = ApplicationProperties.class.getPackage().getImplementationVersion();
        this.SERVERPACKCREATOR_VERSION = version != null ? version : "dev";
        this.loadProperties(propertiesFile);
    }

    public void loadProperties() {
        this.loadProperties(this.SERVERPACKCREATOR_PROPERTIES_FILE);
    }

    private void loadProperties(File propertiesFile) {
        Throwable throwable;
        InputStream inputStream;
        try {
            inputStream = new ClassPathResource("serverpackcreator.properties").getInputStream();
            throwable = null;
            try {
                this.load(inputStream);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream != null) {
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            LOG.error("Couldn't read properties file.", (Throwable)ex);
        }
        if (this.SERVERPACKCREATOR_PROPERTIES_FILE.exists()) {
            try {
                inputStream = Files.newInputStream(this.SERVERPACKCREATOR_PROPERTIES_FILE.toPath(), new OpenOption[0]);
                throwable = null;
                try {
                    this.load(inputStream);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (inputStream != null) {
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
            }
            catch (IOException ex) {
                LOG.error("Couldn't read properties file.", (Throwable)ex);
            }
        }
        if (propertiesFile.exists()) {
            try {
                inputStream = Files.newInputStream(propertiesFile.toPath(), new OpenOption[0]);
                throwable = null;
                try {
                    this.load(inputStream);
                    LOG.info("Loading file: " + propertiesFile.getAbsolutePath());
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (inputStream != null) {
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
            }
            catch (IOException ex) {
                LOG.error("Couldn't read properties file.", (Throwable)ex);
            }
        }
        if (this.updateFallback()) {
            LOG.info("Fallback lists updated.");
        } else {
            this.setFallbackModsList();
        }
        this.setServerPacksDir();
        this.setDirsToIncludeList();
        this.setDirsToExcludeList();
        this.setQueueMaxDiskUsage();
        this.setSaveLoadedConfiguration();
        this.setCheckForPreReleases();
        this.setAikarsFlags();
        this.setFilesToExcludeFromZip();
        this.setZipFileExclusionEnabled();
        this.setScriptTemplates();
        this.setAutoExclusionOfMods();
        this.setServerPackOverwrite();
        this.setServerPackCleanup();
        this.setLanguage();
        this.setHasteBinServerUrl();
        this.setMinecraftPreReleases();
        this.setModExclusionFilterMethod();
        this.setJavaPath();
        this.setJavaScriptsVariablePaths();
        this.setAutoUpdateScriptVariablesJavaPlaceholder();
        this.saveToDisk(this.SERVERPACKCREATOR_PROPERTIES_FILE);
    }

    private String defineProperty(String key, String value) {
        this.setProperty(key, value);
        return value;
    }

    private String acquireProperty(String key, String defaultValue) {
        if (this.getProperty(key) == null) {
            return this.defineProperty(key, defaultValue);
        }
        return this.getProperty(key, defaultValue);
    }

    private List<String> getListProperty(String key, String defaultValue) {
        if (this.acquireProperty(key, defaultValue).contains(",")) {
            return new ArrayList<String>(Arrays.asList(this.acquireProperty(key, defaultValue).split(",")));
        }
        return Collections.singletonList(this.acquireProperty(key, defaultValue));
    }

    private int getIntProperty(String key, int defaultValue) {
        try {
            return Integer.parseInt(this.acquireProperty(key, String.valueOf(defaultValue)));
        }
        catch (NumberFormatException ex) {
            this.defineProperty(key, String.valueOf(defaultValue));
            return defaultValue;
        }
    }

    private List<File> getFileListProperty(String key, String defaultValue, String filePrefix) {
        ArrayList<File> files = new ArrayList<File>(10);
        for (String entry : this.getListProperty(key, defaultValue)) {
            files.add(new File(filePrefix + entry));
        }
        return files;
    }

    private boolean getBoolProperty(String key, boolean defaultValue) {
        return Boolean.parseBoolean(this.acquireProperty(key, String.valueOf(defaultValue)));
    }

    private void setServerPacksDir() {
        if (new File(this.acquireProperty("de.griefed.serverpackcreator.configuration.directories.serverpacks", "server-packs")).exists()) {
            this.directoryServerPacks = this.acquireProperty("de.griefed.serverpackcreator.configuration.directories.serverpacks", "server-packs");
        } else {
            LOG.error("Invalid server-packs directory specified. Defaulting to 'server-packs'.");
            this.directoryServerPacks = "server-packs";
        }
        LOG.info("Server packs directory set to: " + this.directoryServerPacks);
    }

    private void setFallbackModsList() {
        this.FALLBACK_MODS.addAll(this.getListProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist", "3dskinlayers-,Absolutely-Not-A-Zoom-Mod-,AdvancedChat-,AdvancedChatCore-,AdvancedChatHUD-,AdvancedCompas-,Ambience,AmbientEnvironment-,AmbientSounds_,AreYouBlind-,Armor Status HUD-,ArmorSoundTweak-,BH-Menu-,Batty's Coordinates PLUS Mod,BetterAdvancements-,BetterAnimationsCollection-,BetterDarkMode-,BetterF3-,BetterFoliage-,BetterPingDisplay-,BetterPlacement-,BetterTaskbar-,BetterThirdPerson,BetterTitleScreen-,Blur-,BorderlessWindow-,CTM-,ChunkAnimator-,ClientTweaks_,Controller Support-,Controlling-,CraftPresence-,CustomCursorMod-,CustomMainMenu-,DefaultOptions_,DefaultSettings-,DeleteWorldsToTrash-,DetailArmorBar-,Ding-,DistantHorizons-,DripSounds-,Durability101-,DurabilityNotifier-,DynamicSurroundings-,DynamicSurroundingsHuds-,EffectsLeft-,EiraMoticons_,EnchantmentDescriptions-,EnhancedVisuals_,EquipmentCompare-,FPS-Monitor-,FabricCustomCursorMod-,Fallingleaves-,FancySpawnEggs,FancyVideo-API-,FirstPersonMod,FogTweaker-,ForgeCustomCursorMod-,FpsReducer-,FpsReducer2-,FullscreenWindowed-,GameMenuModOption-,HealthOverlay-,HorseStatsMod-,InventoryEssentials_,InventoryHud_[1.17.1].forge-,InventorySpam-,InventoryTweaks-,ItemBorders-,ItemPhysicLite_,ItemStitchingFix-,JBRA-Client-,JustEnoughCalculation-,JustEnoughEffects-,JustEnoughProfessions-,JustEnoughResources-,LLOverlayReloaded-,LOTRDRP-,LegendaryTooltips,LegendaryTooltips-,LightOverlay-,MoBends,MouseTweaks-,MyServerIsCompatible-,Neat ,Neat-,NekosEnchantedBooks-,NoAutoJump-,NoFog-,Notes-,NotifMod-,OldJavaWarning-,OptiFine,OptiFine_,OptiForge,OptiForge-,PackMenu-,PackModeMenu-,PickUpNotifier-,Ping-,PresenceFootsteps-,RPG-HUD-,ReAuth-,ResourceLoader-,ResourcePackOrganizer,ShoulderSurfing-,ShulkerTooltip-,SimpleDiscordRichPresence-,SimpleWorldTimer-,SoundFilters-,SpawnerFix-,TRansliterationLib-,TipTheScales-,Tips-,Toast Control-,Toast-Control-,ToastControl-,TravelersTitles-,VoidFog-,WindowedFullscreen-,WorldNameRandomizer-,[1.12.2]DamageIndicatorsMod-,[1.12.2]bspkrscore-,antighost-,anviltooltipmod-,appleskin-,armorchroma-,armorpointspp-,auditory-,authme-,auto-reconnect-,autojoin-,autoreconnect-,axolotl-item-fix-,backtools-,bannerunlimited-,beenfo-1.19-,better-recipe-book-,betterbiomeblend-,bhmenu-,blur-,borderless-mining-,catalogue-,charmonium-,chat_heads-,cherishedworlds-,cirback-1.0-,classicbar-,clickadv-,clienttweaks-,combat_music-,configured-,controllable-,cullleaves-,cullparticles-,custom-crosshair-mod-,customdiscordrpc-,darkness-,dashloader-,defaultoptions-,desiredservers-,discordrpc-,drippyloadingscreen-,drippyloadingscreen_,dynamic-fps-,dynamic-music-,dynamiclights-,dynmus-,effective-,eggtab-,eguilib-,eiramoticons-,enchantment-lore-,entity-texture-features-,entityculling-,exhaustedstamina-,extremesoundmuffler-,fabricemotes-,fancymenu_,fancymenu_video_extension,findme-,flickerfix-,fm_audio_extension_,forgemod_VoxelMap-,freelook-,galacticraft-rpc-,gamestagesviewer-,grid-,helium-,hiddenrecipebook_,infinitemusic-,inventoryprofiles,invtweaks-,itemzoom,itlt-,jeed-,jehc-,jeiintegration_,just-enough-harvestcraft-,justenoughbeacons-,justenoughdrags-,justzoom_,keymap-,keywizard-,konkrete_,konkrete_forge_,lazydfu-,light-overlay-,lightfallclient-,loadmyresources_,lock_minecart_view-,lootbeams-,lwl-,magnesium_extras-,maptooltip-,massunbind,mcbindtype-,mcwifipnp-,medievalmusic-,mightyarchitect-,mindful-eating-,minetogether-,mobplusplus-,modcredits-,modernworldcreation_,modmenu-,modnametooltip-,modnametooltip_,moreoverlays-,mousewheelie-,movement-vision-,multihotbar-,music-duration-reducer-,musicdr-,neiRecipeHandlers-,ngrok-lan-expose-mod-,nopotionshift_,notenoughanimations-,oculus-,ornaments-,overloadedarmorbar-,panorama-,paperdoll-,phosphor-,preciseblockplacing-,realm-of-lost-souls-,rebrand-,replanter-,rubidium-,rubidium_extras-,screenshot-to-clipboard-,shutupexperimentalsettings-,shutupmodelloader-,signtools-,simple-rpc-,simpleautorun-,smartcursor-,smoothboot-,smoothfocus-,sounddeviceoptions-,soundreloader-,spoticraft-,tconplanner-,timestamps-,tooltipscroller-,torchoptimizer-,torohealth-,totaldarkness,toughnessbar-,wisla-,xlifeheartcolors-,yisthereautojump-"));
        this.setProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist", String.join((CharSequence)",", this.FALLBACK_MODS));
        LOG.info("Fallback modslist set to:");
        this.LIST_UTILITIES.printListToLogChunked(new ArrayList<String>(this.FALLBACK_MODS), 5, "    ", true);
        this.FALLBACK_MODS_REGEX.addAll(this.getListProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist.regex", "^3dskinlayers-.*$,^Absolutely-Not-A-Zoom-Mod-.*$,^AdvancedChat-.*$,^AdvancedChatCore-.*$,^AdvancedChatHUD-.*$,^AdvancedCompas-.*$,^Ambience.*$,^AmbientEnvironment-.*$,^AmbientSounds_.*$,^AreYouBlind-.*$,^Armor Status HUD-.*$,^ArmorSoundTweak-.*$,^BH-Menu-.*$,^Batty's Coordinates PLUS Mod.*$,^BetterAdvancements-.*$,^BetterAnimationsCollection-.*$,^BetterDarkMode-.*$,^BetterF3-.*$,^BetterFoliage-.*$,^BetterPingDisplay-.*$,^BetterPlacement-.*$,^BetterTaskbar-.*$,^BetterThirdPerson.*$,^BetterTitleScreen-.*$,^Blur-.*$,^BorderlessWindow-.*$,^CTM-.*$,^ChunkAnimator-.*$,^ClientTweaks_.*$,^Controller Support-.*$,^Controlling-.*$,^CraftPresence-.*$,^CustomCursorMod-.*$,^CustomMainMenu-.*$,^DefaultOptions_.*$,^DefaultSettings-.*$,^DeleteWorldsToTrash-.*$,^DetailArmorBar-.*$,^Ding-.*$,^DistantHorizons-.*$,^DripSounds-.*$,^Durability101-.*$,^DurabilityNotifier-.*$,^DynamicSurroundings-.*$,^DynamicSurroundingsHuds-.*$,^EffectsLeft-.*$,^EiraMoticons_.*$,^EnchantmentDescriptions-.*$,^EnhancedVisuals_.*$,^EquipmentCompare-.*$,^FPS-Monitor-.*$,^FabricCustomCursorMod-.*$,^Fallingleaves-.*$,^FancySpawnEggs.*$,^FancyVideo-API-.*$,^FirstPersonMod.*$,^FogTweaker-.*$,^ForgeCustomCursorMod-.*$,^FpsReducer-.*$,^FpsReducer2-.*$,^FullscreenWindowed-.*$,^GameMenuModOption-.*$,^HealthOverlay-.*$,^HorseStatsMod-.*$,^InventoryEssentials_.*$,^InventoryHud_[1.17.1].forge-.*$,^InventorySpam-.*$,^InventoryTweaks-.*$,^ItemBorders-.*$,^ItemPhysicLite_.*$,^ItemStitchingFix-.*$,^JBRA-Client-.*$,^JustEnoughCalculation-.*$,^JustEnoughEffects-.*$,^JustEnoughProfessions-.*$,^JustEnoughResources-.*$,^LLOverlayReloaded-.*$,^LOTRDRP-.*$,^LegendaryTooltips-.*$,^LegendaryTooltips.*$,^LightOverlay-.*$,^MoBends.*$,^MouseTweaks-.*$,^MyServerIsCompatible-.*$,^Neat .*$,^Neat-.*$,^NekosEnchantedBooks-.*$,^NoAutoJump-.*$,^NoFog-.*$,^Notes-.*$,^NotifMod-.*$,^OldJavaWarning-.*$,^OptiFine.*$,^OptiFine_.*$,^OptiForge-.*$,^OptiForge.*$,^PackMenu-.*$,^PackModeMenu-.*$,^PickUpNotifier-.*$,^Ping-.*$,^PresenceFootsteps-.*$,^RPG-HUD-.*$,^ReAuth-.*$,^ResourceLoader-.*$,^ResourcePackOrganizer.*$,^ShoulderSurfing-.*$,^ShulkerTooltip-.*$,^SimpleDiscordRichPresence-.*$,^SimpleWorldTimer-.*$,^SoundFilters-.*$,^SpawnerFix-.*$,^TRansliterationLib-.*$,^TipTheScales-.*$,^Tips-.*$,^Toast Control-.*$,^Toast-Control-.*$,^ToastControl-.*$,^TravelersTitles-.*$,^VoidFog-.*$,^WindowedFullscreen-.*$,^WorldNameRandomizer-.*$,^[1.12.2]DamageIndicatorsMod-.*$,^[1.12.2]bspkrscore-.*$,^antighost-.*$,^anviltooltipmod-.*$,^appleskin-.*$,^armorchroma-.*$,^armorpointspp-.*$,^auditory-.*$,^authme-.*$,^auto-reconnect-.*$,^autojoin-.*$,^autoreconnect-.*$,^axolotl-item-fix-.*$,^backtools-.*$,^bannerunlimited-.*$,^beenfo-1.19-.*$,^better-recipe-book-.*$,^betterbiomeblend-.*$,^bhmenu-.*$,^blur-.*$,^borderless-mining-.*$,^catalogue-.*$,^charmonium-.*$,^chat_heads-.*$,^cherishedworlds-.*$,^cirback-1.0-.*$,^classicbar-.*$,^clickadv-.*$,^clienttweaks-.*$,^combat_music-.*$,^configured-.*$,^controllable-.*$,^cullleaves-.*$,^cullparticles-.*$,^custom-crosshair-mod-.*$,^customdiscordrpc-.*$,^darkness-.*$,^dashloader-.*$,^defaultoptions-.*$,^desiredservers-.*$,^discordrpc-.*$,^drippyloadingscreen-.*$,^drippyloadingscreen_.*$,^dynamic-fps-.*$,^dynamic-music-.*$,^dynamiclights-.*$,^dynmus-.*$,^effective-.*$,^eggtab-.*$,^eguilib-.*$,^eiramoticons-.*$,^enchantment-lore-.*$,^entity-texture-features-.*$,^entityculling-.*$,^exhaustedstamina-.*$,^extremesoundmuffler-.*$,^fabricemotes-.*$,^fancymenu_.*$,^fancymenu_video_extension.*$,^findme-.*$,^flickerfix-.*$,^fm_audio_extension_.*$,^forgemod_VoxelMap-.*$,^freelook-.*$,^galacticraft-rpc-.*$,^gamestagesviewer-.*$,^grid-.*$,^helium-.*$,^hiddenrecipebook_.*$,^infinitemusic-.*$,^inventoryprofiles.*$,^invtweaks-.*$,^itemzoom.*$,^itlt-.*$,^jeed-.*$,^jehc-.*$,^jeiintegration_.*$,^just-enough-harvestcraft-.*$,^justenoughbeacons-.*$,^justenoughdrags-.*$,^justzoom_.*$,^keymap-.*$,^keywizard-.*$,^konkrete_.*$,^konkrete_forge_.*$,^lazydfu-.*$,^light-overlay-.*$,^lightfallclient-.*$,^loadmyresources_.*$,^lock_minecart_view-.*$,^lootbeams-.*$,^lwl-.*$,^magnesium_extras-.*$,^maptooltip-.*$,^massunbind.*$,^mcbindtype-.*$,^mcwifipnp-.*$,^medievalmusic-.*$,^mightyarchitect-.*$,^mindful-eating-.*$,^minetogether-.*$,^mobplusplus-.*$,^modcredits-.*$,^modernworldcreation_.*$,^modmenu-.*$,^modnametooltip-.*$,^modnametooltip_.*$,^moreoverlays-.*$,^mousewheelie-.*$,^movement-vision-.*$,^multihotbar-.*$,^music-duration-reducer-.*$,^musicdr-.*$,^neiRecipeHandlers-.*$,^ngrok-lan-expose-mod-.*$,^nopotionshift_.*$,^notenoughanimations-.*$,^oculus-.*$,^ornaments-.*$,^overloadedarmorbar-.*$,^panorama-.*$,^paperdoll-.*$,^phosphor-.*$,^preciseblockplacing-.*$,^realm-of-lost-souls-.*$,^rebrand-.*$,^replanter-.*$,^rubidium-.*$,^rubidium_extras-.*$,^screenshot-to-clipboard-.*$,^shutupexperimentalsettings-.*$,^shutupmodelloader-.*$,^signtools-.*$,^simple-rpc-.*$,^simpleautorun-.*$,^smartcursor-.*$,^smoothboot-.*$,^smoothfocus-.*$,^sounddeviceoptions-.*$,^soundreloader-.*$,^spoticraft-.*$,^tconplanner-.*$,^timestamps-.*$,^tooltipscroller-.*$,^torchoptimizer-.*$,^torohealth-.*$,^totaldarkness.*$,^toughnessbar-.*$,^wisla-.*$,^xlifeheartcolors-.*$,^yisthereautojump-.*$"));
        this.setProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist.regex", String.join((CharSequence)",", this.FALLBACK_MODS_REGEX));
        LOG.info("Fallback regex modslist set to:");
        this.LIST_UTILITIES.printListToLogChunked(new ArrayList<String>(this.FALLBACK_MODS_REGEX), 5, "    ", true);
    }

    private void setDirsToExcludeList() {
        this.getListProperty("de.griefed.serverpackcreator.configuration.directories.shouldexclude", "overrides,packmenu,resourcepacks,server_pack,fancymenu,libraries,downloads,logs,profileImage,resourcepacks,screenshots,shaderpacks,tv-cache,asm").forEach(this::addDirectoryToExclude);
        LOG.info("Directories to exclude set to: " + this.DIRECTORIES_TO_EXCLUDE);
    }

    private void setDirsToIncludeList() {
        this.DIRECTORIES_TO_INCLUDE.addAll(this.getListProperty("de.griefed.serverpackcreator.configuration.directories.mustinclude", "mods,config,kubejs,defaultconfigs,scripts"));
        LOG.info("Directories which must always be included set to: " + this.DIRECTORIES_TO_INCLUDE);
    }

    private void setQueueMaxDiskUsage() {
        int usage = this.getIntProperty("de.griefed.serverpackcreator.spring.artemis.queue.max_disk_usage", 90);
        if (usage >= 0 && usage <= 100) {
            this.queueMaxDiskUsage = this.getIntProperty("de.griefed.serverpackcreator.spring.artemis.queue.max_disk_usage", 90);
        } else {
            LOG.error("Invalid max disk usage set. Defaulting to 90");
            this.queueMaxDiskUsage = 90;
        }
        LOG.info("Queue max disk usage set to: " + this.queueMaxDiskUsage);
    }

    private void setSaveLoadedConfiguration() {
        this.saveLoadedConfiguration = this.getBoolProperty("de.griefed.serverpackcreator.configuration.saveloadedconfig", false);
        LOG.info("Save last loaded config set to: " + this.saveLoadedConfiguration);
    }

    private void setCheckForPreReleases() {
        this.checkForPreReleases = this.getBoolProperty("de.griefed.serverpackcreator.versioncheck.prerelease", false);
        if (this.SERVERPACKCREATOR_VERSION.matches("(.*alpha.*|.*beta.*)")) {
            this.checkForPreReleases = true;
            LOG.info("Using pre-release " + this.SERVERPACKCREATOR_VERSION + ". Checking for pre-releases set to true.");
        } else {
            LOG.info("Set check for pre-releases to: " + this.checkForPreReleases);
        }
    }

    private void setAikarsFlags() {
        this.aikarsFlags = this.acquireProperty("de.griefed.serverpackcreator.configuration.aikar", "-Xms4G -Xmx4G -XX:+UseG1GC -XX:+ParallelRefProcEnabled -XX:MaxGCPauseMillis=200 -XX:+UnlockExperimentalVMOptions -XX:+DisableExplicitGC -XX:+AlwaysPreTouch -XX:G1NewSizePercent=30 -XX:G1MaxNewSizePercent=40 -XX:G1HeapRegionSize=8M -XX:G1ReservePercent=20 -XX:G1HeapWastePercent=5 -XX:G1MixedGCCountTarget=4 -XX:InitiatingHeapOccupancyPercent=15 -XX:G1MixedGCLiveThresholdPercent=90 -XX:G1RSetUpdatingPauseTimePercent=5 -XX:SurvivorRatio=32 -XX:+PerfDisableSharedMem -XX:MaxTenuringThreshold=1 -Dusing.aikars.flags=https://mcflags.emc.gs -Daikars.new.flags=true");
        LOG.info("Aikars flags set to: " + this.aikarsFlags);
    }

    private void setFilesToExcludeFromZip() {
        this.FILES_TO_EXCLUDE_FROM_ZIP.addAll(this.getListProperty("de.griefed.serverpackcreator.serverpack.zip.exclude", "minecraft_server.MINECRAFT_VERSION.jar,server.jar,libraries/net/minecraft/server/MINECRAFT_VERSION/server-MINECRAFT_VERSION.jar"));
        LOG.info("Files which must be excluded from ZIP-archives set to: " + this.FILES_TO_EXCLUDE_FROM_ZIP);
    }

    private void setZipFileExclusionEnabled() {
        this.isZipFileExclusionEnabled = this.getBoolProperty("de.griefed.serverpackcreator.serverpack.zip.exclude.enabled", true);
        LOG.info("Zip file exclusion enabled set to: " + this.isZipFileExclusionEnabled);
    }

    private void setScriptTemplates() {
        this.SCRIPT_TEMPLATES.clear();
        this.SCRIPT_TEMPLATES.addAll(this.getFileListProperty("de.griefed.serverpackcreator.serverpack.script.template", "default_template.sh,default_template.ps1", "server_files/"));
        LOG.info("Using script templates:");
        this.SCRIPT_TEMPLATES.forEach((? super T template) -> LOG.info("    " + template.getPath()));
    }

    private void setAutoExclusionOfMods() {
        this.autoExcludingModsEnabled = this.getBoolProperty("de.griefed.serverpackcreator.serverpack.autodiscovery.enabled", true);
        try {
            if (this.getProperty("de.griefed.serverpackcreator.serverpack.autodiscoverenabled").matches("(true|false)")) {
                this.autoExcludingModsEnabled = Boolean.parseBoolean(this.getProperty("de.griefed.serverpackcreator.serverpack.autodiscoverenabled"));
                this.setProperty("de.griefed.serverpackcreator.serverpack.autodiscovery.enabled", String.valueOf(this.autoExcludingModsEnabled));
                this.remove("de.griefed.serverpackcreator.serverpack.autodiscoverenabled");
                LOG.info("Migrated 'de.griefed.serverpackcreator.serverpack.autodiscoverenabled' to 'de.griefed.serverpackcreator.serverpack.autodiscovery.enabled'.");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        LOG.info("Auto-discovery of clientside-only mods set to: " + this.autoExcludingModsEnabled);
    }

    private void setServerPackOverwrite() {
        this.serverPacksOverwriteEnabled = this.getBoolProperty("de.griefed.serverpackcreator.serverpack.overwrite.enabled", true);
        LOG.info("Overwriting of already existing server packs set to: " + this.serverPacksOverwriteEnabled);
    }

    private void setServerPackCleanup() {
        this.serverPackCleanupEnabled = this.getBoolProperty("de.griefed.serverpackcreator.serverpack.cleanup.enabled", true);
        LOG.info("Cleanup of already existing server packs set to: " + this.serverPackCleanupEnabled);
    }

    private void setLanguage() {
        this.language = this.acquireProperty("de.griefed.serverpackcreator.language", "en_us");
        LOG.info("Language set to: " + this.language);
    }

    private void setHasteBinServerUrl() {
        this.hasteBinServerUrl = this.acquireProperty("de.griefed.serverpackcreator.configuration.hastebinserver", "https://haste.zneix.eu/documents");
        LOG.info("HasteBin documents endpoint set to: " + this.hasteBinServerUrl);
    }

    private void setMinecraftPreReleases() {
        this.minecraftPreReleases = this.getBoolProperty("de.griefed.serverpackcreator.minecraft.snapshots", false);
        LOG.info("Minecraft pre-releases and snapshots available set to: " + this.minecraftPreReleases);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void setModExclusionFilterMethod() {
        try {
            var2_3 = filterText = this.acquireProperty("de.griefed.serverpackcreator.serverpack.autodiscovery.filter", "START");
            var3_4 = -1;
            switch (var2_3.hashCode()) {
                case 68795: {
                    if (!var2_3.equals("END")) break;
                    var3_4 = 0;
                    break;
                }
                case 1669509300: {
                    if (!var2_3.equals("CONTAIN")) break;
                    var3_4 = 1;
                    break;
                }
                case 77854759: {
                    if (!var2_3.equals("REGEX")) break;
                    var3_4 = 2;
                    break;
                }
                case 2045402309: {
                    if (!var2_3.equals("EITHER")) break;
                    var3_4 = 3;
                    break;
                }
                case 79219778: {
                    if (!var2_3.equals("START")) break;
                    var3_4 = 5;
                }
            }
            switch (var3_4) {
                case 0: {
                    this.exclusionFilter = ExclusionFilter.END;
                    ** break;
lbl28:
                    // 1 sources

                    break;
                }
                case 1: {
                    this.exclusionFilter = ExclusionFilter.CONTAIN;
                    ** break;
lbl32:
                    // 1 sources

                    break;
                }
                case 2: {
                    this.exclusionFilter = ExclusionFilter.REGEX;
                    ** break;
lbl36:
                    // 1 sources

                    break;
                }
                case 3: {
                    this.exclusionFilter = ExclusionFilter.EITHER;
                    ** break;
lbl40:
                    // 1 sources

                    break;
                }
                default: {
                    ApplicationProperties.LOG.error("Invalid filter specified. Defaulting to START.");
                }
                case 5: {
                    this.exclusionFilter = ExclusionFilter.START;
                    break;
                }
            }
        }
        catch (NullPointerException var1_2) {
        }
        finally {
            this.setProperty("de.griefed.serverpackcreator.serverpack.autodiscovery.filter", this.exclusionFilter.toString());
        }
        ApplicationProperties.LOG.info("User specified clientside-only mod exclusion filter set to: " + (Object)this.exclusionFilter);
    }

    private void setJavaPath() {
        if (this.checkJavaPath(this.getProperty("de.griefed.serverpackcreator.java", ""))) {
            this.javaPath = this.getProperty("de.griefed.serverpackcreator.java");
        } else {
            this.setProperty("de.griefed.serverpackcreator.java", this.getJavaPath(""));
            this.javaPath = this.acquireProperty("de.griefed.serverpackcreator.java", this.getJavaPath(""));
        }
        LOG.info("Java path set to: " + this.javaPath);
    }

    public void setJavaPath(String javaPath) {
        this.javaPath = this.getJavaPath(javaPath);
        this.saveToDisk(this.SERVERPACKCREATOR_PROPERTIES_FILE);
    }

    public String java() {
        return this.javaPath;
    }

    public boolean javaAvailable() {
        return this.checkJavaPath(this.javaPath);
    }

    private boolean checkJavaPath(String pathToJava) {
        if (pathToJava.isEmpty()) {
            return false;
        }
        FileUtilities.FileType type = this.FILE_UTILITIES.checkFileType(pathToJava);
        switch (type) {
            case FILE: {
                return this.testJava(pathToJava);
            }
            case LINK: 
            case SYMLINK: {
                try {
                    return this.testJava(this.FILE_UTILITIES.resolveLink(new File(pathToJava)));
                }
                catch (InvalidFileTypeException | IOException ex) {
                    LOG.error("Could not read Java link/symlink.", (Throwable)ex);
                    return false;
                }
            }
            case DIRECTORY: {
                LOG.error("Directory specified. Path to Java must lead to a lnk, symlink or file.");
            }
        }
        return false;
    }

    private boolean testJava(String pathToJava) {
        boolean testSuccessful;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(new ArrayList<String>(Arrays.asList(pathToJava, "-version")));
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while (bufferedReader.readLine() != null && !bufferedReader.readLine().equals("null")) {
                System.out.println(bufferedReader.readLine());
            }
            bufferedReader.close();
            process.destroyForcibly();
            testSuccessful = true;
        }
        catch (IOException e) {
            LOG.error("Invalid Java specified.");
            testSuccessful = false;
        }
        return testSuccessful;
    }

    private String getJavaPath(String pathToJava) {
        String checkedJavaPath;
        try {
            if (!pathToJava.isEmpty()) {
                if (this.checkJavaPath(pathToJava)) {
                    return pathToJava;
                }
                if (this.checkJavaPath(pathToJava + ".exe")) {
                    return pathToJava + ".exe";
                }
                if (this.checkJavaPath(pathToJava + ".lnk")) {
                    return this.FILE_UTILITIES.resolveLink(new File(pathToJava + ".lnk"));
                }
            }
            LOG.info("Java setting invalid or otherwise not usable. Using system default.");
            LOG.debug("Acquiring path to Java installation from system properties...");
            checkedJavaPath = this.SYSTEM_UTILITIES.acquireJavaPathFromSystem();
            LOG.debug("Automatically acquired path to Java installation: " + checkedJavaPath);
        }
        catch (InvalidFileTypeException | IOException | NullPointerException ex) {
            LOG.info("Java setting invalid or otherwise not usable. Using system default.");
            checkedJavaPath = this.SYSTEM_UTILITIES.acquireJavaPathFromSystem();
            LOG.debug("Automatically acquired path to Java installation: " + checkedJavaPath, (Throwable)ex);
        }
        return checkedJavaPath;
    }

    private void setJavaScriptsVariablePaths() {
        for (int i2 = 8; i2 < 256; ++i2) {
            if (!this.checkJavaPath(this.getProperty("de.griefed.serverpackcreator.script.java" + i2, ""))) continue;
            if (this.JAVA_PATHS.containsKey(String.valueOf(i2))) {
                this.JAVA_PATHS.replace(String.valueOf(i2), this.getProperty("de.griefed.serverpackcreator.script.java" + i2).replace("\\", "/"));
            } else {
                this.JAVA_PATHS.put(String.valueOf(i2), this.getProperty("de.griefed.serverpackcreator.script.java" + i2).replace("\\", "/"));
            }
            this.setProperty("de.griefed.serverpackcreator.script.java" + i2, this.JAVA_PATHS.get(String.valueOf(i2)));
        }
        LOG.info("Available Java paths for scripts for local testing and debugging:");
        for (Map.Entry<String, String> entry : this.JAVA_PATHS.entrySet()) {
            LOG.info("Java " + entry.getKey() + " path: " + entry.getValue());
        }
    }

    private void setAutoUpdateScriptVariablesJavaPlaceholder() {
        this.javaScriptAutoupdate = this.getBoolProperty("de.griefed.serverpackcreator.script.java.autoupdate", true);
        LOG.info("Automatically update SPC_JAVA_SPC-placeholder in script variables table set to: " + this.javaScriptAutoupdate);
    }

    public List<File> FALLBACK_SCRIPT_TEMPLATES() {
        return new ArrayList<File>(this.FALLBACK_SCRIPT_TEMPLATES);
    }

    public File DEFAULT_SHELL_TEMPLATE() {
        return new File("default_template.sh");
    }

    public File DEFAULT_POWERSHELL_TEMPLATE() {
        return new File("default_template.ps1");
    }

    public List<File> scriptTemplates() {
        return new ArrayList<File>(this.SCRIPT_TEMPLATES);
    }

    public File SERVERPACKCREATOR_PROPERTIES() {
        return this.SERVERPACKCREATOR_PROPERTIES_FILE;
    }

    public List<String> FALLBACK_CLIENTSIDE_MODS() {
        return new ArrayList<String>(this.FALLBACK_CLIENTSIDE_MODS);
    }

    public List<String> FALLBACK_REGEX_CLIENTSIDE_MODS() {
        return new ArrayList<String>(this.FALLBACK_REGEX_CLIENTSIDE_MODS);
    }

    public File DEFAULT_CONFIG() {
        return this.DEFAULT_CONFIG;
    }

    public File DEFAULT_SERVER_PROPERTIES() {
        return this.DEFAULT_SERVER_PROPERTIES;
    }

    public File DEFAULT_SERVER_ICON() {
        return this.DEFAULT_SERVER_ICON;
    }

    public File MINECRAFT_VERSION_MANIFEST() {
        return this.MINECRAFT_VERSION_MANIFEST;
    }

    public File FORGE_VERSION_MANIFEST() {
        return this.FORGE_VERSION_MANIFEST;
    }

    public File FABRIC_VERSION_MANIFEST() {
        return this.FABRIC_VERSION_MANIFEST;
    }

    public File FABRIC_INSTALLER_VERSION_MANIFEST() {
        return this.FABRIC_INSTALLER_VERSION_MANIFEST;
    }

    public File QUILT_VERSION_MANIFEST() {
        return this.QUILT_VERSION_MANIFEST;
    }

    public File QUILT_INSTALLER_VERSION_MANIFEST() {
        return this.QUILT_INSTALLER_VERSION_MANIFEST;
    }

    public File SERVERPACKCREATOR_DATABASE() {
        return this.SERVERPACKCREATOR_DATABASE;
    }

    public File MINECRAFT_VERSION_MANIFEST_LOCATION() {
        return this.MINECRAFT_VERSION_MANIFEST_LOCATION;
    }

    public File FORGE_VERSION_MANIFEST_LOCATION() {
        return this.FORGE_VERSION_MANIFEST_LOCATION;
    }

    public File FABRIC_VERSION_MANIFEST_LOCATION() {
        return this.FABRIC_VERSION_MANIFEST_LOCATION;
    }

    public File FABRIC_INTERMEDIARIES_MANIFEST_LOCATION() {
        return this.FABRIC_INTERMEDIARIES_MANIFEST_LOCATION;
    }

    public File FABRIC_INSTALLER_VERSION_MANIFEST_LOCATION() {
        return this.FABRIC_INSTALLER_VERSION_MANIFEST_LOCATION;
    }

    public File QUILT_VERSION_MANIFEST_LOCATION() {
        return this.QUILT_VERSION_MANIFEST_LOCATION;
    }

    public File QUILT_INSTALLER_VERSION_MANIFEST_LOCATION() {
        return this.QUILT_INSTALLER_VERSION_MANIFEST_LOCATION;
    }

    public File LEGACY_FABRIC_GAME_MANIFEST() {
        return this.LEGACY_FABRIC_GAME_MANIFEST;
    }

    public File LEGACY_FABRIC_LOADER_MANIFEST() {
        return this.LEGACY_FABRIC_LOADER_MANIFEST;
    }

    public File LEGACY_FABRIC_INSTALLER_MANIFEST() {
        return this.LEGACY_FABRIC_INSTALLER_MANIFEST;
    }

    public File LEGACY_FABRIC_GAME_MANIFEST_LOCATION() {
        return this.LEGACY_FABRIC_GAME_MANIFEST_LOCATION;
    }

    public File LEGACY_FABRIC_LOADER_MANIFEST_LOCATION() {
        return this.LEGACY_FABRIC_LOADER_MANIFEST_LOCATION;
    }

    public File LEGACY_FABRIC_INSTALLER_MANIFEST_LOCATION() {
        return this.LEGACY_FABRIC_INSTALLER_MANIFEST_LOCATION;
    }

    public String SERVERPACKCREATOR_VERSION() {
        return this.SERVERPACKCREATOR_VERSION;
    }

    public String[] SUPPORTED_MODLOADERS() {
        return this.SUPPORTED_MODLOADERS;
    }

    public String DIRECTORY_SERVER_FILES() {
        return "server_files";
    }

    public String DIRECTORY_PLUGINS() {
        return "plugins";
    }

    public String DIRECTORY_PLUGINS_CONFIG() {
        return this.DIRECTORY_PLUGINS() + "/config";
    }

    public String MANIFEST_LOCATION() {
        return "./manifests/";
    }

    public String MINECRAFT_SERVER_MANIFEST_LOCATION() {
        return "./manifests/mcserver/";
    }

    public String getDirectoryServerPacks() {
        return this.directoryServerPacks;
    }

    public List<String> getDefaultListFallbackMods() {
        return new ArrayList<String>(this.FALLBACK_MODS);
    }

    public List<String> getListFallbackMods() {
        if (this.exclusionFilter.equals((Object)ExclusionFilter.REGEX)) {
            return new ArrayList<String>(this.FALLBACK_MODS_REGEX);
        }
        return new ArrayList<String>(this.FALLBACK_MODS);
    }

    public List<String> getListFallbackModsRegex() {
        return new ArrayList<String>(this.FALLBACK_MODS_REGEX);
    }

    public List<String> getDirectoriesToInclude() {
        return new ArrayList<String>(this.DIRECTORIES_TO_INCLUDE);
    }

    public List<String> getDirectoriesToExclude() {
        return new ArrayList<String>(this.DIRECTORIES_TO_EXCLUDE);
    }

    public void addDirectoryToExclude(String entry) {
        if (!this.DIRECTORIES_TO_INCLUDE.contains(entry) && this.DIRECTORIES_TO_EXCLUDE.add(entry)) {
            LOG.debug("Adding " + entry + " to list of files or directories to exclude.");
        }
    }

    public boolean getSaveLoadedConfiguration() {
        return this.saveLoadedConfiguration;
    }

    public int getQueueMaxDiskUsage() {
        return this.queueMaxDiskUsage;
    }

    public boolean checkForAvailablePreReleases() {
        return this.checkForPreReleases;
    }

    public String getAikarsFlags() {
        return this.aikarsFlags;
    }

    public List<String> getFilesToExcludeFromZipArchive() {
        return new ArrayList<String>(this.FILES_TO_EXCLUDE_FROM_ZIP);
    }

    public boolean isZipFileExclusionEnabled() {
        return this.isZipFileExclusionEnabled;
    }

    public boolean isAutoExcludingModsEnabled() {
        return this.autoExcludingModsEnabled;
    }

    public boolean updateFallback() {
        Properties properties;
        try (InputStream github = new URL("https://raw.githubusercontent.com/Griefed/ServerPackCreator/main/backend/main/resources/serverpackcreator.properties").openStream();){
            properties = new Properties();
            properties.load(github);
        }
        catch (IOException e) {
            LOG.debug("GitHub could not be reached. Checking GitLab.", (Throwable)e);
            try (InputStream gitlab = new URL("https://gitlab.com/Griefed/ServerPackCreator/-/raw/main/backend/main/resources/serverpackcreator.properties").openStream();){
                properties = new Properties();
                properties.load(gitlab);
            }
            catch (IOException ex) {
                LOG.debug("GitLab could not be reached. Checking GitGriefed", (Throwable)ex);
                try (InputStream gitgriefed = new URL("https://git.griefed.de/Griefed/ServerPackCreator/-/raw/main/backend/main/resources/serverpackcreator.properties").openStream();){
                    properties = new Properties();
                    properties.load(gitgriefed);
                }
                catch (IOException exe) {
                    LOG.debug("GitGriefed could not be reached.", (Throwable)exe);
                    properties = null;
                }
            }
        }
        boolean updated = false;
        if (properties != null) {
            if (properties.getProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist") != null && !this.getProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist").equals(properties.getProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist"))) {
                this.setProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist", properties.getProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist"));
                this.FALLBACK_MODS.clear();
                this.FALLBACK_MODS.addAll(Arrays.asList(this.getProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist").split(",")));
                LOG.info("The fallback-list for clientside only mods has been updated to: " + this.FALLBACK_MODS);
                updated = true;
            }
            if (properties.getProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist.regex") != null && !this.getProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist.regex").equals(properties.getProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist.regex"))) {
                this.setProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist.regex", properties.getProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist.regex"));
                this.FALLBACK_MODS_REGEX.clear();
                this.FALLBACK_MODS_REGEX.addAll(Arrays.asList(this.getProperty("de.griefed.serverpackcreator.configuration.fallbackmodslist.regex").split(",")));
                LOG.info("The fallback regex-list for clientside only mods has been updated to: " + this.FALLBACK_MODS_REGEX);
                updated = true;
            }
        }
        if (updated) {
            this.saveToDisk(this.SERVERPACKCREATOR_PROPERTIES_FILE);
        }
        return updated;
    }

    public boolean isDarkTheme() {
        return Boolean.parseBoolean(this.acquireProperty("de.griefed.serverpackcreator.gui.darkmode", "true"));
    }

    public void setTheme(boolean dark) {
        if (dark) {
            this.defineProperty("de.griefed.serverpackcreator.gui.darkmode", "true");
        } else {
            this.setProperty("de.griefed.serverpackcreator.gui.darkmode", "false");
        }
    }

    public void saveToDisk(File propertiesFile) {
        try (OutputStream outputStream = Files.newOutputStream(propertiesFile.toPath(), new OpenOption[0]);){
            this.store(outputStream, "For details about each property, see https://wiki.griefed.de/en/Documentation/ServerPackCreator/ServerPackCreator-Help#serverpackcreatorproperties");
        }
        catch (IOException ex) {
            LOG.error("Couldn't write properties-file.", (Throwable)ex);
        }
    }

    public boolean isServerPacksOverwriteEnabled() {
        return this.serverPacksOverwriteEnabled;
    }

    public boolean isServerPackCleanupEnabled() {
        return this.serverPackCleanupEnabled;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getHasteBinServerUrl() {
        return this.hasteBinServerUrl;
    }

    public boolean enableMinecraftPreReleases() {
        return this.minecraftPreReleases;
    }

    public ExclusionFilter exclusionFilter() {
        return this.exclusionFilter;
    }

    public Optional<String> javaPath(int javaVersion) {
        if (this.JAVA_PATHS.containsKey(String.valueOf(javaVersion)) && new File(this.JAVA_PATHS.get(String.valueOf(javaVersion))).isFile()) {
            return Optional.of(this.JAVA_PATHS.get(String.valueOf(javaVersion)));
        }
        return Optional.empty();
    }

    public boolean isJavaScriptAutoupdateEnabled() {
        return this.javaScriptAutoupdate;
    }

    public static enum ExclusionFilter {
        START,
        END,
        CONTAIN,
        REGEX,
        EITHER;

    }
}

