/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.larsonscanner;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class LarsonScanner
extends JPanel {
    private static final Color DEFAULT_BACKGROUND_COLOUR = new Color(0, 0, 0);
    private static final Color DEFAULT_EYE_COLOUR = new Color(255, 0, 0);
    private final Thread ANIMATOR_THREAD;
    private final Eye EYE;

    public LarsonScanner() {
        this.setDoubleBuffered(true);
        this.setLayout(new BorderLayout());
        this.setBackground(DEFAULT_BACKGROUND_COLOUR);
        this.EYE = new Eye();
        this.add((Component)this.EYE, "Center");
        this.ANIMATOR_THREAD = new Thread((Runnable)this.EYE, "animation");
        this.ANIMATOR_THREAD.start();
    }

    public LarsonScanner(short updateInterval) {
        this.setDoubleBuffered(true);
        this.setLayout(new BorderLayout());
        this.setBackground(DEFAULT_BACKGROUND_COLOUR);
        this.EYE = new Eye(updateInterval);
        this.add((Component)this.EYE, "Center");
        this.ANIMATOR_THREAD = new Thread((Runnable)this.EYE, "LarsonScanner Eye");
        this.ANIMATOR_THREAD.start();
    }

    public LarsonScanner(short interval, @NotNull Color backgroundColor) {
        this.setDoubleBuffered(true);
        this.setLayout(new BorderLayout());
        this.setBackground(backgroundColor);
        this.EYE = new Eye(interval, backgroundColor);
        this.add((Component)this.EYE, "Center");
        this.ANIMATOR_THREAD = new Thread((Runnable)this.EYE, "LarsonScanner Eye");
        this.ANIMATOR_THREAD.start();
    }

    public LarsonScanner(short interval, @NotNull Color backgroundColor, @NotNull Color eyeColor) {
        this.setDoubleBuffered(true);
        this.setLayout(new BorderLayout());
        this.setBackground(backgroundColor);
        this.EYE = new Eye(interval, backgroundColor, eyeColor);
        this.add((Component)this.EYE, "Center");
        this.ANIMATOR_THREAD = new Thread((Runnable)this.EYE, "LarsonScanner Eye");
        this.ANIMATOR_THREAD.start();
    }

    public byte getNumberOfElements() {
        return this.EYE.numberOfElements;
    }

    public void setNumberOfElements(byte amount) throws IllegalArgumentException {
        if (amount < 1) {
            throw new IllegalArgumentException("Number of elements must be greater than zero. Specified " + amount);
        }
        if ((amount & 1) == 0) {
            throw new IllegalArgumentException("Number of elements must be an odd number. Specified " + amount);
        }
        this.pause();
        this.EYE.numberOfElements = (byte)amount;
        Color[] newColours = new Color[amount];
        for (int i2 = 0; i2 < amount; ++i2) {
            newColours[i2] = i2 < this.EYE.eyeColours.length ? this.EYE.eyeColours[i2] : DEFAULT_EYE_COLOUR;
        }
        Eye.access$102(this.EYE, newColours);
        short[] newAlphas = new short[amount];
        int median = (amount + 1) / 2;
        for (int i3 = 0; i3 < amount; ++i3) {
            newAlphas[i3] = i3 + 1 < median ? (int)(255 / median * (i3 + 1)) : (i3 + 1 == median ? 255 : (short)((amount - i3) * 255 / median));
        }
        Eye.access$202(this.EYE, newAlphas);
        this.play();
    }

    public void setEyeColour(@NotNull Color color) {
        this.EYE.setEyeColour(color);
    }

    public Color[] getEyeColours() {
        return this.EYE.eyeColours;
    }

    public void setEyeColours(@NotNull @NotNull Color @NotNull [] colours) throws IllegalArgumentException {
        if (colours.length != this.EYE.numberOfElements) {
            throw new IllegalArgumentException("Color-array must contain exactly " + this.EYE.numberOfElements + " entries. Specified " + colours.length);
        }
        this.EYE.setEyeColours(colours);
    }

    public Color getEyeBackground() {
        return this.EYE.getBackground();
    }

    public void setEyeBackground(@NotNull Color backgroundColor) {
        this.EYE.setBackground(backgroundColor);
    }

    public void drawOval(boolean useOval) {
        this.EYE.ovalShaped = useOval;
    }

    public void toggleShape() {
        this.EYE.ovalShaped = !this.EYE.ovalShaped;
    }

    public boolean isShapeOval() {
        return this.EYE.ovalShaped;
    }

    public void useGradient(boolean useGradient) {
        this.EYE.useGradients = useGradient;
    }

    public void toggleGradient() {
        this.EYE.useGradients = !this.EYE.useGradients;
    }

    public boolean isGradientActive() {
        return this.EYE.useGradients;
    }

    public void useDivider(boolean useDivider) {
        this.EYE.useDivider = useDivider;
    }

    public void toggleDivider() {
        this.EYE.useDivider = !this.EYE.useDivider;
    }

    public boolean isDividerActive() {
        return this.EYE.useDivider;
    }

    public void useCylonAnimation(boolean useCylonAnimation) {
        this.EYE.cylonAnimation = useCylonAnimation;
    }

    public void toggleCylonAnimation() {
        this.EYE.cylonAnimation = !this.EYE.cylonAnimation;
    }

    public boolean isCylonAnimation() {
        return this.EYE.cylonAnimation;
    }

    public void forceAspectRatio(boolean force) {
        this.EYE.forceAspectRatio = force;
    }

    public void toggleAspectRatio() {
        this.EYE.forceAspectRatio = !this.EYE.forceAspectRatio;
    }

    public boolean isAspectRatioForced() {
        return this.EYE.forceAspectRatio;
    }

    public void setFractions(float fractionOne, float fractionTwo) throws IllegalArgumentException {
        if (fractionOne < 0.0f) {
            throw new IllegalArgumentException("First fraction must not be negative. Specified " + fractionOne);
        }
        if (fractionOne >= 1.0f) {
            throw new IllegalArgumentException("First fraction must be smaller than 1.0f. Specified " + fractionOne);
        }
        if (fractionOne > fractionTwo) {
            throw new IllegalArgumentException("First fraction must be smaller than fraction two. Specified " + fractionOne);
        }
        if (fractionTwo > 1.0f) {
            throw new IllegalArgumentException("Second fraction must be bigger than the first, and smaller or equal to 1.0f. Specified " + fractionTwo);
        }
        ((Eye)this.EYE).fractions[0] = fractionOne;
        ((Eye)this.EYE).fractions[1] = fractionTwo;
    }

    public float[] getFractions() {
        return this.EYE.fractions;
    }

    public short[] getAlphas() {
        return this.EYE.alphas;
    }

    public void setAlphas(short @NotNull [] alphas) throws IllegalArgumentException {
        if (alphas.length != this.EYE.numberOfElements) {
            throw new IllegalArgumentException("Alpha-array must contain exactly " + this.EYE.numberOfElements + " entries. Specified " + alphas.length);
        }
        Eye.access$202(this.EYE, alphas);
    }

    public short getInterval() {
        return this.EYE.interval;
    }

    public void setInterval(short updateInterval) throws IllegalArgumentException {
        if (updateInterval < 1) {
            throw new IllegalArgumentException("Interval must be greater than 0. Specified " + updateInterval);
        }
        this.EYE.interval = updateInterval;
    }

    public short getDivider() {
        return this.EYE.divider;
    }

    public void setDivider(short newStepDivider) throws IllegalArgumentException {
        if (newStepDivider < 1) {
            throw new IllegalArgumentException("Divider must be greater than 0. Specified " + newStepDivider);
        }
        this.EYE.divider = newStepDivider;
    }

    public float getGapPercent() {
        return this.EYE.gapPercent;
    }

    public void setGapPercent(float percentile) throws IllegalArgumentException {
        if (percentile < 0.0f) {
            throw new IllegalArgumentException("Gap percent must be a positive, non-negative, number. Specified " + percentile);
        }
        this.EYE.gapPercent = percentile;
        this.EYE.setNewEyeValues();
    }

    public double getPartitionDivider() {
        return this.EYE.partitionDivider;
    }

    public void setPartitionDivider(double partitionDivider) throws IllegalArgumentException {
        if (partitionDivider <= 0.0) {
            throw new IllegalArgumentException("Partition Divider must be bigger than 0.0D. Specified " + partitionDivider);
        }
        this.EYE.partitionDivider = partitionDivider;
        this.EYE.setNewEyeValues();
    }

    public void pause() {
        this.EYE.pauseAnimation();
    }

    public void play() {
        this.EYE.playAnimation();
    }

    public boolean isRunning() {
        return this.EYE.isRunning();
    }

    public void togglePauseUnpause() {
        this.EYE.togglePauseUnpause();
    }

    public int getQualitySetting() {
        return this.EYE.lastSetRenderingQuality;
    }

    public void setQualityHigh() {
        this.EYE.setRenderingQualityHigh();
    }

    public void setQualityMedium() {
        this.EYE.setRenderingQualityMedium();
    }

    public void setQualityLow() {
        this.EYE.setRenderingQualityLow();
    }

    public void loadConfig(@NotNull ScannerConfig config) throws IllegalArgumentException {
        if (config.qualitySetting == 0) {
            this.setQualityLow();
        } else if (config.qualitySetting == 1) {
            this.setQualityMedium();
        } else {
            this.setQualityHigh();
        }
        this.setNumberOfElements(config.numberOfElements);
        this.setAlphas(config.alphas);
        this.setEyeColours(config.eyeColours);
        this.setInterval(config.interval);
        this.setDivider(config.divider);
        this.setFractions(config.fractions[0], config.fractions[1]);
        this.setGapPercent(config.gapPercent);
        this.setPartitionDivider(config.partitionDivider);
        this.forceAspectRatio(config.forceAspectRatio);
        this.drawOval(config.ovalShaped);
        this.useGradient(config.useGradients);
        this.useDivider(config.useDivider);
        this.useCylonAnimation(config.cylonAnimation);
        this.setBackground(config.scannerBackgroundColour);
        this.EYE.setBackground(config.eyeBackgroundColour);
    }

    public void loadDefaults() {
        this.setQualityLow();
        this.setNumberOfElements((byte)5);
        this.setAlphas(new short[]{100, 200, 255, 200, 100});
        this.setEyeColour(DEFAULT_EYE_COLOUR);
        this.setInterval((short)100);
        this.setDivider((short)25);
        this.setFractions(0.4f, 1.0f);
        this.setGapPercent(25.0f);
        this.setPartitionDivider(5.0);
        this.forceAspectRatio(false);
        this.drawOval(true);
        this.useGradient(true);
        this.useDivider(true);
        this.useCylonAnimation(true);
        this.setBackground(DEFAULT_BACKGROUND_COLOUR);
        this.EYE.setBackground(DEFAULT_BACKGROUND_COLOUR);
    }

    public ScannerConfig getCurrentConfig() {
        return new ScannerConfig(this.EYE.lastSetRenderingQuality, this.EYE.alphas, this.EYE.interval, this.EYE.divider, this.EYE.numberOfElements, this.EYE.fractions, this.EYE.gapPercent, this.EYE.partitionDivider, this.EYE.forceAspectRatio, this.EYE.ovalShaped, this.EYE.useGradients, this.EYE.useDivider, this.EYE.cylonAnimation, this.EYE.eyeColours, this.getBackground(), this.EYE.getBackground());
    }

    static /* synthetic */ Color access$4000() {
        return DEFAULT_EYE_COLOUR;
    }

    private class Eye
    extends JComponent
    implements Runnable {
        private final RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        private final float[] fractions = new float[]{0.4f, 1.0f};
        private volatile boolean paused = true;
        private Color[] eyeColours = new Color[]{LarsonScanner.access$4000(), LarsonScanner.access$4000(), LarsonScanner.access$4000(), LarsonScanner.access$4000(), LarsonScanner.access$4000()};
        private float gapPercent = 25.0f;
        private double width;
        private double height;
        private double elementWidth;
        private double partition;
        private double gapWidth;
        private double totalGapWidth;
        private double halfOfTotalGapWidth;
        private double partitionDivider = 5.0;
        private int lastSetRenderingQuality = 0;
        private short[] alphas = new short[]{100, 200, 255, 200, 100};
        private short p;
        private short interval = (short)100;
        private short divider = (short)25;
        private byte numberOfElements = (byte)5;
        private boolean increasePosition = true;
        private boolean forceAspectRatio = false;
        private boolean ovalShaped = true;
        private boolean useGradients = true;
        private boolean useDivider = true;
        private boolean cylonAnimation = true;

        public Eye() {
            this.setDoubleBuffered(true);
            this.setBackground(DEFAULT_BACKGROUND_COLOUR);
            this.setRenderingQualityLow();
        }

        public Eye(short updateInterval) {
            this.interval = updateInterval;
            this.setDoubleBuffered(true);
            this.setBackground(DEFAULT_BACKGROUND_COLOUR);
            this.setRenderingQualityLow();
        }

        public Eye(@NotNull short updateInterval, Color backgroundColor) {
            this.interval = updateInterval;
            this.setDoubleBuffered(true);
            this.setBackground(backgroundColor);
            this.setRenderingQualityLow();
        }

        public Eye(@NotNull short updateInterval, @NotNull Color backgroundColor, Color eyeColor) {
            this.interval = updateInterval;
            this.setDoubleBuffered(true);
            this.setEyeColour(eyeColor);
            this.setBackground(backgroundColor);
            this.setRenderingQualityLow();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                block7: {
                    try {
                        Thread.sleep(((LarsonScanner)LarsonScanner.this).EYE.interval);
                        if (!this.paused) break block7;
                        Eye eye = this;
                        synchronized (eye) {
                            while (this.paused) {
                                this.wait();
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                LarsonScanner.this.EYE.updatePosition();
                LarsonScanner.this.EYE.repaint();
            }
        }

        @Override
        protected void paintComponent(Graphics g2) {
            super.paintComponent(g2);
            this.updateValues();
            Graphics2D g2d = (Graphics2D)g2;
            g2d.setRenderingHints(this.renderingHints);
            byte startY = 0;
            g2d.setColor(this.getBackground());
            g2d.fillRect(0, 0, (int)this.width, (int)this.height);
            if (this.ovalShaped) {
                if (this.cylonAnimation) {
                    this.drawCylonOval(g2d, startY);
                } else {
                    this.drawKittOval(g2d, startY);
                }
            } else if (this.cylonAnimation) {
                this.drawCylonRect(g2d, startY);
            } else {
                this.drawKittRect(g2d, startY);
            }
            g2d.drawRect(-10, -10, (int)this.width + 20, (int)this.height + 20);
            Toolkit.getDefaultToolkit().sync();
        }

        private synchronized void pauseAnimation() {
            this.paused = true;
        }

        private synchronized void playAnimation() {
            this.paused = false;
            this.notify();
        }

        private synchronized void togglePauseUnpause() {
            boolean bl = this.paused = !this.paused;
            if (!this.paused) {
                this.notify();
            }
        }

        private synchronized boolean isRunning() {
            return this.paused;
        }

        private void setRenderingQualityHigh() {
            this.lastSetRenderingQuality = 2;
            this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.renderingHints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            this.renderingHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            this.renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            this.renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        }

        private void setRenderingQualityMedium() {
            this.lastSetRenderingQuality = 1;
            this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
            this.renderingHints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT);
            this.renderingHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_DEFAULT);
            this.renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            this.renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        }

        private void setRenderingQualityLow() {
            this.lastSetRenderingQuality = 0;
            this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            this.renderingHints.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            this.renderingHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
            this.renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
            this.renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        }

        private void setEyeColours(@NotNull @NotNull Color @NotNull [] colours) {
            this.eyeColours = colours;
        }

        private void setEyeColour(@NotNull Color color) {
            Color[] newColours = new Color[this.numberOfElements];
            for (int i2 = 0; i2 < this.numberOfElements; ++i2) {
                newColours[i2] = color;
            }
            this.eyeColours = newColours;
        }

        private void updateValues() {
            boolean updated = false;
            if (this.forceAspectRatio) {
                if (this.width != (double)LarsonScanner.this.getWidth() || this.height != this.partition / (double)this.numberOfElements) {
                    this.width = LarsonScanner.this.getWidth();
                    this.height = this.partition / (double)this.numberOfElements;
                    updated = true;
                }
            } else {
                if (this.width != (double)LarsonScanner.this.getWidth()) {
                    this.width = LarsonScanner.this.getWidth();
                    updated = true;
                }
                if (this.height != (double)LarsonScanner.this.getHeight()) {
                    this.height = LarsonScanner.this.getHeight();
                    updated = true;
                }
            }
            if (updated) {
                this.setNewEyeValues();
            }
        }

        private void setNewEyeValues() {
            this.setSize((int)this.width, (int)this.height);
            this.partition = this.width / this.partitionDivider;
            this.elementWidth = this.partition / (double)this.numberOfElements;
            this.gapWidth = this.elementWidth / 100.0 * (double)this.gapPercent;
            this.totalGapWidth = this.gapWidth * (double)(this.numberOfElements - 2);
            this.halfOfTotalGapWidth = this.totalGapWidth / 2.0;
        }

        private void drawCylonOval(@NotNull Graphics2D g2d, byte startY) {
            for (byte element = 0; element < this.numberOfElements; element = (byte)(element + 1)) {
                double startOfElement = this.calcCylonOvalStart(element);
                if (this.useGradients) {
                    g2d.setPaint(this.cylonRadialGradient(element, this.getCenter(startOfElement), this.eyeColours[element]));
                } else {
                    g2d.setColor(this.eyeColours[element]);
                }
                g2d.fillOval((int)startOfElement, startY, (int)this.elementWidth, (int)this.height);
            }
        }

        private double getCenter(double start) {
            return start + this.elementWidth / 2.0;
        }

        private double calcCylonOvalStart(byte element) {
            return (double)this.p - this.elementWidth * (double)this.numberOfElements / 2.0 + this.elementWidth * (double)element;
        }

        @NotNull
        private RadialGradientPaint cylonRadialGradient(byte element, double centerX, @NotNull Color color) {
            Color[] colors = new Color[]{this.colorWithAlpha(this.alphas[element], color), this.getBackground()};
            return new RadialGradientPaint(new Point((int)centerX, (int)(this.height / 2.0)), (float)(0.5 * this.height), this.fractions, colors);
        }

        private void drawCylonRect(@NotNull Graphics2D g2d, byte startY) {
            for (byte element = 0; element < this.numberOfElements; element = (byte)(element + 1)) {
                double startOfElement = this.calcCylonRectStart(element);
                if (this.useGradients) {
                    int median = (this.numberOfElements + 1) / 2;
                    if (element + 1 < median) {
                        g2d.setPaint(this.ascCylonRectGradient(element, startOfElement));
                    } else if (element + 1 == median) {
                        g2d.setPaint(this.eyeColours[element]);
                    } else {
                        g2d.setPaint(this.descCylonRectGradient(element, startOfElement));
                    }
                } else {
                    g2d.setColor(this.eyeColours[element]);
                }
                g2d.fillRect((int)startOfElement, startY, (int)this.elementWidth, (int)this.height);
            }
        }

        private double calcCylonRectStart(byte element) {
            if (element == 0) {
                return (double)this.p - this.elementWidth * (double)this.numberOfElements / 2.0 - this.halfOfTotalGapWidth;
            }
            return (double)this.p - this.elementWidth * (double)this.numberOfElements / 2.0 - this.halfOfTotalGapWidth + (this.elementWidth + this.gapWidth) * (double)element;
        }

        @Contract(value="_, _ -> new")
        @NotNull
        private GradientPaint ascCylonRectGradient(byte element, double startX) {
            return new GradientPaint((float)startX, (float)(this.height / 2.0), this.colorWithAlpha((short)(this.alphas[element] - this.alphas[element] / 2), this.eyeColours[element]), (float)(startX + this.elementWidth), (float)(this.height / 2.0), this.colorWithAlpha(this.alphas[element], this.eyeColours[element]));
        }

        @Contract(value="_, _ -> new")
        @NotNull
        private GradientPaint descCylonRectGradient(byte element, double startX) {
            return new GradientPaint((float)startX, (float)(this.height / 2.0), this.colorWithAlpha(this.alphas[element], this.eyeColours[element]), (float)(startX + this.elementWidth), (float)(this.height / 2.0), this.colorWithAlpha((short)(this.alphas[element] - this.alphas[element] / 2), this.eyeColours[element]));
        }

        private void drawKittOval(@NotNull Graphics2D g2d, byte startY) {
            double startOfElement;
            for (byte element = 0; element < this.numberOfElements; element = (byte)(element + 1)) {
                startOfElement = this.calcKittOvalStart(element);
                this.addKittOval(g2d, startY, startOfElement, element);
            }
            if (this.increasePosition) {
                double posDrawn = (double)this.p + (double)this.numberOfElements * this.elementWidth;
                if (posDrawn > this.width) {
                    startOfElement = this.width - this.elementWidth;
                    if (this.useGradients) {
                        g2d.setPaint(this.kittRadialGradient((byte)(this.numberOfElements - 1), this.getCenter(startOfElement), this.eyeColours[this.numberOfElements - 1]));
                    } else {
                        g2d.setColor(this.eyeColours[this.numberOfElements - 1]);
                    }
                    g2d.fillOval((int)startOfElement, startY, (int)this.elementWidth, (int)this.height);
                } else if (this.p < 0) {
                    byte elementToDraw = (byte)((double)this.numberOfElements - posDrawn / this.elementWidth - 1.0);
                    if (this.useGradients) {
                        g2d.setPaint(this.kittRadialGradient(elementToDraw, this.getCenter(0.0), this.eyeColours[elementToDraw]));
                    } else {
                        g2d.setColor(this.eyeColours[elementToDraw]);
                    }
                    g2d.fillOval(0, startY, (int)this.elementWidth, (int)this.height);
                }
            } else {
                double posDrawn = (double)this.p - (double)this.numberOfElements * this.elementWidth;
                if (posDrawn <= 0.0) {
                    if (this.useGradients) {
                        g2d.setPaint(this.kittRadialGradient((byte)(this.numberOfElements - 1), this.getCenter(0.0), this.eyeColours[this.numberOfElements - 1]));
                    } else {
                        g2d.setColor(this.eyeColours[this.numberOfElements - 1]);
                    }
                    g2d.fillOval(0, startY, (int)this.elementWidth, (int)this.height);
                } else if ((double)this.p >= this.width) {
                    startOfElement = this.width - this.elementWidth;
                    byte elementToDraw = (byte)(((double)this.p - this.width) / this.elementWidth);
                    if (elementToDraw >= this.numberOfElements) {
                        elementToDraw = (byte)(this.numberOfElements - 1);
                    }
                    if (elementToDraw < this.numberOfElements) {
                        this.addKittOval(g2d, startY, startOfElement, elementToDraw);
                    }
                }
            }
        }

        private void addKittOval(@NotNull Graphics2D g2d, byte startY, double startOfElement, byte element) {
            if (this.useGradients) {
                g2d.setPaint(this.kittRadialGradient(element, this.getCenter(startOfElement), this.eyeColours[element]));
            } else {
                g2d.setColor(this.eyeColours[element]);
            }
            g2d.fillOval((int)startOfElement, startY, (int)this.elementWidth, (int)this.height);
        }

        private double calcKittOvalStart(byte element) {
            if (this.increasePosition) {
                return (double)this.p + (double)element * this.elementWidth;
            }
            return (double)this.p - (double)(element + 1) * this.elementWidth;
        }

        @NotNull
        private RadialGradientPaint kittRadialGradient(byte element, double centerX, @NotNull Color color) {
            short alpha = (short)(255.0 / (double)this.numberOfElements * (double)(element + 1));
            Color[] colors = new Color[]{this.colorWithAlpha(alpha, color), this.getBackground()};
            return new RadialGradientPaint(new Point((int)centerX, (int)(this.height / 2.0)), (float)(0.5 * this.height), this.fractions, colors);
        }

        private void drawKittRect(@NotNull Graphics2D g2d, byte startY) {
            double startOfElement;
            for (byte element = 0; element < this.numberOfElements; element = (byte)(element + 1)) {
                startOfElement = this.calcKittRectStart(element);
                if (this.useGradients) {
                    g2d.setPaint(this.kittRectGradient(element, startOfElement));
                } else {
                    g2d.setColor(this.eyeColours[element]);
                }
                g2d.fillRect((int)startOfElement, startY, (int)this.elementWidth, (int)this.height);
            }
            if (this.increasePosition) {
                byte elementToDraw;
                double posDrawn = (double)this.p + (double)this.numberOfElements * this.elementWidth + (double)(this.numberOfElements - 2) * this.gapWidth;
                if (posDrawn > this.width) {
                    startOfElement = this.width - this.elementWidth;
                    g2d.setColor(this.eyeColours[this.numberOfElements - 1]);
                    g2d.fillRect((int)startOfElement, startY, (int)this.elementWidth, (int)this.height);
                } else if (this.p < 0 && (elementToDraw = (byte)((double)this.numberOfElements - posDrawn / this.elementWidth - 1.0)) >= 0 && elementToDraw < this.numberOfElements) {
                    if (this.useGradients) {
                        g2d.setPaint(this.kittRectGradient(elementToDraw, this.getCenter(0.0)));
                    } else {
                        g2d.setColor(this.eyeColours[elementToDraw]);
                    }
                    g2d.fillRect(0, startY, (int)this.elementWidth, (int)this.height);
                }
            } else {
                double posDrawn = (double)this.p - (double)this.numberOfElements * this.elementWidth + (double)(this.numberOfElements - 2) * this.gapWidth;
                if (posDrawn <= 0.0) {
                    if (this.useGradients) {
                        g2d.setPaint(this.kittRectGradient((byte)(this.numberOfElements - 1), this.getCenter(0.0)));
                    } else {
                        g2d.setColor(this.eyeColours[this.numberOfElements - 1]);
                    }
                    g2d.fillRect(0, startY, (int)this.elementWidth, (int)this.height);
                } else if ((double)this.p >= this.width) {
                    startOfElement = this.width - this.elementWidth;
                    byte elementToDraw = (byte)(((double)this.p - this.width) / this.elementWidth);
                    if (elementToDraw >= this.numberOfElements) {
                        elementToDraw = (byte)(this.numberOfElements - 1);
                    }
                    if (elementToDraw >= 0) {
                        if (this.useGradients) {
                            g2d.setPaint(this.kittRectGradient(elementToDraw, this.getCenter(startOfElement)));
                        } else {
                            g2d.setColor(this.eyeColours[elementToDraw]);
                        }
                    }
                    g2d.fillRect((int)startOfElement, startY, (int)this.elementWidth, (int)this.height);
                }
            }
        }

        private double calcKittRectStart(byte element) {
            if (element == 0) {
                return this.p;
            }
            if (this.increasePosition) {
                return (double)this.p + (double)element * (this.elementWidth + this.gapWidth);
            }
            return (double)this.p - (double)element * (this.elementWidth + this.gapWidth);
        }

        @Contract(value="_, _ -> new")
        @NotNull
        private GradientPaint kittRectGradient(byte element, double startX) {
            short alphaOne = (short)(255.0 / (double)this.numberOfElements * (double)(element + 1));
            short alphaTwo = (short)(255.0 / (double)this.numberOfElements * (double)(element + 1));
            if (this.increasePosition) {
                return new GradientPaint((float)startX, (float)(this.height / 2.0), this.colorWithAlpha(alphaOne, this.eyeColours[element]), (float)(startX + this.elementWidth), (float)(this.height / 2.0), this.colorWithAlpha(alphaTwo, this.eyeColours[element]));
            }
            return new GradientPaint((float)startX, (float)(this.height / 2.0), this.colorWithAlpha(alphaTwo, this.eyeColours[element]), (float)(startX + this.elementWidth), (float)(this.height / 2.0), this.colorWithAlpha(alphaOne, this.eyeColours[element]));
        }

        @Contract(value="_, _ -> new")
        @NotNull
        private Color colorWithAlpha(short alpha, @NotNull Color color) throws IllegalArgumentException {
            if (alpha < 0 || alpha > 255) {
                throw new IllegalArgumentException("Alpha must be 0 to 255. Specified " + alpha);
            }
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha);
        }

        private void updatePosition() {
            if (this.cylonAnimation) {
                this.updatePositionCylonStyle();
            } else {
                this.updatePositionKittStyle();
            }
        }

        private void updatePositionCylonStyle() {
            if (this.p < 0) {
                this.increasePosition = true;
                this.p = 0;
                return;
            }
            if ((double)this.p > this.width) {
                this.increasePosition = false;
                this.p = (short)this.width;
                return;
            }
            if (this.useDivider) {
                if (this.increasePosition && (double)this.p < this.width) {
                    this.p = (short)((double)this.p + this.width / (double)this.divider);
                } else if (!this.increasePosition && this.p > 0) {
                    this.p = (short)((double)this.p - this.width / (double)this.divider);
                }
            } else if (this.increasePosition && (double)this.p < this.width) {
                this.p = (short)(this.p + 1);
            } else if (!this.increasePosition && this.p > 0) {
                this.p = (short)(this.p - 1);
            }
        }

        private void updatePositionKittStyle() {
            double widthElements = this.ovalShaped ? (double)this.numberOfElements * this.elementWidth : (double)this.numberOfElements * this.elementWidth + this.totalGapWidth;
            double maxWidth = this.width + widthElements;
            double maxNegative = 0.0 - widthElements;
            if ((double)this.p < maxNegative) {
                this.increasePosition = true;
                this.p = (short)maxNegative;
                return;
            }
            if ((double)this.p > maxWidth) {
                this.increasePosition = false;
                this.p = (short)maxWidth;
                return;
            }
            if (this.useDivider) {
                if (this.increasePosition && (double)this.p < maxWidth) {
                    this.p = (short)((double)this.p + maxWidth / (double)this.divider);
                } else if (!this.increasePosition && (double)this.p > maxNegative) {
                    this.p = (short)((double)this.p - maxWidth / (double)this.divider);
                }
            } else if (this.increasePosition && (double)this.p < maxWidth) {
                this.p = (short)(this.p + 1);
            } else if (!this.increasePosition && (double)this.p > maxNegative) {
                this.p = (short)(this.p - 1);
            }
        }

        static /* synthetic */ Color[] access$102(Eye x0, Color[] x1) {
            x0.eyeColours = x1;
            return x1;
        }

        static /* synthetic */ short[] access$202(Eye x0, short[] x1) {
            x0.alphas = x1;
            return x1;
        }
    }

    public static class ScannerConfig {
        public static final int LOW = 0;
        public static final int MEDIUM = 1;
        public static final int HIGH = 2;
        private final float[] fractions = new float[]{0.4f, 1.0f};
        private Color[] eyeColours = new Color[]{LarsonScanner.access$4000(), LarsonScanner.access$4000(), LarsonScanner.access$4000(), LarsonScanner.access$4000(), LarsonScanner.access$4000()};
        private Color scannerBackgroundColour = LarsonScanner.access$4100();
        private Color eyeBackgroundColour = LarsonScanner.access$4100();
        private float gapPercent = 25.0f;
        private int qualitySetting = 0;
        private short[] alphas = new short[]{100, 200, 255, 200, 100};
        private short interval = (short)100;
        private short divider = (short)25;
        private byte numberOfElements = (byte)5;
        private double partitionDivider = 5.0;
        private boolean forceAspectRatio = false;
        private boolean ovalShaped = true;
        private boolean useGradients = true;
        private boolean useDivider = true;
        private boolean cylonAnimation = true;

        public ScannerConfig() {
        }

        public ScannerConfig(int qualitySetting, short[] alphaValues, short intervalInMillis, short divider, byte numberOfElements, float[] fractions, float gapPercent, double partitionDivider, boolean forceAspectRatio, boolean ovalShaped, boolean useGradients, boolean useDivider, boolean cylonAnimation, @NotNull Color[] eyeColours, @NotNull Color scannerBackgroundColour, @NotNull Color eyeBackgroundColour) throws IllegalArgumentException {
            this.setQualitySetting(qualitySetting);
            this.setNumberOfElements(numberOfElements);
            this.setAlphas(alphaValues);
            this.setEyeColours(eyeColours);
            this.setInterval(intervalInMillis);
            this.setDivider(divider);
            this.setGapPercent(gapPercent);
            this.setPartitionDivider(partitionDivider);
            this.setFractions(fractions[0], fractions[1]);
            this.forceAspectRatio = forceAspectRatio;
            this.ovalShaped = ovalShaped;
            this.useGradients = useGradients;
            this.useDivider = useDivider;
            this.scannerBackgroundColour = scannerBackgroundColour;
            this.eyeBackgroundColour = eyeBackgroundColour;
            this.cylonAnimation = cylonAnimation;
        }

        public int getQualitySetting() {
            return this.qualitySetting;
        }

        public void setQualitySetting(int qualitySetting) throws IllegalArgumentException {
            if (qualitySetting < 0 || qualitySetting > 2) {
                throw new IllegalArgumentException("Quality setting must be 0, 1 or 2. Specified " + qualitySetting);
            }
            this.qualitySetting = qualitySetting;
        }

        public short[] getAlphas() {
            return this.alphas;
        }

        public void setAlphas(short @NotNull [] alphas) throws IllegalArgumentException {
            if (alphas.length != this.numberOfElements) {
                throw new IllegalArgumentException("Alpha-array must contain exactly " + this.numberOfElements + " entries. Specified " + alphas.length);
            }
            this.alphas = alphas;
        }

        public short getInterval() {
            return this.interval;
        }

        public void setInterval(short intervalInMillis) throws IllegalArgumentException {
            if (intervalInMillis < 1) {
                throw new IllegalArgumentException("Interval must be greater than 0. Specified " + intervalInMillis);
            }
            this.interval = intervalInMillis;
        }

        public short getDivider() {
            return this.divider;
        }

        public void setDivider(short divider) throws IllegalArgumentException {
            if (divider < 1) {
                throw new IllegalArgumentException("Divider must be greater than 0. Specified " + divider);
            }
            this.divider = divider;
        }

        public byte getNumberOfElements() {
            return this.numberOfElements;
        }

        public void setNumberOfElements(byte numberOfElements) throws IllegalArgumentException {
            if (numberOfElements < 1) {
                throw new IllegalArgumentException("Number of elements must be greater than zero. Specified " + numberOfElements);
            }
            if ((numberOfElements & 1) == 0) {
                throw new IllegalArgumentException("Number of elements must be an odd number. Specified " + numberOfElements);
            }
            this.numberOfElements = numberOfElements;
        }

        public float[] getFractions() {
            return this.fractions;
        }

        public void setFractions(float fractionOne, float fractionTwo) throws IllegalArgumentException {
            if (fractionOne < 0.0f) {
                throw new IllegalArgumentException("First fraction must not be negative. Specified " + fractionOne);
            }
            if (fractionOne >= 1.0f) {
                throw new IllegalArgumentException("First fraction must be smaller than 1.0f. Specified " + fractionOne);
            }
            if (fractionOne > fractionTwo) {
                throw new IllegalArgumentException("First fraction must be smaller than fraction two. Specified " + fractionOne);
            }
            if (fractionTwo > 1.0f) {
                throw new IllegalArgumentException("Second fraction must be bigger than the first, and smaller or equal to 1.0f. Specified " + fractionTwo);
            }
            this.fractions[0] = fractionOne;
            this.fractions[1] = fractionTwo;
        }

        public float getGapPercent() {
            return this.gapPercent;
        }

        public void setGapPercent(float gapPercent) throws IllegalArgumentException {
            if (gapPercent < 0.0f) {
                throw new IllegalArgumentException("Gap percent must be a positive, non-negative, number. Specified " + gapPercent);
            }
            this.gapPercent = gapPercent;
        }

        public double getPartitionDivider() {
            return this.partitionDivider;
        }

        public void setPartitionDivider(double partitionDivider) throws IllegalArgumentException {
            if (partitionDivider <= 0.0) {
                throw new IllegalArgumentException("Partition Divider must be bigger than 0.0D. Specified " + partitionDivider);
            }
            this.partitionDivider = partitionDivider;
        }

        public boolean isAspectRatioForced() {
            return this.forceAspectRatio;
        }

        public void setForceAspectRatio(boolean forceAspectRatio) {
            this.forceAspectRatio = forceAspectRatio;
        }

        public boolean isShapeOval() {
            return this.ovalShaped;
        }

        public void setOvalShaped(boolean ovalShaped) {
            this.ovalShaped = ovalShaped;
        }

        public boolean isGradientActive() {
            return this.useGradients;
        }

        public void setUseGradients(boolean useGradients) {
            this.useGradients = useGradients;
        }

        public boolean isDividerActive() {
            return this.useDivider;
        }

        public void setUseDivider(boolean useDivider) {
            this.useDivider = useDivider;
        }

        public boolean isCylonAnimation() {
            return this.cylonAnimation;
        }

        public void setCylonAnimation(boolean cylonAnimation) {
            this.cylonAnimation = cylonAnimation;
        }

        public Color[] getEyeColours() {
            return this.eyeColours;
        }

        public void setEyeColours(Color @NotNull [] eyeColours) throws IllegalArgumentException {
            if (eyeColours.length != this.numberOfElements) {
                throw new IllegalArgumentException("Color-array must contain exactly " + this.numberOfElements + " entries. Specified " + eyeColours.length);
            }
            this.eyeColours = eyeColours;
        }

        public Color getScannerBackgroundColour() {
            return this.scannerBackgroundColour;
        }

        public void setScannerBackgroundColour(@NotNull Color scannerBackgroundColour) {
            this.scannerBackgroundColour = scannerBackgroundColour;
        }

        public Color getEyeBackgroundColour() {
            return this.eyeBackgroundColour;
        }

        public void setEyeBackgroundColour(@NotNull Color eyeBackgroundColour) {
            this.eyeBackgroundColour = eyeBackgroundColour;
        }
    }
}

