/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.common.iteration;

import java.util.NoSuchElementException;
import org.wildfly.common._private.CommonMessages;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.common.iteration.CodePointIterator;

abstract class Base32DecodingByteIterator
extends ByteIterator {
    private final CodePointIterator iter;
    private final boolean requirePadding;
    private int state = 0;
    private int o0;
    private int o1;
    private int o2;
    private int o3;
    private int o4;
    private int offset;

    Base32DecodingByteIterator(CodePointIterator iter2, boolean requirePadding) {
        this.iter = iter2;
        this.requirePadding = requirePadding;
    }

    @Override
    public boolean hasNext() {
        if (this.state == 0) {
            if (!this.iter.hasNext()) {
                return false;
            }
            int b0 = this.iter.next();
            if (b0 == 61) {
                throw CommonMessages.msg.unexpectedPadding();
            }
            if (!this.iter.hasNext()) {
                if (this.requirePadding) {
                    throw CommonMessages.msg.expectedPadding();
                }
                throw CommonMessages.msg.incompleteDecode();
            }
            int b1 = this.iter.next();
            if (b1 == 61) {
                throw CommonMessages.msg.unexpectedPadding();
            }
            this.o0 = this.calc0(b0, b1);
            if (!this.iter.hasNext()) {
                if (this.requirePadding) {
                    throw CommonMessages.msg.expectedPadding();
                }
                this.state = 25;
                return true;
            }
            int b2 = this.iter.next();
            if (b2 == 61) {
                for (int i2 = 0; i2 < 5; ++i2) {
                    if (!this.iter.hasNext()) {
                        throw CommonMessages.msg.expectedPaddingCharacters(6);
                    }
                    if (this.iter.next() == 61) continue;
                    throw CommonMessages.msg.expectedPaddingCharacters(6);
                }
                this.state = 15;
                return true;
            }
            if (!this.iter.hasNext()) {
                if (this.requirePadding) {
                    throw CommonMessages.msg.expectedPadding();
                }
                throw CommonMessages.msg.incompleteDecode();
            }
            int b3 = this.iter.next();
            if (b3 == 61) {
                throw CommonMessages.msg.unexpectedPadding();
            }
            this.o1 = this.calc1(b1, b2, b3);
            if (!this.iter.hasNext()) {
                if (this.requirePadding) {
                    throw CommonMessages.msg.expectedPadding();
                }
                this.state = 23;
                return true;
            }
            int b4 = this.iter.next();
            if (b4 == 61) {
                for (int i3 = 0; i3 < 3; ++i3) {
                    if (!this.iter.hasNext()) {
                        throw CommonMessages.msg.expectedPaddingCharacters(4);
                    }
                    if (this.iter.next() == 61) continue;
                    throw CommonMessages.msg.expectedPaddingCharacters(4);
                }
                this.state = 13;
                return true;
            }
            this.o2 = this.calc2(b3, b4);
            if (!this.iter.hasNext()) {
                if (this.requirePadding) {
                    throw CommonMessages.msg.expectedPadding();
                }
                this.state = 20;
                return true;
            }
            int b5 = this.iter.next();
            if (b5 == 61) {
                for (int i4 = 0; i4 < 2; ++i4) {
                    if (!this.iter.hasNext()) {
                        throw CommonMessages.msg.expectedPaddingCharacters(3);
                    }
                    if (this.iter.next() == 61) continue;
                    throw CommonMessages.msg.expectedPaddingCharacters(3);
                }
                this.state = 10;
                return true;
            }
            if (!this.iter.hasNext()) {
                if (this.requirePadding) {
                    throw CommonMessages.msg.expectedPadding();
                }
                throw CommonMessages.msg.incompleteDecode();
            }
            int b6 = this.iter.next();
            if (b6 == 61) {
                throw CommonMessages.msg.unexpectedPadding();
            }
            this.o3 = this.calc3(b4, b5, b6);
            if (!this.iter.hasNext()) {
                if (this.requirePadding) {
                    throw CommonMessages.msg.expectedPadding();
                }
                this.state = 16;
                return true;
            }
            int b7 = this.iter.next();
            if (b7 == 61) {
                this.state = 6;
                return true;
            }
            this.o4 = this.calc4(b6, b7);
            this.state = 1;
            return true;
        }
        return this.state < 26;
    }

    @Override
    public boolean hasPrevious() {
        return this.offset > 0;
    }

    abstract int calc0(int var1, int var2);

    abstract int calc1(int var1, int var2, int var3);

    abstract int calc2(int var1, int var2);

    abstract int calc3(int var1, int var2, int var3);

    abstract int calc4(int var1, int var2);

    @Override
    public int next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        switch (this.state) {
            case 1: 
            case 6: 
            case 10: 
            case 13: 
            case 16: 
            case 20: 
            case 23: {
                ++this.state;
                ++this.offset;
                return this.o0;
            }
            case 2: 
            case 7: 
            case 11: 
            case 17: 
            case 21: {
                ++this.state;
                ++this.offset;
                return this.o1;
            }
            case 3: 
            case 8: 
            case 18: {
                ++this.state;
                ++this.offset;
                return this.o2;
            }
            case 4: {
                this.state = 5;
                ++this.offset;
                return this.o3;
            }
            case 5: {
                this.state = 0;
                ++this.offset;
                return this.o4;
            }
            case 9: {
                this.state = 26;
                ++this.offset;
                return this.o3;
            }
            case 12: {
                this.state = 27;
                ++this.offset;
                return this.o2;
            }
            case 14: {
                this.state = 28;
                ++this.offset;
                return this.o1;
            }
            case 15: {
                this.state = 29;
                ++this.offset;
                return this.o0;
            }
            case 19: {
                this.state = 30;
                ++this.offset;
                return this.o3;
            }
            case 22: {
                this.state = 31;
                ++this.offset;
                return this.o2;
            }
            case 24: {
                this.state = 32;
                ++this.offset;
                return this.o1;
            }
            case 25: {
                this.state = 33;
                ++this.offset;
                return this.o0;
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public int peekNext() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        switch (this.state) {
            case 1: 
            case 6: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 20: 
            case 23: 
            case 25: {
                return this.o0;
            }
            case 2: 
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 21: 
            case 24: {
                return this.o1;
            }
            case 3: 
            case 8: 
            case 12: 
            case 18: 
            case 22: {
                return this.o2;
            }
            case 4: 
            case 9: 
            case 19: {
                return this.o3;
            }
            case 5: {
                return this.o4;
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public int previous() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        int skipChars = 0;
        switch (this.state) {
            case 0: 
            case 1: 
            case 6: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 20: 
            case 23: 
            case 25: {
                if (this.state == 6 || this.state == 10 || this.state == 13 || this.state == 15) {
                    skipChars = 8;
                } else if (this.state == 16) {
                    skipChars = 7;
                } else if (this.state == 20) {
                    skipChars = 5;
                } else if (this.state == 23) {
                    skipChars = 4;
                } else if (this.state == 25) {
                    skipChars = 2;
                }
                for (int i2 = 0; i2 < skipChars; ++i2) {
                    this.iter.previous();
                }
                int b7 = this.iter.previous();
                int b6 = this.iter.previous();
                int b5 = this.iter.previous();
                int b4 = this.iter.previous();
                int b3 = this.iter.previous();
                int b2 = this.iter.previous();
                int b1 = this.iter.previous();
                int b0 = this.iter.previous();
                this.o0 = this.calc0(b0, b1);
                this.o1 = this.calc1(b1, b2, b3);
                this.o2 = this.calc2(b3, b4);
                this.o3 = this.calc3(b4, b5, b6);
                this.o4 = this.calc4(b6, b7);
                this.state = 5;
                --this.offset;
                return this.o4;
            }
            case 2: 
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 21: 
            case 24: {
                --this.state;
                --this.offset;
                return this.o0;
            }
            case 3: 
            case 8: 
            case 12: 
            case 18: 
            case 22: {
                --this.state;
                --this.offset;
                return this.o1;
            }
            case 4: 
            case 9: 
            case 19: {
                --this.state;
                --this.offset;
                return this.o2;
            }
            case 5: {
                this.state = 4;
                --this.offset;
                return this.o3;
            }
            case 26: {
                this.state = 9;
                --this.offset;
                return this.o3;
            }
            case 27: {
                this.state = 12;
                --this.offset;
                return this.o2;
            }
            case 28: {
                this.state = 14;
                --this.offset;
                return this.o1;
            }
            case 29: {
                this.state = 15;
                --this.offset;
                return this.o0;
            }
            case 30: {
                this.state = 19;
                --this.offset;
                return this.o3;
            }
            case 31: {
                this.state = 22;
                --this.offset;
                return this.o2;
            }
            case 32: {
                this.state = 24;
                --this.offset;
                return this.o1;
            }
            case 33: {
                this.state = 25;
                --this.offset;
                return this.o0;
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public int peekPrevious() throws NoSuchElementException {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        int skipChars = 0;
        switch (this.state) {
            case 0: 
            case 1: 
            case 6: 
            case 10: 
            case 13: 
            case 15: 
            case 16: 
            case 20: 
            case 23: 
            case 25: {
                if (this.state == 6 || this.state == 10 || this.state == 13 || this.state == 15) {
                    skipChars = 8;
                } else if (this.state == 16) {
                    skipChars = 7;
                } else if (this.state == 20) {
                    skipChars = 5;
                } else if (this.state == 23) {
                    skipChars = 4;
                } else if (this.state == 25) {
                    skipChars = 2;
                }
                for (int i2 = 0; i2 < skipChars; ++i2) {
                    this.iter.previous();
                }
                int b7 = this.iter.previous();
                int b6 = this.iter.peekPrevious();
                this.iter.next();
                for (int i3 = 0; i3 < skipChars; ++i3) {
                    this.iter.next();
                }
                return this.calc4(b6, b7);
            }
            case 2: 
            case 7: 
            case 11: 
            case 14: 
            case 17: 
            case 21: 
            case 24: 
            case 29: 
            case 33: {
                return this.o0;
            }
            case 3: 
            case 8: 
            case 12: 
            case 18: 
            case 22: 
            case 28: 
            case 32: {
                return this.o1;
            }
            case 4: 
            case 9: 
            case 19: 
            case 27: 
            case 31: {
                return this.o2;
            }
            case 5: 
            case 26: 
            case 30: {
                return this.o3;
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public long getIndex() {
        return this.offset;
    }
}

