/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.function.BiConsumer;
import org.jgroups.Message;
import org.jgroups.tests.ParseMessages;
import org.jgroups.util.MessageBatch;

public class ParseMessagesFields
extends ParseMessages {
    private static final DateTimeFormatter TIME_EPOCH_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss,SSS");
    private static final ZoneId ZONE_ID = ZoneId.systemDefault();
    private static String[] fields;

    @Override
    protected InputStream createInputStream(InputStream in) {
        return new BinaryToAsciiWithFieldsInputStream(in);
    }

    @Override
    public void parse(InputStream in, BiConsumer<Short, Message> msg_consumer, BiConsumer<Short, MessageBatch> batch_consumer, boolean tcp) {
        this.parseWithFields(in, msg_consumer, batch_consumer, tcp);
    }

    public void parseWithFields(InputStream input, BiConsumer<Short, Message> msg_consumer, BiConsumer<Short, MessageBatch> batch_consumer, boolean tcp) {
        try {
            while (true) {
                byte b;
                String[] fieldValues = new String[fields.length];
                BinaryToAsciiWithFieldsInputStream cast = (BinaryToAsciiWithFieldsInputStream)input;
                for (int i2 = 0; i2 < fields.length; ++i2) {
                    String field = fields[i2];
                    if ("frame.time_epoch".equals(field)) {
                        fieldValues[i2] = cast.readEpochTime();
                        continue;
                    }
                    if (field.contains(".srcport")) {
                        fieldValues[i2] = cast.readIntegerAsStr();
                        continue;
                    }
                    if (field.contains(".dstport")) {
                        fieldValues[i2] = cast.readIntegerAsStr();
                        continue;
                    }
                    throw new RuntimeException(String.format("%s not implemented", field));
                }
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                while ((b = cast.readPlainByte()) != 10 && b != 13 && b != -1) {
                    outputStream.write(b);
                }
                if (outputStream.size() == 0) continue;
                for (String fieldValue : fieldValues) {
                    System.out.print(fieldValue + " ");
                }
                super.parse(new ParseMessages.BinaryToAsciiInputStream(new ByteArrayInputStream(outputStream.toByteArray())), msg_consumer, batch_consumer, tcp);
            }
        }
        catch (EOFException fieldValues) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        String fieldsArgument = System.getProperty("fields");
        if (fieldsArgument != null) {
            fields = fieldsArgument.split(",");
        }
    }

    public static class BinaryToAsciiWithFieldsInputStream
    extends ParseMessages.BinaryToAsciiInputStream {
        public BinaryToAsciiWithFieldsInputStream(InputStream in) {
            super(in);
        }

        public String readIntegerAsStr() throws IOException {
            Object str = "";
            while (true) {
                this.input[0] = (byte)this.in.read();
                if (this.input[0] == 9) break;
                this.input[1] = (byte)this.in.read();
                if (this.input[1] == 9) {
                    str = (String)str + new String(new byte[]{this.input[0]});
                    break;
                }
                str = (String)str + new String(this.input);
            }
            return str;
        }

        public String readEpochTime() throws IOException {
            Object timestamp = "";
            while (((String)timestamp).length() != 20) {
                this.input[0] = (byte)this.in.read();
                if (this.input[0] == 10 || this.input[0] == 13) continue;
                this.input[1] = (byte)this.in.read();
                if (this.input[0] == -1 || this.input[1] == -1) {
                    throw new EOFException();
                }
                timestamp = (String)timestamp + new String(this.input);
            }
            this.readPlainByte();
            String[] time = ((String)timestamp).split("\\.");
            long epochMilli = Long.valueOf(time[0]) * 1000L;
            long nanos = Long.valueOf(time[1]);
            ZonedDateTime zonedDateTime = Instant.ofEpochMilli(epochMilli).plusNanos(nanos).atZone(ZONE_ID);
            String epochTime = TIME_EPOCH_DATE_TIME_FORMATTER.format(zonedDateTime);
            return epochTime;
        }

        public byte readPlainByte() throws IOException {
            return (byte)this.in.read();
        }
    }
}

