/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.pretty;

import java.io.Serializable;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.Type;

public final class MessageHelper {
    private MessageHelper() {
    }

    public static String infoString(String entityName, Serializable id) {
        StringBuilder s2 = new StringBuilder();
        s2.append('[');
        if (entityName == null) {
            s2.append("<null entity name>");
        } else {
            s2.append(entityName);
        }
        s2.append('#');
        if (id == null) {
            s2.append("<null>");
        } else {
            s2.append(id);
        }
        s2.append(']');
        return s2.toString();
    }

    public static String infoString(EntityPersister persister, Object id, SessionFactoryImplementor factory) {
        Type idType;
        StringBuilder s2 = new StringBuilder();
        s2.append('[');
        if (persister == null) {
            s2.append("<null EntityPersister>");
            idType = null;
        } else {
            s2.append(persister.getEntityName());
            idType = persister.getIdentifierType();
        }
        s2.append('#');
        if (id == null) {
            s2.append("<null>");
        } else if (idType == null) {
            s2.append(id);
        } else if (factory != null) {
            s2.append(idType.toLoggableString(id, factory));
        } else {
            s2.append("<not loggable>");
        }
        s2.append(']');
        return s2.toString();
    }

    public static String infoString(EntityPersister persister, Object id, Type identifierType, SessionFactoryImplementor factory) {
        StringBuilder s2 = new StringBuilder();
        s2.append('[');
        if (persister == null) {
            s2.append("<null EntityPersister>");
        } else {
            s2.append(persister.getEntityName());
        }
        s2.append('#');
        if (id == null) {
            s2.append("<null>");
        } else {
            s2.append(identifierType.toLoggableString(id, factory));
        }
        s2.append(']');
        return s2.toString();
    }

    public static String infoString(EntityPersister persister, Serializable[] ids, SessionFactoryImplementor factory) {
        StringBuilder s2 = new StringBuilder();
        s2.append('[');
        if (persister == null) {
            s2.append("<null EntityPersister>");
        } else {
            s2.append(persister.getEntityName());
            s2.append("#<");
            for (int i2 = 0; i2 < ids.length; ++i2) {
                s2.append(persister.getIdentifierType().toLoggableString(ids[i2], factory));
                if (i2 >= ids.length - 1) continue;
                s2.append(", ");
            }
            s2.append('>');
        }
        s2.append(']');
        return s2.toString();
    }

    public static String infoString(EntityPersister persister) {
        StringBuilder s2 = new StringBuilder();
        s2.append('[');
        if (persister == null) {
            s2.append("<null EntityPersister>");
        } else {
            s2.append(persister.getEntityName());
        }
        s2.append(']');
        return s2.toString();
    }

    public static String infoString(String entityName, String propertyName, Object key) {
        StringBuilder s2 = new StringBuilder().append('[').append(entityName).append('.').append(propertyName).append('#');
        if (key == null) {
            s2.append("<null>");
        } else {
            s2.append(key);
        }
        s2.append(']');
        return s2.toString();
    }

    public static String collectionInfoString(CollectionPersister persister, PersistentCollection collection, Serializable collectionKey, SharedSessionContractImplementor session) {
        StringBuilder s2 = new StringBuilder();
        s2.append('[');
        if (persister == null) {
            s2.append("<unreferenced>");
        } else {
            Serializable ownerKey;
            s2.append(persister.getRole());
            s2.append('#');
            Type ownerIdentifierType = persister.getOwnerEntityPersister().getIdentifierType();
            if (collectionKey.getClass().isAssignableFrom(ownerIdentifierType.getReturnedClass())) {
                ownerKey = collectionKey;
            } else {
                Object collectionOwner = collection == null ? null : collection.getOwner();
                EntityEntry entry = collectionOwner == null ? null : session.getPersistenceContextInternal().getEntry(collectionOwner);
                ownerKey = entry == null ? null : entry.getId();
            }
            s2.append(ownerIdentifierType.toLoggableString(ownerKey, session.getFactory()));
        }
        s2.append(']');
        return s2.toString();
    }

    public static String collectionInfoString(CollectionPersister persister, Serializable[] ids, SessionFactoryImplementor factory) {
        StringBuilder s2 = new StringBuilder();
        s2.append('[');
        if (persister == null) {
            s2.append("<unreferenced>");
        } else {
            s2.append(persister.getRole());
            s2.append("#<");
            for (int i2 = 0; i2 < ids.length; ++i2) {
                MessageHelper.addIdToCollectionInfoString(persister, ids[i2], factory, s2);
                if (i2 >= ids.length - 1) continue;
                s2.append(", ");
            }
            s2.append('>');
        }
        s2.append(']');
        return s2.toString();
    }

    public static String collectionInfoString(CollectionPersister persister, Serializable id, SessionFactoryImplementor factory) {
        StringBuilder s2 = new StringBuilder();
        s2.append('[');
        if (persister == null) {
            s2.append("<unreferenced>");
        } else {
            s2.append(persister.getRole());
            s2.append('#');
            if (id == null) {
                s2.append("<null>");
            } else {
                MessageHelper.addIdToCollectionInfoString(persister, id, factory, s2);
            }
        }
        s2.append(']');
        return s2.toString();
    }

    private static void addIdToCollectionInfoString(CollectionPersister persister, Serializable id, SessionFactoryImplementor factory, StringBuilder s2) {
        Type ownerIdentifierType = persister.getOwnerEntityPersister().getIdentifierType();
        if (id.getClass().isAssignableFrom(ownerIdentifierType.getReturnedClass())) {
            s2.append(ownerIdentifierType.toLoggableString(id, factory));
        } else {
            s2.append(id.toString());
        }
    }

    public static String collectionInfoString(String role, Serializable id) {
        StringBuilder s2 = new StringBuilder();
        s2.append('[');
        if (role == null) {
            s2.append("<unreferenced>");
        } else {
            s2.append(role);
            s2.append('#');
            if (id == null) {
                s2.append("<null>");
            } else {
                s2.append(id);
            }
        }
        s2.append(']');
        return s2.toString();
    }
}

