/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.uri;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Locale;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.utils.collections.ConcurrentHashSet;
import org.apache.commons.beanutils.FluentPropertyBeanIntrospector;
import org.apache.commons.beanutils.IntrospectionContext;
import org.jboss.logging.Logger;

public class FluentPropertyBeanIntrospectorWithIgnores
extends FluentPropertyBeanIntrospector {
    static Logger logger = Logger.getLogger(FluentPropertyBeanIntrospectorWithIgnores.class);
    private static ConcurrentHashSet<Pair<String, String>> ignores = new ConcurrentHashSet();

    public static void addIgnore(String className, String propertyName) {
        logger.trace("Adding ignore on " + className + "/" + propertyName);
        ignores.add(new Pair<String, String>(className, propertyName));
    }

    public static boolean isIgnored(String className, String propertyName) {
        return ignores.contains(new Pair<String, String>(className, propertyName));
    }

    @Override
    public void introspect(IntrospectionContext icontext) throws IntrospectionException {
        for (Method m3 : icontext.getTargetClass().getMethods()) {
            if (!m3.getName().startsWith(this.getWriteMethodPrefix())) continue;
            String propertyName = this.propertyName(m3);
            PropertyDescriptor pd = icontext.getPropertyDescriptor(propertyName);
            if (FluentPropertyBeanIntrospectorWithIgnores.isIgnored(icontext.getTargetClass().getName(), m3.getName())) {
                logger.trace(m3.getName() + " Ignored for " + icontext.getTargetClass().getName());
                continue;
            }
            try {
                if (pd == null) {
                    icontext.addPropertyDescriptor(this.createFluentPropertyDescritor(m3, propertyName));
                    continue;
                }
                if (pd.getWriteMethod() != null) continue;
                pd.setWriteMethod(m3);
            }
            catch (IntrospectionException e) {
                logger.debug((Object)e.getMessage(), e);
            }
        }
    }

    private PropertyDescriptor createFluentPropertyDescritor(Method m3, String propertyName) throws IntrospectionException {
        return new PropertyDescriptor(this.propertyName(m3), null, m3);
    }

    private String propertyName(Method m3) {
        String methodName = m3.getName().substring(this.getWriteMethodPrefix().length());
        return methodName.length() > 1 ? Character.toLowerCase(methodName.charAt(0)) + methodName.substring(1) : methodName.toLowerCase(Locale.ENGLISH);
    }
}

