/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.ssl.SslHandler;
import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.jboss.logging.Logger;

public class CertificateUtil {
    private static final Logger logger = Logger.getLogger(CertificateUtil.class);

    public static X509Certificate[] getCertsFromChannel(Channel channel) {
        Certificate[] plainCerts = null;
        ChannelHandler channelHandler = channel.pipeline().get("ssl");
        if (channelHandler != null && channelHandler instanceof SslHandler) {
            SslHandler sslHandler = (SslHandler)channelHandler;
            try {
                plainCerts = sslHandler.engine().getSession().getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
        }
        X509Certificate[] x509Certs = null;
        if (plainCerts != null && plainCerts.length > 0) {
            x509Certs = new X509Certificate[plainCerts.length];
            for (int i2 = 0; i2 < plainCerts.length; ++i2) {
                if (plainCerts[i2] instanceof X509Certificate) {
                    x509Certs[i2] = (X509Certificate)plainCerts[i2];
                } else {
                    try {
                        x509Certs[i2] = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(plainCerts[i2].getEncoded()));
                    }
                    catch (Exception ex) {
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)"Failed to convert SSL cert", ex);
                        }
                        return null;
                    }
                }
                if (!logger.isTraceEnabled()) continue;
                logger.trace("Cert #" + i2 + " = " + x509Certs[i2]);
            }
        }
        return x509Certs;
    }
}

