/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.uri.schemas.clusterConnection;

import java.net.URI;
import java.util.Map;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.uri.schemas.clusterConnection.ClusterConnectionStaticSchema;
import org.apache.activemq.artemis.utils.uri.BeanSupport;
import org.apache.activemq.artemis.utils.uri.URISupport;

public class ClusterConnectionMulticastSchema
extends ClusterConnectionStaticSchema {
    @Override
    public String getSchemaName() {
        return "multicast";
    }

    @Override
    public void populateObject(URI uri, ClusterConnectionConfiguration bean2) throws Exception {
        if (URISupport.isCompositeURI(uri)) {
            super.populateObject(uri, bean2);
        } else {
            bean2.setDiscoveryGroupName(uri.getHost());
            Map<String, String> parameters = URISupport.parseParameters(uri);
            BeanSupport.setData(uri, bean2, parameters);
        }
    }
}

