/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.uri;

import java.io.NotSerializableException;
import java.net.URI;
import java.util.Map;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.JGroupsFileBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.JGroupsPropertiesBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.uri.AbstractCFSchema;
import org.apache.activemq.artemis.uri.JMSConnectionOptions;
import org.apache.activemq.artemis.uri.schema.serverLocator.JGroupsServerLocatorSchema;
import org.apache.activemq.artemis.utils.uri.BeanSupport;

public class JGroupsSchema
extends AbstractCFSchema {
    @Override
    public String getSchemaName() {
        return "jgroups";
    }

    @Override
    public ActiveMQConnectionFactory internalNewObject(URI uri, Map<String, String> query2, String name) throws Exception {
        JMSConnectionOptions options = this.newConectionOptions(uri, query2);
        DiscoveryGroupConfiguration dcConfig = JGroupsServerLocatorSchema.getDiscoveryGroupConfiguration(uri, query2, name);
        ActiveMQConnectionFactory factory = options.isHa() ? ActiveMQJMSClient.createConnectionFactoryWithHA(dcConfig, options.getFactoryTypeEnum()) : ActiveMQJMSClient.createConnectionFactoryWithoutHA(dcConfig, options.getFactoryTypeEnum());
        return this.setData(uri, query2, factory);
    }

    @Override
    protected URI internalNewURI(ActiveMQConnectionFactory bean2) throws Exception {
        String auth;
        DiscoveryGroupConfiguration dgc = bean2.getDiscoveryGroupConfiguration();
        BroadcastEndpointFactory endpoint = dgc.getBroadcastEndpointFactory();
        if (endpoint instanceof JGroupsFileBroadcastEndpointFactory) {
            auth = ((JGroupsFileBroadcastEndpointFactory)endpoint).getChannelName();
        } else if (endpoint instanceof JGroupsPropertiesBroadcastEndpointFactory) {
            auth = ((JGroupsPropertiesBroadcastEndpointFactory)endpoint).getChannelName();
        } else {
            throw new NotSerializableException(endpoint + "not serializable");
        }
        String query2 = BeanSupport.getData(null, bean2, dgc, endpoint);
        dgc.setBroadcastEndpointFactory(endpoint);
        return new URI("jgroups", null, auth, -1, null, query2, null);
    }
}

