/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.plugin.impl;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.security.SecurityStore;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ConsumerInfo;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.ServerConsumer;
import org.apache.activemq.artemis.core.server.ServerSession;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerPlugin;
import org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal;
import org.jboss.logging.Logger;

public class BrokerMessageAuthorizationPlugin
implements ActiveMQServerPlugin {
    private static final Logger logger = Logger.getLogger(BrokerMessageAuthorizationPlugin.class);
    private static final String ROLE_PROPERTY = "ROLE_PROPERTY";
    private final AtomicReference<ActiveMQServer> server = new AtomicReference();
    private String roleProperty = "requiredRole";

    @Override
    public void init(Map<String, String> properties) {
        this.roleProperty = properties.getOrDefault(ROLE_PROPERTY, "requiredRole");
    }

    @Override
    public void registered(ActiveMQServer server) {
        this.server.set(server);
    }

    @Override
    public void unregistered(ActiveMQServer server) {
        this.server.set(null);
    }

    @Override
    public boolean canAccept(ServerConsumer consumer, MessageReference reference) throws ActiveMQException {
        String requiredRole = reference.getMessage().getStringProperty(this.roleProperty);
        if (requiredRole == null) {
            return true;
        }
        Subject subject = this.getSubject(consumer);
        if (subject == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Subject not found for consumer: " + consumer.getID());
            }
            return false;
        }
        boolean permitted = new RolePrincipal(requiredRole).implies(subject);
        if (!permitted && logger.isDebugEnabled()) {
            logger.debug("Message consumer: " + consumer.getID() + " does not have required role `" + requiredRole + "` needed to receive message: " + reference.getMessageID());
        }
        return permitted;
    }

    private Subject getSubject(ConsumerInfo consumer) {
        ActiveMQServer activeMQServer = this.server.get();
        SecurityStore securityStore = activeMQServer.getSecurityStore();
        ServerSession session = activeMQServer.getSessionByID(consumer.getSessionName());
        return securityStore.getSessionSubject(session);
    }
}

