/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.management;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.management.ArtemisMBeanServerBuilder;
import org.apache.activemq.artemis.core.server.management.JMXAccessControlList;
import org.apache.activemq.artemis.logs.AuditLogger;

public class ArtemisMBeanServerGuard
implements InvocationHandler {
    private JMXAccessControlList jmxAccessControlList = JMXAccessControlList.createDefaultList();

    public void init() {
        ArtemisMBeanServerBuilder.setGuard(this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getParameterTypes().length == 0) {
            return null;
        }
        if (!ObjectName.class.isAssignableFrom(method.getParameterTypes()[0])) {
            return null;
        }
        ObjectName objectName = (ObjectName)args[0];
        if ("getAttribute".equals(method.getName())) {
            this.handleGetAttribute((MBeanServer)proxy, objectName, (String)args[1]);
        } else if ("getAttributes".equals(method.getName())) {
            this.handleGetAttributes((MBeanServer)proxy, objectName, (String[])args[1]);
        } else if ("setAttribute".equals(method.getName())) {
            this.handleSetAttribute((MBeanServer)proxy, objectName, (Attribute)args[1]);
        } else if ("setAttributes".equals(method.getName())) {
            this.handleSetAttributes((MBeanServer)proxy, objectName, (AttributeList)args[1]);
        } else if ("invoke".equals(method.getName())) {
            this.handleInvoke(objectName, (String)args[1]);
        }
        return null;
    }

    private void handleGetAttribute(MBeanServer proxy, ObjectName objectName, String attributeName) throws JMException, IOException {
        MBeanInfo info = proxy.getMBeanInfo(objectName);
        String prefix = null;
        for (MBeanAttributeInfo attr : info.getAttributes()) {
            if (!attr.getName().equals(attributeName)) continue;
            prefix = attr.isIs() ? "is" : "get";
        }
        if (prefix != null) {
            try {
                this.handleInvoke(objectName, prefix + attributeName);
            }
            catch (SecurityException e) {
                throw new SecurityException("User not authorized to access attribute: " + attributeName, e);
            }
        }
    }

    private void handleGetAttributes(MBeanServer proxy, ObjectName objectName, String[] attributeNames) throws JMException, IOException {
        for (String attr : attributeNames) {
            this.handleGetAttribute(proxy, objectName, attr);
        }
    }

    private void handleSetAttribute(MBeanServer proxy, ObjectName objectName, Attribute attribute) throws JMException, IOException {
        String dataType = null;
        MBeanInfo info = proxy.getMBeanInfo(objectName);
        for (MBeanAttributeInfo attr : info.getAttributes()) {
            if (!attr.getName().equals(attribute.getName())) continue;
            dataType = attr.getType();
            break;
        }
        if (dataType == null) {
            throw new IllegalStateException("Attribute data type can not be found");
        }
        this.handleInvoke(objectName, "set" + attribute.getName());
    }

    private void handleSetAttributes(MBeanServer proxy, ObjectName objectName, AttributeList attributes) throws JMException, IOException {
        for (Attribute attr : attributes.asList()) {
            this.handleSetAttribute(proxy, objectName, attr);
        }
    }

    private boolean canBypassRBAC(ObjectName objectName) {
        return this.jmxAccessControlList.isInAllowList(objectName);
    }

    public boolean canInvoke(String object, String operationName) {
        ObjectName objectName = null;
        try {
            objectName = ObjectName.getInstance(object);
        }
        catch (MalformedObjectNameException e) {
            ActiveMQServerLogger.LOGGER.debug("can't check invoke rights as object name invalid: " + object);
            return false;
        }
        if (this.canBypassRBAC(objectName)) {
            return true;
        }
        List<String> requiredRoles = this.getRequiredRoles(objectName, operationName);
        for (String role : requiredRoles) {
            if (!ArtemisMBeanServerGuard.currentUserHasRole(role)) continue;
            return true;
        }
        ActiveMQServerLogger.LOGGER.debug(object + " " + operationName + " " + false);
        return false;
    }

    void handleInvoke(ObjectName objectName, String operationName) throws IOException {
        if (this.canBypassRBAC(objectName)) {
            return;
        }
        List<String> requiredRoles = this.getRequiredRoles(objectName, operationName);
        for (String role : requiredRoles) {
            if (!ArtemisMBeanServerGuard.currentUserHasRole(role)) continue;
            return;
        }
        if (AuditLogger.isResourceLoggingEnabled()) {
            AuditLogger.objectInvokedFailure(objectName, operationName);
        }
        throw new SecurityException("User not authorized to access operation: " + operationName);
    }

    List<String> getRequiredRoles(ObjectName objectName, String methodName) {
        return this.jmxAccessControlList.getRolesForObject(objectName, methodName);
    }

    public void setJMXAccessControlList(JMXAccessControlList JMXAccessControlList2) {
        this.jmxAccessControlList = JMXAccessControlList2;
    }

    public static boolean currentUserHasRole(String requestedRole) {
        String role;
        String clazz;
        int index = requestedRole.indexOf(58);
        if (index > 0) {
            clazz = requestedRole.substring(0, index);
            role = requestedRole.substring(index + 1);
        } else {
            clazz = "org.apache.activemq.artemis.spi.core.security.jaas.RolePrincipal";
            role = requestedRole;
        }
        AccessControlContext acc = AccessController.getContext();
        if (acc == null) {
            return false;
        }
        Subject subject = Subject.getSubject(acc);
        if (subject == null) {
            return false;
        }
        for (Principal p : subject.getPrincipals()) {
            if (!clazz.equals(p.getClass().getName()) || !role.equals(p.getName())) continue;
            return true;
        }
        return false;
    }
}

