/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal.codec;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.journal.EncodingSupport;

public class DeliveryCountUpdateEncoding
implements EncodingSupport {
    public long queueID;
    public int count;

    public DeliveryCountUpdateEncoding() {
    }

    public DeliveryCountUpdateEncoding(long queueID, int count) {
        this.queueID = queueID;
        this.count = count;
    }

    @Override
    public void decode(ActiveMQBuffer buffer) {
        this.queueID = buffer.readLong();
        this.count = buffer.readInt();
    }

    @Override
    public void encode(ActiveMQBuffer buffer) {
        buffer.writeLong(this.queueID);
        buffer.writeInt(this.count);
    }

    @Override
    public int getEncodeSize() {
        return 12;
    }

    public String toString() {
        return "DeliveryCountUpdateEncoding [queueID=" + this.queueID + ", count=" + this.count + "]";
    }
}

