/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.federation;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.config.TransformerConfiguration;
import org.apache.activemq.artemis.utils.Preconditions;

public class FederationTransformerConfiguration
implements Serializable {
    private String name;
    private TransformerConfiguration transformerConfiguration;

    public FederationTransformerConfiguration() {
    }

    public FederationTransformerConfiguration(String name, TransformerConfiguration transformerConfiguration) {
        this.name = name;
        this.transformerConfiguration = transformerConfiguration;
    }

    public String getName() {
        return this.name;
    }

    public TransformerConfiguration getTransformerConfiguration() {
        return this.transformerConfiguration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FederationTransformerConfiguration)) {
            return false;
        }
        FederationTransformerConfiguration that = (FederationTransformerConfiguration)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.transformerConfiguration, that.transformerConfiguration);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.transformerConfiguration);
    }

    public void encode(ActiveMQBuffer buffer) {
        Preconditions.checkArgument(this.name != null, "name can not be null");
        Preconditions.checkArgument(this.transformerConfiguration != null, "transformerConfiguration can not be null");
        buffer.writeString(this.name);
        buffer.writeString(this.transformerConfiguration.getClassName());
        buffer.writeInt(this.transformerConfiguration.getProperties() == null ? 0 : this.transformerConfiguration.getProperties().size());
        if (this.transformerConfiguration.getProperties() != null) {
            for (Map.Entry<String, String> entry : this.transformerConfiguration.getProperties().entrySet()) {
                buffer.writeString(entry.getKey());
                buffer.writeString(entry.getValue());
            }
        }
    }

    public void decode(ActiveMQBuffer buffer) {
        this.name = buffer.readString();
        this.transformerConfiguration = new TransformerConfiguration(buffer.readString());
        int propertiesSize = buffer.readInt();
        for (int i2 = 0; i2 < propertiesSize; ++i2) {
            this.transformerConfiguration.getProperties().put(buffer.readString(), buffer.readString());
        }
    }
}

