/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.utilities.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public final class ListUtilities {
    private static final Logger LOG = LogManager.getLogger(ListUtilities.class);

    public String encapsulateListElements(List<String> listToEncapsulate) {
        if (listToEncapsulate.isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[\"").append(listToEncapsulate.get(0).replace("\\", "/")).append("\"");
        for (int i2 = 1; i2 < listToEncapsulate.size(); ++i2) {
            stringBuilder.append(",\"").append(listToEncapsulate.get(i2).replace("\\", "/")).append("\"");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public List<String> readStringList() {
        Scanner readerArray = new Scanner(System.in);
        ArrayList<String> result = new ArrayList<String>(100);
        while (true) {
            String stringArray;
            if ((stringArray = readerArray.nextLine()).isEmpty()) {
                readerArray.close();
                return result;
            }
            result.add(stringArray);
        }
    }

    public List<String> cleanList(List<String> listToCleanUp) {
        listToCleanUp.removeIf(entry -> entry.matches("\\s+") || entry.length() == 0);
        return listToCleanUp;
    }

    public void printListToConsoleChunked(List<String> list, int chunkSize, String prefix, boolean printIndexes) {
        StringBuilder text = new StringBuilder();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            int n;
            text.delete(0, text.length());
            int m3 = i2 + chunkSize;
            for (n = i2; n < m3 && n < list.size(); ++n) {
                if (n == i2) {
                    text.append(list.get(n));
                    continue;
                }
                text.append(", ").append(list.get(n));
            }
            if (printIndexes) {
                System.out.println(prefix + "(" + (i2 + 1) + " to " + n + ")  " + text);
            } else {
                System.out.println(prefix + text);
            }
            i2 = n - 1;
        }
    }

    public void printListToLogChunked(List<String> list, int chunkSize, String prefix, boolean printIndexes) {
        StringBuilder text = new StringBuilder();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            int n;
            text.delete(0, text.length());
            int m3 = i2 + chunkSize;
            for (n = i2; n < m3 && n < list.size(); ++n) {
                if (n == i2) {
                    text.append(list.get(n));
                    continue;
                }
                text.append(", ").append(list.get(n));
            }
            if (printIndexes) {
                LOG.info(prefix + "(" + (i2 + 1) + " to " + n + ")  " + text);
            } else {
                LOG.info(prefix + text);
            }
            i2 = n - 1;
        }
    }
}

