/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator.spring.zip;

import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.ConfigurationHandler;
import de.griefed.serverpackcreator.spring.NotificationResponse;
import de.griefed.serverpackcreator.spring.zip.ZipService;
import de.griefed.serverpackcreator.utilities.common.Utilities;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/api/v1/zip"})
public class ZipController {
    private final ZipService ZIPSERVICE;
    private final ConfigurationHandler CONFIGURATIONHANDLER;
    private final NotificationResponse NOTIFICATIONRESPONSE;
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final Utilities UTILITIES;

    @Autowired
    public ZipController(ZipService injectedZipService, ConfigurationHandler injectedConfigurationHandler, NotificationResponse injectedNotificationResponse, ApplicationProperties injectedApplicationProperties, Utilities injectedUtilities) {
        this.ZIPSERVICE = injectedZipService;
        this.CONFIGURATIONHANDLER = injectedConfigurationHandler;
        this.NOTIFICATIONRESPONSE = injectedNotificationResponse;
        this.APPLICATIONPROPERTIES = injectedApplicationProperties;
        this.UTILITIES = injectedUtilities;
    }

    @PostMapping(value={"/upload"})
    public ResponseEntity<String> handleFileUpload(@RequestParam(value="file") MultipartFile file) throws IOException {
        ArrayList<String> encounteredErrors = new ArrayList<String>();
        Path pathToZip = this.ZIPSERVICE.saveUploadedFile(file);
        if (this.CONFIGURATIONHANDLER.checkZipArchive(Paths.get(pathToZip.toString().replace("\\", "/"), new String[0]), encounteredErrors)) {
            FileUtils.deleteQuietly(new File(pathToZip.toString()));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.badRequest().header("Content-Type", "application/json")).body(this.NOTIFICATIONRESPONSE.zipResponse(encounteredErrors, 10000, "error", "negative", file.getOriginalFilename(), false));
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", "application/json")).body(this.NOTIFICATIONRESPONSE.zipResponse("ZIP-file checks passed. You may press Submit. :)", 5000, "info", "positive", pathToZip.toFile().getName(), true));
    }

    @GetMapping(value={"/{zipName}&{clientMods}&{minecraftVersion}&{modLoader}&{modLoaderVersion}"})
    public ResponseEntity<String> requestGenerationFromZip(@PathVariable(value="zipName") String zipName, @PathVariable(value="clientMods") String clientMods, @PathVariable(value="minecraftVersion") String minecraftVersion, @PathVariable(value="modLoader") String modLoader, @PathVariable(value="modLoaderVersion") String modLoaderVersion) {
        if (clientMods.length() == 0) {
            clientMods = this.UTILITIES.StringUtils().buildString(this.APPLICATIONPROPERTIES.getListFallbackMods());
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Type", "application/json")).body(this.ZIPSERVICE.submitGenerationTask(zipName + "&" + clientMods + "&" + minecraftVersion + "&" + modLoader + "&" + modLoaderVersion));
    }
}

