/*
 * Decompiled with CFR 0.152.
 */
package de.griefed.serverpackcreator;

import com.electronwill.nightconfig.toml.TomlParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.griefed.serverpackcreator.ApplicationAddons;
import de.griefed.serverpackcreator.ApplicationProperties;
import de.griefed.serverpackcreator.ConfigurationHandler;
import de.griefed.serverpackcreator.ConfigurationModel;
import de.griefed.serverpackcreator.ServerPackHandler;
import de.griefed.serverpackcreator.i18n.I18n;
import de.griefed.serverpackcreator.i18n.IncorrectLanguageException;
import de.griefed.serverpackcreator.modscanning.AnnotationScanner;
import de.griefed.serverpackcreator.modscanning.FabricScanner;
import de.griefed.serverpackcreator.modscanning.ModScanner;
import de.griefed.serverpackcreator.modscanning.QuiltScanner;
import de.griefed.serverpackcreator.modscanning.TomlScanner;
import de.griefed.serverpackcreator.swing.ServerPackCreatorGui;
import de.griefed.serverpackcreator.swing.ServerPackCreatorSplash;
import de.griefed.serverpackcreator.utilities.ConfigUtilities;
import de.griefed.serverpackcreator.utilities.ConfigurationEditor;
import de.griefed.serverpackcreator.utilities.UpdateChecker;
import de.griefed.serverpackcreator.utilities.common.BooleanUtilities;
import de.griefed.serverpackcreator.utilities.common.FileUtilities;
import de.griefed.serverpackcreator.utilities.common.JarUtilities;
import de.griefed.serverpackcreator.utilities.common.JsonUtilities;
import de.griefed.serverpackcreator.utilities.common.ListUtilities;
import de.griefed.serverpackcreator.utilities.common.StringUtilities;
import de.griefed.serverpackcreator.utilities.common.SystemUtilities;
import de.griefed.serverpackcreator.utilities.common.Utilities;
import de.griefed.serverpackcreator.utilities.common.WebUtilities;
import de.griefed.serverpackcreator.versionmeta.VersionMeta;
import de.griefed.versionchecker.Update;
import java.awt.GraphicsEnvironment;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.InputMismatchException;
import java.util.Optional;
import java.util.Scanner;
import java.util.concurrent.Executors;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.xml.sax.SAXException;

@SpringBootApplication
@EnableScheduling
@PropertySources(value={@PropertySource(value={"classpath:application.properties"}), @PropertySource(value={"classpath:serverpackcreator.properties"}), @PropertySource(value={"file:./serverpackcreator.properties"})})
public class ServerPackCreator {
    private static final Logger LOG = LogManager.getLogger(ServerPackCreator.class);
    private static final String[] SETUP = new String[]{"--setup"};
    private static ServerPackCreator serverPackCreator = null;
    private final String[] ARGS;
    private final CommandlineParser COMMANDLINE_PARSER;
    private final ApplicationProperties APPLICATIONPROPERTIES;
    private final I18n I18N;
    private final File LOG4J2XML = new File("log4j2.xml");
    private final File SERVERPACKCREATOR_PROPERTIES = new File("serverpackcreator.properties");
    private final ObjectMapper OBJECT_MAPPER = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
    private BooleanUtilities booleanUtilities = null;
    private FileUtilities fileUtilities = null;
    private JarUtilities jarUtilities = null;
    private JsonUtilities jsonUtilities = null;
    private ListUtilities listUtilities = null;
    private StringUtilities stringUtilities = null;
    private SystemUtilities systemUtilities = null;
    private WebUtilities webUtilities = null;
    private Utilities utilities = null;
    private VersionMeta versionMeta = null;
    private ConfigUtilities configUtilities = null;
    private ConfigurationHandler configurationHandler = null;
    private ApplicationAddons applicationAddons = null;
    private ServerPackHandler serverPackHandler = null;
    private ServerPackCreatorSplash serverPackCreatorSplash = null;
    private UpdateChecker updateChecker = null;
    private ModScanner modScanner = null;
    private AnnotationScanner annotationScanner = null;
    private FabricScanner fabricScanner = null;
    private QuiltScanner quiltScanner = null;
    private TomlParser tomlParser = null;
    private TomlScanner tomlScanner = null;
    private ConfigurationEditor configurationEditor = null;
    private ServerPackCreatorGui serverPackCreatorGui = null;

    public ServerPackCreator(String[] args) {
        this.ARGS = args;
        this.COMMANDLINE_PARSER = new CommandlineParser(args);
        this.APPLICATIONPROPERTIES = this.COMMANDLINE_PARSER.propertiesFile().isPresent() ? new ApplicationProperties(this.COMMANDLINE_PARSER.propertiesFile().get(), this.getFileUtilities(), this.getSystemUtilities(), this.getListUtilities()) : new ApplicationProperties(this.getFileUtilities(), this.getSystemUtilities(), this.getListUtilities());
        this.I18N = this.COMMANDLINE_PARSER.getLanguageToUse().isPresent() ? new I18n(this.APPLICATIONPROPERTIES, this.COMMANDLINE_PARSER.getLanguageToUse().get()) : new I18n(this.APPLICATIONPROPERTIES);
    }

    public static synchronized ServerPackCreator getInstance() {
        return ServerPackCreator.getInstance(SETUP);
    }

    public static synchronized ServerPackCreator getInstance(String[] args) {
        if (serverPackCreator == null) {
            serverPackCreator = new ServerPackCreator(args);
            try {
                serverPackCreator.run(Mode.SETUP);
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                LOG.error("Something went horribly wrong trying to run the ServerPackCreator setup.", (Throwable)ex);
            }
        }
        return serverPackCreator;
    }

    public static void main(String[] args) throws IOException, ParserConfigurationException, SAXException {
        serverPackCreator = new ServerPackCreator(args);
        serverPackCreator.run();
    }

    public static void web(String[] args) {
        SpringApplication.run(ServerPackCreator.class, args);
    }

    public synchronized String[] getArgs() {
        return this.ARGS;
    }

    public synchronized I18n getI18n() {
        return this.I18N;
    }

    public synchronized ObjectMapper getObjectMapper() {
        return this.OBJECT_MAPPER;
    }

    public synchronized ApplicationProperties getApplicationProperties() {
        return this.APPLICATIONPROPERTIES;
    }

    public synchronized BooleanUtilities getBooleanUtilities() {
        if (this.booleanUtilities == null) {
            this.booleanUtilities = new BooleanUtilities();
        }
        return this.booleanUtilities;
    }

    public synchronized FileUtilities getFileUtilities() {
        if (this.fileUtilities == null) {
            this.fileUtilities = new FileUtilities();
        }
        return this.fileUtilities;
    }

    public synchronized JarUtilities getJarUtilities() {
        if (this.jarUtilities == null) {
            this.jarUtilities = new JarUtilities();
        }
        return this.jarUtilities;
    }

    public synchronized JsonUtilities getJsonUtilities() {
        if (this.jsonUtilities == null) {
            this.jsonUtilities = new JsonUtilities();
        }
        return this.jsonUtilities;
    }

    public synchronized ListUtilities getListUtilities() {
        if (this.listUtilities == null) {
            this.listUtilities = new ListUtilities();
        }
        return this.listUtilities;
    }

    public synchronized StringUtilities getStringUtilities() {
        if (this.stringUtilities == null) {
            this.stringUtilities = new StringUtilities();
        }
        return this.stringUtilities;
    }

    public synchronized SystemUtilities getSystemUtilities() {
        if (this.systemUtilities == null) {
            this.systemUtilities = new SystemUtilities();
        }
        return this.systemUtilities;
    }

    public synchronized WebUtilities getWebUtilities() {
        if (this.webUtilities == null) {
            this.webUtilities = new WebUtilities(this.getApplicationProperties());
        }
        return this.webUtilities;
    }

    public synchronized Utilities getUtilities() {
        if (this.utilities == null) {
            this.utilities = new Utilities(this.getBooleanUtilities(), this.getFileUtilities(), this.getJarUtilities(), this.getListUtilities(), this.getStringUtilities(), this.getSystemUtilities(), this.getWebUtilities(), this.getJsonUtilities());
        }
        return this.utilities;
    }

    public synchronized VersionMeta getVersionMeta() throws IOException, ParserConfigurationException, SAXException {
        if (this.versionMeta == null) {
            this.versionMeta = new VersionMeta(this.APPLICATIONPROPERTIES.MINECRAFT_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.FORGE_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.FABRIC_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.FABRIC_INSTALLER_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.FABRIC_INTERMEDIARIES_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.QUILT_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.QUILT_INSTALLER_VERSION_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.LEGACY_FABRIC_GAME_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.LEGACY_FABRIC_LOADER_MANIFEST_LOCATION(), this.APPLICATIONPROPERTIES.LEGACY_FABRIC_INSTALLER_MANIFEST_LOCATION(), this.OBJECT_MAPPER);
        }
        return this.versionMeta;
    }

    public synchronized ConfigUtilities getConfigUtilities() {
        if (this.configUtilities == null) {
            this.configUtilities = new ConfigUtilities(this.getUtilities(), this.APPLICATIONPROPERTIES, this.OBJECT_MAPPER);
        }
        return this.configUtilities;
    }

    public synchronized ConfigurationHandler getConfigurationHandler() throws IOException, ParserConfigurationException, SAXException {
        if (this.configurationHandler == null) {
            this.configurationHandler = new ConfigurationHandler(this.I18N, this.getVersionMeta(), this.APPLICATIONPROPERTIES, this.getUtilities(), this.getConfigUtilities(), this.getApplicationAddons(), this.getTomlParser());
        }
        return this.configurationHandler;
    }

    public synchronized ApplicationAddons getApplicationAddons() throws IOException, ParserConfigurationException, SAXException {
        if (this.applicationAddons == null) {
            this.applicationAddons = new ApplicationAddons(this.getTomlParser(), this.getApplicationProperties(), this.getVersionMeta(), this.getUtilities());
        }
        return this.applicationAddons;
    }

    public synchronized ServerPackHandler getServerPackHandler() throws IOException, ParserConfigurationException, SAXException {
        if (this.serverPackHandler == null) {
            this.serverPackHandler = new ServerPackHandler(this.APPLICATIONPROPERTIES, this.getVersionMeta(), this.getUtilities(), this.getApplicationAddons(), this.getModScanner());
        }
        return this.serverPackHandler;
    }

    public synchronized ServerPackCreatorSplash getServerPackCreatorSplash() {
        if (this.serverPackCreatorSplash == null) {
            this.serverPackCreatorSplash = new ServerPackCreatorSplash(this.APPLICATIONPROPERTIES.SERVERPACKCREATOR_VERSION());
        }
        return this.serverPackCreatorSplash;
    }

    public synchronized UpdateChecker getUpdateChecker() {
        if (this.updateChecker == null) {
            this.updateChecker = new UpdateChecker();
        }
        return this.updateChecker;
    }

    public synchronized ModScanner getModScanner() {
        if (this.modScanner == null) {
            this.modScanner = new ModScanner(this.getAnnotationScanner(), this.getFabricScanner(), this.getQuiltScanner(), this.getTomlScanner());
        }
        return this.modScanner;
    }

    public synchronized AnnotationScanner getAnnotationScanner() {
        if (this.annotationScanner == null) {
            this.annotationScanner = new AnnotationScanner(this.OBJECT_MAPPER, this.getUtilities());
        }
        return this.annotationScanner;
    }

    public synchronized FabricScanner getFabricScanner() {
        if (this.fabricScanner == null) {
            this.fabricScanner = new FabricScanner(this.OBJECT_MAPPER, this.getUtilities());
        }
        return this.fabricScanner;
    }

    public synchronized QuiltScanner getQuiltScanner() {
        if (this.quiltScanner == null) {
            this.quiltScanner = new QuiltScanner(this.OBJECT_MAPPER, this.getUtilities());
        }
        return this.quiltScanner;
    }

    public synchronized TomlParser getTomlParser() {
        if (this.tomlParser == null) {
            this.tomlParser = new TomlParser();
        }
        return this.tomlParser;
    }

    public synchronized TomlScanner getTomlScanner() {
        if (this.tomlScanner == null) {
            this.tomlScanner = new TomlScanner(this.getTomlParser());
        }
        return this.tomlScanner;
    }

    public synchronized ConfigurationEditor getConfigurationEditor() throws IOException, ParserConfigurationException, SAXException {
        if (this.configurationEditor == null) {
            this.configurationEditor = new ConfigurationEditor(this.getConfigurationHandler(), this.APPLICATIONPROPERTIES, this.getUtilities(), this.getVersionMeta(), this.getConfigUtilities());
        }
        return this.configurationEditor;
    }

    public synchronized ServerPackCreatorGui getServerPackCreatorGui() throws IOException, ParserConfigurationException, SAXException {
        if (this.serverPackCreatorGui == null) {
            this.serverPackCreatorGui = new ServerPackCreatorGui(this.I18N, this.getConfigurationHandler(), this.getServerPackHandler(), this.APPLICATIONPROPERTIES, this.getVersionMeta(), this.getUtilities(), this.getUpdateChecker(), this.getServerPackCreatorSplash(), this.getApplicationAddons());
        }
        return this.serverPackCreatorGui;
    }

    public synchronized void run() throws IOException, ParserConfigurationException, SAXException {
        this.run(this.COMMANDLINE_PARSER.getModeToRunIn());
    }

    public synchronized void run(Mode modeToRunIn) throws IOException, ParserConfigurationException, SAXException {
        switch (modeToRunIn) {
            case HELP: {
                this.printHelp();
                this.continuedRunOptions();
                break;
            }
            case UPDATE: {
                this.updateCheck();
                this.continuedRunOptions();
                break;
            }
            case WEB: {
                this.stageOne();
                this.stageFour();
                this.checkDatabase();
                ServerPackCreator.web(this.ARGS);
                break;
            }
            case CGEN: {
                this.stageOne();
                this.stageTwo();
                this.runConfigurationEditor();
                this.continuedRunOptions();
                break;
            }
            case CLI: {
                this.stageOne();
                this.stageTwo();
                this.stageThree();
                this.runHeadless();
                break;
            }
            case GUI: {
                this.showSplashScreen();
                this.stageOne();
                this.getServerPackCreatorSplash().update(20);
                this.stageTwo();
                this.getServerPackCreatorSplash().update(40);
                this.stageThree();
                this.getServerPackCreatorSplash().update(60);
                Executors.newSingleThreadExecutor().execute(this::stageFour);
                this.getServerPackCreatorSplash().update(80);
                this.runGui();
                break;
            }
            case SETUP: {
                this.stageOne();
                this.stageTwo();
                this.stageThree();
                LOG.info("Setup completed.");
            }
            default: {
                LOG.debug("Exiting...");
            }
        }
    }

    private void stageOne() {
        Object langSource;
        System.setProperty("log4j2.formatMsgNoLookups", "true");
        System.setProperty("file.encoding", StandardCharsets.UTF_8.name());
        HashMap<String, String> systemInformation = this.getUtilities().JarUtils().systemInformation(this.getUtilities().JarUtils().getApplicationHomeForClass(ServerPackCreator.class));
        LOG.debug("System information jarPath: " + systemInformation.get("jarPath"));
        LOG.debug("System information jarName: " + systemInformation.get("jarName"));
        if (!this.getUtilities().FileUtils().checkPermissions(new File(systemInformation.get("jarPath")).getParentFile())) {
            LOG.error("One or more file or directory has no read- or write-permission. This may lead to corrupted server packs! Check the permissions of the ServerPackCreator base directory!");
        }
        this.getUtilities().JarUtils().copyFileFromJar(this.LOG4J2XML.getName(), ServerPackCreator.class);
        if (!this.SERVERPACKCREATOR_PROPERTIES.exists()) {
            this.getUtilities().JarUtils().copyFileFromJar(this.SERVERPACKCREATOR_PROPERTIES.getName(), ServerPackCreator.class);
        }
        try {
            String prefix = "BOOT-INF/classes";
            langSource = "/de/griefed/resources/lang";
            if (systemInformation.get("jarName").endsWith(".exe")) {
                prefix = "";
                langSource = "de/griefed/resources/lang";
            }
            this.getUtilities().JarUtils().copyFolderFromJar(ServerPackCreator.class, (String)langSource, "lang", prefix, ".properties");
        }
        catch (IOException ex) {
            LOG.error("Error copying \"/de/griefed/resources/lang\" from the JAR-file.");
        }
        this.getUtilities().FileUtils().createDirectories(Paths.get("./server_files", new String[0]));
        this.getUtilities().FileUtils().createDirectories(Paths.get("./work", new String[0]));
        this.getUtilities().FileUtils().createDirectories(Paths.get("./work/temp", new String[0]));
        this.getUtilities().FileUtils().createDirectories(Paths.get("./work/modpacks", new String[0]));
        this.getUtilities().FileUtils().createDirectories(Paths.get("./server-packs", new String[0]));
        this.getUtilities().FileUtils().createDirectories(Paths.get(System.getProperty("pf4j.pluginsDir", "./plugins"), new String[0]));
        this.getUtilities().FileUtils().createDirectories(Paths.get("./plugins/config", new String[0]));
        if (!new File(System.getProperty("pf4j.pluginsDir", "./plugins") + "/disabled.txt").exists()) {
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(Paths.get(System.getProperty("pf4j.pluginsDir", "./plugins"), new String[0]) + "/disabled.txt"));
                langSource = null;
                try {
                    writer.write("########################################\n");
                    writer.write("#...Load all plugins except these......#\n");
                    writer.write("#...Add one plugin-id per line.........#\n");
                    writer.write("########################################\n");
                    writer.write("#example-plugin\n");
                }
                catch (Throwable throwable) {
                    langSource = throwable;
                    throw throwable;
                }
                finally {
                    if (writer != null) {
                        if (langSource != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)langSource).addSuppressed(throwable);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            }
            catch (IOException ex) {
                LOG.error("Error generating disable.txt in the plugins directory.", (Throwable)ex);
            }
        }
        boolean config = this.checkForConfig();
        boolean serverProperties = this.checkServerFilesFile(this.APPLICATIONPROPERTIES.DEFAULT_SERVER_PROPERTIES());
        boolean serverIcon = this.checkServerFilesFile(this.APPLICATIONPROPERTIES.DEFAULT_SERVER_ICON());
        this.overwriteServerFilesFile(this.APPLICATIONPROPERTIES.DEFAULT_SHELL_TEMPLATE());
        this.overwriteServerFilesFile(this.APPLICATIONPROPERTIES.DEFAULT_POWERSHELL_TEMPLATE());
        if (config || serverProperties || serverIcon) {
            LOG.warn("#################################################################");
            LOG.warn("#.............ONE OR MORE DEFAULT FILE(S) GENERATED.............#");
            LOG.warn("#..CHECK THE LOGS TO FIND OUT WHICH FILE(S) WAS/WERE GENERATED..#");
            LOG.warn("#...............CUSTOMIZE THEM BEFORE CONTINUING!...............#");
            LOG.warn("#################################################################");
        } else {
            LOG.info("Setup completed.");
        }
        LOG.debug("Gathering system information to include in log to make debugging easier.");
        this.APPLICATIONPROPERTIES.setProperty("homeDir", systemInformation.get("jarPath").substring(0, systemInformation.get("jarPath").replace("\\", "/").lastIndexOf("/")).replace("\\", "/"));
        if (this.APPLICATIONPROPERTIES.SERVERPACKCREATOR_VERSION().contains("dev") || this.APPLICATIONPROPERTIES.SERVERPACKCREATOR_VERSION().contains("alpha") || this.APPLICATIONPROPERTIES.SERVERPACKCREATOR_VERSION().contains("beta")) {
            LOG.debug("Warning user about possible data loss.");
            LOG.warn("################################################################");
            LOG.warn("#.............ALPHA | BETA | DEV VERSION DETECTED..............#");
            LOG.warn("#.............THESE VERSIONS ARE WORK IN PROGRESS!.............#");
            LOG.warn("#..USE AT YOUR OWN RISK! BE AWARE THAT DATA LOSS IS POSSIBLE!..#");
            LOG.warn("#........I WILL NOT BE HELD RESPONSIBLE FOR DATA LOSS!.........#");
            LOG.warn("#....................YOU HAVE BEEN WARNED!.....................#");
            LOG.warn("################################################################");
        }
        LOG.info("SYSTEM INFORMATION:");
        LOG.info("ServerPackCreator version: " + this.APPLICATIONPROPERTIES.SERVERPACKCREATOR_VERSION());
        LOG.info("JAR Path:        " + systemInformation.get("jarPath"));
        LOG.info("JAR Name:        " + systemInformation.get("jarName"));
        LOG.info("Java version:    " + systemInformation.get("javaVersion"));
        LOG.info("OS architecture: " + systemInformation.get("osArch"));
        LOG.info("OS name:         " + systemInformation.get("osName"));
        LOG.info("OS version:      " + systemInformation.get("osVersion"));
        LOG.info("Include this information when reporting an issue on GitHub.");
    }

    private void stageTwo() throws IOException, ParserConfigurationException, SAXException {
        this.getVersionMeta();
        this.getConfigUtilities();
        this.getConfigurationHandler();
    }

    private void stageThree() throws IOException, ParserConfigurationException, SAXException {
        this.getApplicationAddons();
        this.getAnnotationScanner();
        this.getFabricScanner();
        this.getQuiltScanner();
        this.getTomlParser();
        this.getTomlScanner();
        this.getModScanner();
        this.getServerPackHandler();
        this.getUpdateChecker();
    }

    private void stageFour() {
        LOG.debug("Setting up FileWatcher...");
        FileAlterationObserver fileAlterationObserver = new FileAlterationObserver(new File("."));
        FileAlterationListener fileAlterationListener = new FileAlterationListener(){

            @Override
            public void onStart(FileAlterationObserver observer) {
            }

            @Override
            public void onDirectoryCreate(File directory) {
            }

            @Override
            public void onDirectoryChange(File directory) {
            }

            @Override
            public void onDirectoryDelete(File directory) {
            }

            @Override
            public void onFileCreate(File file) {
            }

            @Override
            public void onFileChange(File file) {
            }

            @Override
            public void onFileDelete(File file) {
                if (!file.toString().replace("\\", "/").startsWith("./server-packs") && !file.toString().replace("\\", "/").startsWith("./work/modpacks")) {
                    if (this.check(file, ServerPackCreator.this.APPLICATIONPROPERTIES.SERVERPACKCREATOR_PROPERTIES())) {
                        this.createFile(ServerPackCreator.this.APPLICATIONPROPERTIES.SERVERPACKCREATOR_PROPERTIES());
                        ServerPackCreator.this.APPLICATIONPROPERTIES.loadProperties();
                        LOG.info("Restored serverpackcreator.properties and loaded defaults.");
                    } else if (this.check(file, ServerPackCreator.this.APPLICATIONPROPERTIES.DEFAULT_SERVER_PROPERTIES())) {
                        ServerPackCreator.this.checkServerFilesFile(ServerPackCreator.this.APPLICATIONPROPERTIES.DEFAULT_SERVER_PROPERTIES());
                        LOG.info("Restored default server.properties.");
                    } else if (this.check(file, ServerPackCreator.this.APPLICATIONPROPERTIES.DEFAULT_SERVER_ICON())) {
                        ServerPackCreator.this.checkServerFilesFile(ServerPackCreator.this.APPLICATIONPROPERTIES.DEFAULT_SERVER_ICON());
                        LOG.info("Restored default server-icon.png.");
                    } else if (this.check(file, ServerPackCreator.this.APPLICATIONPROPERTIES.DEFAULT_SHELL_TEMPLATE())) {
                        ServerPackCreator.this.checkServerFilesFile(ServerPackCreator.this.APPLICATIONPROPERTIES.DEFAULT_SHELL_TEMPLATE());
                        LOG.info("Restored default_template.sh.");
                    } else if (this.check(file, ServerPackCreator.this.APPLICATIONPROPERTIES.DEFAULT_POWERSHELL_TEMPLATE())) {
                        ServerPackCreator.this.checkServerFilesFile(ServerPackCreator.this.APPLICATIONPROPERTIES.DEFAULT_POWERSHELL_TEMPLATE());
                        LOG.info("Restored default_template.ps1.");
                    }
                }
            }

            @Override
            public void onStop(FileAlterationObserver observer) {
            }

            private boolean check(File watched, File toCreate) {
                return watched.toString().replace("\\", "/").substring(watched.toString().replace("\\", "/").lastIndexOf("/") + 1).equals(toCreate.toString());
            }

            private void createFile(File toCreate) {
                ServerPackCreator.this.getUtilities().JarUtils().copyFileFromJar(toCreate.getName(), ServerPackCreator.class);
            }
        };
        fileAlterationObserver.addListener(fileAlterationListener);
        FileAlterationMonitor fileAlterationMonitor = new FileAlterationMonitor(1000L);
        fileAlterationMonitor.addObserver(fileAlterationObserver);
        try {
            fileAlterationMonitor.start();
        }
        catch (Exception ex) {
            LOG.error("Error starting the FileWatcher Monitor.", (Throwable)ex);
        }
        LOG.debug("File-watcher started...");
    }

    private void showSplashScreen() {
        this.getServerPackCreatorSplash();
    }

    private void runGui() throws IOException, ParserConfigurationException, SAXException {
        this.getServerPackCreatorGui().mainGUI();
    }

    private void continuedRunOptions() throws IOException, ParserConfigurationException, SAXException {
        int selection;
        this.printMenu();
        Scanner scanner = new Scanner(System.in);
        block13: do {
            try {
                selection = scanner.nextInt();
                if (selection == 7 && GraphicsEnvironment.isHeadless()) {
                    System.out.println("You environment does not support a GUI.");
                    selection = 100;
                }
                switch (selection) {
                    case 1: {
                        this.printHelp();
                        this.printMenu();
                        selection = 100;
                        break;
                    }
                    case 2: {
                        this.updateCheck();
                        this.printMenu();
                        selection = 100;
                        break;
                    }
                    case 3: {
                        this.changeLocale();
                        this.printMenu();
                        selection = 100;
                        break;
                    }
                    case 4: {
                        this.runConfigurationEditor();
                        this.printMenu();
                        selection = 100;
                        break;
                    }
                    default: {
                        if (selection <= 7) continue block13;
                        System.out.println("Not a valid number. Please pick a number from 0 to 7.");
                        this.printMenu();
                        break;
                    }
                }
            }
            catch (InputMismatchException | ParserConfigurationException | SAXException ex) {
                System.out.println("Not a valid number. Please pick a number from 0 to 7.");
                selection = 100;
            }
        } while (selection > 7);
        scanner.close();
        switch (selection) {
            case 5: {
                this.run(Mode.CLI);
                break;
            }
            case 6: {
                this.run(Mode.WEB);
                break;
            }
            case 7: {
                this.run(Mode.GUI);
                break;
            }
            default: {
                System.out.println("Exiting...");
            }
        }
    }

    private void changeLocale() {
        String userLocale;
        System.out.println("What locale would you like to use?");
        System.out.println("(Locale format is en_us, de_de, uk_ua etc.)");
        System.out.println("Note: Changing the locale only affects the GUI. CLI always uses en_US.");
        Scanner scanner = new Scanner(System.in);
        String regex = "^[a-zA-Z]+_[a-zA-Z]+$";
        do {
            if (!(userLocale = scanner.next()).matches(regex)) {
                System.out.println("Incorrect format. ServerPackCreator currently only supports locales in the format of en_us (Language, Country).");
                continue;
            }
            try {
                this.I18N.initialize(userLocale);
            }
            catch (IncorrectLanguageException e) {
                System.out.println("Incorrect format. ServerPackCreator currently only supports locales in the format of en_us (Language, Country).");
                userLocale = "";
            }
        } while (!userLocale.matches(regex));
        scanner.close();
        System.out.println("Using language: " + this.I18N.getMessage("localeName"));
    }

    private void printMenu() {
        System.out.println();
        System.out.println("What would you like to do next?");
        System.out.println("(1) : Print help");
        System.out.println("(2) : Check for updates");
        System.out.println("(3) : Change locale");
        System.out.println("(4) : Generate a new configuration");
        System.out.println("(5) : Run ServerPackCreator in CLI-mode");
        System.out.println("(6) : Run ServerPackCreator as a webservice");
        System.out.println("(7) : Run ServerPackCreator with a GUI");
        System.out.println("(0) : Exit");
        System.out.println("-------------------------------------------");
        System.out.print("Enter the number of your selection: ");
    }

    private void runHeadless() throws IOException, ParserConfigurationException, SAXException {
        if (!this.APPLICATIONPROPERTIES.DEFAULT_CONFIG().exists()) {
            LOG.warn("No serverpackcreator.conf found...");
            LOG.info("If you want to run ServerPackCreator in CLI-mode, a serverpackcreator.conf is required.");
            LOG.info("Either copy an existing config, or run ServerPackCreator with the '-cgen'-argument to generate one via commandline.");
            System.exit(1);
        } else {
            ConfigurationModel configurationModel = new ConfigurationModel();
            if (this.getConfigurationHandler().checkConfiguration(this.APPLICATIONPROPERTIES.DEFAULT_CONFIG(), configurationModel, false)) {
                System.exit(1);
            }
            if (!this.getServerPackHandler().run(configurationModel)) {
                System.exit(1);
            }
        }
    }

    private void runConfigurationEditor() throws IOException, ParserConfigurationException, SAXException {
        this.getConfigurationEditor().continuedRunOptions();
    }

    public boolean checkForConfig() {
        if (!this.APPLICATIONPROPERTIES.DEFAULT_CONFIG().exists() && this.COMMANDLINE_PARSER.getModeToRunIn() != Mode.CLI && this.COMMANDLINE_PARSER.getModeToRunIn() != Mode.CGEN) {
            return this.getUtilities().JarUtils().copyFileFromJar("de/griefed/resources/" + this.APPLICATIONPROPERTIES.DEFAULT_CONFIG().getName(), this.APPLICATIONPROPERTIES.DEFAULT_CONFIG(), ServerPackCreator.class);
        }
        return false;
    }

    public boolean checkServerFilesFile(File fileToCheckFor) {
        return this.getUtilities().JarUtils().copyFileFromJar("de/griefed/resources/server_files/" + fileToCheckFor, new File("./server_files/" + fileToCheckFor), ServerPackCreator.class);
    }

    public void overwriteServerFilesFile(File fileToOverwrite) {
        FileUtils.deleteQuietly(new File(String.format("server_files/%s", fileToOverwrite.getName())));
        this.checkServerFilesFile(fileToOverwrite);
    }

    public void checkDatabase() {
        Connection connection = null;
        try {
            connection = DriverManager.getConnection("jdbc:sqlite:" + this.APPLICATIONPROPERTIES.SERVERPACKCREATOR_DATABASE());
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            LOG.debug("Database driver name: " + databaseMetaData.getDriverName());
            LOG.debug("Database driver version: " + databaseMetaData.getDriverVersion());
            LOG.debug("Database product name: " + databaseMetaData.getDatabaseProductName());
            LOG.debug("Database product version: " + databaseMetaData.getDatabaseProductVersion());
        }
        catch (SQLException ex) {
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {
                    LOG.error("Couldn't close SQL connection", (Throwable)ex);
                }
            }
        }
    }

    public void updateCheck() {
        this.getUpdateChecker().refresh();
        Optional<Update> update = this.getUpdateChecker().checkForUpdate(this.APPLICATIONPROPERTIES.SERVERPACKCREATOR_VERSION(), this.APPLICATIONPROPERTIES.checkForAvailablePreReleases());
        System.out.println();
        if (update.isPresent()) {
            System.out.println("Update available!");
            System.out.println("    " + update.get().version());
            System.out.println("    " + update.get().url());
        } else {
            System.out.println("No updates available.");
        }
    }

    private void printHelp() {
        System.out.println("# How to use ServerPackCreator:\n#   java -jar ServerPackCreator.jar\n#     Simply running the JAR without extra arguments runs ServerPackCreator in GUI mode unless\n#     you are running in a headless environment. In the case of a headless environment, the CLI\n#     mode will automatically be used.\n#");
        System.out.println("#   Extra arguments to use ServerPackCreator with:\n#");
        System.out.println("#     -lang : Allows you to use one of the available languages for ServerPackCreator. I can not\n#             guarantee that each of the following available languages is 100% translated.\n#             You best choice is en_us, or not specifying any as that is the default, because\n#             I write ServerPackCreator with english in mind. Available usages:\n#             -lang en_us\n#             -lang uk_ua\n#             -lang de_de\n#");
        System.out.println("#     -cgen : Only available for the commandline interface. This will start the generation of\n#             a new configuration file. You will be asked to enter information about your modpack\n#             step-by-step. Each setting you enter will be checked for errors before it is saved.\n#             If everything you enter is valid and without errors, it will be written to a new\n#             serverpackcreator.conf and ServerPackCreator will immediately start a run with said\n#             configuration file, generating a server pack for you.\n#");
        System.out.println("#   -update : Check whether a new version of ServerPackCreator is available for download.\n#             If an update is available, the version and link to the release of said update are\n#             written to the console so you can from work with it from there.\n#             Note: Automatic updates are currently not planned nor supported, and neither are\n#             downloads of any available updates to your system. You need to update manually.\n#");
        System.out.println("#     -cgen : Only available for the commandline interface. This will start the generation of\n#             a new configuration file. You will be asked to enter information about your modpack\n#             step-by-step. Each setting you enter will be checked for errors before it is saved.\n#             If everything you enter is valid and without errors, it will be written to a new\n#             serverpackcreator.conf and ServerPackCreator will immediately start a run with said\n#             configuration file, generating a server pack for you.\n#");
        System.out.println("#     -cli  : Run ServerPackCreator in Command-line interface mode. Checks the serverpackcreator.conf\n#             for errors and if none are found, starts the generation of a server pack with the configuration\n#             provided by your serverpackcreator.conf.\n#");
        System.out.println("#     -web  : Run ServerPackCreator as a webservice available at http://localhost:8080. The webservice\n#             provides the same functionality as running ServerPackCreator in GUI mode (so no Commandline\n#             arguments and a non-headless environment) as well as a REST API which can be used in different ways.\n#             For more information about the REST API, please see the Java documentation:\n#              - GitHub Pages: https://griefed.github.io/ServerPackCreator/\n#              - GitLab Pages: https://griefed.pages.griefed.de/ServerPackCreator/\n#");
        System.out.println("#      -gui : Run ServerPackCreator using the graphical user interface. If your environment supports\n#             graphics, i.e. is not headless, then this is the default mode in which ServerPackCreator\n#             started as when no arguments are used.\n#");
        System.out.println("#   --setup : Set up and prepare the environment for subsequent runs of ServerPackCreator.\n#             This will create/copy all files needed for ServerPackCreator to function\n#             properly from inside its JAR-file and setup everything else, too.\n#");
        System.out.println("# Support:\n#");
        System.out.println("#   Issues:  Encountered a bug, or want some part of the documentation to be improved on? Got a suggestion?\n#            Open an issue on GitHub at: https://github.com/Griefed/ServerPackCreator/issues\n#");
        System.out.println("#   Discord: If you would like to chat with me, ask me questions, or see when there's something new\n#            regarding ServerPackCreator coming up, you can join my Discord server to stay up-to-date.\n#             - Discord link: https://discord.griefed.de\n#");
        System.out.println("# Help/Wiki: If you want additional help on how to use ServerPackCreator, take a look at my wiki articles\n#            regarding ServerPackCreator and some of the more advanced things it can do.\n#             - Help:  https://wiki.griefed.de/en/Documentation/ServerPackCreator/ServerPackCreator-Help\n#             - HowTo: https://wiki.griefed.de/en/Documentation/ServerPackCreator/ServerPackCreator-HowTo\n#");
        System.out.println("# Buy Me A Coffee:\n#   You like ServerPackCreator and would like to support me? By all means, every bit is very much\n#   appreciated and helps me pay for servers and food. Food is most important. And coffee. Food and Coffee.\n#   Those two get converted into code. Thank you very much!\n#     - Github Sponsors: https://github.com/sponsors/Griefed");
    }

    public class CommandlineParser {
        private final Mode MODE;
        private final String LANG;
        private File propertiesFile = null;

        public CommandlineParser(String[] args) {
            ArrayList<String> argsList = new ArrayList<String>(Arrays.asList(args));
            this.LANG = argsList.contains(Mode.LANG.argument()) && argsList.size() >= argsList.indexOf(Mode.LANG.argument()) + 1 ? (String)argsList.get(argsList.indexOf(Mode.LANG.argument()) + 1) : "en_us";
            if (argsList.contains(Mode.HELP.argument())) {
                this.MODE = Mode.HELP;
                return;
            }
            if (argsList.contains(Mode.UPDATE.argument())) {
                this.MODE = Mode.UPDATE;
                return;
            }
            if (argsList.contains(Mode.CGEN.argument())) {
                this.MODE = Mode.CGEN;
                return;
            }
            if (argsList.contains(Mode.CLI.argument())) {
                this.MODE = Mode.CLI;
                return;
            }
            if (GraphicsEnvironment.isHeadless()) {
                this.MODE = Mode.CLI;
                return;
            }
            if (argsList.contains(Mode.WEB.argument())) {
                this.MODE = Mode.WEB;
                return;
            }
            if (argsList.contains(Mode.GUI.argument())) {
                this.MODE = Mode.GUI;
                return;
            }
            if (argsList.contains(Mode.SETUP.argument())) {
                if (argsList.size() > 1 && new File((String)argsList.get(argsList.indexOf(Mode.SETUP.argument()) + 1)).isFile()) {
                    this.propertiesFile = new File((String)argsList.get(argsList.indexOf(Mode.SETUP.argument()) + 1));
                }
                this.MODE = Mode.SETUP;
                return;
            }
            if (!GraphicsEnvironment.isHeadless()) {
                this.MODE = Mode.GUI;
                return;
            }
            this.MODE = Mode.EXIT;
        }

        protected Mode getModeToRunIn() {
            return this.MODE;
        }

        protected Optional<String> getLanguageToUse() {
            return Optional.ofNullable(this.LANG);
        }

        public Optional<File> propertiesFile() {
            return Optional.ofNullable(this.propertiesFile);
        }
    }

    public static enum Mode {
        HELP("-help"),
        UPDATE("-update"),
        CGEN("-cgen"),
        CLI("-cli"),
        WEB("-web"),
        GUI("-gui"),
        SETUP("--setup"),
        EXIT("exit"),
        LANG("-lang");

        private final String ARGUMENT;

        private Mode(String cliArg) {
            this.ARGUMENT = cliArg;
        }

        public String argument() {
            return this.ARGUMENT;
        }
    }
}

