/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.springframework.beans.BeanUtils;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.util.KotlinReflectionUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public final class ReflectionUtils {
    private ReflectionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static <T> T createInstanceIfPresent(String classname, T defaultInstance) {
        try {
            Class<?> type = ClassUtils.forName(classname, ClassUtils.getDefaultClassLoader());
            return (T)BeanUtils.instantiateClass(type);
        }
        catch (Exception e) {
            return defaultInstance;
        }
    }

    public static boolean isVoid(Class<?> type) {
        if (type == Void.class || Void.TYPE == type) {
            return true;
        }
        return type.getName().equals("kotlin.Unit");
    }

    @Nullable
    public static Field findField(Class<?> type, final ReflectionUtils.FieldFilter filter2) {
        return ReflectionUtils.findField(type, new DescribedFieldFilter(){

            @Override
            public boolean matches(Field field) {
                return filter2.matches(field);
            }

            @Override
            public String getDescription() {
                return String.format("FieldFilter %s", filter2.toString());
            }
        }, false);
    }

    @Nullable
    public static Field findField(Class<?> type, DescribedFieldFilter filter2) {
        return ReflectionUtils.findField(type, filter2, true);
    }

    @Nullable
    public static Field findField(Class<?> type, DescribedFieldFilter filter2, boolean enforceUniqueness) {
        Assert.notNull(type, "Type must not be null");
        Assert.notNull((Object)filter2, "Filter must not be null");
        Field foundField = null;
        for (Class<?> targetClass = type; targetClass != Object.class; targetClass = targetClass.getSuperclass()) {
            for (Field field : targetClass.getDeclaredFields()) {
                if (!filter2.matches(field)) continue;
                if (!enforceUniqueness) {
                    return field;
                }
                if (foundField != null && enforceUniqueness) {
                    throw new IllegalStateException(filter2.getDescription());
                }
                foundField = field;
            }
        }
        return foundField;
    }

    public static Field findRequiredField(Class<?> type, String name) {
        Field result = org.springframework.util.ReflectionUtils.findField(type, name);
        if (result == null) {
            throw new IllegalArgumentException(String.format("Unable to find field %s on %s", name, type));
        }
        return result;
    }

    public static void setField(Field field, Object target, @Nullable Object value) {
        org.springframework.util.ReflectionUtils.makeAccessible(field);
        org.springframework.util.ReflectionUtils.setField(field, target, value);
    }

    public static Optional<Constructor<?>> findConstructor(Class<?> type, Object ... constructorArguments) {
        Assert.notNull(type, "Target type must not be null");
        Assert.notNull((Object)constructorArguments, "Constructor arguments must not be null");
        return Arrays.stream(type.getDeclaredConstructors()).filter(constructor -> ReflectionUtils.argumentsMatch(constructor.getParameterTypes(), constructorArguments)).findFirst();
    }

    public static Method findRequiredMethod(Class<?> type, String name, Class<?> ... parameterTypes) {
        Assert.notNull(type, "Class must not be null");
        Assert.notNull((Object)name, "Method name must not be null");
        Method result = null;
        for (Class<?> searchType = type; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : org.springframework.util.ReflectionUtils.getDeclaredMethods(searchType)) {
                if (!name.equals(method.getName()) || !ReflectionUtils.hasSameParams(method, parameterTypes) || result != null && !result.isSynthetic() && !result.isBridge()) continue;
                result = method;
            }
        }
        if (result == null) {
            String parameterTypeNames = Arrays.stream(parameterTypes).map(Object::toString).collect(Collectors.joining(", "));
            throw new IllegalArgumentException(String.format("Unable to find method %s(%s) on %s", name, parameterTypeNames, type));
        }
        return result;
    }

    private static boolean hasSameParams(Method method, Class<?>[] paramTypes) {
        return paramTypes.length == method.getParameterCount() && Arrays.equals(paramTypes, method.getParameterTypes());
    }

    public static Stream<Class<?>> returnTypeAndParameters(Method method) {
        Assert.notNull((Object)method, "Method must not be null");
        Stream<Class<?>> returnType = Stream.of(method.getReturnType());
        Stream<Class<?>> parameterTypes = Arrays.stream(method.getParameterTypes());
        return Stream.concat(returnType, parameterTypes);
    }

    public static Optional<Method> getMethod(Class<?> type, String name, ResolvableType ... parameterTypes) {
        Assert.notNull(type, "Type must not be null");
        Assert.hasText(name, "Name must not be null or empty");
        Assert.notNull((Object)parameterTypes, "Parameter types must not be null");
        List<Class> collect = Arrays.stream(parameterTypes).map(ResolvableType::getRawClass).collect(Collectors.toList());
        Method method = org.springframework.util.ReflectionUtils.findMethod(type, name, collect.toArray(new Class[collect.size()]));
        return Optional.ofNullable(method).filter(it -> IntStream.range(0, it.getParameterCount()).allMatch(index -> ResolvableType.forMethodParameter(it, index).equals(parameterTypes[index])));
    }

    private static boolean argumentsMatch(Class<?>[] parameterTypes, Object[] arguments) {
        if (parameterTypes.length != arguments.length) {
            return false;
        }
        int index = 0;
        for (Class<?> argumentType : parameterTypes) {
            Object argument = arguments[index];
            if (argumentType.isPrimitive() && argument == null) {
                return false;
            }
            if (argument != null && !ClassUtils.isAssignableValue(argumentType, argument)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    @Deprecated
    public static boolean isKotlinClass(Class<?> type) {
        return KotlinDetector.isKotlinType(type);
    }

    @Deprecated
    public static boolean isSupportedKotlinClass(Class<?> type) {
        return KotlinReflectionUtils.isSupportedKotlinClass(type);
    }

    public static boolean isNullable(MethodParameter parameter) {
        if (ReflectionUtils.isVoid(parameter.getParameterType())) {
            return true;
        }
        if (ReflectionUtils.isSupportedKotlinClass(parameter.getDeclaringClass())) {
            return KotlinReflectionUtils.isNullable(parameter);
        }
        return !parameter.getParameterType().isPrimitive();
    }

    public static Object getPrimitiveDefault(Class<?> type) {
        if (type == Byte.TYPE || type == Byte.class) {
            return (byte)0;
        }
        if (type == Short.TYPE || type == Short.class) {
            return (short)0;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return 0;
        }
        if (type == Long.TYPE || type == Long.class) {
            return 0L;
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(0.0f);
        }
        if (type == Double.TYPE || type == Double.class) {
            return 0.0;
        }
        if (type == Character.TYPE || type == Character.class) {
            return Character.valueOf('\u0000');
        }
        if (type == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException(String.format("Primitive type %s not supported", type));
    }

    @Nullable
    public static Class<?> loadIfPresent(String name, ClassLoader classLoader) {
        try {
            return ClassUtils.forName(name, classLoader);
        }
        catch (Exception o_O) {
            return null;
        }
    }

    public static class AnnotationFieldFilter
    implements DescribedFieldFilter {
        private final Class<? extends Annotation> annotationType;

        public AnnotationFieldFilter(Class<? extends Annotation> annotationType) {
            this.annotationType = annotationType;
        }

        @Override
        public boolean matches(Field field) {
            return AnnotationUtils.getAnnotation(field, this.annotationType) != null;
        }

        @Override
        public String getDescription() {
            return String.format("Annotation filter for %s", this.annotationType.getName());
        }
    }

    public static interface DescribedFieldFilter
    extends ReflectionUtils.FieldFilter {
        public String getDescription();
    }
}

