/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.AfterDomainEventPublication;
import org.springframework.data.domain.DomainEvents;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;
import org.springframework.data.util.AnnotationDetectionMethodCallback;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;

public class EventPublishingRepositoryProxyPostProcessor
implements RepositoryProxyPostProcessor {
    private final ApplicationEventPublisher publisher;

    public EventPublishingRepositoryProxyPostProcessor(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @Override
    public void postProcess(ProxyFactory factory, RepositoryInformation repositoryInformation) {
        EventPublishingMethod method = EventPublishingMethod.of(repositoryInformation.getDomainType());
        if (method == null) {
            return;
        }
        factory.addAdvice(new EventPublishingMethodInterceptor(method, this.publisher));
    }

    private static boolean isEventPublishingMethod(Method method) {
        return method.getParameterCount() == 1 && (EventPublishingRepositoryProxyPostProcessor.isSaveMethod(method.getName()) || EventPublishingRepositoryProxyPostProcessor.isDeleteMethod(method.getName()));
    }

    private static boolean isSaveMethod(String methodName) {
        return methodName.startsWith("save");
    }

    private static boolean isDeleteMethod(String methodName) {
        return methodName.equals("delete") || methodName.equals("deleteAll") || methodName.equals("deleteInBatch") || methodName.equals("deleteAllInBatch");
    }

    static class EventPublishingMethod {
        private static Map<Class<?>, EventPublishingMethod> cache = new ConcurrentReferenceHashMap();
        private static EventPublishingMethod NONE = new EventPublishingMethod(Object.class, null, null);
        private final Class<?> type;
        private final Method publishingMethod;
        @Nullable
        private final Method clearingMethod;

        EventPublishingMethod(Class<?> type, Method publishingMethod, @Nullable Method clearingMethod) {
            this.type = type;
            this.publishingMethod = publishingMethod;
            this.clearingMethod = clearingMethod;
        }

        @Nullable
        public static EventPublishingMethod of(Class<?> type) {
            Assert.notNull(type, "Type must not be null");
            EventPublishingMethod eventPublishingMethod = cache.get(type);
            if (eventPublishingMethod != null) {
                return eventPublishingMethod.orNull();
            }
            EventPublishingMethod result = EventPublishingMethod.from(type, EventPublishingMethod.getDetector(type, DomainEvents.class), () -> EventPublishingMethod.getDetector(type, AfterDomainEventPublication.class));
            cache.put(type, result);
            return result.orNull();
        }

        public void publishEventsFrom(@Nullable Object object, ApplicationEventPublisher publisher) {
            if (object == null) {
                return;
            }
            for (Object aggregateRoot : EventPublishingMethod.asCollection(object)) {
                if (!this.type.isInstance(aggregateRoot)) continue;
                for (Object event : EventPublishingMethod.asCollection(ReflectionUtils.invokeMethod(this.publishingMethod, aggregateRoot))) {
                    publisher.publishEvent(event);
                }
                if (this.clearingMethod == null) continue;
                ReflectionUtils.invokeMethod(this.clearingMethod, aggregateRoot);
            }
        }

        @Nullable
        private EventPublishingMethod orNull() {
            return this == NONE ? null : this;
        }

        private static <T extends Annotation> AnnotationDetectionMethodCallback<T> getDetector(Class<?> type, Class<T> annotation) {
            AnnotationDetectionMethodCallback<T> callback = new AnnotationDetectionMethodCallback<T>(annotation);
            ReflectionUtils.doWithMethods(type, callback);
            return callback;
        }

        private static EventPublishingMethod from(Class<?> type, AnnotationDetectionMethodCallback<?> publishing, Supplier<AnnotationDetectionMethodCallback<?>> clearing) {
            if (!publishing.hasFoundAnnotation()) {
                return NONE;
            }
            Method eventMethod = publishing.getRequiredMethod();
            ReflectionUtils.makeAccessible(eventMethod);
            return new EventPublishingMethod(type, eventMethod, EventPublishingMethod.getClearingMethod(clearing.get()));
        }

        @Nullable
        private static Method getClearingMethod(AnnotationDetectionMethodCallback<?> clearing) {
            if (!clearing.hasFoundAnnotation()) {
                return null;
            }
            Method method = clearing.getRequiredMethod();
            ReflectionUtils.makeAccessible(method);
            return method;
        }

        private static Collection<Object> asCollection(@Nullable Object source) {
            if (source == null) {
                return Collections.emptyList();
            }
            if (Collection.class.isInstance(source)) {
                return (Collection)source;
            }
            return Collections.singletonList(source);
        }
    }

    static class EventPublishingMethodInterceptor
    implements MethodInterceptor {
        private final EventPublishingMethod eventMethod;
        private final ApplicationEventPublisher publisher;

        private EventPublishingMethodInterceptor(EventPublishingMethod eventMethod, ApplicationEventPublisher publisher) {
            this.eventMethod = eventMethod;
            this.publisher = publisher;
        }

        public static EventPublishingMethodInterceptor of(EventPublishingMethod eventMethod, ApplicationEventPublisher publisher) {
            return new EventPublishingMethodInterceptor(eventMethod, publisher);
        }

        @Override
        @Nullable
        public Object invoke(MethodInvocation invocation) throws Throwable {
            Object result = invocation.proceed();
            if (!EventPublishingRepositoryProxyPostProcessor.isEventPublishingMethod(invocation.getMethod())) {
                return result;
            }
            Object[] arguments = invocation.getArguments();
            this.eventMethod.publishEventsFrom(arguments[0], this.publisher);
            return result;
        }
    }
}

