/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.ParameterMode;
import javax.persistence.StoredProcedureQuery;
import javax.persistence.TypedQuery;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.ProcedureParameter;
import org.springframework.data.jpa.repository.query.QueryParameterSetter;
import org.springframework.data.jpa.repository.query.StoredProcedureAttributes;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class StoredProcedureJpaQuery
extends AbstractJpaQuery {
    private final StoredProcedureAttributes procedureAttributes;
    private final boolean useNamedParameters;
    private final QueryParameterSetter.QueryMetadataCache metadataCache = new QueryParameterSetter.QueryMetadataCache();

    StoredProcedureJpaQuery(JpaQueryMethod method, EntityManager em) {
        super(method, em);
        this.procedureAttributes = method.getProcedureAttributes();
        this.useNamedParameters = StoredProcedureJpaQuery.useNamedParameters(method);
    }

    private static boolean useNamedParameters(QueryMethod method) {
        for (Parameter parameter : method.getParameters()) {
            if (!parameter.isNamedParameter()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected StoredProcedureQuery createQuery(JpaParametersParameterAccessor accessor) {
        return this.applyHints(this.doCreateQuery(accessor), this.getQueryMethod());
    }

    @Override
    protected StoredProcedureQuery doCreateQuery(JpaParametersParameterAccessor accessor) {
        StoredProcedureQuery storedProcedure = this.createStoredProcedure();
        QueryParameterSetter.QueryMetadata metadata = this.metadataCache.getMetadata("singleton", storedProcedure);
        return ((ParameterBinder)this.parameterBinder.get()).bind(storedProcedure, metadata, accessor);
    }

    @Override
    protected TypedQuery<Long> doCreateCountQuery(JpaParametersParameterAccessor accessor) {
        throw new UnsupportedOperationException("StoredProcedureQuery does not support count queries!");
    }

    @Nullable
    Object extractOutputValue(StoredProcedureQuery storedProcedureQuery) {
        Assert.notNull((Object)storedProcedureQuery, "StoredProcedureQuery must not be null!");
        if (!this.procedureAttributes.hasReturnValue()) {
            return null;
        }
        List<ProcedureParameter> outputParameters = this.procedureAttributes.getOutputProcedureParameters();
        if (outputParameters.size() == 1) {
            return this.extractOutputParameterValue(outputParameters.get(0), 0, storedProcedureQuery);
        }
        HashMap<String, Object> outputValues = new HashMap<String, Object>();
        for (int i2 = 0; i2 < outputParameters.size(); ++i2) {
            ProcedureParameter outputParameter = outputParameters.get(i2);
            outputValues.put(outputParameter.getName(), this.extractOutputParameterValue(outputParameter, i2, storedProcedureQuery));
        }
        return outputValues;
    }

    private Object extractOutputParameterValue(ProcedureParameter outputParameter, Integer index, StoredProcedureQuery storedProcedureQuery) {
        JpaParameters methodParameters = this.getQueryMethod().getParameters();
        return this.useNamedParameters && StringUtils.hasText(outputParameter.getName()) ? storedProcedureQuery.getOutputParameterValue(outputParameter.getName()) : storedProcedureQuery.getOutputParameterValue(methodParameters.getNumberOfParameters() + index + 1);
    }

    private StoredProcedureQuery createStoredProcedure() {
        return this.procedureAttributes.isNamedStoredProcedure() ? this.newNamedStoredProcedureQuery() : this.newAdhocStoredProcedureQuery();
    }

    private StoredProcedureQuery newNamedStoredProcedureQuery() {
        return this.getEntityManager().createNamedStoredProcedureQuery(this.procedureAttributes.getProcedureName());
    }

    private StoredProcedureQuery newAdhocStoredProcedureQuery() {
        ProcedureParameter procedureOutput;
        JpaParameters params = this.getQueryMethod().getParameters();
        StoredProcedureQuery procedureQuery = this.createAdhocStoredProcedureQuery();
        for (JpaParameters.JpaParameter param : params) {
            if (!param.isBindable()) continue;
            if (this.useNamedParameters) {
                procedureQuery.registerStoredProcedureParameter(param.getName().orElseThrow(() -> new IllegalArgumentException("For queries with named parameters you need to use provide names for method parameters. Use @Param for query method parameters, or when on Java 8+ use the javac flag -parameters.")), param.getType(), ParameterMode.IN);
                continue;
            }
            procedureQuery.registerStoredProcedureParameter(param.getIndex() + 1, param.getType(), ParameterMode.IN);
        }
        if (this.procedureAttributes.hasReturnValue() && (this.storedProcedureHasResultSetUsingRefCursor(procedureOutput = this.procedureAttributes.getOutputProcedureParameters().get(0)) || !this.isResultSetProcedure())) {
            if (this.useNamedParameters) {
                procedureQuery.registerStoredProcedureParameter(procedureOutput.getName(), procedureOutput.getType(), procedureOutput.getMode());
            } else {
                int outputParameterIndex = params.getNumberOfParameters() + 1;
                procedureQuery.registerStoredProcedureParameter(outputParameterIndex, procedureOutput.getType(), procedureOutput.getMode());
            }
        }
        return procedureQuery;
    }

    private boolean storedProcedureHasResultSetUsingRefCursor(ProcedureParameter procedureOutput) {
        return this.isResultSetProcedure() && procedureOutput.getMode() == ParameterMode.REF_CURSOR;
    }

    private StoredProcedureQuery createAdhocStoredProcedureQuery() {
        if (this.getQueryMethod().isQueryForEntity()) {
            return this.getEntityManager().createStoredProcedureQuery(this.procedureAttributes.getProcedureName(), this.getQueryMethod().getEntityInformation().getJavaType());
        }
        return this.getEntityManager().createStoredProcedureQuery(this.procedureAttributes.getProcedureName());
    }

    private boolean isResultSetProcedure() {
        return this.getQueryMethod().isCollectionQuery() || this.getQueryMethod().isQueryForEntity();
    }
}

