/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import javax.persistence.criteria.ParameterExpression;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

interface QueryParameterSetter {
    public static final QueryParameterSetter NOOP = (query2, values, errorHandling) -> {};

    public void setParameter(BindableQuery var1, JpaParametersParameterAccessor var2, ErrorHandling var3);

    public static class BindableQuery
    extends QueryMetadata {
        private final Query query;
        private final Query unwrapped;

        BindableQuery(QueryMetadata metadata, Query query2) {
            super(metadata);
            this.query = query2;
            this.unwrapped = Proxy.isProxyClass(query2.getClass()) ? (Query)query2.unwrap(null) : query2;
        }

        private BindableQuery(Query query2) {
            super(query2);
            this.query = query2;
            this.unwrapped = Proxy.isProxyClass(query2.getClass()) ? (Query)query2.unwrap(null) : query2;
        }

        public static BindableQuery from(Query query2) {
            return new BindableQuery(query2);
        }

        public Query getQuery() {
            return this.query;
        }

        public <T> Query setParameter(Parameter<T> param, T value) {
            return this.unwrapped.setParameter(param, value);
        }

        public Query setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
            return this.unwrapped.setParameter(param, value, temporalType);
        }

        public Query setParameter(String name, Object value) {
            return this.unwrapped.setParameter(name, value);
        }

        public Query setParameter(String name, Date value, TemporalType temporalType) {
            return this.query.setParameter(name, value, temporalType);
        }

        public Query setParameter(int position, Object value) {
            return this.unwrapped.setParameter(position, value);
        }

        public Query setParameter(int position, Date value, TemporalType temporalType) {
            return this.unwrapped.setParameter(position, value, temporalType);
        }
    }

    public static class QueryMetadata {
        private final boolean namedParameters;
        private final Set<Parameter<?>> parameters;
        private final boolean registerExcessParameters;

        QueryMetadata(Query query2) {
            this.namedParameters = QueryUtils.hasNamedParameter(query2);
            this.parameters = query2.getParameters();
            this.registerExcessParameters = query2.getParameters().size() == 0 && QueryMetadata.unwrapClass(query2).getName().startsWith("org.eclipse");
        }

        QueryMetadata(QueryMetadata metadata) {
            this.namedParameters = metadata.namedParameters;
            this.parameters = metadata.parameters;
            this.registerExcessParameters = metadata.registerExcessParameters;
        }

        public BindableQuery withQuery(Query query2) {
            return new BindableQuery(this, query2);
        }

        public Set<Parameter<?>> getParameters() {
            return this.parameters;
        }

        public boolean hasNamedParameters() {
            return this.namedParameters;
        }

        public boolean registerExcessParameters() {
            return this.registerExcessParameters;
        }

        private static Class<?> unwrapClass(Query query2) {
            Class<?> queryType = query2.getClass();
            try {
                return Proxy.isProxyClass(queryType) ? query2.unwrap(null).getClass() : queryType;
            }
            catch (RuntimeException e) {
                LogFactory.getLog(QueryMetadata.class).warn("Failed to unwrap actual class for Query proxy.", e);
                return queryType;
            }
        }
    }

    public static class QueryMetadataCache {
        private Map<String, QueryMetadata> cache = Collections.emptyMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public QueryMetadata getMetadata(String cacheKey, Query query2) {
            QueryMetadata queryMetadata = this.cache.get(cacheKey);
            if (queryMetadata == null) {
                Map<String, QueryMetadata> cache;
                queryMetadata = new QueryMetadata(query2);
                if (this.cache.isEmpty()) {
                    cache = Collections.singletonMap(cacheKey, queryMetadata);
                } else {
                    cache = new HashMap<String, QueryMetadata>(this.cache);
                    cache.put(cacheKey, queryMetadata);
                }
                QueryMetadataCache queryMetadataCache = this;
                synchronized (queryMetadataCache) {
                    this.cache = cache;
                }
            }
            return queryMetadata;
        }
    }

    public static enum ErrorHandling {
        STRICT{

            @Override
            public void execute(Runnable block) {
                block.run();
            }
        }
        ,
        LENIENT{

            @Override
            public void execute(Runnable block) {
                try {
                    block.run();
                }
                catch (RuntimeException rex) {
                    LOG.info("Silently ignoring", rex);
                }
            }
        };

        private static final Log LOG;

        abstract void execute(Runnable var1);

        static {
            LOG = LogFactory.getLog(ErrorHandling.class);
        }
    }

    public static class NamedOrIndexedQueryParameterSetter
    implements QueryParameterSetter {
        private final Function<JpaParametersParameterAccessor, Object> valueExtractor;
        private final Parameter<?> parameter;
        @Nullable
        private final TemporalType temporalType;

        NamedOrIndexedQueryParameterSetter(Function<JpaParametersParameterAccessor, Object> valueExtractor, Parameter<?> parameter, @Nullable TemporalType temporalType) {
            Assert.notNull(valueExtractor, "ValueExtractor must not be null!");
            this.valueExtractor = valueExtractor;
            this.parameter = parameter;
            this.temporalType = temporalType;
        }

        @Override
        public void setParameter(BindableQuery query2, JpaParametersParameterAccessor accessor, ErrorHandling errorHandling) {
            Object value = this.valueExtractor.apply(accessor);
            if (this.temporalType != null) {
                if (this.parameter instanceof ParameterExpression) {
                    errorHandling.execute(() -> query2.setParameter(this.parameter, (Date)value, this.temporalType));
                } else if (query2.hasNamedParameters() && this.parameter.getName() != null) {
                    errorHandling.execute(() -> query2.setParameter(this.parameter.getName(), (Date)value, this.temporalType));
                } else {
                    Integer position = this.parameter.getPosition();
                    if (position != null && (query2.getParameters().size() >= this.parameter.getPosition() || query2.registerExcessParameters() || errorHandling == ErrorHandling.LENIENT)) {
                        errorHandling.execute(() -> query2.setParameter(this.parameter.getPosition(), (Date)value, this.temporalType));
                    }
                }
            } else if (this.parameter instanceof ParameterExpression) {
                errorHandling.execute(() -> query2.setParameter(this.parameter, value));
            } else if (query2.hasNamedParameters() && this.parameter.getName() != null) {
                errorHandling.execute(() -> query2.setParameter(this.parameter.getName(), value));
            } else {
                Integer position = this.parameter.getPosition();
                if (position != null && (query2.getParameters().size() >= position || errorHandling == ErrorHandling.LENIENT || query2.registerExcessParameters())) {
                    errorHandling.execute(() -> query2.setParameter(position, value));
                }
            }
        }
    }
}

