/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.StoredProcedureQuery;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.JpaResultConverters;
import org.springframework.data.jpa.repository.query.StoredProcedureJpaQuery;
import org.springframework.data.repository.core.support.SurroundingTransactionDetectorMethodInterceptor;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.data.util.CloseableIterator;
import org.springframework.data.util.StreamUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public abstract class JpaQueryExecution {
    private static final ConversionService CONVERSION_SERVICE;

    @Nullable
    public Object execute(AbstractJpaQuery query2, JpaParametersParameterAccessor accessor) {
        Object result;
        Assert.notNull((Object)query2, "AbstractJpaQuery must not be null!");
        Assert.notNull((Object)accessor, "JpaParametersParameterAccessor must not be null!");
        try {
            result = this.doExecute(query2, accessor);
        }
        catch (NoResultException e) {
            return null;
        }
        if (result == null) {
            return null;
        }
        JpaQueryMethod queryMethod = query2.getQueryMethod();
        Class<?> requiredType = queryMethod.getReturnType();
        if (ClassUtils.isAssignable(requiredType, Void.TYPE) || ClassUtils.isAssignableValue(requiredType, result)) {
            return result;
        }
        return CONVERSION_SERVICE.canConvert(result.getClass(), requiredType) ? CONVERSION_SERVICE.convert(result, requiredType) : result;
    }

    @Nullable
    protected abstract Object doExecute(AbstractJpaQuery var1, JpaParametersParameterAccessor var2);

    public static void potentiallyRemoveOptionalConverter(ConfigurableConversionService conversionService) {
        ClassLoader classLoader = JpaQueryExecution.class.getClassLoader();
        if (ClassUtils.isPresent("java.util.Optional", classLoader)) {
            try {
                Class<?> optionalType = ClassUtils.forName("java.util.Optional", classLoader);
                conversionService.removeConvertible(Object.class, optionalType);
            }
            catch (ClassNotFoundException | LinkageError throwable) {
                // empty catch block
            }
        }
    }

    static {
        DefaultConversionService conversionService = new DefaultConversionService();
        conversionService.addConverter(JpaResultConverters.BlobToByteArrayConverter.INSTANCE);
        conversionService.removeConvertible(Collection.class, Object.class);
        JpaQueryExecution.potentiallyRemoveOptionalConverter(conversionService);
        CONVERSION_SERVICE = conversionService;
    }

    static class StreamExecution
    extends JpaQueryExecution {
        private static final String NO_SURROUNDING_TRANSACTION = "You're trying to execute a streaming query method without a surrounding transaction that keeps the connection open so that the Stream can actually be consumed. Make sure the code consuming the stream uses @Transactional or any other way of declaring a (read-only) transaction.";
        private static Method streamMethod = ReflectionUtils.findMethod(Query.class, "getResultStream");

        StreamExecution() {
        }

        @Override
        protected Object doExecute(AbstractJpaQuery query2, JpaParametersParameterAccessor accessor) {
            if (!SurroundingTransactionDetectorMethodInterceptor.INSTANCE.isSurroundingTransactionActive()) {
                throw new InvalidDataAccessApiUsageException(NO_SURROUNDING_TRANSACTION);
            }
            Query jpaQuery = query2.createQuery(accessor);
            if (streamMethod != null) {
                return ReflectionUtils.invokeMethod(streamMethod, jpaQuery);
            }
            PersistenceProvider persistenceProvider = PersistenceProvider.fromEntityManager(query2.getEntityManager());
            CloseableIterator<Object> iter2 = persistenceProvider.executeQueryWithResultStream(jpaQuery);
            return StreamUtils.createStreamFromIterator(iter2);
        }
    }

    static class ProcedureExecution
    extends JpaQueryExecution {
        private static final String NO_SURROUNDING_TRANSACTION = "You're trying to execute a @Procedure method without a surrounding transaction that keeps the connection open so that the ResultSet can actually be consumed. Make sure the consumer code uses @Transactional or any other way of declaring a (read-only) transaction.";

        ProcedureExecution() {
        }

        @Override
        protected Object doExecute(AbstractJpaQuery jpaQuery, JpaParametersParameterAccessor accessor) {
            Assert.isInstanceOf(StoredProcedureJpaQuery.class, jpaQuery);
            StoredProcedureJpaQuery storedProcedureJpaQuery = (StoredProcedureJpaQuery)jpaQuery;
            StoredProcedureQuery storedProcedure = storedProcedureJpaQuery.createQuery(accessor);
            boolean returnsResultSet = storedProcedure.execute();
            if (returnsResultSet) {
                if (!SurroundingTransactionDetectorMethodInterceptor.INSTANCE.isSurroundingTransactionActive()) {
                    throw new InvalidDataAccessApiUsageException(NO_SURROUNDING_TRANSACTION);
                }
                if (storedProcedureJpaQuery.getQueryMethod().isCollectionQuery()) {
                    return storedProcedure.getResultList();
                }
                return storedProcedure.getSingleResult();
            }
            return storedProcedureJpaQuery.extractOutputValue(storedProcedure);
        }
    }

    static class ExistsExecution
    extends JpaQueryExecution {
        ExistsExecution() {
        }

        @Override
        protected Object doExecute(AbstractJpaQuery query2, JpaParametersParameterAccessor accessor) {
            return !query2.createQuery(accessor).getResultList().isEmpty();
        }
    }

    static class DeleteExecution
    extends JpaQueryExecution {
        private final EntityManager em;

        public DeleteExecution(EntityManager em) {
            this.em = em;
        }

        @Override
        protected Object doExecute(AbstractJpaQuery jpaQuery, JpaParametersParameterAccessor accessor) {
            Query query2 = jpaQuery.createQuery(accessor);
            List resultList = query2.getResultList();
            for (Object o : resultList) {
                this.em.remove(o);
            }
            return jpaQuery.getQueryMethod().isCollectionQuery() ? resultList : Integer.valueOf(resultList.size());
        }
    }

    static class ModifyingExecution
    extends JpaQueryExecution {
        private final EntityManager em;
        private final boolean flush;
        private final boolean clear;

        public ModifyingExecution(JpaQueryMethod method, EntityManager em) {
            Assert.notNull((Object)em, "The EntityManager must not be null.");
            Class<?> returnType = method.getReturnType();
            boolean isVoid = ClassUtils.isAssignable(returnType, Void.class);
            boolean isInt = ClassUtils.isAssignable(returnType, Integer.class);
            Assert.isTrue(isInt || isVoid, "Modifying queries can only use void or int/Integer as return type! Offending method: " + method);
            this.em = em;
            this.flush = method.getFlushAutomatically();
            this.clear = method.getClearAutomatically();
        }

        @Override
        protected Object doExecute(AbstractJpaQuery query2, JpaParametersParameterAccessor accessor) {
            if (this.flush) {
                this.em.flush();
            }
            int result = query2.createQuery(accessor).executeUpdate();
            if (this.clear) {
                this.em.clear();
            }
            return result;
        }
    }

    static class SingleEntityExecution
    extends JpaQueryExecution {
        SingleEntityExecution() {
        }

        @Override
        protected Object doExecute(AbstractJpaQuery query2, JpaParametersParameterAccessor accessor) {
            return query2.createQuery(accessor).getSingleResult();
        }
    }

    static class PagedExecution
    extends JpaQueryExecution {
        PagedExecution() {
        }

        @Override
        protected Object doExecute(AbstractJpaQuery repositoryQuery, JpaParametersParameterAccessor accessor) {
            Query query2 = repositoryQuery.createQuery(accessor);
            return PageableExecutionUtils.getPage(query2.getResultList(), accessor.getPageable(), () -> this.count(repositoryQuery, accessor));
        }

        private long count(AbstractJpaQuery repositoryQuery, JpaParametersParameterAccessor accessor) {
            List totals = repositoryQuery.createCountQuery(accessor).getResultList();
            return totals.size() == 1 ? CONVERSION_SERVICE.convert(totals.get(0), Long.class) : (long)totals.size();
        }
    }

    static class SlicedExecution
    extends JpaQueryExecution {
        SlicedExecution() {
        }

        @Override
        protected Object doExecute(AbstractJpaQuery query2, JpaParametersParameterAccessor accessor) {
            Pageable pageable = accessor.getPageable();
            Query createQuery = query2.createQuery(accessor);
            int pageSize = 0;
            if (pageable.isPaged()) {
                pageSize = pageable.getPageSize();
                createQuery.setMaxResults(pageSize + 1);
            }
            List resultList = createQuery.getResultList();
            boolean hasNext = pageable.isPaged() && resultList.size() > pageSize;
            return new SliceImpl(hasNext ? resultList.subList(0, pageSize) : resultList, pageable, hasNext);
        }
    }

    static class CollectionExecution
    extends JpaQueryExecution {
        CollectionExecution() {
        }

        @Override
        protected Object doExecute(AbstractJpaQuery query2, JpaParametersParameterAccessor accessor) {
            return query2.createQuery(accessor).getResultList();
        }
    }
}

