/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.mapping;

import org.springframework.data.annotation.Version;
import org.springframework.data.jpa.mapping.JpaPersistentEntity;
import org.springframework.data.jpa.mapping.JpaPersistentProperty;
import org.springframework.data.jpa.provider.ProxyIdAccessor;
import org.springframework.data.jpa.util.JpaMetamodel;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.mapping.model.IdPropertyIdentifierAccessor;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

class JpaPersistentEntityImpl<T>
extends BasicPersistentEntity<T, JpaPersistentProperty>
implements JpaPersistentEntity<T> {
    private static final String INVALID_VERSION_ANNOTATION = "%s is annotated with " + Version.class.getName() + " but needs to use " + javax.persistence.Version.class.getName() + " to trigger optimistic locking correctly!";
    private final ProxyIdAccessor proxyIdAccessor;
    private final JpaMetamodel metamodel;

    public JpaPersistentEntityImpl(TypeInformation<T> information, ProxyIdAccessor proxyIdAccessor, JpaMetamodel metamodel) {
        super(information, null);
        Assert.notNull((Object)proxyIdAccessor, "ProxyIdAccessor must not be null!");
        this.proxyIdAccessor = proxyIdAccessor;
        this.metamodel = metamodel;
    }

    @Override
    protected JpaPersistentProperty returnPropertyIfBetterIdPropertyCandidateOrNull(JpaPersistentProperty property) {
        return property.isIdProperty() ? property : null;
    }

    @Override
    public IdentifierAccessor getIdentifierAccessor(Object bean2) {
        return new JpaProxyAwareIdentifierAccessor(this, bean2, this.proxyIdAccessor);
    }

    @Override
    public void verify() {
        super.verify();
        JpaPersistentProperty versionProperty = (JpaPersistentProperty)this.getVersionProperty();
        if (versionProperty != null && versionProperty.isAnnotationPresent(Version.class)) {
            throw new IllegalArgumentException(String.format(INVALID_VERSION_ANNOTATION, versionProperty));
        }
    }

    JpaMetamodel getMetamodel() {
        return this.metamodel;
    }

    private static class JpaProxyAwareIdentifierAccessor
    extends IdPropertyIdentifierAccessor {
        private final Object bean;
        private final ProxyIdAccessor proxyIdAccessor;

        JpaProxyAwareIdentifierAccessor(JpaPersistentEntity<?> entity, Object bean2, ProxyIdAccessor proxyIdAccessor) {
            super(entity, bean2);
            Assert.notNull((Object)proxyIdAccessor, "Proxy identifier accessor must not be null!");
            this.proxyIdAccessor = proxyIdAccessor;
            this.bean = bean2;
        }

        @Override
        public Object getIdentifier() {
            return this.proxyIdAccessor.shouldUseAccessorFor(this.bean) ? this.proxyIdAccessor.getIdentifierFrom(this.bean) : super.getIdentifier();
        }
    }
}

