/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import org.jgroups.Constructable;
import org.jgroups.util.FixedSizeBitSet;
import org.jgroups.util.SizeStreamable;
import org.jgroups.util.Util;

public class SeqnoList
extends FixedSizeBitSet
implements SizeStreamable,
Iterable<Long>,
Constructable<SeqnoList> {
    protected long offset;

    public SeqnoList() {
    }

    public SeqnoList(int size, long offset) {
        super(size);
        this.offset = offset;
    }

    @Override
    public Supplier<? extends SeqnoList> create() {
        return SeqnoList::new;
    }

    public SeqnoList(int size) {
        this(size, 0L);
    }

    public SeqnoList add(long seqno) {
        super.set(this.index(seqno));
        return this;
    }

    public SeqnoList add(long ... seqnos) {
        if (seqnos != null) {
            for (long seqno : seqnos) {
                this.add(seqno);
            }
        }
        return this;
    }

    public SeqnoList add(long from, long to) {
        super.set(this.index(from), this.index(to));
        return this;
    }

    public SeqnoList removeHigherThan(long seqno) {
        int from = this.index(seqno + 1L);
        int to = this.size - 1;
        if (from < 0) {
            from = 0;
        }
        if (from <= to && from >= 0) {
            super.clear(from, to);
        }
        return this;
    }

    public SeqnoList removeLowerThan(long seqno) {
        int to = this.index(seqno - 1L);
        if (to >= 0) {
            super.clear(0, to);
        }
        return this;
    }

    public long getLast() {
        int index = this.previousSetBit(this.size - 1);
        return index == -1 ? -1L : this.seqno(index);
    }

    public long getFirst() {
        int index = this.nextSetBit(0);
        return index < 0 ? -1L : this.seqno(index);
    }

    @Override
    public int serializedSize() {
        return 4 + (this.words.length + 1) * 8;
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeLong(this.offset);
        for (long word : this.words) {
            out.writeLong(word);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException {
        this.size = in.readInt();
        this.offset = in.readLong();
        this.words = new long[SeqnoList.wordIndex(this.size - 1) + 1];
        for (int i2 = 0; i2 < this.words.length; ++i2) {
            this.words[i2] = in.readLong();
        }
    }

    @Override
    public int size() {
        return super.cardinality();
    }

    public boolean isEmpty() {
        return this.cardinality() == 0;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder("(").append(this.cardinality()).append("): {");
        boolean first = true;
        int num = Util.MAX_LIST_PRINT_SIZE;
        int i2 = this.nextSetBit(0);
        while (i2 >= 0) {
            int endOfRun = this.nextClearBit(i2);
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            if (endOfRun != -1 && endOfRun - 1 != i2) {
                sb.append(this.seqno(i2)).append('-').append(this.seqno(endOfRun - 1));
                i2 = endOfRun;
            } else {
                sb.append(this.seqno(i2));
            }
            if (--num <= 0) {
                sb.append(", ... ");
                break;
            }
            i2 = this.nextSetBit(i2 + 1);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public Iterator<Long> iterator() {
        return new SeqnoListIterator();
    }

    protected int index(long seqno) {
        return (int)(seqno - this.offset);
    }

    protected long seqno(int index) {
        return this.offset + (long)index;
    }

    protected class SeqnoListIterator
    implements Iterator<Long> {
        protected int index;

        protected SeqnoListIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < SeqnoList.this.size && SeqnoList.this.nextSetBit(this.index) != -1;
        }

        @Override
        public Long next() {
            int next_index = SeqnoList.this.nextSetBit(this.index);
            if (next_index == -1 || next_index >= SeqnoList.this.size) {
                throw new NoSuchElementException("index: " + next_index);
            }
            this.index = next_index + 1;
            return SeqnoList.this.seqno(next_index);
        }

        @Override
        public void remove() {
        }
    }
}

