/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.util.Util;

public class GenerateGettersAndSetters {
    public static void main(String[] args) throws ClassNotFoundException {
        Field[] fields;
        String classname = null;
        boolean use_generics = false;
        for (int i2 = 0; i2 < args.length; ++i2) {
            if ("-class".equals(args[i2])) {
                classname = args[++i2];
                continue;
            }
            if ("-use-generics".equals(args[i2])) {
                use_generics = true;
                continue;
            }
            System.out.printf("%s -class <classname> [-use-generics>]\n", GenerateGettersAndSetters.class.getSimpleName());
            return;
        }
        if (classname == null) {
            System.err.println("no classname given (-class)");
            return;
        }
        Class<?> clazz = Util.loadClass(classname, GenerateGettersAndSetters.class);
        for (Field f : fields = clazz.getDeclaredFields()) {
            boolean is_boolean;
            Object getter_name;
            if (Modifier.isStatic(f.getModifiers()) || f.getAnnotation(ManagedAttribute.class) == null && f.getAnnotation(Property.class) == null) continue;
            Class<?> type = f.getType();
            Object setter_name = getter_name = Util.attributeNameToMethodName(f.getName());
            boolean bl = is_boolean = type.equals(Boolean.TYPE) || type.equals(Boolean.class);
            if (is_boolean) {
                getter_name = setter_name = ((String)getter_name).substring(0, 1).toLowerCase() + ((String)getter_name).substring(1);
            } else {
                getter_name = "get" + (String)getter_name;
                setter_name = "set" + (String)setter_name;
            }
            String typename = f.getType().getSimpleName();
            String var_name = f.getName().substring(0, 1).toLowerCase();
            String getter = String.format("public %s %s() {return %s;}", typename, getter_name, f.getName());
            String retval = use_generics ? String.format("<T extends %s> T", clazz.getSimpleName()) : clazz.getSimpleName();
            String setter = String.format("public %s %s(%s %s) {this.%s=%s; return %sthis;}", retval, setter_name, typename, var_name, f.getName(), var_name, use_generics ? "(T)" : "");
            System.out.printf("%s\n%s\n\n", getter, setter);
        }
    }
}

