/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Constructable;
import org.jgroups.util.Bits;
import org.jgroups.util.MutableDigest;
import org.jgroups.util.SizeStreamable;
import org.jgroups.util.Util;

public class Digest
implements SizeStreamable,
Iterable<Entry>,
Constructable<Digest> {
    protected Address[] members;
    protected long[] seqnos;

    public Digest() {
    }

    public Digest(Address[] members, long[] seqnos) {
        if (members == null) {
            throw new IllegalArgumentException("members is null");
        }
        if (seqnos == null) {
            throw new IllegalArgumentException("seqnos is null");
        }
        this.members = members;
        this.seqnos = seqnos;
        this.checkPostcondition();
    }

    public Digest(Address[] members) {
        if (members == null) {
            throw new IllegalArgumentException("members is null");
        }
        this.members = members;
    }

    public Digest(Digest digest) {
        if (digest == null) {
            return;
        }
        this.members = digest.members;
        this.seqnos = digest instanceof MutableDigest || this instanceof MutableDigest ? Arrays.copyOf(digest.seqnos, digest.seqnos.length) : digest.seqnos;
        this.checkPostcondition();
    }

    public Digest(Map<Address, long[]> map) {
        this.createArrays(map);
        this.checkPostcondition();
    }

    public Digest(Address sender, long highest_delivered, long highest_received) {
        this.members = new Address[]{sender};
        this.seqnos = new long[]{highest_delivered, highest_received};
    }

    @Override
    public Supplier<? extends Digest> create() {
        return Digest::new;
    }

    public Address[] getMembersRaw() {
        return this.members;
    }

    public int capacity() {
        return this.members != null ? this.members.length : 0;
    }

    public boolean contains(Address mbr) {
        if (mbr == null || this.members == null) {
            return false;
        }
        for (Address member : this.members) {
            if (!Objects.equals(member, mbr)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Address ... members) {
        for (Address member : members) {
            if (this.contains(member)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        Digest other = (Digest)obj;
        boolean same_mbrs = Arrays.equals(this.members, other.members);
        boolean same_seqnos = Arrays.equals(this.seqnos, other.seqnos);
        return same_mbrs && same_seqnos;
    }

    public long[] get(Address member) {
        int index = this.find(member);
        if (index < 0) {
            return null;
        }
        return new long[]{this.seqnos[index * 2], this.seqnos[index * 2 + 1]};
    }

    @Override
    public Iterator<Entry> iterator() {
        return new MyIterator();
    }

    public Digest copy() {
        return new Digest(this.members, Arrays.copyOf(this.seqnos, this.seqnos.length));
    }

    @Override
    public void writeTo(DataOutput out) throws IOException {
        this.writeTo(out, true);
    }

    public void writeTo(DataOutput out, boolean write_addrs) throws IOException {
        if (write_addrs) {
            Util.writeAddresses(this.members, out);
        } else {
            out.writeShort(this.members.length);
        }
        for (int i2 = 0; i2 < this.capacity(); ++i2) {
            Bits.writeLongSequence(this.seqnos[i2 * 2], this.seqnos[i2 * 2 + 1], out);
        }
    }

    @Override
    public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
        this.readFrom(in, true);
    }

    public void readFrom(DataInput in, boolean read_addrs) throws IOException, ClassNotFoundException {
        if (read_addrs) {
            this.members = Util.readAddresses(in);
            this.seqnos = new long[this.capacity() * 2];
        } else {
            this.seqnos = new long[in.readShort() * 2];
        }
        for (int i2 = 0; i2 < this.seqnos.length / 2; ++i2) {
            Bits.readLongSequence(in, this.seqnos, i2 * 2);
        }
    }

    @Override
    public int serializedSize() {
        return (int)this.serializedSize(true);
    }

    public long serializedSize(boolean with_members) {
        long retval = with_members ? Util.size(this.members) : 2L;
        for (int i2 = 0; i2 < this.members.length; ++i2) {
            retval += (long)Bits.size(this.seqnos[i2 * 2], this.seqnos[i2 * 2 + 1]);
        }
        return retval;
    }

    public String toString() {
        return this.toString(this.members, true);
    }

    public String toString(Digest order) {
        return order != null ? this.toString(order.members, true) : this.toString(this.members, true);
    }

    public String toString(Address[] order, boolean print_highest_received) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (this.capacity() == 0) {
            return "[]";
        }
        int count = 0;
        int capacity = this.capacity();
        for (Address key : order) {
            long[] tmp_seqnos;
            long[] lArray = tmp_seqnos = key != null ? this.get(key) : null;
            if (key == null || tmp_seqnos == null) continue;
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(key).append(": ").append('[').append(tmp_seqnos[0]);
            if (print_highest_received) {
                sb.append(" (").append(tmp_seqnos[1]).append(")");
            }
            sb.append("]");
            if (Util.MAX_LIST_PRINT_SIZE <= 0 || ++count < Util.MAX_LIST_PRINT_SIZE) continue;
            if (capacity <= count) break;
            sb.append(", ...");
            break;
        }
        return sb.toString();
    }

    protected int find(Address mbr) {
        if (mbr == null || this.members == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.members.length; ++i2) {
            Address member = this.members[i2];
            if (!Objects.equals(member, mbr)) continue;
            return i2;
        }
        return -1;
    }

    protected void createArrays(Map<Address, long[]> map) {
        int size = map.size();
        this.members = new Address[size];
        this.seqnos = new long[size * 2];
        int index = 0;
        for (Map.Entry<Address, long[]> entry : map.entrySet()) {
            this.members[index] = entry.getKey();
            this.seqnos[index * 2] = entry.getValue()[0];
            this.seqnos[index * 2 + 1] = entry.getValue()[1];
            ++index;
        }
    }

    protected void checkPostcondition() {
        int size = this.members.length;
        if (size * 2 != this.seqnos.length) {
            throw new IllegalArgumentException("seqnos.length (" + this.seqnos.length + ") is not twice the members size (" + size + ")");
        }
    }

    protected class MyIterator
    implements Iterator<Entry> {
        protected int index;

        protected MyIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < Digest.this.capacity();
        }

        @Override
        public Entry next() {
            if (this.index >= Digest.this.capacity()) {
                throw new NoSuchElementException("index=" + this.index + ", capacity=" + Digest.this.capacity());
            }
            Address mbr = Digest.this.members != null ? Digest.this.members[this.index] : null;
            long hd = Digest.this.seqnos != null ? Digest.this.seqnos[this.index * 2] : 0L;
            long hr = Digest.this.seqnos != null ? Digest.this.seqnos[this.index * 2 + 1] : 0L;
            Entry entry = new Entry(mbr, hd, hr);
            ++this.index;
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Entry {
        protected final Address member;
        protected final long hd;
        protected final long hr;

        public Entry(Address member, long highest_delivered, long highest_received) {
            this.member = member;
            this.hd = highest_delivered;
            this.hr = highest_received;
        }

        public Address getMember() {
            return this.member;
        }

        public long getHighestDeliveredSeqno() {
            return this.hd;
        }

        public long getHighestReceivedSeqno() {
            return this.hr;
        }

        public long getHighest() {
            return Math.max(this.hd, this.hr);
        }

        public boolean equals(Object obj) {
            Entry other = (Entry)obj;
            return this.member.equals(other.member) && this.hd == other.hd && this.hr == other.hr;
        }

        public String toString() {
            return String.valueOf(this.member) + ": [" + this.hd + " (" + this.hr + ")]";
        }
    }
}

