/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.jgroups.Address;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

public class AckCollector {
    protected final List<Address> missing_acks;
    protected final Promise<Boolean> all_acks_received = new Promise();

    public AckCollector() {
        this.missing_acks = new ArrayList<Address>();
    }

    public AckCollector(Collection<Address> members) {
        this.missing_acks = new ArrayList<Address>(members != null ? members.size() : 10);
        this.addAll(members);
    }

    public AckCollector(Address ... members) {
        this.missing_acks = new ArrayList<Address>(members != null ? members.length : 10);
        this.addAll(members);
    }

    public synchronized void reset(Collection<Address> members) {
        this.missing_acks.clear();
        this.addAll(members);
        this.all_acks_received.reset();
    }

    public synchronized AckCollector reset(Collection<Address> expected_acks, Collection<Address> exclude) {
        this.missing_acks.clear();
        this.addAll(expected_acks, exclude);
        this.all_acks_received.reset();
        return this;
    }

    public synchronized AckCollector reset(Collection<Address> expected_acks, Address ... exclude) {
        this.missing_acks.clear();
        this.addAll(expected_acks, exclude);
        this.all_acks_received.reset();
        return this;
    }

    public synchronized void destroy() {
        this.missing_acks.clear();
        this.all_acks_received.setResult(null);
    }

    public synchronized int size() {
        return this.missing_acks.size();
    }

    public synchronized int expectedAcks() {
        return this.missing_acks.size();
    }

    public synchronized void ack(Address member) {
        if (member != null && this.missing_acks.remove(member) && this.missing_acks.isEmpty()) {
            this.all_acks_received.setResult(Boolean.TRUE);
        }
    }

    public synchronized void ack(Address ... members) {
        for (Address member : members) {
            if (member == null || !this.missing_acks.remove(member) || !this.missing_acks.isEmpty()) continue;
            this.all_acks_received.setResult(Boolean.TRUE);
        }
    }

    public synchronized void ack(Collection<Address> members) {
        for (Address member : members) {
            if (member == null || !this.missing_acks.remove(member) || !this.missing_acks.isEmpty()) continue;
            this.all_acks_received.setResult(Boolean.TRUE);
        }
    }

    public void suspect(Address member) {
        this.ack(member);
    }

    public void suspect(Address ... members) {
        this.ack(members);
    }

    public void suspect(Collection<Address> members) {
        this.ack(members);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection<Address> members) {
        if (members == null) {
            return false;
        }
        boolean retval = false;
        AckCollector ackCollector = this;
        synchronized (ackCollector) {
            retval = this.missing_acks.retainAll(members);
            if (retval && this.missing_acks.isEmpty()) {
                this.all_acks_received.setResult(Boolean.TRUE);
            }
        }
        return retval;
    }

    public boolean waitForAllAcks() {
        if (this.missing_acks.isEmpty()) {
            return true;
        }
        Boolean result = this.all_acks_received.getResult();
        return result != null && result != false;
    }

    public boolean waitForAllAcks(long timeout) throws TimeoutException {
        if (this.missing_acks.isEmpty()) {
            return true;
        }
        Boolean result = this.all_acks_received.getResultWithTimeout(timeout);
        return result != null && result != false;
    }

    public String toString() {
        return this.printMissing();
    }

    public synchronized String printMissing() {
        return Util.printListWithDelimiter(this.missing_acks, ", ");
    }

    protected synchronized void addAll(Address ... members) {
        if (members == null) {
            return;
        }
        for (Address member : members) {
            if (member == null || this.missing_acks.contains(member)) continue;
            this.missing_acks.add(member);
        }
    }

    protected synchronized void addAll(Collection<Address> members) {
        if (members == null) {
            return;
        }
        members.stream().filter(member -> member != null && !this.missing_acks.contains(member)).forEach(this.missing_acks::add);
    }

    protected synchronized void addAll(Collection<Address> members, Collection<Address> exclude) {
        if (members == null) {
            return;
        }
        members.stream().filter(m3 -> m3 != null && !this.missing_acks.contains(m3) && exclude != null && !exclude.contains(m3)).forEach(this.missing_acks::add);
    }

    protected synchronized void addAll(Collection<Address> members, Address ... exclude) {
        if (members == null) {
            return;
        }
        members.stream().filter(m3 -> m3 != null && !this.missing_acks.contains(m3) && exclude != null && !Util.contains(m3, exclude)).forEach(this.missing_acks::add);
    }
}

