/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests.rt.transports;

import java.io.Closeable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.List;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.tests.rt.RtReceiver;
import org.jgroups.tests.rt.RtTransport;
import org.jgroups.util.Util;

public class NioTransport
implements RtTransport {
    protected ServerSocketChannel srv_channel;
    protected SocketChannel client_channel;
    protected Receiver receiver_thread;
    protected RtReceiver receiver;
    protected InetAddress host;
    protected int port = 7800;
    protected boolean server;
    protected boolean direct_buffers;
    protected final Log log = LogFactory.getLog(NioTransport.class);

    @Override
    public String[] options() {
        return new String[]{"-host <host>", "-port <port>", "-server", "-direct"};
    }

    @Override
    public void options(String ... options) throws Exception {
        if (options == null) {
            return;
        }
        for (int i2 = 0; i2 < options.length; ++i2) {
            if (options[i2].equals("-server")) {
                this.server = true;
                continue;
            }
            if (options[i2].equals("-host")) {
                this.host = InetAddress.getByName(options[++i2]);
                continue;
            }
            if (options[i2].equals("-port")) {
                this.port = Integer.parseInt(options[++i2]);
                continue;
            }
            if (!options[i2].equals("-direct")) continue;
            this.direct_buffers = Boolean.valueOf(options[++i2]);
        }
        if (this.host == null) {
            this.host = InetAddress.getLocalHost();
        }
    }

    @Override
    public void receiver(RtReceiver receiver) {
        this.receiver = receiver;
    }

    @Override
    public Object localAddress() {
        return null;
    }

    @Override
    public List<? extends Object> clusterMembers() {
        return null;
    }

    @Override
    public void start(String ... options) throws Exception {
        this.options(options);
        if (this.server) {
            this.srv_channel = ServerSocketChannel.open();
            this.srv_channel.bind(new InetSocketAddress(this.host, this.port), 50);
            System.out.println("server started (ctrl-c to kill)");
            while (true) {
                this.client_channel = this.srv_channel.accept();
                this.receiver_thread = new Receiver();
                this.receiver_thread.start();
            }
        }
        this.client_channel = SocketChannel.open();
        this.client_channel.connect(new InetSocketAddress(this.host, this.port));
        this.receiver_thread = new Receiver();
        this.receiver_thread.start();
    }

    @Override
    public void stop() {
        Util.close(this.srv_channel, this.client_channel);
    }

    @Override
    public void send(Object dest, byte[] buf, int offset, int length) throws Exception {
        ByteBuffer sbuf = ByteBuffer.wrap(buf, offset, length);
        this.client_channel.write(sbuf);
    }

    protected class Receiver
    extends Thread {
        protected Receiver() {
        }

        @Override
        public void run() {
            ByteBuffer buf = NioTransport.this.direct_buffers ? ByteBuffer.allocateDirect(11) : ByteBuffer.allocate(11);
            block2: while (true) {
                try {
                    while (true) {
                        buf.position(0);
                        int num = NioTransport.this.client_channel.read(buf);
                        if (num == -1) break block2;
                        if (num != 11) {
                            throw new IllegalStateException("expected 11 bytes, but got only " + num);
                        }
                        if (NioTransport.this.receiver == null) continue;
                        buf.flip();
                        int offset = buf.hasArray() ? buf.arrayOffset() + buf.position() : buf.position();
                        int len = buf.remaining();
                        if (!buf.isDirect()) {
                            NioTransport.this.receiver.receive(null, buf.array(), offset, len);
                            continue;
                        }
                        byte[] tmp = new byte[len];
                        buf.get(tmp, 0, len);
                        NioTransport.this.receiver.receive(null, tmp, 0, len);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            Util.close((Closeable)NioTransport.this.client_channel);
        }
    }
}

