/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.Util;

public class RoundTripRpc
implements Receiver {
    protected JChannel channel;
    protected RpcDispatcher disp;
    protected int num_msgs = 20000;
    protected int num_senders = 1;
    protected boolean oob = true;
    protected boolean dont_bundle;
    protected boolean details;
    protected Invoker[] invokers;
    protected static final Method requestMethod;

    protected void start(String props, String name) throws Exception {
        this.channel = new JChannel(props).name(name);
        this.disp = new RpcDispatcher(this.channel, this).setReceiver(this);
        this.disp.setMethodLookup(ignored -> requestMethod);
        this.channel.connect("rt");
        View view = this.channel.getView();
        if (view.size() > 2) {
            System.err.printf("More than 2 members found (%s); terminating\n", view);
        } else {
            this.loop();
        }
        Util.close(this.channel, this.disp);
    }

    public static short request(short id) {
        return id;
    }

    @Override
    public void viewAccepted(View view) {
        System.out.println("view = " + String.valueOf(view));
    }

    protected void loop() {
        boolean looping = true;
        while (looping) {
            int c = Util.keyPress(String.format("[1] send [2] num_msgs (%d) [3] senders (%d)\n[o] oob (%b) [b] dont_bundle (%b) [d] details (%b) [x] exit\n", this.num_msgs, this.num_senders, this.oob, this.dont_bundle, this.details));
            try {
                switch (c) {
                    case 49: {
                        this.invokeRequests();
                        break;
                    }
                    case 50: {
                        this.num_msgs = Util.readIntFromStdin("num_msgs: ");
                        break;
                    }
                    case 51: {
                        this.num_senders = Util.readIntFromStdin("num_senders: ");
                        break;
                    }
                    case 111: {
                        this.oob = !this.oob;
                        break;
                    }
                    case 98: {
                        this.dont_bundle = !this.dont_bundle;
                        break;
                    }
                    case 100: {
                        this.details = !this.details;
                        break;
                    }
                    case -1: 
                    case 120: {
                        looping = false;
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    protected void invokeRequests() throws Exception {
        View view = this.channel.getView();
        if (view.size() != 2) {
            System.err.printf("Cluster must have exactly 2 members: %s\n", view);
            return;
        }
        Address target = Util.pickNext(view.getMembers(), this.channel.getAddress());
        CountDownLatch latch = new CountDownLatch(1);
        AtomicInteger sent_msgs = new AtomicInteger(0);
        this.invokers = new Invoker[this.num_senders];
        for (int i2 = 0; i2 < this.num_senders; ++i2) {
            this.invokers[i2] = new Invoker((short)i2, latch, sent_msgs, target);
            this.invokers[i2].start();
        }
        long start = System.nanoTime();
        latch.countDown();
        for (Invoker invoker : this.invokers) {
            invoker.join();
        }
        long total_time = System.nanoTime() - start;
        double msgs_sec = (double)this.num_msgs / ((double)total_time / 1.0E9);
        AverageMinMax avg = null;
        if (this.details) {
            System.out.println("");
        }
        for (Invoker invoker : this.invokers) {
            if (this.details) {
                System.out.printf("%d: %s\n", invoker.id, RoundTripRpc.print(invoker.avg));
            }
            if (avg == null) {
                avg = invoker.avg;
                continue;
            }
            avg.merge(invoker.avg);
        }
        System.out.printf(Util.bold("\n\nreqs/sec = %.2f, round-trip = min/avg/max: %.2f / %.2f / %.2f us\n\n"), msgs_sec, (double)avg.min() / 1000.0, avg.average() / 1000.0, (double)avg.max() / 1000.0);
    }

    protected static String print(AverageMinMax avg) {
        return String.format("round-trip min/avg/max = %.2f / %.2f / %.2f us", (double)avg.min() / 1000.0, avg.average() / 1000.0, (double)avg.max() / 1000.0);
    }

    public static void main(String[] args) throws Exception {
        String props = null;
        String name = null;
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (args[i2].equals("-props")) {
                props = args[++i2];
                continue;
            }
            if (args[i2].equals("-name")) {
                name = args[++i2];
                continue;
            }
            RoundTripRpc.help();
            return;
        }
        new RoundTripRpc().start(props, name);
    }

    private static void help() {
        System.out.println("RoundTripRpc [-props <properties>] [-name name]");
    }

    static {
        try {
            requestMethod = RoundTripRpc.class.getDeclaredMethod("request", Short.TYPE);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    protected class Invoker
    extends Thread {
        protected final short id;
        protected final CountDownLatch latch;
        protected final AtomicInteger sent_msgs;
        protected final int print;
        protected final Address target;
        protected final AverageMinMax avg = new AverageMinMax();

        public Invoker(short id, CountDownLatch latch, AtomicInteger sent_msgs, Address target) {
            this.id = id;
            this.latch = latch;
            this.sent_msgs = sent_msgs;
            this.target = target;
            this.print = Math.max(1, RoundTripRpc.this.num_msgs / 10);
        }

        @Override
        public void run() {
            int num;
            try {
                this.latch.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            RequestOptions opts = new RequestOptions(ResponseMode.GET_ALL, 0L);
            if (RoundTripRpc.this.oob) {
                opts.flags(Message.Flag.OOB);
            }
            if (RoundTripRpc.this.dont_bundle) {
                opts.flags(Message.Flag.DONT_BUNDLE);
            }
            MethodCall call = new MethodCall(1, this.id);
            while ((num = this.sent_msgs.getAndIncrement()) <= RoundTripRpc.this.num_msgs) {
                if (num > 0 && num % this.print == 0) {
                    System.out.printf(".", new Object[0]);
                }
                try {
                    long start = System.nanoTime();
                    RoundTripRpc.this.disp.callRemoteMethod(this.target, call, opts);
                    long time = System.nanoTime() - start;
                    this.avg.add(time);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

