/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.jgroups.Address;
import org.jgroups.BytesMessage;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.MessageFactory;
import org.jgroups.View;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.conf.AttributeType;
import org.jgroups.protocols.FragHeader;
import org.jgroups.protocols.Fragmentation;
import org.jgroups.util.ByteArray;
import org.jgroups.util.FastArray;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.Util;

public class FRAG
extends Fragmentation {
    protected final FragmentationList fragment_list = new FragmentationList();
    protected final AtomicInteger curr_id = new AtomicInteger(1);
    protected final List<Address> members = new ArrayList<Address>(11);
    protected MessageFactory msg_factory;
    protected final Predicate<Message> HAS_FRAG_HEADER = msg -> msg.getHeader(this.id) != null;
    @ManagedAttribute(description="Number of sent messages", type=AttributeType.SCALAR)
    long num_sent_msgs;
    @ManagedAttribute(description="Number of received messages", type=AttributeType.SCALAR)
    long num_received_msgs;

    public long getNumberOfSentMessages() {
        return this.num_sent_msgs;
    }

    public long getNumberOfReceivedMessages() {
        return this.num_received_msgs;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.msg_factory = this.getTransport().getMessageFactory();
        HashMap<String, Integer> info = new HashMap<String, Integer>(1);
        info.put("frag_size", this.frag_size);
        this.down_prot.down(new Event(56, info));
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_received_msgs = 0L;
        this.num_sent_msgs = 0L;
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.handleViewChange((View)evt.getArg());
            }
        }
        return super.down(evt);
    }

    @Override
    public Object down(Message msg) {
        int size = msg.size();
        ++this.num_sent_msgs;
        if (size > this.frag_size) {
            if (this.log.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder("message size is ");
                sb.append(size).append(", will fragment (frag_size=").append(this.frag_size).append(')');
                this.log.trace(sb.toString());
            }
            this.fragment(msg);
            return null;
        }
        return this.down_prot.down(msg);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.handleViewChange((View)evt.getArg());
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object up(Message msg) {
        FragHeader hdr = (FragHeader)msg.getHeader(this.id);
        if (hdr != null) {
            Message assembled_msg = this.unfragment(msg, hdr);
            if (assembled_msg != null) {
                this.up_prot.up(assembled_msg);
            }
            return null;
        }
        ++this.num_received_msgs;
        return this.up_prot.up(msg);
    }

    @Override
    public void up(MessageBatch batch) {
        FastArray.FastIterator it = (FastArray.FastIterator)batch.iteratorWithFilter(this.HAS_FRAG_HEADER);
        while (it.hasNext()) {
            FragHeader hdr;
            Message msg = (Message)it.next();
            Message assembled_msg = this.unfragment(msg, hdr = (FragHeader)msg.getHeader(this.id));
            if (assembled_msg != null) {
                it.replace(assembled_msg);
                continue;
            }
            it.remove();
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    private void handleViewChange(View view) {
        List<Address> new_mbrs = view.getMembers();
        List<Address> left_mbrs = Util.determineLeftMembers(this.members, new_mbrs);
        this.members.clear();
        this.members.addAll(new_mbrs);
        for (Address mbr : left_mbrs) {
            this.fragment_list.remove(mbr);
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace("[VIEW_CHANGE] removed " + String.valueOf(mbr) + " from fragmentation table");
        }
    }

    private void fragment(Message msg) {
        Address dest = msg.getDest();
        Address src = msg.getSrc();
        long frag_id = this.curr_id.getAndIncrement();
        try {
            ByteArray tmp = Util.messageToBuffer(msg);
            byte[] buffer = tmp.getArray();
            byte[][] fragments = Util.fragmentBuffer(buffer, this.frag_size, tmp.getLength());
            int num_frags = fragments.length;
            this.num_frags_sent.add(num_frags);
            if (this.log.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("fragmenting packet to ").append(dest != null ? dest.toString() : "<all members>").append(" (size=").append(buffer.length).append(") into ").append(num_frags).append(" fragment(s) [frag_size=").append(this.frag_size).append(']');
                this.log.trace(sb.toString());
            }
            for (int i2 = 0; i2 < num_frags; ++i2) {
                Message frag_msg = new BytesMessage(dest, fragments[i2]).setSrc(src).setFlag(msg.getFlags(true), true).setFlag(msg.getFlags(false), false).putHeader(this.id, new FragHeader(frag_id, i2, num_frags));
                this.down_prot.down(frag_msg);
            }
        }
        catch (Exception e) {
            this.log.error(Util.getMessage("ExceptionOccurredTryingToFragmentMessage"), e);
        }
    }

    private Message unfragment(Message msg, FragHeader hdr) {
        Address sender = msg.getSrc();
        FragmentationTable frag_table = this.fragment_list.get(sender);
        if (frag_table == null) {
            frag_table = new FragmentationTable(sender);
            try {
                this.fragment_list.add(sender, frag_table);
            }
            catch (IllegalArgumentException x) {
                frag_table = this.fragment_list.get(sender);
            }
        }
        this.num_frags_received.add(1L);
        byte[] buf = frag_table.add(hdr.id, hdr.frag_id, hdr.num_frags, msg.getArray());
        if (buf == null) {
            return null;
        }
        try {
            Message assembled_msg = Util.messageFromBuffer(buf, 0, buf.length, this.msg_factory);
            assembled_msg.setSrc(sender);
            if (this.log.isTraceEnabled()) {
                this.log.trace("assembled_msg is " + String.valueOf(assembled_msg));
            }
            ++this.num_received_msgs;
            return assembled_msg;
        }
        catch (Exception e) {
            this.log.error(Util.getMessage("FailedUnfragmentingAMessage"), e);
            return null;
        }
    }

    static class FragmentationList {
        private final HashMap<Address, FragmentationTable> frag_tables = new HashMap(11);

        FragmentationList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Address sender, FragmentationTable table) throws IllegalArgumentException {
            HashMap<Address, FragmentationTable> hashMap = this.frag_tables;
            synchronized (hashMap) {
                FragmentationTable healthCheck = this.frag_tables.get(sender);
                if (healthCheck != null) {
                    throw new IllegalArgumentException("Sender <" + String.valueOf(sender) + "> already exists in the fragementation list");
                }
                this.frag_tables.put(sender, table);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FragmentationTable get(Address sender) {
            HashMap<Address, FragmentationTable> hashMap = this.frag_tables;
            synchronized (hashMap) {
                return this.frag_tables.get(sender);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsSender(Address sender) {
            HashMap<Address, FragmentationTable> hashMap = this.frag_tables;
            synchronized (hashMap) {
                return this.frag_tables.containsKey(sender);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Address sender) {
            HashMap<Address, FragmentationTable> hashMap = this.frag_tables;
            synchronized (hashMap) {
                boolean result = this.containsSender(sender);
                this.frag_tables.remove(sender);
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Address[] getSenders() {
            Address[] result;
            int index = 0;
            HashMap<Address, FragmentationTable> hashMap = this.frag_tables;
            synchronized (hashMap) {
                result = new Address[this.frag_tables.size()];
                Iterator<Address> it = this.frag_tables.keySet().iterator();
                while (it.hasNext()) {
                    result[index++] = it.next();
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuilder buf = new StringBuilder("Fragmentation list contains ");
            HashMap<Address, FragmentationTable> hashMap = this.frag_tables;
            synchronized (hashMap) {
                buf.append(this.frag_tables.size()).append(" tables\n");
                for (Map.Entry<Address, FragmentationTable> entry : this.frag_tables.entrySet()) {
                    buf.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
                }
            }
            return buf.toString();
        }
    }

    static class FragmentationTable {
        private final Address sender;
        private final Map<Long, FragEntry> table = new HashMap<Long, FragEntry>(11);

        FragmentationTable(Address sender) {
            this.sender = sender;
        }

        public synchronized byte[] add(long id, int frag_id, int tot_frags, byte[] fragment) {
            byte[] retval = null;
            FragEntry e = this.table.get(id);
            if (e == null) {
                e = new FragEntry(id, tot_frags);
                this.table.put(id, e);
            }
            e.set(frag_id, fragment);
            if (e.isComplete()) {
                retval = e.assembleBuffer();
                this.table.remove(id);
            }
            return retval;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder("Fragmentation Table Sender:").append(this.sender).append("\n\t");
            for (FragEntry entry : this.table.values()) {
                int count = 0;
                for (int i2 = 0; i2 < entry.fragments.length; ++i2) {
                    if (entry.fragments[i2] == null) continue;
                    ++count;
                }
                buf.append("Message ID:").append(entry.msg_id).append("\n\t");
                buf.append("Total Frags:").append(entry.tot_frags).append("\n\t");
                buf.append("Frags Received:").append(count).append("\n\n");
            }
            return buf.toString();
        }

        static class FragEntry {
            int tot_frags = 0;
            byte[][] fragments = null;
            int number_of_frags_recvd = 0;
            long msg_id = -1L;

            FragEntry(long msg_id, int tot_frags) {
                this.msg_id = msg_id;
                this.tot_frags = tot_frags;
                this.fragments = new byte[tot_frags][];
                for (int i2 = 0; i2 < tot_frags; ++i2) {
                    this.fragments[i2] = null;
                }
            }

            public void set(int frag_id, byte[] frag) {
                this.fragments[frag_id] = frag;
                ++this.number_of_frags_recvd;
            }

            public boolean isComplete() {
                if (this.number_of_frags_recvd < this.tot_frags) {
                    return false;
                }
                for (int i2 = 0; i2 < this.fragments.length; ++i2) {
                    if (this.fragments[i2] != null) continue;
                    return false;
                }
                return true;
            }

            public byte[] assembleBuffer() {
                return Util.defragmentBuffer(this.fragments);
            }

            public String toString() {
                StringBuilder ret = new StringBuilder();
                ret.append("[tot_frags=").append(this.tot_frags).append(", number_of_frags_recvd=").append(this.number_of_frags_recvd).append(']');
                return ret.toString();
            }

            public int hashCode() {
                return super.hashCode();
            }
        }
    }
}

