/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.conf.AttributeType;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

@Experimental
@MBean(description="Protocol just above the transport which disseminates multicasts via daisy chaining")
public class DAISYCHAIN
extends Protocol {
    @Property(description="Loop back multicast messages")
    boolean loopback = true;
    @ManagedAttribute(description="The member to which all multicasts are forwarded")
    protected volatile Address next;
    @ManagedAttribute(description="The current view")
    protected volatile View view;
    @ManagedAttribute(type=AttributeType.SCALAR)
    protected int msgs_forwarded;
    @ManagedAttribute(type=AttributeType.SCALAR)
    protected int msgs_sent;
    protected TP transport;

    @Override
    public void resetStats() {
        super.resetStats();
        this.msgs_sent = 0;
        this.msgs_forwarded = 0;
    }

    @Override
    public void init() throws Exception {
        this.transport = this.getTransport();
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.handleView((View)evt.getArg());
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object down(Message msg) {
        if (msg.getDest() != null) {
            return this.down_prot.down(msg);
        }
        if (this.next == null) {
            return this.down_prot.down(msg);
        }
        if (this.loopback) {
            if (msg.getSrc() == null && this.local_addr != null) {
                msg.setSrc(this.local_addr);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("%s: looping back message %s", this.local_addr, msg);
            }
            this.transport.loopback(msg, true);
        }
        Message copy = msg.copy(true, true).setDest(this.next).putHeader(this.getId(), new DaisyHeader(this.local_addr));
        ++this.msgs_sent;
        if (this.log.isTraceEnabled()) {
            this.log.trace("%s: forwarding multicast message %s (hdrs: %s) to %s", this.local_addr, msg, msg.getHeaders(), this.next);
        }
        return this.down_prot.down(copy);
    }

    @Override
    public Object up(Message msg) {
        DaisyHeader hdr = (DaisyHeader)msg.getHeader(this.getId());
        if (hdr == null) {
            return this.up_prot.up(msg);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("%s: received message from %s with original sender=%s", this.local_addr, msg.getSrc(), hdr.getOriginalSender());
        }
        if (this.next != null && !this.next.equals(hdr.getOriginalSender())) {
            Message copy = msg.copy(true, true).setSrc(null).setDest(this.next);
            ++this.msgs_forwarded;
            if (this.log.isTraceEnabled()) {
                this.log.trace("%s: forwarding message to %s", this.local_addr, this.next);
            }
            this.down_prot.down(copy);
        }
        msg.setDest(null).setSrc(hdr.getOriginalSender());
        return this.up_prot.up(msg);
    }

    protected void handleView(View view) {
        this.view = view;
        Address tmp = Util.pickNext(view.getMembers(), this.local_addr);
        if (tmp != null && !tmp.equals(this.local_addr)) {
            this.next = tmp;
            this.log.debug("%s: next=%s", this.local_addr, this.next);
        } else {
            this.next = null;
        }
    }

    public static class DaisyHeader
    extends Header {
        protected Address original_sender;

        public DaisyHeader() {
        }

        public DaisyHeader(Address original_sender) {
            this.original_sender = original_sender;
        }

        @Override
        public short getMagicId() {
            return 69;
        }

        public Address getOriginalSender() {
            return this.original_sender;
        }

        public DaisyHeader setOriginalSender(Address s2) {
            this.original_sender = s2;
            return null;
        }

        @Override
        public Supplier<? extends Header> create() {
            return DaisyHeader::new;
        }

        @Override
        public int serializedSize() {
            return Util.size(this.original_sender);
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            Util.writeAddress(this.original_sender, out);
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            this.original_sender = Util.readAddress(in);
        }

        @Override
        public String toString() {
            return "original sender=" + String.valueOf(this.original_sender);
        }
    }
}

