/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import javax.swing.JComponent;
import org.jdesktop.swingx.painter.AbstractPainter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PinstripePainter
extends AbstractPainter<Object> {
    private double angle = 45.0;
    private double spacing = 8.0;
    private double stripeWidth = 1.0;
    private Paint paint;

    public PinstripePainter() {
    }

    public PinstripePainter(Paint paint) {
        this(paint, 45.0);
    }

    public PinstripePainter(Paint paint, double angle) {
        this.paint = paint;
        this.angle = angle;
    }

    public PinstripePainter(double angle) {
        this.angle = angle;
    }

    public PinstripePainter(Paint paint, double angle, double stripeWidth, double spacing) {
        this.paint = paint;
        this.angle = angle;
        this.stripeWidth = stripeWidth;
        this.spacing = spacing;
    }

    public void setPaint(Paint p) {
        Paint old = this.getPaint();
        this.paint = p;
        this.firePropertyChange("paint", old, this.getPaint());
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setAngle(double angle) {
        if (angle > 360.0) {
            angle %= 360.0;
        }
        if (angle < 0.0) {
            angle = 360.0 - angle * -1.0 % 360.0;
        }
        double old = this.getAngle();
        this.angle = angle;
        this.firePropertyChange("angle", old, this.getAngle());
    }

    public double getAngle() {
        return this.angle;
    }

    public void setSpacing(double spacing) {
        double old = this.getSpacing();
        this.spacing = spacing;
        this.firePropertyChange("spacing", old, this.getSpacing());
    }

    public double getSpacing() {
        return this.spacing;
    }

    @Override
    protected void doPaint(Graphics2D g2, Object component, int width, int height) {
        Shape oldClip = g2.getClip();
        Area area = new Area(new Rectangle(0, 0, width, height));
        if (oldClip != null) {
            area = new Area(oldClip);
        }
        area.intersect(new Area(new Rectangle(0, 0, width, height)));
        g2.setClip(area);
        Paint p = this.getPaint();
        if (p == null) {
            if (component instanceof JComponent) {
                g2.setColor(((JComponent)component).getForeground());
            }
        } else {
            g2.setPaint(p);
        }
        g2.setStroke(new BasicStroke((float)this.getStripeWidth()));
        double hypLength = Math.sqrt(width * width + height * height);
        double radians2 = Math.toRadians(this.getAngle());
        g2.rotate(radians2);
        double spacing = this.getSpacing();
        int numLines = (int)(hypLength / (spacing += this.getStripeWidth()));
        for (int i2 = 0; i2 < numLines; ++i2) {
            double x = (double)i2 * spacing;
            Line2D.Double line = new Line2D.Double(x, -hypLength, x, hypLength);
            g2.draw(line);
        }
        g2.setClip(oldClip);
    }

    public double getStripeWidth() {
        return this.stripeWidth;
    }

    public void setStripeWidth(double stripeWidth) {
        double oldSripeWidth = this.getStripeWidth();
        this.stripeWidth = stripeWidth;
        this.firePropertyChange("stripeWidth", new Double(oldSripeWidth), new Double(stripeWidth));
    }
}

