/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.auth;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class UserPermissions {
    private static final UserPermissions INSTANCE = new UserPermissions();
    private PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
    private String[] roles;

    private UserPermissions() {
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChange.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        this.propertyChange.addPropertyChangeListener(name, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChange.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        this.propertyChange.removePropertyChangeListener(name, listener);
    }

    public static UserPermissions getInstance() {
        return INSTANCE;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public boolean isUserInRole(String role) {
        if (this.roles != null) {
            for (int iter2 = 0; iter2 < this.roles.length; ++iter2) {
                if (!this.roles[iter2].equals(role)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isUserInARole(String[] roles) {
        for (int iter2 = 0; iter2 < roles.length; ++iter2) {
            if (!this.isUserInRole(roles[iter2])) continue;
            return true;
        }
        return false;
    }

    public boolean isUserInRoles(String[] roles) {
        for (int iter2 = 0; iter2 < roles.length; ++iter2) {
            if (this.isUserInRole(roles[iter2])) continue;
            return false;
        }
        return true;
    }

    void setRoles(String[] roles) {
        String[] oldValue = this.roles;
        this.roles = roles;
        this.propertyChange.firePropertyChange("roles", oldValue, roles);
    }
}

