/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.MouseInputAdapter;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.color.ColorUtil;
import org.jdesktop.swingx.error.ErrorListener;
import org.jdesktop.swingx.error.ErrorSupport;
import org.jdesktop.swingx.graphics.GraphicsUtilities;

public class JXImageView
extends JXPanel {
    private Logger log = Logger.getLogger(JXImageView.class.getName());
    private Image image;
    private URL imageURL;
    private ErrorSupport errorSupport = new ErrorSupport(this);
    private Point2D imageLocation;
    private Paint checkerPaint;
    private double scale = 1.0;
    private boolean editable = true;
    private MoveHandler moveHandler = new MoveHandler(this);
    private boolean dragEnabled = false;
    private String exportName = "UntitledImage";
    private String exportFormat = "png";

    public JXImageView() {
        this.checkerPaint = ColorUtil.getCheckerPaint(Color.white, new Color(250, 250, 250), 50);
        this.setEditable(true);
    }

    public Point2D getImageLocation() {
        return this.imageLocation;
    }

    public void setImageLocation(Point2D imageLocation) {
        Point2D old = this.getImageLocation();
        this.imageLocation = imageLocation;
        this.firePropertyChange("imageLocation", old, this.getImageLocation());
        this.repaint();
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        Image oldImage = this.getImage();
        this.image = image;
        this.setImageLocation(null);
        this.setScale(1.0);
        this.firePropertyChange("image", oldImage, image);
        this.repaint();
    }

    public void setImage(URL url) throws IOException {
        this.setImageURL(url);
    }

    public void setImage(File file) throws IOException {
        this.setImageURL(file.toURI().toURL());
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        double oldScale = this.scale;
        this.scale = scale;
        this.firePropertyChange("scale", oldScale, scale);
        this.repaint();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        boolean old = this.isEditable();
        this.editable = editable;
        if (editable) {
            this.addMouseMotionListener(this.moveHandler);
            this.addMouseListener(this.moveHandler);
            this.setCursor(Cursor.getPredefinedCursor(12));
            try {
                this.setTransferHandler(new DnDHandler());
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
                this.fireError(ex);
            }
        } else {
            this.removeMouseMotionListener(this.moveHandler);
            this.removeMouseListener(this.moveHandler);
            this.setCursor(Cursor.getDefaultCursor());
            this.setTransferHandler(null);
        }
        this.firePropertyChange("editable", old, this.isEditable());
    }

    public void setDragEnabled(boolean dragEnabled) {
        boolean old = this.isDragEnabled();
        this.dragEnabled = dragEnabled;
        this.firePropertyChange("dragEnabled", old, this.isDragEnabled());
    }

    public boolean isDragEnabled() {
        return this.dragEnabled;
    }

    public void addErrorListener(ErrorListener el) {
        this.errorSupport.addErrorListener(el);
    }

    public void removeErrorListener(ErrorListener el) {
        this.errorSupport.removeErrorListener(el);
    }

    protected void fireError(Throwable throwable) {
        this.errorSupport.fireErrorEvent(throwable);
    }

    private static FileDialog getSafeFileDialog(Component comp) {
        Window win = SwingUtilities.windowForComponent(comp);
        if (win instanceof Dialog) {
            return new FileDialog((Dialog)win);
        }
        if (win instanceof Frame) {
            return new FileDialog((Frame)win);
        }
        return null;
    }

    @Deprecated
    public Action getOpenAction() {
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileDialog fd = JXImageView.getSafeFileDialog(JXImageView.this);
                fd.setMode(0);
                fd.setVisible(true);
                if (fd.getFile() != null) {
                    try {
                        JXImageView.this.setImage(new File(fd.getDirectory(), fd.getFile()));
                    }
                    catch (IOException ex) {
                        JXImageView.this.fireError(ex);
                    }
                }
            }
        };
        action.putValue("Name", "Open");
        return action;
    }

    @Deprecated
    public Action getSaveAction() {
        AbstractAction action = new AbstractAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent evt) {
                Image img = JXImageView.this.getImage();
                BufferedImage dst = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
                Graphics2D g2 = (Graphics2D)dst.getGraphics();
                try {
                    g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                    g2.drawImage(img, 0, 0, null);
                }
                finally {
                    g2.dispose();
                }
                FileDialog fd = new FileDialog((Frame)SwingUtilities.windowForComponent(JXImageView.this));
                fd.setMode(1);
                fd.setVisible(true);
                if (fd.getFile() != null) {
                    try {
                        ImageIO.write((RenderedImage)dst, "png", new File(fd.getDirectory(), fd.getFile()));
                    }
                    catch (IOException ex) {
                        JXImageView.this.fireError(ex);
                    }
                }
            }
        };
        action.putValue("Name", "Save");
        return action;
    }

    @Deprecated
    public Action getRotateClockwiseAction() {
        AbstractAction action = new AbstractAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent evt) {
                Image img = JXImageView.this.getImage();
                BufferedImage src = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
                BufferedImage dst = new BufferedImage(img.getHeight(null), img.getWidth(null), 2);
                Graphics2D g2 = (Graphics2D)src.getGraphics();
                try {
                    g2.drawImage(img, 0, 0, null);
                }
                finally {
                    g2.dispose();
                }
                AffineTransform trans = AffineTransform.getRotateInstance(1.5707963267948966, 0.0, 0.0);
                trans.translate(0.0, -src.getHeight());
                AffineTransformOp op = new AffineTransformOp(trans, 1);
                op.filter(src, dst);
                JXImageView.this.setImage(dst);
            }
        };
        action.putValue("Name", "Rotate Clockwise");
        return action;
    }

    @Deprecated
    public Action getRotateCounterClockwiseAction() {
        AbstractAction action = new AbstractAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent evt) {
                Image img = JXImageView.this.getImage();
                BufferedImage src = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
                BufferedImage dst = new BufferedImage(img.getHeight(null), img.getWidth(null), 2);
                Graphics2D g2 = (Graphics2D)src.getGraphics();
                try {
                    g2.drawImage(img, 0, 0, null);
                }
                finally {
                    g2.dispose();
                }
                AffineTransform trans = AffineTransform.getRotateInstance(-1.5707963267948966, 0.0, 0.0);
                trans.translate(-src.getWidth(), 0.0);
                AffineTransformOp op = new AffineTransformOp(trans, 1);
                op.filter(src, dst);
                JXImageView.this.setImage(dst);
            }
        };
        action.putValue("Name", "Rotate CounterClockwise");
        return action;
    }

    @Deprecated
    public Action getZoomOutAction() {
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JXImageView.this.setScale(JXImageView.this.getScale() * 0.5);
            }
        };
        action.putValue("Name", "Zoom Out");
        return action;
    }

    @Deprecated
    public Action getZoomInAction() {
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JXImageView.this.setScale(JXImageView.this.getScale() * 2.0);
            }
        };
        action.putValue("Name", "Zoom In");
        return action;
    }

    protected void paintComponent(Graphics g2) {
        ((Graphics2D)g2).setPaint(this.checkerPaint);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.getImage() != null) {
            Point2D center = new Point2D.Double(this.getWidth() / 2, this.getHeight() / 2);
            if (this.getImageLocation() != null) {
                center = this.getImageLocation();
            }
            Point2D.Double loc = new Point2D.Double();
            double width = (double)this.getImage().getWidth(null) * this.getScale();
            double height = (double)this.getImage().getHeight(null) * this.getScale();
            ((Point2D)loc).setLocation(center.getX() - width / 2.0, center.getY() - height / 2.0);
            g2.drawImage(this.getImage(), (int)((Point2D)loc).getX(), (int)((Point2D)loc).getY(), (int)width, (int)height, null);
        }
    }

    public String getExportName() {
        return this.exportName;
    }

    public void setExportName(String exportName) {
        String old = this.getExportName();
        this.exportName = exportName;
        this.firePropertyChange("exportName", old, this.getExportName());
    }

    public String getExportFormat() {
        return this.exportFormat;
    }

    public void setExportFormat(String exportFormat) {
        String old = this.getExportFormat();
        this.exportFormat = exportFormat;
        this.firePropertyChange("exportFormat", old, this.getExportFormat());
    }

    public URL getImageURL() {
        return this.imageURL;
    }

    public void setImageURL(URL imageURL) throws IOException {
        URL old = this.getImageURL();
        this.imageURL = imageURL;
        this.firePropertyChange("imageURL", old, this.getImageURL());
        this.setImage(ImageIO.read(this.getImageURL()));
    }

    public String getImageString() {
        if (this.getImageURL() == null) {
            return null;
        }
        return this.getImageURL().toString();
    }

    public void setImageString(String url) throws IOException {
        String old = this.getImageString();
        this.setImageURL(new URL(url));
        this.firePropertyChange("imageString", old, url);
    }

    private class ImageTransferable
    implements Transferable {
        private Image img;
        private List<File> files;
        private String exportName;
        private String exportFormat;

        public ImageTransferable(Image img, String exportName, String exportFormat) {
            this.img = img;
            this.exportName = exportName;
            this.exportFormat = exportFormat;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor, DataFlavor.javaFileListFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            if (flavor == DataFlavor.imageFlavor) {
                return true;
            }
            return flavor == DataFlavor.javaFileListFlavor;
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor == DataFlavor.imageFlavor) {
                return this.img;
            }
            if (flavor == DataFlavor.javaFileListFlavor) {
                if (this.files == null) {
                    this.files = new ArrayList<File>();
                    File file = File.createTempFile(this.exportName, "." + this.exportFormat);
                    ImageIO.write((RenderedImage)GraphicsUtilities.convertToBufferedImage(this.img), this.exportFormat, file);
                    this.files.add(file);
                }
                return this.files;
            }
            return null;
        }
    }

    private class DnDHandler
    extends TransferHandler {
        DataFlavor urlFlavor = new DataFlavor("application/x-java-url;class=java.net.URL");

        public void exportAsDrag(JComponent c, InputEvent evt, int action) {
            super.exportAsDrag(c, evt, action);
        }

        public int getSourceActions(JComponent c) {
            return 1;
        }

        protected void exportDone(JComponent source, Transferable data, int action) {
        }

        public boolean canImport(JComponent c, DataFlavor[] flavors) {
            for (int i2 = 0; i2 < flavors.length; ++i2) {
                if (DataFlavor.javaFileListFlavor.equals(flavors[i2])) {
                    return true;
                }
                if (DataFlavor.imageFlavor.equals(flavors[i2])) {
                    return true;
                }
                if (!this.urlFlavor.match(flavors[i2])) continue;
                return true;
            }
            return false;
        }

        protected Transferable createTransferable(JComponent c) {
            JXImageView view = (JXImageView)c;
            return new ImageTransferable(view.getImage(), view.getExportName(), view.getExportFormat());
        }

        public boolean importData(JComponent comp, Transferable t) {
            if (this.canImport(comp, t.getTransferDataFlavors())) {
                try {
                    List files;
                    if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && (files = (List)t.getTransferData(DataFlavor.javaFileListFlavor)).size() > 0) {
                        File file = (File)files.get(0);
                        JXImageView.this.setImageString(file.toURI().toURL().toString());
                        return true;
                    }
                    Object obj = t.getTransferData(this.urlFlavor);
                    if (obj instanceof URL) {
                        JXImageView.this.setImageString(((URL)obj).toString());
                    }
                    return true;
                }
                catch (Exception ex) {
                    JXImageView.this.log.severe(ex.getMessage());
                    ex.printStackTrace();
                    JXImageView.this.fireError(ex);
                }
            }
            return false;
        }
    }

    private class MoveHandler
    extends MouseInputAdapter {
        private JXImageView panel;
        private Point prev = null;
        private Point start = null;

        public MoveHandler(JXImageView panel) {
            this.panel = panel;
        }

        public void mousePressed(MouseEvent evt) {
            this.start = this.prev = evt.getPoint();
        }

        public void mouseDragged(MouseEvent evt) {
            Point curr = evt.getPoint();
            if (JXImageView.this.isDragEnabled() && curr.distance(this.start) > 5.0) {
                JXImageView.this.log.fine("starting the drag: ");
                this.panel.getTransferHandler().exportAsDrag((JComponent)evt.getSource(), evt, 1);
                return;
            }
            int offx = curr.x - this.prev.x;
            int offy = curr.y - this.prev.y;
            Point2D offset = JXImageView.this.getImageLocation();
            if (offset == null) {
                offset = JXImageView.this.image != null ? new Point2D.Double(JXImageView.this.getWidth() / 2, JXImageView.this.getHeight() / 2) : new Point2D.Double(0.0, 0.0);
            }
            offset = new Point2D.Double(offset.getX() + (double)offx, offset.getY() + (double)offy);
            JXImageView.this.setImageLocation(offset);
            this.prev = curr;
            JXImageView.this.repaint();
        }

        public void mouseReleased(MouseEvent evt) {
            this.prev = null;
        }
    }
}

