/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.handlers.FileHandler;
import org.jboss.logmanager.handlers.SuffixRotator;

public class PeriodicRotatingFileHandler
extends FileHandler {
    private SimpleDateFormat format;
    private String nextSuffix;
    private Period period = Period.NEVER;
    private long nextRollover = Long.MAX_VALUE;
    private TimeZone timeZone = TimeZone.getDefault();
    private SuffixRotator suffixRotator = SuffixRotator.EMPTY;

    public PeriodicRotatingFileHandler() {
    }

    public PeriodicRotatingFileHandler(String fileName) throws FileNotFoundException {
        super(fileName);
    }

    public PeriodicRotatingFileHandler(String fileName, boolean append) throws FileNotFoundException {
        super(fileName, append);
    }

    public PeriodicRotatingFileHandler(File file, String suffix) throws FileNotFoundException {
        super(file);
        this.setSuffix(suffix);
    }

    public PeriodicRotatingFileHandler(File file, String suffix, boolean append) throws FileNotFoundException {
        super(file, append);
        this.setSuffix(suffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFile(File file) throws FileNotFoundException {
        Object object = this.outputLock;
        synchronized (object) {
            super.setFile(file);
            if (this.format != null && file != null && file.lastModified() > 0L) {
                this.calcNextRollover(file.lastModified());
            }
        }
    }

    @Override
    protected void preWrite(ExtLogRecord record) {
        long recordMillis = record.getMillis();
        if (recordMillis >= this.nextRollover) {
            this.rollOver();
            this.calcNextRollover(recordMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSuffix(String suffix) throws IllegalArgumentException {
        SuffixRotator suffixRotator = SuffixRotator.parse(suffix);
        String dateSuffix = suffixRotator.getDatePattern();
        SimpleDateFormat format = new SimpleDateFormat(dateSuffix);
        format.setTimeZone(this.timeZone);
        int len = dateSuffix.length();
        Period period = Period.NEVER;
        block14: for (int i2 = 0; i2 < len; ++i2) {
            switch (dateSuffix.charAt(i2)) {
                case 'y': {
                    period = PeriodicRotatingFileHandler.min(period, Period.YEAR);
                    continue block14;
                }
                case 'M': {
                    period = PeriodicRotatingFileHandler.min(period, Period.MONTH);
                    continue block14;
                }
                case 'W': 
                case 'w': {
                    period = PeriodicRotatingFileHandler.min(period, Period.WEEK);
                    continue block14;
                }
                case 'D': 
                case 'E': 
                case 'F': 
                case 'd': {
                    period = PeriodicRotatingFileHandler.min(period, Period.DAY);
                    continue block14;
                }
                case 'a': {
                    period = PeriodicRotatingFileHandler.min(period, Period.HALF_DAY);
                    continue block14;
                }
                case 'H': 
                case 'K': 
                case 'h': 
                case 'k': {
                    period = PeriodicRotatingFileHandler.min(period, Period.HOUR);
                    continue block14;
                }
                case 'm': {
                    period = PeriodicRotatingFileHandler.min(period, Period.MINUTE);
                    continue block14;
                }
                case '\'': {
                    while (dateSuffix.charAt(++i2) != '\'') {
                    }
                    continue block14;
                }
                case 'S': 
                case 's': {
                    throw new IllegalArgumentException("Rotating by second or millisecond is not supported");
                }
            }
        }
        Object object = this.outputLock;
        synchronized (object) {
            this.format = format;
            this.period = period;
            this.suffixRotator = suffixRotator;
            File file = this.getFile();
            long now = file != null && file.lastModified() > 0L ? file.lastModified() : System.currentTimeMillis();
            this.calcNextRollover(now);
        }
    }

    protected final String getNextSuffix() {
        return this.nextSuffix;
    }

    SuffixRotator getSuffixRotator() {
        return this.suffixRotator;
    }

    private void rollOver() {
        try {
            File file = this.getFile();
            this.setFile(null);
            this.suffixRotator.rotate(this.getErrorManager(), file.toPath(), this.nextSuffix);
            this.setFile(file);
        }
        catch (IOException e) {
            this.reportError("Unable to rotate log file", e, 4);
        }
    }

    private void calcNextRollover(long fromTime) {
        if (this.period == Period.NEVER) {
            this.nextRollover = Long.MAX_VALUE;
            return;
        }
        this.nextSuffix = this.format.format(new Date(fromTime));
        Calendar calendar = Calendar.getInstance(this.timeZone);
        calendar.setTimeInMillis(fromTime);
        Period period = this.period;
        switch (period) {
            default: {
                calendar.set(2, 0);
            }
            case MONTH: {
                calendar.set(5, 1);
                calendar.clear(4);
            }
            case WEEK: {
                if (period == Period.WEEK) {
                    calendar.set(7, calendar.getFirstDayOfWeek());
                } else {
                    calendar.clear(7);
                }
                calendar.clear(8);
            }
            case DAY: {
                calendar.set(11, 0);
            }
            case HALF_DAY: {
                if (period == Period.HALF_DAY) {
                    calendar.set(10, 0);
                } else {
                    calendar.set(10, 0);
                    calendar.set(9, 0);
                }
            }
            case HOUR: {
                calendar.set(12, 0);
            }
            case MINUTE: 
        }
        calendar.set(13, 0);
        calendar.set(14, 0);
        switch (period) {
            case YEAR: {
                calendar.add(1, 1);
                break;
            }
            case MONTH: {
                calendar.add(2, 1);
                break;
            }
            case WEEK: {
                calendar.add(3, 1);
                break;
            }
            case DAY: {
                calendar.add(5, 1);
                break;
            }
            case HALF_DAY: {
                calendar.add(9, 1);
                break;
            }
            case HOUR: {
                calendar.add(11, 1);
                break;
            }
            case MINUTE: {
                calendar.add(12, 1);
            }
        }
        this.nextRollover = calendar.getTimeInMillis();
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            throw new NullPointerException("timeZone is null");
        }
        this.timeZone = timeZone;
    }

    private static <T extends Comparable<? super T>> T min(T a, T b) {
        return a.compareTo(b) <= 0 ? a : b;
    }

    public static enum Period {
        MINUTE,
        HOUR,
        HALF_DAY,
        DAY,
        WEEK,
        MONTH,
        YEAR,
        NEVER;

    }
}

