/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.LogManager;
import org.jboss.logmanager.Jvm;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.LogContext;

class LogLevelInitTask
implements PrivilegedAction<Void> {
    LogLevelInitTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void run() {
        AnnotatedElement knownField;
        if (Jvm.isModular()) {
            return null;
        }
        Class<java.util.logging.Level> lc = java.util.logging.Level.class;
        try {
            Class<java.util.logging.Level> clazz = lc;
            synchronized (clazz) {
                knownField = lc.getDeclaredField("known");
                ((Field)knownField).setAccessible(true);
                List old = (List)((Field)knownField).get(null);
                if (!(old instanceof ReadOnlyArrayList)) {
                    ((Field)knownField).set(null, new ReadOnlyArrayList<java.util.logging.Level>((Collection<java.util.logging.Level>)Arrays.asList(Level.TRACE, Level.DEBUG, Level.INFO, Level.WARN, Level.ERROR, Level.FATAL, java.util.logging.Level.ALL, java.util.logging.Level.FINEST, java.util.logging.Level.FINER, java.util.logging.Level.FINE, java.util.logging.Level.INFO, java.util.logging.Level.CONFIG, java.util.logging.Level.WARNING, java.util.logging.Level.SEVERE, java.util.logging.Level.OFF)));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Class<?> knownLevelClass = Class.forName("java.util.logging.Level$KnownLevel");
            knownField = knownLevelClass;
            synchronized (knownField) {
                Constructor<?> constructor = knownLevelClass.getDeclaredConstructor(java.util.logging.Level.class);
                constructor.setAccessible(true);
                boolean doBuild = false;
                boolean setNameToLevel = false;
                boolean setIntToLevel = false;
                Field nameToLevels = knownLevelClass.getDeclaredField("nameToLevels");
                nameToLevels.setAccessible(true);
                Map oldNameToLevels = (Map)nameToLevels.get(null);
                if (!(oldNameToLevels instanceof ReadOnlyHashMap)) {
                    doBuild = true;
                    setNameToLevel = true;
                }
                Field intToLevels = knownLevelClass.getDeclaredField("intToLevels");
                intToLevels.setAccessible(true);
                Map oldIntToLevels = (Map)intToLevels.get(null);
                if (!(oldIntToLevels instanceof ReadOnlyHashMap)) {
                    doBuild = true;
                    setIntToLevel = true;
                }
                if (doBuild) {
                    KnownLevelBuilder builder = new KnownLevelBuilder(constructor).add(Level.TRACE).add(Level.DEBUG).add(Level.INFO).add(Level.WARN).add(Level.ERROR).add(Level.FATAL).add(java.util.logging.Level.ALL).add(java.util.logging.Level.FINEST).add(java.util.logging.Level.FINER).add(java.util.logging.Level.FINE).add(java.util.logging.Level.INFO).add(java.util.logging.Level.CONFIG).add(java.util.logging.Level.WARNING).add(java.util.logging.Level.SEVERE).add(java.util.logging.Level.OFF);
                    if (setNameToLevel) {
                        nameToLevels.set(null, builder.toNameMap());
                    }
                    if (setIntToLevel) {
                        intToLevels.set(null, builder.toIntMap());
                    }
                }
            }
        }
        catch (Throwable knownLevelClass) {
            // empty catch block
        }
        try {
            Class<?> traceManagerClass = Class.forName("com.sun.jmx.trace.Trace");
            Field outField = traceManagerClass.getDeclaredField("out");
            outField.setAccessible(true);
            outField.set(null, null);
        }
        catch (Throwable traceManagerClass) {
            // empty catch block
        }
        Class<LogManager> lmc = LogManager.class;
        try {
            Class<LogManager> clazz = lmc;
            synchronized (clazz) {
                Field loggingMXBean = lmc.getDeclaredField("loggingMXBean");
                loggingMXBean.setAccessible(true);
                loggingMXBean.set(null, LogContext.getSystemLogContext().getLoggingMXBean());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    static class KnownLevelBuilder {
        private final Map<String, List<Object>> nameMap = new HashMap<String, List<Object>>();
        private final Map<Integer, List<Object>> intMap = new HashMap<Integer, List<Object>>();
        private final Constructor<?> constructor;

        KnownLevelBuilder(Constructor<?> constructor) {
            this.constructor = constructor;
        }

        public KnownLevelBuilder add(java.util.logging.Level level) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            String name = level.getName();
            Object knownLevel = this.constructor.newInstance(level);
            List<Object> nl = this.nameMap.get(name);
            if (nl == null) {
                nl = new ArrayList<Object>();
                this.nameMap.put(name, nl);
            }
            nl.add(this.constructor.newInstance(knownLevel));
            int intValue = level.intValue();
            List<Object> il = this.intMap.get(intValue);
            if (il == null) {
                il = new ArrayList<Object>();
                this.intMap.put(intValue, il);
            }
            il.add(knownLevel);
            return this;
        }

        public ReadOnlyHashMap<String, ReadOnlyArrayList<Object>> toNameMap() {
            ArrayList list = new ArrayList(this.nameMap.size());
            for (String key : this.nameMap.keySet()) {
                list.add(ReadOnlyMapEntry.of(key, ReadOnlyArrayList.of((Collection)this.nameMap.get(key))));
            }
            return ReadOnlyHashMap.of(list);
        }

        public ReadOnlyHashMap<Integer, ReadOnlyArrayList<Object>> toIntMap() {
            ArrayList list = new ArrayList(this.intMap.size());
            for (Integer key : this.intMap.keySet()) {
                list.add(ReadOnlyMapEntry.of(key, ReadOnlyArrayList.of((Collection)this.intMap.get(key))));
            }
            return ReadOnlyHashMap.of(list);
        }
    }

    static final class ReadOnlyMapEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        private ReadOnlyMapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        static <K, V> ReadOnlyMapEntry<K, V> of(K key, V value) {
            return new ReadOnlyMapEntry<K, V>(key, value);
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            return null;
        }
    }

    static final class ReadOnlyHashMap<K, V>
    extends HashMap<K, V> {
        private static final long serialVersionUID = -6048215349511680936L;

        ReadOnlyHashMap(int size) {
            super(size);
        }

        static <K, V> ReadOnlyHashMap<K, V> of(List<ReadOnlyMapEntry<K, V>> entries) {
            ReadOnlyHashMap<K, V> result = new ReadOnlyHashMap<K, V>(entries.size());
            for (ReadOnlyMapEntry<K, V> entry : entries) {
                super.add(entry.getKey(), entry.getValue());
            }
            return result;
        }

        private void add(K key, V value) {
            super.put(key, value);
        }

        @Override
        public V put(K key, V value) {
            return null;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m3) {
        }

        @Override
        public V remove(Object key) {
            return null;
        }

        @Override
        public void clear() {
        }

        @Override
        public Collection<V> values() {
            return new ReadOnlyArrayList(super.values());
        }
    }

    static final class ReadOnlyArrayList<T>
    extends ArrayList<T> {
        private static final long serialVersionUID = -6048215349511680936L;

        ReadOnlyArrayList(Collection<? extends T> c) {
            super(c);
        }

        static <T> ReadOnlyArrayList<T> of(Collection<? extends T> c) {
            return new ReadOnlyArrayList<T>(c);
        }

        @Override
        public T set(int index, T element) {
            return null;
        }

        @Override
        public T remove(int index) {
            return null;
        }

        @Override
        public boolean remove(Object o) {
            return false;
        }

        @Override
        public void clear() {
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
        }

        @Override
        public Iterator<T> iterator() {
            final Iterator superIter = super.iterator();
            return new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return superIter.hasNext();
                }

                @Override
                public T next() {
                    return superIter.next();
                }

                @Override
                public void remove() {
                }
            };
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            final ListIterator superIter = super.listIterator(index);
            return new ListIterator<T>(){

                @Override
                public boolean hasNext() {
                    return superIter.hasNext();
                }

                @Override
                public T next() {
                    return superIter.next();
                }

                @Override
                public boolean hasPrevious() {
                    return superIter.hasPrevious();
                }

                @Override
                public T previous() {
                    return superIter.previous();
                }

                @Override
                public int nextIndex() {
                    return superIter.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return superIter.previousIndex();
                }

                @Override
                public void remove() {
                }

                @Override
                public void set(T o) {
                }

                @Override
                public void add(T o) {
                }
            };
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return false;
        }
    }
}

