/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast;

import antlr.SemanticException;
import java.io.PrintStream;
import java.io.PrintWriter;
import org.hibernate.internal.build.AllowPrintStacktrace;

public class DetailedSemanticException
extends SemanticException {
    private Throwable cause;
    private boolean showCauseMessage = true;

    public DetailedSemanticException(String message) {
        super(message);
    }

    public DetailedSemanticException(String s2, Throwable e) {
        super(s2);
        this.cause = e;
    }

    @Override
    public String toString() {
        if (this.cause == null || !this.showCauseMessage) {
            return super.toString();
        }
        return super.toString() + "\n[cause=" + this.cause.toString() + "]";
    }

    @Override
    @AllowPrintStacktrace
    public void printStackTrace() {
        super.printStackTrace();
        if (this.cause != null) {
            this.cause.printStackTrace();
        }
    }

    @Override
    @AllowPrintStacktrace
    public void printStackTrace(PrintStream s2) {
        super.printStackTrace(s2);
        if (this.cause != null) {
            s2.println("Cause:");
            this.cause.printStackTrace(s2);
        }
    }

    @Override
    public void printStackTrace(PrintWriter w) {
        super.printStackTrace(w);
        if (this.cause != null) {
            w.println("Cause:");
            this.cause.printStackTrace(w);
        }
    }
}

