/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal.tracker;

import java.util.Arrays;
import org.hibernate.engine.spi.CompositeOwner;

public final class CompositeOwnerTracker {
    private String[] names = new String[0];
    private CompositeOwner[] owners = new CompositeOwner[0];

    public void add(String name, CompositeOwner owner) {
        for (int i2 = 0; i2 < this.names.length; ++i2) {
            if (!this.names[i2].equals(name)) continue;
            this.owners[i2] = owner;
            return;
        }
        this.names = Arrays.copyOf(this.names, this.names.length + 1);
        this.names[this.names.length - 1] = name;
        this.owners = Arrays.copyOf(this.owners, this.owners.length + 1);
        this.owners[this.owners.length - 1] = owner;
    }

    public void callOwner(String fieldName) {
        for (int i2 = 0; i2 < this.owners.length; ++i2) {
            if (this.owners[i2] == null) continue;
            this.owners[i2].$$_hibernate_trackChange(this.names[i2] + fieldName);
        }
    }

    public void removeOwner(String name) {
        for (int i2 = 0; i2 < this.names.length; ++i2) {
            if (!name.equals(this.names[i2])) continue;
            String[] newNames = Arrays.copyOf(this.names, this.names.length - 1);
            System.arraycopy(this.names, i2 + 1, newNames, i2, newNames.length - i2);
            this.names = newNames;
            CompositeOwner[] newOwners = Arrays.copyOf(this.owners, this.owners.length - 1);
            System.arraycopy(this.owners, i2 + 1, newOwners, i2, newOwners.length - i2);
            this.owners = newOwners;
            return;
        }
    }
}

