/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.stream.JsonParser;
import org.apache.johnzon.core.BufferStrategy;
import org.apache.johnzon.core.JohnzonJsonParser;
import org.apache.johnzon.core.JsonLongImpl;
import org.apache.johnzon.core.JsonNumberImpl;
import org.apache.johnzon.core.JsonReaderImpl;
import org.apache.johnzon.core.JsonStringImpl;
import org.apache.johnzon.core.RejectDuplicateKeysMode;

public abstract class JohnzonJsonParserImpl
implements JohnzonJsonParser {
    private boolean manualNext = false;

    protected abstract boolean isInArray();

    protected abstract boolean isInObject();

    protected abstract BufferStrategy.BufferProvider<char[]> getCharArrayProvider();

    @Override
    public JsonParser.Event next() {
        this.manualNext = true;
        return this.internalNext();
    }

    protected abstract JsonParser.Event internalNext();

    @Override
    public JsonObject getObject() {
        JsonParser.Event current = this.current();
        if (current != JsonParser.Event.START_OBJECT) {
            throw new IllegalStateException((Object)((Object)current) + " doesn't support getObject()");
        }
        JsonReaderImpl jsonReader = new JsonReaderImpl(this, true, this.getCharArrayProvider(), RejectDuplicateKeysMode.DEFAULT);
        return jsonReader.readObject();
    }

    @Override
    public JsonArray getArray() {
        JsonParser.Event current = this.current();
        if (current != JsonParser.Event.START_ARRAY) {
            throw new IllegalStateException((Object)((Object)current) + " doesn't support getArray()");
        }
        JsonReaderImpl jsonReader = new JsonReaderImpl(this, true, this.getCharArrayProvider(), RejectDuplicateKeysMode.DEFAULT);
        return jsonReader.readArray();
    }

    @Override
    public JsonValue getValue() {
        JsonParser.Event current = this.current();
        switch (current) {
            case START_ARRAY: 
            case START_OBJECT: {
                JsonReaderImpl jsonReader = new JsonReaderImpl(this, true, this.getCharArrayProvider(), RejectDuplicateKeysMode.DEFAULT);
                return jsonReader.readValue();
            }
            case VALUE_TRUE: {
                return JsonValue.TRUE;
            }
            case VALUE_FALSE: {
                return JsonValue.FALSE;
            }
            case VALUE_NULL: {
                return JsonValue.NULL;
            }
            case VALUE_STRING: 
            case KEY_NAME: {
                return new JsonStringImpl(this.getString());
            }
            case VALUE_NUMBER: {
                if (this.isFitLong()) {
                    return new JsonLongImpl(this.getLong());
                }
                return new JsonNumberImpl(this.getBigDecimal());
            }
        }
        throw new IllegalStateException((Object)((Object)current) + " doesn't support getValue()");
    }

    @Override
    public void skipObject() {
        if (this.isInObject()) {
            int level = 1;
            do {
                JsonParser.Event event;
                if ((event = this.internalNext()) == JsonParser.Event.START_OBJECT) {
                    ++level;
                    continue;
                }
                if (event != JsonParser.Event.END_OBJECT) continue;
                --level;
            } while (level > 0 && this.hasNext());
        }
    }

    @Override
    public void skipArray() {
        if (this.isInArray()) {
            int level = 1;
            do {
                JsonParser.Event event;
                if ((event = this.internalNext()) == JsonParser.Event.START_ARRAY) {
                    ++level;
                    continue;
                }
                if (event != JsonParser.Event.END_ARRAY) continue;
                --level;
            } while (level > 0 && this.hasNext());
        }
    }

    @Override
    public Stream<JsonValue> getArrayStream() {
        JsonParser.Event current = this.current();
        if (current != JsonParser.Event.START_ARRAY) {
            throw new IllegalStateException((Object)((Object)current) + " doesn't support getArrayStream()");
        }
        return StreamSupport.stream(new ArrayStreamSpliterator(this), false);
    }

    @Override
    public Stream<Map.Entry<String, JsonValue>> getObjectStream() {
        JsonParser.Event current = this.current();
        if (current != JsonParser.Event.START_OBJECT) {
            throw new IllegalStateException((Object)((Object)current) + " doesn't support getObjectStream()");
        }
        return StreamSupport.stream(new ObjectStreamSpliterator(this), false);
    }

    @Override
    public Stream<JsonValue> getValueStream() {
        if (this.manualNext) {
            throw new IllegalStateException("JsonStream already got propagated manually");
        }
        JsonParser.Event event = this.internalNext();
        switch (event) {
            case START_ARRAY: 
            case START_OBJECT: 
            case VALUE_TRUE: 
            case VALUE_FALSE: 
            case VALUE_NULL: 
            case VALUE_STRING: 
            case VALUE_NUMBER: {
                return Collections.singletonList(this.getValue()).stream();
            }
        }
        throw new IllegalStateException((Object)((Object)event) + " doesn't support getValueStream");
    }

    private static class ObjectStreamSpliterator
    extends Spliterators.AbstractSpliterator<Map.Entry<String, JsonValue>> {
        private final JohnzonJsonParserImpl parser;

        ObjectStreamSpliterator(JohnzonJsonParserImpl parser) {
            super(Long.MAX_VALUE, 1296);
            this.parser = parser;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<String, JsonValue>> action) {
            JsonParser.Event next = this.parser.next();
            if (next == JsonParser.Event.END_OBJECT) {
                return false;
            }
            if (next != JsonParser.Event.KEY_NAME) {
                throw new IllegalStateException("Expected key name event but got " + (Object)((Object)next) + " instead.");
            }
            String key = this.parser.getString();
            this.parser.next();
            JsonValue value = this.parser.getValue();
            action.accept(new AbstractMap.SimpleImmutableEntry<String, JsonValue>(key, value));
            return true;
        }
    }

    private static class ArrayStreamSpliterator
    extends Spliterators.AbstractSpliterator<JsonValue> {
        private final JohnzonJsonParserImpl parser;

        ArrayStreamSpliterator(JohnzonJsonParserImpl parser) {
            super(Long.MAX_VALUE, 1296);
            this.parser = parser;
        }

        @Override
        public boolean tryAdvance(Consumer<? super JsonValue> action) {
            JsonParser.Event next = this.parser.next();
            if (next == JsonParser.Event.END_ARRAY) {
                return false;
            }
            action.accept(this.parser.getValue());
            return true;
        }
    }
}

