/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.uri;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.artemis.utils.uri.URISchema;

public class URIFactory<T, P> {
    private URI defaultURI;
    private final Map<String, URISchema<T, P>> schemas = new ConcurrentHashMap<String, URISchema<T, P>>();

    public URI getDefaultURI() {
        return this.defaultURI;
    }

    public void setDefaultURI(URI uri) {
        this.defaultURI = uri;
    }

    public void registerSchema(URISchema<T, P> schemaFactory) {
        this.schemas.put(schemaFactory.getSchemaName(), schemaFactory);
        schemaFactory.setFactory(this);
    }

    public void removeSchema(String schemaName) {
        this.schemas.remove(schemaName);
    }

    public URI expandURI(String uriString) throws Exception {
        return this.normalise(uriString);
    }

    public T newObject(URI uri, P param) throws Exception {
        URISchema<T, P> schemaFactory = this.schemas.get(uri.getScheme());
        if (schemaFactory == null) {
            throw new NullPointerException("Schema " + uri.getScheme() + " not found");
        }
        return schemaFactory.newObject(uri, param);
    }

    public T newObject(URI uri, Map<String, String> overrides, P param) throws Exception {
        URISchema<T, P> schemaFactory = this.schemas.get(uri.getScheme());
        if (schemaFactory == null) {
            throw new NullPointerException("Schema " + uri.getScheme() + " not found");
        }
        return schemaFactory.newObject(uri, overrides, param);
    }

    public T newObject(String uri, P param) throws Exception {
        return this.newObject(new URI(uri), param);
    }

    public void populateObject(URI uri, T bean2) throws Exception {
        URISchema<T, P> schemaFactory = this.schemas.get(uri.getScheme());
        if (schemaFactory == null) {
            throw new NullPointerException("Schema " + uri.getScheme() + " not found");
        }
        schemaFactory.populateObject(uri, bean2);
    }

    public void populateObject(String uri, T bean2) throws Exception {
        this.populateObject(new URI(uri), bean2);
    }

    public URI createSchema(String scheme, T bean2) throws Exception {
        URISchema<T, P> schemaFactory = this.schemas.get(scheme);
        if (schemaFactory == null) {
            throw new NullPointerException("Schema " + scheme + " not found");
        }
        return schemaFactory.newURI(bean2);
    }

    private URI normalise(String uri) throws URISyntaxException {
        if (uri.startsWith("(")) {
            String[] split = uri.split("\\)", 2);
            String[] connectorURIS = split[0].substring(split[0].indexOf(40) + 1).split(",");
            String factoryQuery = split.length > 1 ? split[1] : "";
            StringBuilder builder = new StringBuilder(connectorURIS[0]);
            if (factoryQuery != null && factoryQuery.length() > 0) {
                if (connectorURIS[0].contains("?")) {
                    builder.append("&").append(factoryQuery.substring(1));
                } else {
                    builder.append(factoryQuery);
                }
            }
            if (connectorURIS.length > 1) {
                builder.append("#");
                for (int i2 = 1; i2 < connectorURIS.length; ++i2) {
                    if (i2 > 1) {
                        builder.append(",");
                    }
                    builder.append(connectorURIS[i2]);
                }
            }
            return new URI(builder.toString().replace(";", "&"));
        }
        return new URI(uri.replace(";", "&"));
    }
}

