/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.collections;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.activemq.artemis.core.PriorityAware;
import org.apache.activemq.artemis.utils.collections.ArrayResettableIterator;
import org.apache.activemq.artemis.utils.collections.MultiIterator;
import org.apache.activemq.artemis.utils.collections.MultiResettableIterator;
import org.apache.activemq.artemis.utils.collections.ResettableIterator;

public class PriorityCollection<E extends PriorityAware>
extends AbstractCollection<E> {
    private final Supplier<Collection<E>> supplier;
    private volatile PriorityHolder<E>[] priorityHolders = PriorityCollection.newPrioritySetArrayInstance(0);
    private volatile int size;

    private void setArray(PriorityHolder<E>[] priorityHolders) {
        this.priorityHolders = priorityHolders;
    }

    private PriorityHolder<E>[] getArray() {
        return this.priorityHolders;
    }

    public PriorityCollection(Supplier<Collection<E>> supplier) {
        this.supplier = supplier;
    }

    private static <E> PriorityHolder<E>[] newPrioritySetArrayInstance(int length) {
        return (PriorityHolder[])Array.newInstance(PriorityHolder.class, length);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set<Integer> getPriorites() {
        PriorityHolder<E>[] snapshot = this.getArray();
        return Arrays.stream(snapshot).map(PriorityAware::getPriority).collect(Collectors.toSet());
    }

    @Override
    public Iterator<E> iterator() {
        Iterator<E>[] iterators = this.getIterators();
        return new MultiIterator<E>(iterators);
    }

    private Iterator<E>[] getIterators() {
        PriorityHolder<E>[] snapshot = this.getArray();
        int size = snapshot.length;
        Iterator<E>[] iterators = PriorityCollection.newIteratorArrayInstance(size);
        for (int i2 = 0; i2 < size; ++i2) {
            iterators[i2] = snapshot[i2].getValues().iterator();
        }
        return iterators;
    }

    private static <E> Iterator<E>[] newIteratorArrayInstance(int length) {
        return (Iterator[])Array.newInstance(Iterator.class, length);
    }

    public ResettableIterator<E> resettableIterator() {
        return new MultiResettableIterator<E>(this.getResettableIterators());
    }

    private ResettableIterator<E>[] getResettableIterators() {
        PriorityHolder<E>[] snapshot = this.getArray();
        int size = snapshot.length;
        ResettableIterator<E>[] iterators = PriorityCollection.newResettableIteratorArrayInstance(size);
        for (int i2 = 0; i2 < size; ++i2) {
            iterators[i2] = ArrayResettableIterator.iterator(snapshot[i2].getValues());
        }
        return iterators;
    }

    private static <E> ResettableIterator<E>[] newResettableIteratorArrayInstance(int length) {
        return (ResettableIterator[])Array.newInstance(ResettableIterator.class, length);
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        Objects.requireNonNull(action);
        PriorityHolder<E>[] current = this.getArray();
        int len = current.length;
        for (int i2 = 0; i2 < len; ++i2) {
            current[i2].getValues().forEach(action);
        }
    }

    private Collection<E> getCollection(int priority, boolean createIfMissing) {
        PriorityHolder<E>[] current = this.getArray();
        int low = 0;
        int high = current.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            PriorityHolder<E> midVal = current[mid];
            if (midVal.getPriority() > priority) {
                low = mid + 1;
                continue;
            }
            if (midVal.getPriority() < priority) {
                high = mid - 1;
                continue;
            }
            return midVal.getValues();
        }
        if (createIfMissing) {
            PriorityHolder<E>[] newArray = PriorityCollection.newPrioritySetArrayInstance(current.length + 1);
            if (low > 0) {
                System.arraycopy(current, 0, newArray, 0, low);
            }
            if (current.length - low > 0) {
                System.arraycopy(current, low, newArray, low + 1, current.length - low);
            }
            newArray[low] = new PriorityHolder<E>(priority, this.supplier);
            this.setArray(newArray);
            return newArray[low].getValues();
        }
        return null;
    }

    @Override
    public synchronized boolean add(E e) {
        if (this.size() == Integer.MAX_VALUE) {
            return false;
        }
        boolean result = this.addInternal(e);
        this.calcSize();
        return result;
    }

    private boolean addInternal(E e) {
        if (e == null) {
            return false;
        }
        Collection<E> priority = this.getCollection(e.getPriority(), true);
        return priority.add(e);
    }

    @Override
    public synchronized boolean remove(Object o) {
        boolean result = this.removeInternal(o);
        this.calcSize();
        return result;
    }

    private boolean removeInternal(Object o) {
        if (o instanceof PriorityAware) {
            boolean result;
            PriorityAware priorityAware = (PriorityAware)o;
            Collection<E> priority = this.getCollection(priorityAware.getPriority(), false);
            boolean bl = result = priority != null && priority.remove(priorityAware);
            if (priority != null && priority.isEmpty()) {
                this.removeCollection(priorityAware.getPriority());
            }
            return result;
        }
        return false;
    }

    private Collection<E> removeCollection(int priority) {
        PriorityHolder<E>[] current = this.getArray();
        int len = current.length;
        int low = 0;
        int high = len - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            PriorityHolder<E> midVal = current[mid];
            if (midVal.getPriority() > priority) {
                low = mid + 1;
                continue;
            }
            if (midVal.getPriority() < priority) {
                high = mid - 1;
                continue;
            }
            PriorityHolder<E>[] newArray = PriorityCollection.newPrioritySetArrayInstance(len - 1);
            System.arraycopy(current, 0, newArray, 0, mid);
            System.arraycopy(current, mid + 1, newArray, mid, len - mid - 1);
            this.setArray(newArray);
            return midVal.getValues();
        }
        return null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Objects.requireNonNull(c);
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> c) {
        Objects.requireNonNull(c);
        if (this.size() >= Integer.MAX_VALUE - c.size()) {
            return false;
        }
        boolean modified = false;
        for (PriorityAware e : c) {
            if (!this.addInternal(e)) continue;
            modified = true;
        }
        this.calcSize();
        return modified;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        Objects.requireNonNull(c);
        boolean modified = false;
        for (Object o : c) {
            if (!this.removeInternal(o)) continue;
            modified = true;
        }
        this.calcSize();
        return modified;
    }

    @Override
    public synchronized boolean retainAll(Collection<?> c) {
        PriorityHolder<E>[] snapshot;
        Objects.requireNonNull(c);
        boolean modified = false;
        for (PriorityHolder<E> priorityHolder : snapshot = this.getArray()) {
            if (!priorityHolder.getValues().retainAll(c)) continue;
            modified = true;
            if (!priorityHolder.getValues().isEmpty()) continue;
            this.removeCollection(priorityHolder.getPriority());
        }
        this.calcSize();
        return modified;
    }

    @Override
    public synchronized void clear() {
        PriorityHolder<E>[] snapshot;
        for (PriorityHolder<E> priorityHolder : snapshot = this.getArray()) {
            priorityHolder.getValues().clear();
        }
        this.calcSize();
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof PriorityAware && this.contains((PriorityAware)o);
    }

    public boolean contains(PriorityAware priorityAware) {
        if (priorityAware == null) {
            return false;
        }
        Collection<E> prioritySet = this.getCollection(priorityAware.getPriority(), false);
        return prioritySet != null && prioritySet.contains(priorityAware);
    }

    private void calcSize() {
        PriorityHolder<E>[] current = this.getArray();
        int size = 0;
        for (PriorityHolder<E> priorityHolder : current) {
            size += priorityHolder.getValues().size();
        }
        this.size = size;
    }

    public static class PriorityHolder<E>
    implements PriorityAware {
        private final int priority;
        private final Collection<E> values;

        public PriorityHolder(int priority, Supplier<Collection<E>> supplier) {
            this.priority = priority;
            this.values = supplier.get();
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        public Collection<E> getValues() {
            return this.values;
        }
    }
}

