/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

public abstract class StringEscapeUtils {
    public static String escapeString(String str) {
        if (str == null) {
            return str;
        }
        int sz = str.length();
        StringBuilder stringBuilder = new StringBuilder(str.length());
        block13: for (int i2 = 0; i2 < sz; ++i2) {
            char ch = str.charAt(i2);
            if (ch > '\u0fff') {
                stringBuilder.append("\\u").append(StringEscapeUtils.hex(ch));
                continue;
            }
            if (ch > '\u00ff') {
                stringBuilder.append("\\u0").append(StringEscapeUtils.hex(ch));
                continue;
            }
            if (ch > '\u007f') {
                stringBuilder.append("\\u00").append(StringEscapeUtils.hex(ch));
                continue;
            }
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        stringBuilder.append('\\').append('b');
                        break;
                    }
                    case '\n': {
                        stringBuilder.append('\\').append('n');
                        break;
                    }
                    case '\t': {
                        stringBuilder.append('\\').append('t');
                        break;
                    }
                    case '\f': {
                        stringBuilder.append('\\').append('f');
                        break;
                    }
                    case '\r': {
                        stringBuilder.append('\\').append('r');
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            stringBuilder.append("\\u00").append(StringEscapeUtils.hex(ch));
                            break;
                        }
                        stringBuilder.append("\\u000").append(StringEscapeUtils.hex(ch));
                        break;
                    }
                }
                continue;
            }
            switch (ch) {
                case '\'': {
                    stringBuilder.append('\\').append('\'');
                    continue block13;
                }
                case '\"': {
                    stringBuilder.append('\\').append('\"');
                    continue block13;
                }
                case '\\': {
                    stringBuilder.append('\\').append('\\');
                    continue block13;
                }
                case '/': {
                    stringBuilder.append('\\').append('/');
                    continue block13;
                }
                default: {
                    stringBuilder.append(ch);
                }
            }
        }
        return stringBuilder.toString();
    }

    private static String hex(char ch) {
        return Integer.toHexString(ch).toUpperCase();
    }
}

