/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import io.netty.util.collection.LongObjectHashMap;
import io.netty.util.collection.LongObjectMap;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.logging.Logger;

public class SoftValueLongObjectHashMap<V extends ValueCache>
implements LongObjectMap<V> {
    private static final Logger logger = Logger.getLogger(SoftValueLongObjectHashMap.class);
    private final ReferenceQueue<V> refQueue = new ReferenceQueue();
    private final LongObjectMap<AggregatedSoftReference<V>> mapDelegate = new LongObjectHashMap<AggregatedSoftReference<V>>();
    private long usedCounter = 0L;
    private int maxElements;

    public SoftValueLongObjectHashMap(int maxElements) {
        this.maxElements = maxElements;
    }

    public void setMaxElements(int maxElements) {
        this.maxElements = maxElements;
        this.checkCacheSize();
    }

    public int getMaxEelements() {
        return this.maxElements;
    }

    @Override
    public int size() {
        this.processQueue();
        return this.mapDelegate.size();
    }

    @Override
    public boolean isEmpty() {
        this.processQueue();
        return this.mapDelegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey(SoftValueLongObjectHashMap.objectToKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
        this.processQueue();
        for (AggregatedSoftReference valueIter : this.mapDelegate.values()) {
            ValueCache valueElement = (ValueCache)valueIter.get();
            if (valueElement == null || !value.equals(valueElement)) continue;
            return true;
        }
        return false;
    }

    private static long objectToKey(Object key) {
        return (Long)key;
    }

    @Override
    public V get(Object key) {
        return (V)this.get(SoftValueLongObjectHashMap.objectToKey(key));
    }

    @Override
    public V put(Long key, V value) {
        return this.put(SoftValueLongObjectHashMap.objectToKey(key), value);
    }

    @Override
    public V get(long key) {
        this.processQueue();
        AggregatedSoftReference<V> value = this.mapDelegate.get(key);
        if (value != null) {
            ++this.usedCounter;
            value.used(this.usedCounter);
            return (V)((ValueCache)value.get());
        }
        return null;
    }

    @Override
    public V put(long key, V value) {
        this.processQueue();
        AggregatedSoftReference newRef = this.createReference(key, value);
        AggregatedSoftReference oldRef = this.mapDelegate.put(key, newRef);
        this.checkCacheSize();
        ++this.usedCounter;
        newRef.used(this.usedCounter);
        if (oldRef != null) {
            return (V)((ValueCache)oldRef.get());
        }
        return null;
    }

    @Override
    public V remove(long key) {
        this.processQueue();
        AggregatedSoftReference<V> ref = this.mapDelegate.remove(key);
        if (ref != null) {
            return (V)((ValueCache)ref.get());
        }
        return null;
    }

    private void checkCacheSize() {
        if (this.maxElements > 0 && this.mapDelegate.size() > this.maxElements) {
            TreeSet<AggregatedSoftReference> usedReferences = new TreeSet<AggregatedSoftReference>(new ComparatorAgregated());
            for (AggregatedSoftReference ref : this.mapDelegate.values()) {
                ValueCache v = (ValueCache)ref.get();
                if (v == null || v.isLive()) continue;
                usedReferences.add(ref);
            }
            for (AggregatedSoftReference ref : usedReferences) {
                if (ref.used <= 0L) continue;
                AggregatedSoftReference<V> removed = this.mapDelegate.remove(ref.key);
                if (logger.isTraceEnabled()) {
                    logger.trace("Removing " + removed + " with id = " + ref.key + " from SoftValueLongObjectHashMap");
                }
                if (this.mapDelegate.size() > this.maxElements) continue;
                break;
            }
        }
    }

    @Override
    public V remove(Object key) {
        return (V)this.remove(SoftValueLongObjectHashMap.objectToKey(key));
    }

    @Override
    public void putAll(Map<? extends Long, ? extends V> m3) {
        this.processQueue();
        if (m3 instanceof LongObjectMap) {
            LongObjectMap primitiveMap = (LongObjectMap)m3;
            for (LongObjectMap.PrimitiveEntry entry : primitiveMap.entries()) {
                this.put(entry.key(), (V)((ValueCache)entry.value()));
            }
        } else {
            for (Map.Entry<Long, V> e : m3.entrySet()) {
                this.put(e.getKey(), (V)((ValueCache)e.getValue()));
            }
        }
    }

    @Override
    public void clear() {
        this.mapDelegate.clear();
    }

    @Override
    public Set<Long> keySet() {
        this.processQueue();
        return this.mapDelegate.keySet();
    }

    @Override
    public Collection<V> values() {
        this.processQueue();
        ArrayList<ValueCache> list = new ArrayList<ValueCache>();
        for (AggregatedSoftReference refs : this.mapDelegate.values()) {
            ValueCache value = (ValueCache)refs.get();
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    @Override
    public Set<Map.Entry<Long, V>> entrySet() {
        return null;
    }

    @Override
    public Iterable<LongObjectMap.PrimitiveEntry<V>> entries() {
        this.processQueue();
        int size = this.mapDelegate.size();
        ArrayList<LongObjectMap.PrimitiveEntry<V>> entries = new ArrayList<LongObjectMap.PrimitiveEntry<V>>(size);
        for (LongObjectMap.PrimitiveEntry<AggregatedSoftReference<V>> pair : this.mapDelegate.entries()) {
            ValueCache value = (ValueCache)pair.value().get();
            if (value == null) continue;
            entries.add(new EntryElement<ValueCache>(pair.key(), value));
        }
        return entries;
    }

    @Override
    public boolean containsKey(long key) {
        this.processQueue();
        return this.mapDelegate.containsKey(key);
    }

    @Override
    public boolean equals(Object o) {
        this.processQueue();
        return this.mapDelegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.mapDelegate.hashCode();
    }

    private void processQueue() {
        AggregatedSoftReference ref;
        while ((ref = (AggregatedSoftReference)this.refQueue.poll()) != null) {
            logger.tracef("Removing reference through processQueue:: %s", ref.get());
            this.mapDelegate.remove(ref.key);
        }
    }

    private AggregatedSoftReference createReference(long key, V value) {
        return new AggregatedSoftReference<V>(key, value, this.refQueue);
    }

    static final class EntryElement<V>
    implements LongObjectMap.PrimitiveEntry<V> {
        final long key;
        final V value;

        EntryElement(long key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public long key() {
            return this.key;
        }

        @Override
        public V value() {
            return this.value;
        }

        @Override
        @Deprecated
        public void setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }

    static final class AggregatedSoftReference<V>
    extends SoftReference<V> {
        final long key;
        long used = 0L;

        public long getUsed() {
            return this.used;
        }

        public void used(long value) {
            this.used = value;
        }

        AggregatedSoftReference(long key, V referent, ReferenceQueue<V> refQueue) {
            super(referent, refQueue);
            this.key = key;
        }

        public String toString() {
            return "AggregatedSoftReference [key=" + this.key + ", used=" + this.used + "]";
        }
    }

    class ComparatorAgregated
    implements Comparator<AggregatedSoftReference> {
        ComparatorAgregated() {
        }

        @Override
        public int compare(AggregatedSoftReference o1, AggregatedSoftReference o2) {
            long k = o1.used - o2.used;
            if (k > 0L) {
                return 1;
            }
            if (k < 0L) {
                return -1;
            }
            k = o1.hashCode() - o2.hashCode();
            if (k > 0L) {
                return 1;
            }
            if (k < 0L) {
                return -1;
            }
            return 0;
        }
    }

    public static interface ValueCache {
        public boolean isLive();
    }
}

